/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.MimeMessage;
import org.flowable.engine.IdentityService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.jeecg.common.api.dto.message.BusTemplateMessageDTO;
import org.jeecg.common.api.dto.message.TemplateDTO;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.HTMLUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.SysAnnmentTypeEnum;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.vo.DomainUrl;
import org.jeecg.modules.extbpm.process.entity.ExtActTaskNotification;
import org.jeecg.modules.extbpm.process.mapper.ExtActTaskNotificationMapper;
import org.jeecg.modules.extbpm.process.service.IExtActTaskNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="extActTaskNotificationService")
public class p
extends ServiceImpl<ExtActTaskNotificationMapper, ExtActTaskNotification>
implements IExtActTaskNotificationService {
    private static final Logger a = LoggerFactory.getLogger(p.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    protected IdentityService identityService;
    @Autowired
    private ExtActTaskNotificationMapper extActTaskNotificationMapper;
    @Value(value="${spring.mail.username}")
    private String emailFrom;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void taskNotification(ExtActTaskNotification extActTaskNotification) {
        List list = ((TaskQuery)this.taskService.createTaskQuery().active().processInstanceId(extActTaskNotification.getProcInstId())).list();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(extActTaskNotification.getProcInstId()).singleResult();
        extActTaskNotification.setProcName(processInstance.getProcessDefinitionName());
        for (Task task : list) {
            MimeMessage mimeMessage;
            Object object;
            Object object2;
            if (!oConvertUtils.isNotEmpty((Object)task.getAssignee())) continue;
            a.info("--------\u53d1\u6d88\u606f----------");
            extActTaskNotification.setId(UUIDGenerator.generate());
            extActTaskNotification.setTaskId(task.getId());
            extActTaskNotification.setTaskName(task.getName());
            extActTaskNotification.setTaskAssignee(task.getAssignee());
            extActTaskNotification.setOpTime(new Date());
            extActTaskNotification.setTaskAssignee(task.getAssignee());
            this.extActTaskNotificationMapper.insert(extActTaskNotification);
            String[] stringArray = extActTaskNotification.getNotifyType().split(",");
            if (stringArray == null || stringArray.length <= 0) continue;
            List<String> list2 = Arrays.asList(stringArray);
            if (list2.contains("2")) {
                a.info("--------\u90ae\u4ef6\u901a\u77e5----------");
                object2 = this.sysBaseAPI.getUserByName(task.getAssignee());
                if (object2 != null && object2.getEmail() != null) {
                    try {
                        object = (JavaMailSender)SpringContextUtils.getBean((String)"mailSender");
                        mimeMessage = object.createMimeMessage();
                        MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, true);
                        mimeMessageHelper.setFrom(this.emailFrom);
                        mimeMessageHelper.setTo(object2.getEmail());
                        mimeMessageHelper.setSubject("\u6d41\u7a0b\u50ac\u529e\u63d0\u9192");
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("bpm_name", extActTaskNotification.getProcName());
                        hashMap.put("bpm_task", extActTaskNotification.getTaskName());
                        hashMap.put("remark", extActTaskNotification.getRemarks());
                        hashMap.put("datetime", DateUtils.formatDateTime());
                        TemplateDTO templateDTO = new TemplateDTO("bpm_cuiban_email", hashMap);
                        String string = this.sysBaseAPI.parseTemplateByCode(templateDTO);
                        string = HTMLUtils.parseMarkdown((String)string);
                        mimeMessageHelper.setText(string, true);
                        object.send(mimeMessage);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        a.error("--------\u90ae\u4ef6\u901a\u77e5\u5f02\u5e38----------", (Object)exception.getMessage());
                    }
                }
            }
            if (!list2.contains("1")) continue;
            a.info("--------\u7cfb\u7edf\u9875\u9762\u901a\u77e5----------");
            object2 = new HashMap();
            object2.put("bpm_name", extActTaskNotification.getProcName());
            object2.put("bpm_task", extActTaskNotification.getTaskName());
            object2.put("remark", extActTaskNotification.getRemarks());
            object2.put("datetime", DateUtils.formatDateTime());
            object = this.getAppDomainUrl() + "/pages/lowApp/process/taskDetail?tenantId={0}&procInsId={1}&taskId={2}&taskDefKey={3}";
            object = MessageFormat.format((String)object, TenantContext.getTenant(), processInstance.getId(), processInstance.getActivityId(), extActTaskNotification.getTaskId());
            object2.put("url", object);
            mimeMessage = new BusTemplateMessageDTO(extActTaskNotification.getCreateBy(), extActTaskNotification.getTaskAssignee(), "\u6d41\u7a0b\u50ac\u529e\u63d0\u9192", (Map)object2, "bpm_cuiban", SysAnnmentTypeEnum.BPM.getType(), task.getId());
            this.sysBaseAPI.sendBusTemplateAnnouncement((BusTemplateMessageDTO)mimeMessage);
        }
    }

    private String getAppDomainUrl() {
        DomainUrl domainUrl;
        if (this.jeecgBaseConfig == null) {
            this.jeecgBaseConfig = (JeecgBaseConfig)SpringContextUtils.getBean(JeecgBaseConfig.class);
        }
        if ((domainUrl = this.jeecgBaseConfig.getDomainUrl()) == null || oConvertUtils.isEmpty((Object)domainUrl.getApp())) {
            a.error("\u7f3a\u5c11\u914d\u7f6e\uff1ajeecg.domainUrl.app!");
            return "";
        }
        return domainUrl.getApp();
    }

    private Set<User> a(String string) {
        HashSet<User> hashSet = new HashSet<User>();
        List list = this.taskService.getIdentityLinksForTask(string);
        if (list != null && list.size() > 0) {
            for (IdentityLink identityLink : list) {
                Object object;
                if (identityLink.getUserId() != null && (object = this.b(identityLink.getUserId())) != null) {
                    hashSet.add((User)object);
                }
                if (identityLink.getGroupId() == null || (object = ((UserQuery)this.identityService.createUserQuery().memberOfGroup(identityLink.getGroupId())).list()) == null || object.size() <= 0) continue;
                hashSet.addAll((Collection<User>)object);
            }
        }
        return hashSet;
    }

    private User b(String string) {
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(string)).singleResult();
        return user;
    }
}

