/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.bpm.a.a;
import org.jeecg.modules.extbpm.process.common.b;
import org.jeecg.modules.extbpm.process.mapper.ExtSystemOaMapper;
import org.jeecg.modules.extbpm.process.service.impl.q;
import org.jeecg.modules.extbpm.util.BranchConditionGroupUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="flowUtil")
public class FlowUtilService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowUtilService.class);
    @Autowired
    private BranchConditionGroupUtils branchConditionGroupUtils;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private ExtSystemOaMapper extSystemOaMapper;
    @Autowired
    private q temporaryVariableService;

    public List<String> stringToList(String content) {
        log.debug("\u3010\u4f1a\u7b7e\u9009\u62e9\u4eba\u8868\u8fbe\u5f0f\u3011------stringToList------" + content);
        if (StringUtil.isEmpty((String)content)) {
            throw new org.jeecg.modules.extbpm.process.c.a("\u63d0\u4ea4\u5931\u8d25\uff0c\u4e0b\u4e00\u4efb\u52a1\u662f\u4f1a\u7b7e\u8282\u70b9\uff0c\u8bf7\u9009\u62e9\u4f1a\u7b7e\u4eba\u5458");
        }
        String[] huiQianUsersArray = content.split(",");
        List<String> userNames = Arrays.stream(huiQianUsersArray).map(String::trim).filter(name -> !name.isEmpty()).distinct().collect(Collectors.toList());
        List validUsers = this.sysBaseAPI.queryUserByNames(userNames.toArray(new String[0]));
        if (validUsers == null || validUsers.isEmpty()) {
            log.warn("\u3010\u4f1a\u7b7e\u9009\u62e9\u4eba\u8868\u8fbe\u5f0f\u3011\u6240\u6709\u7528\u6237\u90fd\u4e0d\u5b58\u5728: {}", (Object)content);
            throw new org.jeecg.modules.extbpm.process.c.a("\u63d0\u4ea4\u5931\u8d25\uff0c\u9009\u62e9\u7684\u4f1a\u7b7e\u4eba\u5458\u90fd\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        List<String> validUserNames = validUsers.stream().map(UserAccountInfo::getUsername).collect(Collectors.toList());
        log.info("\u3010\u4f1a\u7b7e\u9009\u62e9\u4eba\u8868\u8fbe\u5f0f\u3011\u6709\u6548\u7528\u6237\u5217\u8868: {}", (Object)String.join((CharSequence)",", validUserNames));
        return validUserNames;
    }

    public List<String> convertToList(Object filedValue) {
        if (filedValue == null) {
            log.debug("-----\u8f6c\u6362\u4efb\u52a1\u529e\u7406\u4eba\u5b57\u7b26\u4e32\u4e3aList---filedValue is null");
            return null;
        }
        log.debug("------filedValue------" + filedValue);
        if (filedValue instanceof String) {
            String content = (String)filedValue;
            if (content != null && content.startsWith("[") && content.endsWith("]")) {
                content = content.substring(1, content.length() - 1);
            }
            if (StringUtil.isEmpty((String)content)) {
                log.warn("------str2List------content is empty");
            }
            String[] s = content.split(",");
            return Arrays.asList(s);
        }
        if (filedValue instanceof List) {
            return (List)filedValue;
        }
        if (filedValue.getClass().isArray()) {
            Object[] array = (Object[])filedValue;
            return Arrays.stream(array).map(Object::toString).collect(Collectors.toList());
        }
        log.warn("------str2List------filedValue is not String or List or Array");
        return Arrays.asList(filedValue.toString());
    }

    public List<String> loopAssigneeCollection(String users, DelegateExecution execution) {
        List loopAssigneeCollection = (List)execution.getVariable("loopAssigneeCollection", List.class);
        if (CollectionUtils.isEmpty((Collection)loopAssigneeCollection)) {
            String[] s = users.split(",");
            log.debug(" >>> loopAssigneeCollection\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316\u9ed8\u8ba4\u503c\uff1a" + users);
            List<String> usersList = Arrays.asList(s);
            execution.setVariableLocal("loopAssigneeCollection", usersList);
            return usersList;
        }
        log.debug(" >>> loopAssigneeCollection\u96c6\u5408\uff1a" + loopAssigneeCollection);
        return loopAssigneeCollection;
    }

    public boolean evaluateExpression(DelegateExecution execution, Object conditionInput, String groupLogic) {
        try {
            List<org.jeecg.modules.extbpm.process.d.b> conditionGroups = this.branchConditionGroupUtils.parseConditionInput(conditionInput);
            if (CollectionUtils.isEmpty(conditionGroups)) {
                log.debug("\u6761\u4ef6\u7ec4\u4e3a\u7a7a\uff0c\u8fd4\u56de false");
                return false;
            }
            ArrayList<Boolean> groupResults = new ArrayList<Boolean>();
            for (org.jeecg.modules.extbpm.process.d.b group : conditionGroups) {
                boolean groupResult = this.branchConditionGroupUtils.evaluateConditionGroup(execution, group);
                groupResults.add(groupResult);
                String logicDisplay = "AND".equalsIgnoreCase(group.getLogic()) ? "\u4e14" : "\u6216";
                int conditionCount = group.getConditions() != null ? group.getConditions().size() : 0;
                log.debug("\u3010\u6761\u4ef6\u7ec4\u8bc4\u4f30\u3011\u6761\u4ef6\u6570\u91cf: <{}> | \u7ec4\u5185\u903b\u8f91: <{}> | \u7ec4\u7ed3\u679c: <{}>", new Object[]{conditionCount, logicDisplay, groupResult ? "\u2713\u901a\u8fc7" : "\u2717\u5931\u8d25"});
            }
            boolean finalResult = this.branchConditionGroupUtils.combineResults(groupResults, groupLogic);
            String groupLogicDisplay = "AND".equalsIgnoreCase(groupLogic) ? "\u4e14" : "\u6216";
            log.debug("\u3010\u6700\u7ec8\u8bc4\u4f30\u3011\u7ec4\u95f4\u903b\u8f91: <{}> | \u6700\u7ec8\u7ed3\u679c: <{}>", (Object)groupLogicDisplay, (Object)(finalResult ? "\u2713\u901a\u8fc7" : "\u2717\u5931\u8d25"));
            return finalResult;
        }
        catch (Exception e2) {
            log.error("\u591a\u6761\u4ef6\u8868\u8fbe\u5f0f\u8bc4\u4f30\u5f02\u5e38", (Throwable)e2);
            return false;
        }
    }

    private boolean evaluateExpression(DelegateExecution execution, List<org.jeecg.modules.extbpm.process.d.b> conditionGroups, String groupLogic) {
        return this.evaluateExpression(execution, (Object)conditionGroups, groupLogic);
    }

    public List<String> getAssigneeUsers(DelegateExecution execution, String signConfigForExpressionBase64) {
        String requestId = "REQ_" + System.currentTimeMillis();
        String processInstanceId = execution.getProcessInstanceId();
        String activityId = execution.getCurrentActivityId();
        log.info("\n\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 \u4f1a\u7b7e\u4eba\u5458\u8868\u8fbe\u5f0f \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n\u2502 requestId: {}\n\u2502 processInstanceId: {}\n\u2502 activityId: {}\n\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", new Object[]{requestId, processInstanceId, activityId});
        log.debug("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] Base64\u7f16\u7801\u914d\u7f6e: {}", (Object)requestId, (Object)signConfigForExpressionBase64);
        try {
            String cacheKey = a.l + "_" + activityId;
            String countersignFilteredUsernames = oConvertUtils.getString((Object)this.temporaryVariableService.a(processInstanceId, cacheKey));
            if (oConvertUtils.isNotEmpty((Object)countersignFilteredUsernames)) {
                log.info("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u4ece\u4e34\u65f6\u53d8\u91cf\u83b7\u53d6\u5230\u7b5b\u9009\u540e\u7684\u4f1a\u7b7e\u4eba\u5458: {}", (Object)requestId, (Object)countersignFilteredUsernames);
                List<String> filteredUsers = Arrays.stream(countersignFilteredUsernames.split(",")).filter(StringUtils::isNotEmpty).map(String::trim).distinct().collect(Collectors.toList());
                return filteredUsers;
            }
        }
        catch (Exception e2) {
            log.warn("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u4ece\u4e34\u65f6\u53d8\u91cf\u83b7\u53d6\u7b5b\u9009\u7528\u6237\u5931\u8d25\uff0c\u7ee7\u7eed\u4f7f\u7528\u914d\u7f6e\u89e3\u6790: {}", (Object)requestId, (Object)e2.getMessage());
        }
        String signConfigContent = null;
        try {
            log.debug("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u6b65\u9aa41: \u5f00\u59cbBase64\u89e3\u7801", (Object)requestId);
            try {
                signConfigContent = new String(Base64.getDecoder().decode(signConfigForExpressionBase64), StandardCharsets.UTF_8);
                log.debug("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] Base64\u89e3\u7801\u6210\u529f", (Object)requestId);
            }
            catch (Exception e3) {
                signConfigContent = signConfigForExpressionBase64;
                log.warn("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] Base64\u89e3\u7801\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cb\u5185\u5bb9: {}", (Object)requestId, (Object)e3.getMessage());
            }
            log.debug("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u89e3\u7801\u540e\u914d\u7f6e\u5185\u5bb9: {}", (Object)requestId, (Object)signConfigContent);
            if (StringUtils.isEmpty((String)signConfigContent)) {
                log.warn("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u5217\u8868", (Object)requestId);
                return new ArrayList<String>();
            }
            log.debug("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u6b65\u9aa43: \u5f00\u59cb\u89e3\u6790JSON\u914d\u7f6e", (Object)requestId);
            JSONObject signConfig = JSONObject.parseObject((String)signConfigContent);
            log.debug("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] JSON\u89e3\u6790\u6210\u529f", (Object)requestId);
            log.debug("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u6b65\u9aa44: \u5f00\u59cb\u89e3\u6790\u4f1a\u7b7e\u914d\u7f6e", (Object)requestId);
            ArrayList result = this.parseAssigneeConfig(execution, signConfig, requestId);
            int userCount = result != null ? result.size() : 0;
            log.debug("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u6267\u884c\u5b8c\u6210 - \u83b7\u53d6\u5230 {} \u4e2a\u4f1a\u7b7e\u4eba\u5458: {}", new Object[]{requestId, userCount, result});
            return result != null ? result : new ArrayList();
        }
        catch (Exception e4) {
            log.error("\u3010\u4f1a\u7b7e\u4eba\u5458\u83b7\u53d6\u3011[{}] \u6267\u884c\u5931\u8d25 - \u914d\u7f6e\u5185\u5bb9: {}", new Object[]{requestId, signConfigContent, e4});
            return new ArrayList<String>();
        }
    }

    private List<String> parseAssigneeConfig(DelegateExecution execution, JSONObject signConfig, String requestId) {
        String auditorUserType = signConfig.getString("auditorUserType");
        JSONArray auditorDeptIds = signConfig.getJSONArray("auditorDeptIds");
        JSONArray auditorPostIds = signConfig.getJSONArray("auditorPostIds");
        JSONArray auditorGroupIds = signConfig.getJSONArray("auditorGroupIds");
        JSONArray auditorApprovalGroupIds = signConfig.getJSONArray("auditorApprovalGroupIds");
        JSONArray auditorDeptPositionIds = signConfig.getJSONArray("auditorDeptPositionIds");
        String auditorCountersignFormField = signConfig.getString("auditorCountersignFormField");
        String auditorCountersignFormFieldType = signConfig.getString("auditorCountersignFormFieldType");
        String desformCode = signConfig.getString("desformCode");
        log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5ba1\u6279\u4eba\u7c7b\u578b: {}", (Object)requestId, (Object)auditorUserType);
        log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011 \u7c7b\u578b: {}, \u90e8\u95e8IDs: {}, \u5c97\u4f4dIDs: {}: {}, \u8868\u5355\u5b57\u6bb5: {}, \u8868\u5355\u7f16\u7801: {}, \u5ba1\u6279\u89d2\u8272IDs: {}, \u90e8\u95e8\u5c97\u4f4dIDs: {}, \u7cfb\u7edf\u89d2\u8272IDs: {}", new Object[]{auditorUserType, auditorDeptIds, auditorPostIds, auditorCountersignFormField, desformCode, auditorApprovalGroupIds, auditorDeptPositionIds, auditorGroupIds});
        if ("candidateDepts".equals(auditorUserType)) {
            int deptCount = auditorDeptIds != null ? auditorDeptIds.size() : 0;
            log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u90e8\u95e8\u914d\u7f6e - \u90e8\u95e8\u6570\u91cf: {}", (Object)requestId, (Object)deptCount);
        } else if ("candidatePosts".equals(auditorUserType)) {
            int postCount = auditorPostIds != null ? auditorPostIds.size() : 0;
            log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u804c\u7ea7\u914d\u7f6e - \u5c97\u4f4d\u6570\u91cf: {}", (Object)requestId, (Object)postCount);
        } else if ("candidateGroups".equals(auditorUserType)) {
            int groupCount = auditorGroupIds != null ? auditorGroupIds.size() : 0;
            log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u7cfb\u7edf\u89d2\u8272\u914d\u7f6e - \u89d2\u8272\u6570\u91cf: {}", (Object)requestId, (Object)groupCount);
        } else if ("candidateApprovalGroups".equals(auditorUserType)) {
            int approvalGroupCount = auditorApprovalGroupIds != null ? auditorApprovalGroupIds.size() : 0;
            log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u5ba1\u6279\u89d2\u8272\u914d\u7f6e - \u5ba1\u6279\u89d2\u8272\u6570\u91cf: {}", (Object)requestId, (Object)approvalGroupCount);
        } else if ("candidateDeptPositions".equals(auditorUserType)) {
            int deptPositionCount = auditorDeptPositionIds != null ? auditorDeptPositionIds.size() : 0;
            log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u5c97\u4f4d\u914d\u7f6e - \u90e8\u95e8\u5c97\u4f4d\u6570\u91cf: {}", (Object)requestId, (Object)deptPositionCount);
        } else if ("formData".equals(auditorUserType)) {
            log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u8868\u5355\u6570\u636e\u914d\u7f6e - \u5b57\u6bb5\u540d: {}, \u5b57\u6bb5\u7c7b\u578b: {}, \u8868\u5355\u7f16\u7801: {}", new Object[]{requestId, auditorCountersignFormField, auditorCountersignFormFieldType, desformCode});
        }
        ArrayList<String> assigneeUsers = new ArrayList<String>();
        switch (auditorUserType) {
            case "candidateDepts": {
                List<String> deptIds = this.convertToList(auditorDeptIds);
                if (deptIds != null && !deptIds.isEmpty()) {
                    log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u90e8\u95e8 - \u5904\u7406 {} \u4e2a\u90e8\u95e8", (Object)requestId, (Object)deptIds.size());
                    List<String> deptUsers = this.extSystemOaMapper.getUsernamesByDepIds(deptIds);
                    if (deptUsers == null) break;
                    assigneeUsers.addAll(deptUsers);
                    break;
                }
                log.warn("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u90e8\u95e8 - \u90e8\u95e8ID\u5217\u8868\u4e3a\u7a7a", (Object)requestId);
                break;
            }
            case "candidatePosts": {
                List<String> postLevelIdList = this.convertToList(auditorPostIds);
                String sysOrgCode = oConvertUtils.getString((Object)execution.getVariable("sys_org_code"));
                if (postLevelIdList != null && !postLevelIdList.isEmpty()) {
                    log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u804c\u7ea7 - \u5904\u7406 {} \u4e2a\u5c97\u4f4d\uff0c\u53d1\u8d77\u90e8\u95e8: {}", new Object[]{requestId, postLevelIdList.size(), sysOrgCode});
                    List<String> postUsers = this.extSystemOaMapper.getUsernamesByOrgCodeAndPositionIds(sysOrgCode, postLevelIdList);
                    if (postUsers == null) break;
                    assigneeUsers.addAll(postUsers);
                    break;
                }
                log.warn("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u804c\u7ea7 - \u5c97\u4f4dID\u5217\u8868\u4e3a\u7a7a", (Object)requestId);
                break;
            }
            case "candidateDeptPositions": {
                List<String> auditorDeptPositionIdList = this.convertToList(auditorDeptPositionIds);
                if (auditorDeptPositionIdList != null && !auditorDeptPositionIdList.isEmpty()) {
                    log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u5c97\u4f4d - \u5904\u7406 {} \u4e2a\u90e8\u95e8\u5c97\u4f4d", (Object)requestId, (Object)auditorDeptPositionIdList.size());
                    List positionUsers = this.sysBaseAPI.queryUsernameByDepartPositIds(auditorDeptPositionIdList);
                    if (positionUsers == null) break;
                    assigneeUsers.addAll(positionUsers);
                    break;
                }
                log.warn("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u5c97\u4f4d - \u90e8\u95e8\u5c97\u4f4dID\u5217\u8868\u4e3a\u7a7a", (Object)requestId);
                break;
            }
            case "candidateApprovalGroups": {
                List<String> auditorApprovalGroupIdList = this.convertToList(auditorApprovalGroupIds);
                if (auditorApprovalGroupIdList != null && !auditorApprovalGroupIdList.isEmpty()) {
                    String approvalRoleIds = auditorApprovalGroupIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
                    log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u5ba1\u6279\u89d2\u8272 - \u5904\u7406 {} \u4e2a\u5ba1\u6279\u89d2\u8272", (Object)requestId, (Object)auditorApprovalGroupIdList.size());
                    List<String> approvalRoleUsers = this.getUsersByApprRole(execution, approvalRoleIds);
                    if (approvalRoleUsers == null || approvalRoleUsers.isEmpty()) break;
                    assigneeUsers.addAll(approvalRoleUsers);
                    break;
                }
                log.warn("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u5ba1\u6279\u89d2\u8272 - \u5ba1\u6279\u89d2\u8272ID\u5217\u8868\u4e3a\u7a7a", (Object)requestId);
                break;
            }
            case "candidateGroups": {
                List<String> auditorGroupIdList = this.convertToList(auditorGroupIds);
                if (auditorGroupIdList != null && !auditorGroupIdList.isEmpty()) {
                    List<String> roleUsers;
                    log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u7cfb\u7edf\u89d2\u8272 - \u5904\u7406 {} \u4e2a\u7cfb\u7edf\u89d2\u8272", (Object)requestId, (Object)auditorGroupIdList.size());
                    List<String> userIds = this.extSystemOaMapper.getUserIdsByRoleCodes(auditorGroupIdList);
                    if (CollectionUtils.isEmpty(userIds) || (roleUsers = this.extSystemOaMapper.getUsernamesByUserIds(userIds)) == null) break;
                    assigneeUsers.addAll(roleUsers);
                    break;
                }
                log.warn("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u5019\u9009\u7cfb\u7edf\u89d2\u8272 - \u7cfb\u7edf\u89d2\u8272ID\u5217\u8868\u4e3a\u7a7a", (Object)requestId);
                break;
            }
            case "formData": {
                if (StringUtils.isNotEmpty((String)auditorCountersignFormField)) {
                    log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u8868\u5355\u6570\u636e - \u5b57\u6bb5: {}, \u7c7b\u578b: {}, \u8868\u5355\u7f16\u7801: {}", new Object[]{requestId, auditorCountersignFormField, auditorCountersignFormFieldType, desformCode});
                    List<String> formUsers = this.getUsersByFormData(execution, auditorCountersignFormField, auditorCountersignFormFieldType, desformCode);
                    if (formUsers == null || formUsers.isEmpty()) break;
                    assigneeUsers.addAll(formUsers);
                    break;
                }
                log.warn("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u8868\u5355\u6570\u636e - \u8868\u5355\u5b57\u6bb5\u540d\u4e3a\u7a7a", (Object)requestId);
                break;
            }
            default: {
                log.warn("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u4e0d\u652f\u6301\u7684\u5ba1\u6279\u4eba\u7c7b\u578b: {}", (Object)requestId, (Object)auditorUserType);
            }
        }
        ArrayList<String> distinctUsers = new ArrayList();
        if (assigneeUsers != null && !assigneeUsers.isEmpty()) {
            distinctUsers = assigneeUsers.stream().filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        }
        int userCount = distinctUsers != null ? distinctUsers.size() : 0;
        log.debug("\u3010\u4f1a\u7b7e\u914d\u7f6e\u89e3\u6790\u3011[{}] \u89e3\u6790\u5b8c\u6210 - \u83b7\u53d6\u5230 {} \u4e2a\u7528\u6237: {}", new Object[]{requestId, userCount, distinctUsers});
        return distinctUsers;
    }

    public List<String> getUsersByApprRole(DelegateExecution execution, String apprRoleIds) {
        String sysOrgCode = oConvertUtils.getString((Object)execution.getVariable("sys_org_code"));
        List<String> userIds = this.extSystemOaMapper.getUsersByApplyRoleIds(Arrays.asList(apprRoleIds.split(",")), sysOrgCode);
        if (CollectionUtils.isEmpty(userIds)) {
            log.debug("\u3010\u6839\u636e\u5ba1\u6279\u89d2\u8272\u8303\u56f4\uff0c\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u6839\u636e\u5ba1\u6279\u89d2\u8272 {} \u548c\u53d1\u8d77\u90e8\u95e8 {} \u83b7\u53d6\u7528\u6237\u5217\u8868\u4e3a\u7a7a\uff01", (Object)apprRoleIds, (Object)sysOrgCode);
            return new ArrayList<String>();
        }
        ArrayList userNames = this.extSystemOaMapper.getUsernamesByUserIds(userIds);
        int userCount = userNames != null ? userNames.size() : 0;
        log.debug("\u3010\u6839\u636e\u5ba1\u6279\u89d2\u8272\u8303\u56f4\uff0c\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u6839\u636e\u5ba1\u6279\u89d2\u8272 {} \u548c\u53d1\u8d77\u90e8\u95e8 {} \u83b7\u53d6\u5230 {} \u4e2a\u7528\u6237: {}", new Object[]{apprRoleIds, sysOrgCode, userCount, userNames});
        return userNames != null ? userNames : new ArrayList();
    }

    public List<String> getUsersByFormData(DelegateExecution execution, String formFieldName, String formFieldType) {
        String desFormCode = oConvertUtils.getString((Object)execution.getVariable(b.r));
        if (StringUtils.isEmpty((String)formFieldName)) {
            log.warn("\u3010\u6839\u636e\u8bbe\u8ba1\u5668\u8868\u5355\u6570\u636e\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u6821\u9a8c\u4e0d\u901a\u8fc7 formFieldName\u4e3a\u7a7a \uff01");
            return new ArrayList<String>();
        }
        if (StringUtils.isEmpty((String)desFormCode)) {
            log.warn("\u3010\u6839\u636e\u8bbe\u8ba1\u5668\u8868\u5355\u6570\u636e\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u53d8\u91cfBPM_DES_FORM_CODE \u3010\u8868\u5355\u7f16\u7801\u3011\uff01");
            return new ArrayList<String>();
        }
        log.debug("\u3010\u6839\u636e\u8bbe\u8ba1\u5668\u8868\u5355\u6570\u636e\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u4ece\u8bbe\u8ba1\u5668\u8868\u5355\u3010{}\u3011\uff0c\u8868\u5355\u5b57\u6bb5: {}, \u5b57\u6bb5\u7c7b\u578b: {}\uff0c\u8fdb\u5165\u83b7\u53d6\u7528\u6237\u96c6\u5408\u903b\u8f91\uff01", new Object[]{desFormCode, formFieldName, formFieldType});
        return this.getUsersByFormData(execution, formFieldName, formFieldType, desFormCode);
    }

    private List<String> getUsersByFormData(DelegateExecution execution, String formFieldName, String formFieldType, String desformCode) {
        if (StringUtils.isEmpty((String)formFieldName)) {
            return new ArrayList<String>();
        }
        try {
            Object fieldValue = this.branchConditionGroupUtils.getFormFieldValue(execution, formFieldName, desformCode);
            if (fieldValue == null) {
                log.debug("\u3010\u6839\u636e\u8bbe\u8ba1\u5668\u8868\u5355\u6570\u636e\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u8bbe\u8ba1\u5668\u8868\u5355\u5b57\u6bb5 {} \u7684\u503c\u4e3a\u7a7a\uff0c\u8868\u5355\u7f16\u7801: {}", (Object)formFieldName, (Object)desformCode);
                return new ArrayList<String>();
            }
            List<Object> users = new ArrayList();
            if (formFieldType != null && formFieldType.contains("select-depart")) {
                List<String> deptIds = this.convertToList(fieldValue);
                if (CollectionUtils.isEmpty(deptIds)) {
                    log.debug("\u3010\u6839\u636e\u8bbe\u8ba1\u5668\u8868\u5355\u6570\u636e\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u4ece\u8bbe\u8ba1\u5668\u8868\u5355\u3010{}\u3011 \u7684\u90e8\u95e8\u5b57\u6bb5 \u3010{}\u3011\uff0c\u83b7\u53d6\u7684deptIds \u4e3a\u7a7a\uff01", (Object)desformCode, (Object)formFieldName);
                    return new ArrayList<String>();
                }
                int deptCount = deptIds.size();
                log.debug("\u3010\u6839\u636e\u8bbe\u8ba1\u5668\u8868\u5355\u6570\u636e\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u4ece\u8bbe\u8ba1\u5668\u8868\u5355\u3010{}\u3011 \u7684\u90e8\u95e8\u5b57\u6bb5 \u3010{}\u3011\uff0c\u83b7\u53d6\u5230 {} \u4e2a\u90e8\u95e8", new Object[]{desformCode, formFieldName, deptCount});
                users = this.extSystemOaMapper.getUsernamesByDepIds(deptIds);
            } else {
                users = this.convertToList(fieldValue);
            }
            int userCount = users != null ? users.size() : 0;
            log.debug("\u3010\u6839\u636e\u8bbe\u8ba1\u5668\u8868\u5355\u6570\u636e\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u4ece\u8bbe\u8ba1\u5668\u8868\u5355\u3010{}\u3011 \u7684\u5b57\u6bb5 \u3010{}\u3011\uff0c \u83b7\u53d6\u5230 {} \u4e2a\u7528\u6237: {}", new Object[]{desformCode, formFieldName, userCount, users});
            return users != null ? users : new ArrayList();
        }
        catch (Exception e2) {
            log.error("\u3010\u6839\u636e\u8bbe\u8ba1\u5668\u8868\u5355\u6570\u636e\u83b7\u53d6\u7528\u6237\u5217\u8868\u3011\u4ece\u8bbe\u8ba1\u5668\u8868\u5355\u3010{}\u3011 \u7684\u5b57\u6bb5 \u3010{}\u3011,\u83b7\u53d6\u7528\u6237\u5931\u8d25 \uff01", new Object[]{desformCode, formFieldName, e2});
            return new ArrayList<String>();
        }
    }
}

