/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.listener.global;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.event.impl.FlowableEntityEventImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.extbpm.process.entity.ExtActBpmLog;
import org.jeecg.modules.extbpm.process.service.IExtActBpmLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="taskCreatedEventListener")
public class TaskCreatedEventListener
implements FlowableEventListener {
    @Autowired
    private IExtActBpmLogService extActBpmLogService;
    @Autowired
    protected RuntimeService runtimeService;
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    public void onEvent(FlowableEvent event) {
        FlowElement firstElement;
        if (!(event instanceof FlowableEntityEventImpl)) {
            return;
        }
        FlowableEntityEventImpl entityEvent = (FlowableEntityEventImpl)event;
        Object entity = entityEvent.getEntity();
        if (!(entity instanceof TaskEntity)) {
            return;
        }
        TaskEntity taskEntity = (TaskEntity)entity;
        if (FlowableEngineEventType.TASK_CREATED.equals((Object)event.getType()) && (firstElement = this.findFirstFlowElement(taskEntity)) != null && taskEntity.getTaskDefinitionKey().equals(firstElement.getId())) {
            Context.getProcessEngineConfiguration().getTaskService().complete(taskEntity.getId());
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
            LoginUser user = this.sysBaseAPI.getUserByName(username);
            String processInstanceId = taskEntity.getProcessInstanceId();
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            ExtActBpmLog bpmlog = new ExtActBpmLog();
            if (processInstance != null) {
                bpmlog.setBusinessKey(processInstance.getBusinessKey());
                bpmlog.setProcName(processInstance.getName());
            }
            bpmlog.setOpTime(new Date());
            bpmlog.setOpUserId(username);
            if (user != null) {
                bpmlog.setOpUserName(user.getRealname());
            }
            bpmlog.setProcInstId(processInstanceId);
            bpmlog.setRemarks("\u53d1\u8d77\u6d41\u7a0b");
            bpmlog.setTaskDefKey(taskEntity.getTaskDefinitionKey());
            bpmlog.setTaskId(taskEntity.getId());
            bpmlog.setTaskName(taskEntity.getName());
            this.extActBpmLogService.save(bpmlog);
        }
    }

    private FlowElement findFirstFlowElement(TaskEntity taskEntity) {
        RepositoryService repositoryService = (RepositoryService)SpringContextUtils.getBean(RepositoryService.class);
        BpmnModel bpmnModel = repositoryService.getBpmnModel(taskEntity.getProcessDefinitionId());
        for (FlowElement flowElement : ((Process)bpmnModel.getProcesses().get(0)).getFlowElements()) {
            if (!(flowElement instanceof StartEvent)) continue;
            return bpmnModel.getFlowElement(((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef());
        }
        return null;
    }

    public boolean isFailOnException() {
        return false;
    }

    public boolean isFireOnTransactionLifecycleEvent() {
        return false;
    }

    public String getOnTransaction() {
        return null;
    }
}

