/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.b.a;
import org.jeecg.modules.extbpm.process.b.b;
import org.jeecg.modules.extbpm.process.mapper.ExtSystemOaMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="branchConditionGroupUtils")
public class BranchConditionGroupUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BranchConditionGroupUtils.class);
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ExtSystemOaMapper extSystemOaMapper;
    @Lazy
    @Autowired
    private ISysBaseAPI sysbase;

    public List<org.jeecg.modules.extbpm.process.d.b> parseConditionInput(Object conditionInput) {
        if (conditionInput == null) {
            return Collections.emptyList();
        }
        try {
            if (conditionInput instanceof List) {
                return (List)conditionInput;
            }
            if (conditionInput instanceof String) {
                String input = (String)conditionInput;
                try {
                    byte[] decoded = Base64.getDecoder().decode(input);
                    String jsonStr = new String(decoded, StandardCharsets.UTF_8);
                    log.info("\u3010\u65b0\u5206\u652f\u8868\u8fbe\u5f0f\u3011Base64 \u89e3\u7801\u7ed3\u679c: {}", (Object)jsonStr);
                    ObjectMapper mapper = new ObjectMapper();
                    List rawGroups = (List)mapper.readValue(jsonStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                    return this.convertToConditionGroups(rawGroups);
                }
                catch (Exception e2) {
                    log.warn("Base64 \u89e3\u7801\u5931\u8d25\uff0c\u5c1d\u8bd5\u76f4\u63a5\u89e3\u6790 JSON: {}", (Object)e2.getMessage());
                    ObjectMapper mapper = new ObjectMapper();
                    List rawGroups = (List)mapper.readValue(input, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                    return this.convertToConditionGroups(rawGroups);
                }
            }
        }
        catch (Exception e3) {
            log.error("\u89e3\u6790\u6761\u4ef6\u8f93\u5165\u5931\u8d25", (Throwable)e3);
        }
        return Collections.emptyList();
    }

    public List<org.jeecg.modules.extbpm.process.d.b> convertToConditionGroups(List<Map<String, Object>> rawGroups) {
        ArrayList<org.jeecg.modules.extbpm.process.d.b> groups = new ArrayList<org.jeecg.modules.extbpm.process.d.b>();
        for (Map<String, Object> rawGroup : rawGroups) {
            String logic = (String)rawGroup.get("logic");
            List conditions = (List)rawGroup.get("conditions");
            org.jeecg.modules.extbpm.process.d.b group = new org.jeecg.modules.extbpm.process.d.b(logic != null ? logic : "and");
            if (conditions != null) {
                for (Map condMap : conditions) {
                    String operator = (String)condMap.get("operator");
                    String field = (String)condMap.get("field");
                    String expectedValue = String.valueOf(condMap.get("expectedValue"));
                    group.a(operator, field, null, expectedValue);
                }
            }
            groups.add(group);
        }
        return groups;
    }

    public boolean evaluateConditionGroup(DelegateExecution execution, org.jeecg.modules.extbpm.process.d.b group) {
        if (CollectionUtils.isEmpty(group.getConditions())) {
            return false;
        }
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        for (org.jeecg.modules.extbpm.process.d.a condition : group.getConditions()) {
            boolean result = this.evaluateSingleCondition(execution, condition);
            results.add(result);
            String actualValueDisplay = condition.getActualValue() != null && !condition.getActualValue().equals("[]") ? condition.getActualValue() : "\u7a7a";
            String expectedValueDisplay = condition.getExpectedValue() != null && !condition.getActualValue().equals("[]") ? condition.getExpectedValue() : "\u7a7a";
            String operatorDisplay = this.getOperatorDisplayName(condition.getOperator());
            String fieldDisplay = this.getFieldDisplayName(condition.getField());
            log.info("\u3010\u6761\u4ef6\u8bc4\u4f30\u3011\u5b57\u6bb5: <{}> | \u64cd\u4f5c\u7b26: <{}> | \u5b9e\u9645\u503c: <{}> | \u671f\u671b\u503c: <{}> | \u7ed3\u679c: <{}>", new Object[]{fieldDisplay, operatorDisplay, actualValueDisplay, expectedValueDisplay, result ? "\u2713\u901a\u8fc7" : "\u2717\u5931\u8d25"});
        }
        return this.combineResults(results, group.getLogic());
    }

    private boolean evaluateSingleCondition(DelegateExecution execution, org.jeecg.modules.extbpm.process.d.a condition) {
        String actualValue = this.getActualValue(execution, condition);
        condition.setActualValue(actualValue);
        return this.evaluateConditionByOperator(condition.getOperator(), actualValue, condition.getExpectedValue());
    }

    private String getActualValue(DelegateExecution execution, org.jeecg.modules.extbpm.process.d.a condition) {
        try {
            String fieldName = condition.getField();
            if (fieldName == null) {
                return null;
            }
            a fieldEnum = a.b(fieldName);
            if (fieldEnum != null) {
                return this.getValueByEnum(execution, fieldEnum);
            }
            return this.handleUnknownField(execution, fieldName);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u5f02\u5e38: {}", (Object)condition.getField(), (Object)e2);
            return null;
        }
    }

    private String getValueByEnum(DelegateExecution execution, a fieldEnum) {
        Object value = null;
        String applyUserId = oConvertUtils.getString((Object)execution.getVariable("applyUserId"));
        switch (3.a[fieldEnum.ordinal()]) {
            case 1: {
                value = execution.getVariable(fieldEnum.getVariableName());
                break;
            }
            case 2: {
                value = this.getUserPosts(applyUserId);
                break;
            }
            case 3: {
                String sysOrgCode = oConvertUtils.getString((Object)execution.getVariable(fieldEnum.getVariableName()));
                if (!oConvertUtils.isNotEmpty((Object)sysOrgCode)) break;
                value = this.extSystemOaMapper.getDepId(sysOrgCode);
                break;
            }
            case 4: {
                value = execution.getVariable(fieldEnum.getVariableName());
                break;
            }
            case 5: {
                return this.getLastAssigneeValue(execution);
            }
            case 6: {
                if (!oConvertUtils.isNotEmpty((Object)applyUserId)) break;
                value = this.getDepartLeaders(applyUserId);
                log.info("\u3010\u67e5\u627e\u5f53\u524d\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u83b7\u53d6\u53d1\u8d77\u4eba= {}\uff0c\u90e8\u95e8\u8d1f\u8d23\u4eba: {}", (Object)applyUserId, value);
                break;
            }
            case 7: {
                if (!oConvertUtils.isNotEmpty((Object)applyUserId)) break;
                value = this.getLevel1DepartLeaders(applyUserId);
                log.info("\u3010\u67e5\u627e\u5f53\u524d\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011\u83b7\u53d6\u53d1\u8d77\u4eba= {}\uff0c\u4e0a\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba: {}", (Object)applyUserId, value);
                break;
            }
            default: {
                value = execution.getVariable(fieldEnum.getVariableName());
            }
        }
        return value != null ? String.valueOf(value) : null;
    }

    public List<String> getDepartLeaders(String applyUserId) {
        List depIds = this.sysbase.getDepartIdsByUsername(applyUserId);
        if (CollectionUtils.isEmpty((Collection)depIds)) {
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)depIds, (String)","));
        return users;
    }

    public List<String> getLevel1DepartLeaders(String applyUserId) {
        Set level1DepParentIds = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        if (CollectionUtils.isEmpty((Collection)level1DepParentIds)) {
            log.info("\u3010\u67e5\u627e\u4e0a\u4e00\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011 \u7528\u6237: [{}] | \u4e0a\u4e00\u7ea7\u90e8\u95e8\u5217\u8868: [\u7a7a] | \u7ed3\u679c: [\u65e0\u4e0a\u7ea7\u90e8\u95e8\u4fe1\u606f]", (Object)applyUserId);
            return null;
        }
        log.info("\u3010\u67e5\u627e\u4e0a\u4e00\u7ea7\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011 \u7528\u6237={}, \u4e0a\u4e00\u7ea7\u90e8\u95e8\u5217\u8868={}, \u4e0a\u4e00\u7ea7\u90e8\u95e8\u6570\u91cf: [{}]", new Object[]{applyUserId, level1DepParentIds, level1DepParentIds.size()});
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)level1DepParentIds, (String)","));
        return users;
    }

    private String getLastAssigneeValue(DelegateExecution execution) {
        try {
            List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
            if (tasks != null && tasks.size() > 0) {
                return ((HistoricTaskInstance)tasks.get(0)).getAssignee();
            }
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u4e0a\u4e2a\u8282\u70b9\u5904\u7406\u4eba\u5f02\u5e38", (Throwable)e2);
        }
        return null;
    }

    private String handleUnknownField(DelegateExecution execution, String fieldName) {
        Object value = execution.getVariable(fieldName);
        return value != null ? String.valueOf(value) : null;
    }

    private boolean evaluateConditionByOperator(String operator, String actualValue, String expectedValue) {
        try {
            if (operator == null) {
                return false;
            }
            b operatorEnum = b.b(operator);
            if (operatorEnum == null) {
                log.warn("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26: {}", (Object)operator);
                return false;
            }
            if (operatorEnum.c()) {
                if (operatorEnum == b.l) {
                    return actualValue == null || actualValue.trim().isEmpty();
                }
                if (operatorEnum == b.m) {
                    return actualValue != null && !actualValue.trim().isEmpty();
                }
            }
            if (operatorEnum.d()) {
                if (operatorEnum == b.n) {
                    return this.isDepartmentManager(actualValue);
                }
                if (operatorEnum == b.o) {
                    return !this.isDepartmentManager(actualValue);
                }
            }
            if (operatorEnum.b() && (actualValue == null || expectedValue == null)) {
                return false;
            }
            switch (3.b[operatorEnum.ordinal()]) {
                case 1: 
                case 2: {
                    return this.evaluateEqualsCondition(actualValue, expectedValue);
                }
                case 3: {
                    return !this.evaluateEqualsCondition(actualValue, expectedValue);
                }
                case 4: {
                    return this.compareNumericOrDate(actualValue, expectedValue) > 0;
                }
                case 5: {
                    return this.compareNumericOrDate(actualValue, expectedValue) >= 0;
                }
                case 6: {
                    return this.compareNumericOrDate(actualValue, expectedValue) < 0;
                }
                case 7: {
                    return this.compareNumericOrDate(actualValue, expectedValue) <= 0;
                }
                case 8: {
                    return this.evaluateInCondition(actualValue, expectedValue);
                }
                case 9: {
                    return !this.evaluateInCondition(actualValue, expectedValue);
                }
                case 10: {
                    return this.evaluateContains(actualValue, expectedValue);
                }
                case 11: {
                    return !this.evaluateContains(actualValue, expectedValue);
                }
            }
            log.warn("\u672a\u5904\u7406\u7684\u64cd\u4f5c\u7b26: {}", (Object)operatorEnum);
            return false;
        }
        catch (Exception e2) {
            log.error("\u6761\u4ef6\u8bc4\u4f30\u5f02\u5e38: operator={}, actualValue={}, expectedValue={}", new Object[]{operator, actualValue, expectedValue, e2});
            return false;
        }
    }

    private boolean evaluateEqualsCondition(String actualValue, String expectedValue) {
        if (actualValue == null && expectedValue == null) {
            return true;
        }
        if (actualValue == null || expectedValue == null) {
            return false;
        }
        try {
            if (actualValue.startsWith("[") && actualValue.endsWith("]")) {
                List<String> actualList = this.convertToArray(actualValue);
                List<String> expectedList = this.convertToArray(expectedValue);
                if (actualList.isEmpty() && expectedList.isEmpty()) {
                    return true;
                }
                if (actualList.isEmpty() || expectedList.isEmpty()) {
                    return false;
                }
                boolean result = oConvertUtils.isEqList(actualList, expectedList);
                log.info("EQUALS\u6761\u4ef6\u8bc4\u4f30: actualList={} equals expectedList={} = {}", new Object[]{actualList, expectedList, result});
                return result;
            }
            return actualValue.equals(expectedValue);
        }
        catch (Exception e2) {
            log.warn("EQUALS\u6761\u4ef6\u8bc4\u4f30\u5f02\u5e38: actualValue={}, expectedValue={}", new Object[]{actualValue, expectedValue, e2});
            return actualValue.equals(expectedValue);
        }
    }

    private List<String> convertToArray(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            String listContent = value.substring(1, value.length() - 1).trim();
            if (listContent.isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.stream(listContent.split("[,\uff0c]")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        if (value.contains(",")) {
            return Arrays.stream(value.split("[,\uff0c]")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? Collections.emptyList() : Collections.singletonList(trimmed);
    }

    private boolean evaluateContains(String actualValue, String expectedValue) {
        if (actualValue == null || expectedValue == null) {
            return false;
        }
        try {
            if (actualValue.startsWith("[") && actualValue.endsWith("]")) {
                List<String> actualList = this.convertToArray(actualValue);
                List<String> expectedList = this.convertToArray(expectedValue);
                if (actualList.isEmpty() || expectedList.isEmpty()) {
                    return false;
                }
                boolean result = oConvertUtils.isAllInList(expectedList, actualList);
                log.debug("\u6570\u7ec4\u683c\u5f0fCONTAINS\u6761\u4ef6(\u7cbe\u786e\u5339\u914d): actualList={} contains expectedList={} = {}", new Object[]{actualList, expectedList, result});
                return result;
            }
            return actualValue.contains(expectedValue);
        }
        catch (Exception e2) {
            log.warn("\u5305\u542b\u5173\u7cfb\u8bc4\u4f30\u5f02\u5e38: actualValue={}, expectedValue={}", new Object[]{actualValue, expectedValue, e2});
            return actualValue.contains(expectedValue);
        }
    }

    private boolean evaluateInCondition(String actualValue, String expectedValue) {
        if (actualValue == null || expectedValue == null) {
            return false;
        }
        try {
            List<String> actualList = this.convertToArray(actualValue);
            List<String> expectedList = this.convertToArray(expectedValue);
            if (actualList.isEmpty() || expectedList.isEmpty()) {
                return false;
            }
            boolean result = oConvertUtils.isAllInList(actualList, expectedList);
            log.debug("IN\u6761\u4ef6\u8bc4\u4f30: actualList={} in expectedList={} = {}", new Object[]{actualList, expectedList, result});
            return result;
        }
        catch (Exception e2) {
            log.warn("IN\u6761\u4ef6\u8bc4\u4f30\u5f02\u5e38: actualValue={}, expectedValue={}", new Object[]{actualValue, expectedValue, e2});
            return Arrays.asList(expectedValue.split("[,\uff0c]")).contains(actualValue);
        }
    }

    private int compareNumericOrDate(String actualValue, String expectedValue) {
        try {
            BigDecimal actual = new BigDecimal(actualValue);
            BigDecimal expected = new BigDecimal(expectedValue);
            return actual.compareTo(expected);
        }
        catch (NumberFormatException e2) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date actualDate = sdf.parse(actualValue);
                Date expectedDate = sdf.parse(expectedValue);
                return actualDate.compareTo(expectedDate);
            }
            catch (Exception ex) {
                return actualValue.compareTo(expectedValue);
            }
        }
    }

    public boolean combineResults(List<Boolean> results, String logic) {
        if (CollectionUtils.isEmpty(results)) {
            return false;
        }
        if ("or".equalsIgnoreCase(logic)) {
            return results.stream().anyMatch(Boolean::booleanValue);
        }
        return results.stream().allMatch(Boolean::booleanValue);
    }

    private boolean isDepartmentManager(String userId) {
        if (userId == null || userId.trim().isEmpty()) {
            return false;
        }
        try {
            boolean isManager = this.extSystemOaMapper.isDepartmentManager(userId);
            log.info("\u5224\u65ad\u7528\u6237 {} \u662f\u5426\u4e3a\u90e8\u95e8\u8d1f\u8d23\u4eba: {}", (Object)userId, (Object)isManager);
            return isManager;
        }
        catch (Exception e2) {
            log.error("\u5224\u65ad\u90e8\u95e8\u8d1f\u8d23\u4eba\u5f02\u5e38: userId={}", (Object)userId, (Object)e2);
            return false;
        }
    }

    private Set<String> getUserPosts(String applyId) {
        try {
            if (applyId == null) {
                return null;
            }
            return this.extSystemOaMapper.getUserPositionIdsByUsername(applyId);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u7528\u6237\u4e3b\u5c97\u4f4d\u548c\u517c\u804c\u5c97\u4f4d\u7684\u804c\u52a1\uff01\u5f02\u5e38: applyId={}", (Object)applyId, (Object)e2);
            return null;
        }
    }

    private String getOperatorDisplayName(String operator) {
        if (operator == null) {
            return "\u672a\u77e5";
        }
        b operatorEnum = b.b(operator);
        if (operatorEnum != null) {
            return operator + "(" + operatorEnum.getLabel() + ")";
        }
        return operator;
    }

    private String getFieldDisplayName(String fieldName) {
        if (fieldName == null) {
            return "\u672a\u77e5\u5b57\u6bb5";
        }
        a fieldEnum = a.b(fieldName);
        if (fieldEnum != null) {
            return fieldName + "(" + fieldEnum.getDescription() + ")";
        }
        return fieldName + "(\u81ea\u5b9a\u4e49\u5b57\u6bb5)";
    }
}

