/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.jeecg.modules.extbpm.process.c.a;
import org.jeecg.modules.extbpm.process.d.b;
import org.jeecg.modules.extbpm.util.BranchConditionGroupUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="flowUtil")
public class FlowUtilService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowUtilService.class);
    @Autowired
    private BranchConditionGroupUtils branchConditionGroupUtils;

    public List<String> stringToList(String content) {
        log.info("------stringToList------" + content);
        if (StringUtil.isEmpty((String)content)) {
            throw new a("\u63d0\u4ea4\u5931\u8d25\uff0c\u4e0b\u4e00\u4efb\u52a1\u662f\u4f1a\u7b7e\u8282\u70b9\uff0c\u8bf7\u9009\u62e9\u4f1a\u7b7e\u4eba\u5458");
        }
        String[] s = content.split(",");
        return Arrays.asList(s);
    }

    public List<String> convertToList(Object filedValue) {
        if (filedValue == null) {
            log.info("-----\u8f6c\u6362\u4efb\u52a1\u529e\u7406\u4eba\u5b57\u7b26\u4e32\u4e3aList---filedValue is null");
            return null;
        }
        log.info("------filedValue------" + filedValue);
        if (filedValue instanceof String) {
            String content = (String)filedValue;
            if (content != null && content.startsWith("[") && content.endsWith("]")) {
                content = content.substring(1, content.length() - 1);
            }
            if (StringUtil.isEmpty((String)content)) {
                log.warn("------str2List------content is empty");
            }
            String[] s = content.split(",");
            return Arrays.asList(s);
        }
        if (filedValue instanceof List) {
            return (List)filedValue;
        }
        if (filedValue.getClass().isArray()) {
            Object[] array = (Object[])filedValue;
            return Arrays.stream(array).map(Object::toString).collect(Collectors.toList());
        }
        log.warn("------str2List------filedValue is not String or List or Array");
        return Arrays.asList(filedValue.toString());
    }

    public List<String> loopAssigneeCollection(String users, DelegateExecution execution) {
        List loopAssigneeCollection = (List)execution.getVariable("loopAssigneeCollection", List.class);
        if (CollectionUtils.isEmpty((Collection)loopAssigneeCollection)) {
            String[] s = users.split(",");
            log.info(" >>> loopAssigneeCollection\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316\u9ed8\u8ba4\u503c\uff1a" + users);
            List<String> usersList = Arrays.asList(s);
            execution.setVariableLocal("loopAssigneeCollection", usersList);
            return usersList;
        }
        log.info(" >>> loopAssigneeCollection\u96c6\u5408\uff1a" + loopAssigneeCollection);
        return loopAssigneeCollection;
    }

    public boolean evaluateExpression(DelegateExecution execution, Object conditionInput, String groupLogic) {
        try {
            List<b> conditionGroups = this.branchConditionGroupUtils.parseConditionInput(conditionInput);
            if (CollectionUtils.isEmpty(conditionGroups)) {
                log.info("\u6761\u4ef6\u7ec4\u4e3a\u7a7a\uff0c\u8fd4\u56de false");
                return false;
            }
            ArrayList<Boolean> groupResults = new ArrayList<Boolean>();
            for (b group : conditionGroups) {
                boolean groupResult = this.branchConditionGroupUtils.evaluateConditionGroup(execution, group);
                groupResults.add(groupResult);
                String logicDisplay = "AND".equalsIgnoreCase(group.getLogic()) ? "\u4e14" : "\u6216";
                int conditionCount = group.getConditions() != null ? group.getConditions().size() : 0;
                log.info("\u3010\u6761\u4ef6\u7ec4\u8bc4\u4f30\u3011\u6761\u4ef6\u6570\u91cf: <{}> | \u7ec4\u5185\u903b\u8f91: <{}> | \u7ec4\u7ed3\u679c: <{}>", new Object[]{conditionCount, logicDisplay, groupResult ? "\u2713\u901a\u8fc7" : "\u2717\u5931\u8d25"});
            }
            boolean finalResult = this.branchConditionGroupUtils.combineResults(groupResults, groupLogic);
            String groupLogicDisplay = "AND".equalsIgnoreCase(groupLogic) ? "\u4e14" : "\u6216";
            log.info("\u3010\u6700\u7ec8\u8bc4\u4f30\u3011\u7ec4\u95f4\u903b\u8f91: <{}> | \u6700\u7ec8\u7ed3\u679c: <{}>", (Object)groupLogicDisplay, (Object)(finalResult ? "\u2713\u901a\u8fc7" : "\u2717\u5931\u8d25"));
            return finalResult;
        }
        catch (Exception e2) {
            log.error("\u591a\u6761\u4ef6\u8868\u8fbe\u5f0f\u8bc4\u4f30\u5f02\u5e38", (Throwable)e2);
            return false;
        }
    }

    private boolean evaluateExpression(DelegateExecution execution, List<b> conditionGroups, String groupLogic) {
        return this.evaluateExpression(execution, (Object)conditionGroups, groupLogic);
    }
}

