/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.flowable.engine.IdentityService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.jeecg.common.api.dto.message.BusTemplateMessageDTO;
import org.jeecg.common.constant.enums.DySmsEnum;
import org.jeecg.common.constant.enums.EmailTemplateEnum;
import org.jeecg.common.constant.enums.SysAnnmentTypeEnum;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.b.a;
import org.jeecg.modules.extbpm.process.entity.ExtActTaskNotification;
import org.jeecg.modules.extbpm.process.mapper.ExtActTaskNotificationMapper;
import org.jeecg.modules.extbpm.process.service.IExtActTaskNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="extActTaskNotificationService")
public class o
extends ServiceImpl<ExtActTaskNotificationMapper, ExtActTaskNotification>
implements IExtActTaskNotificationService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(o.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    protected IdentityService identityService;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    private ExtActTaskNotificationMapper extActTaskNotificationMapper;
    @Value(value="${spring.mail.username}")
    private String emailFrom;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void taskNotification(ExtActTaskNotification extActTaskNotification) {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().active().processInstanceId(extActTaskNotification.getProcInstId())).list();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(extActTaskNotification.getProcInstId()).singleResult();
        extActTaskNotification.setProcName(processInstance.getProcessDefinitionName());
        for (Task task : taskList) {
            if (!oConvertUtils.isNotEmpty((Object)task.getAssignee())) continue;
            a.info("--------\u53d1\u6d88\u606f----------");
            extActTaskNotification.setId(UUIDGenerator.generate());
            extActTaskNotification.setTaskId(task.getId());
            extActTaskNotification.setTaskName(task.getName());
            extActTaskNotification.setTaskAssignee(task.getAssignee());
            extActTaskNotification.setOpTime(new Date());
            extActTaskNotification.setTaskAssignee(task.getAssignee());
            this.extActTaskNotificationMapper.insert(extActTaskNotification);
            String[] types = extActTaskNotification.getNotifyType().split(",");
            if (types == null || types.length <= 0) continue;
            List<String> list = Arrays.asList(types);
            LoginUser user = this.sysBaseAPI.getUserByName(task.getAssignee());
            if (list.contains("2")) {
                a.info("--------\u3010\u50ac\u529e\u3011\u90ae\u4ef6\u901a\u77e5----------");
                if (user != null && user.getEmail() != null) {
                    try {
                        JSONObject mp = new JSONObject();
                        mp.put("bpm_name", (Object)extActTaskNotification.getProcName());
                        mp.put("bpm_task", (Object)extActTaskNotification.getTaskName());
                        mp.put("remark", (Object)extActTaskNotification.getRemarks());
                        mp.put("datetime", (Object)DateUtils.formatDateTime());
                        String msgAbstract = org.jeecg.modules.extbpm.b.a.a(processInstance, extActTaskNotification, task.getTaskDefinitionKey());
                        String emailLoginToken = this.a(user.getUsername(), user.getPassword());
                        mp.put("url", (Object)org.jeecg.modules.extbpm.b.a.a((Map<String, Object>)mp, emailLoginToken, msgAbstract));
                        this.sysBaseAPI.sendHtmlTemplateEmail(user.getEmail(), "\u6d41\u7a0b\u50ac\u529e\u63d0\u9192", EmailTemplateEnum.BPM_CUIBAN_EMAIL, mp);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        a.error("--------\u90ae\u4ef6\u901a\u77e5\u5f02\u5e38----------", (Object)e2.getMessage());
                    }
                }
            }
            if (list.contains("1")) {
                a.info("--------\u3010\u50ac\u529e\u3011\u7cfb\u7edf\u901a\u77e5----------");
                HashMap<String, String> templateParam = new HashMap<String, String>();
                templateParam.put("bpm_name", extActTaskNotification.getProcName());
                templateParam.put("bpm_task", extActTaskNotification.getTaskName());
                templateParam.put("remark", extActTaskNotification.getRemarks());
                templateParam.put("datetime", DateUtils.formatDateTime());
                templateParam.put("msg_abstract", org.jeecg.modules.extbpm.b.a.b(processInstance, extActTaskNotification, task.getTaskDefinitionKey()));
                templateParam.put("url", org.jeecg.modules.extbpm.b.a.a(processInstance.getId(), task.getId(), task.getTaskDefinitionKey()));
                BusTemplateMessageDTO message = new BusTemplateMessageDTO(extActTaskNotification.getCreateBy(), extActTaskNotification.getTaskAssignee(), "\u6d41\u7a0b\u50ac\u529e\u63d0\u9192", templateParam, "bpm_cuiban", SysAnnmentTypeEnum.BPM.getType(), task.getId());
                this.sysBaseAPI.sendBusTemplateAnnouncement(message);
            }
            if (!list.contains("3")) continue;
            a.info("--------\u3010\u50ac\u529e\u3011\u77ed\u4fe1\u901a\u77e5----------");
            JSONObject param = new JSONObject();
            if (!oConvertUtils.isNotEmpty((Object)user.getPhone())) continue;
            param.put("realname", (Object)user.getRealname());
            if (oConvertUtils.isNotEmpty((Object)extActTaskNotification.getRemarks())) {
                param.put("bpmTitle", (Object)extActTaskNotification.getRemarks());
            } else {
                param.put("bpmTitle", (Object)(oConvertUtils.getString((String)extActTaskNotification.getProcName()) + " - " + oConvertUtils.getString((String)extActTaskNotification.getTaskName())));
            }
            this.sysBaseAPI.sendSmsMsg(user.getPhone(), param, DySmsEnum.TASK_NOTIFICATION_TEMPLATE_CODE);
        }
    }

    private String a(String username, String password) {
        String token = JwtUtil.sign((String)username, (String)password);
        this.redisUtil.set("prefix_user_token:" + token, (Object)token);
        this.redisUtil.expire("prefix_user_token:" + token, 302400L);
        return token;
    }

    private Set<User> a(String taskId) {
        HashSet<User> users = new HashSet<User>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                List userList;
                User user;
                if (identityLink.getUserId() != null && (user = this.b(identityLink.getUserId())) != null) {
                    users.add(user);
                }
                if (identityLink.getGroupId() == null || (userList = ((UserQuery)this.identityService.createUserQuery().memberOfGroup(identityLink.getGroupId())).list()) == null || userList.size() <= 0) continue;
                users.addAll(userList);
            }
        }
        return users;
    }

    private User b(String userId) {
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        return user;
    }
}

