/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtil;
import org.flowable.engine.HistoryService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.b.a;
import org.jeecg.modules.extbpm.process.c.b;
import org.jeecg.modules.extbpm.process.mapper.ExtSystemOaMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="flowUtil")
public class FlowUtilService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowUtilService.class);
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ExtSystemOaMapper extSystemOaMapper;

    public List<String> stringToList(String content) {
        log.info("------stringToList------" + content);
        if (StringUtil.isEmpty((String)content)) {
            throw new a("\u63d0\u4ea4\u5931\u8d25\uff0c\u4e0b\u4e00\u4efb\u52a1\u662f\u4f1a\u7b7e\u8282\u70b9\uff0c\u8bf7\u9009\u62e9\u4f1a\u7b7e\u4eba\u5458");
        }
        String[] s = content.split(",");
        return Arrays.asList(s);
    }

    public List<String> convertToList(Object filedValue) {
        if (filedValue == null) {
            log.info("-----\u8f6c\u6362\u4efb\u52a1\u529e\u7406\u4eba\u5b57\u7b26\u4e32\u4e3aList---filedValue is null");
            return null;
        }
        log.info("------filedValue------" + filedValue);
        if (filedValue instanceof String) {
            String content = (String)filedValue;
            if (content != null && content.startsWith("[") && content.endsWith("]")) {
                content = content.substring(1, content.length() - 1);
            }
            if (StringUtil.isEmpty((String)content)) {
                log.warn("------str2List------content is empty");
            }
            String[] s = content.split(",");
            return Arrays.asList(s);
        }
        if (filedValue instanceof List) {
            return (List)filedValue;
        }
        if (filedValue.getClass().isArray()) {
            Object[] array = (Object[])filedValue;
            return Arrays.stream(array).map(Object::toString).collect(Collectors.toList());
        }
        log.warn("------str2List------filedValue is not String or List or Array");
        return Arrays.asList(filedValue.toString());
    }

    public List<String> loopAssigneeCollection(String users, DelegateExecution execution) {
        List loopAssigneeCollection = (List)execution.getVariable("loopAssigneeCollection", List.class);
        if (CollectionUtils.isEmpty((Collection)loopAssigneeCollection)) {
            String[] s = users.split(",");
            log.info(" >>> loopAssigneeCollection\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316\u9ed8\u8ba4\u503c\uff1a" + users);
            List<String> usersList = Arrays.asList(s);
            execution.setVariableLocal("loopAssigneeCollection", usersList);
            return usersList;
        }
        log.info(" >>> loopAssigneeCollection\u96c6\u5408\uff1a" + loopAssigneeCollection);
        return loopAssigneeCollection;
    }

    public boolean evaluateExpression(DelegateExecution execution, Object conditionInput, String groupLogic) {
        try {
            List<b> conditionGroups = this.parseConditionInput(conditionInput);
            if (CollectionUtils.isEmpty(conditionGroups)) {
                log.debug("\u6761\u4ef6\u7ec4\u4e3a\u7a7a\uff0c\u8fd4\u56de false");
                return false;
            }
            ArrayList<Boolean> groupResults = new ArrayList<Boolean>();
            for (b group : conditionGroups) {
                boolean groupResult = this.evaluateConditionGroup(execution, group);
                groupResults.add(groupResult);
                log.debug("\u6761\u4ef6\u7ec4 {} \u8bc4\u4f30\u7ed3\u679c: {}", (Object)group.getLogic(), (Object)groupResult);
            }
            boolean finalResult = this.combineResults(groupResults, groupLogic);
            log.debug("\u6700\u7ec8\u8bc4\u4f30\u7ed3\u679c: {}", (Object)finalResult);
            return finalResult;
        }
        catch (Exception e2) {
            log.error("\u591a\u6761\u4ef6\u8868\u8fbe\u5f0f\u8bc4\u4f30\u5f02\u5e38", (Throwable)e2);
            return false;
        }
    }

    private List<b> parseConditionInput(Object conditionInput) {
        if (conditionInput == null) {
            return Collections.emptyList();
        }
        try {
            if (conditionInput instanceof List) {
                return (List)conditionInput;
            }
            if (conditionInput instanceof String) {
                String input = (String)conditionInput;
                try {
                    byte[] decoded = Base64.getDecoder().decode(input);
                    String jsonStr = new String(decoded, StandardCharsets.UTF_8);
                    log.debug("Base64 \u89e3\u7801\u7ed3\u679c: {}", (Object)jsonStr);
                    ObjectMapper mapper = new ObjectMapper();
                    List rawGroups = (List)mapper.readValue(jsonStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                    return this.convertToConditionGroups(rawGroups);
                }
                catch (Exception e2) {
                    log.warn("Base64 \u89e3\u7801\u5931\u8d25\uff0c\u5c1d\u8bd5\u76f4\u63a5\u89e3\u6790 JSON: {}", (Object)e2.getMessage());
                    ObjectMapper mapper = new ObjectMapper();
                    List rawGroups = (List)mapper.readValue(input, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                    return this.convertToConditionGroups(rawGroups);
                }
            }
        }
        catch (Exception e3) {
            log.error("\u89e3\u6790\u6761\u4ef6\u8f93\u5165\u5931\u8d25", (Throwable)e3);
        }
        return Collections.emptyList();
    }

    private List<b> convertToConditionGroups(List<Map<String, Object>> rawGroups) {
        ArrayList<b> groups = new ArrayList<b>();
        for (Map<String, Object> rawGroup : rawGroups) {
            String logic = (String)rawGroup.get("logic");
            List conditions = (List)rawGroup.get("conditions");
            b group = new b(logic != null ? logic : "and");
            if (conditions != null) {
                for (Map condMap : conditions) {
                    String operator = (String)condMap.get("operator");
                    String field = (String)condMap.get("field");
                    String expectedValue = String.valueOf(condMap.get("expectedValue"));
                    group.a(operator, field, null, expectedValue);
                }
            }
            groups.add(group);
        }
        return groups;
    }

    private boolean evaluateConditionGroup(DelegateExecution execution, b group) {
        if (CollectionUtils.isEmpty(group.getConditions())) {
            return false;
        }
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        for (org.jeecg.modules.extbpm.process.c.a condition : group.getConditions()) {
            boolean result = this.evaluateSingleCondition(execution, condition);
            results.add(result);
            log.debug("\u6761\u4ef6 {}[{}] {} {} \u8bc4\u4f30\u7ed3\u679c: {}", new Object[]{condition.getField(), condition.getOperator(), condition.getActualValue(), condition.getExpectedValue(), result});
        }
        return this.combineResults(results, group.getLogic());
    }

    private boolean evaluateSingleCondition(DelegateExecution execution, org.jeecg.modules.extbpm.process.c.a condition) {
        String actualValue = this.getActualValue(execution, condition);
        return this.evaluateConditionByOperator(condition.getOperator(), actualValue, condition.getExpectedValue());
    }

    private String getActualValue(DelegateExecution execution, org.jeecg.modules.extbpm.process.c.a condition) {
        try {
            String fieldName = condition.getField();
            if (fieldName == null) {
                return null;
            }
            Set<String> value = execution.getVariable(fieldName);
            switch (fieldName.toLowerCase()) {
                case "applyuserid": {
                    value = execution.getVariable("applyUserId");
                    break;
                }
                case "applyuserpostlevel": {
                    String applyUserId = oConvertUtils.getString((Object)execution.getVariable("applyUserId"));
                    value = this.getUserPosts(applyUserId);
                    break;
                }
                case "applyuserorgcode": {
                    value = execution.getVariable("sys_org_code");
                    break;
                }
                case "create_time": {
                    value = execution.getVariable("create_time");
                    break;
                }
                case "lastassignee": {
                    List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
                    if (tasks == null || tasks.size() <= 0) break;
                    return ((HistoricTaskInstance)tasks.get(0)).getAssignee();
                }
                default: {
                    value = execution.getVariable(fieldName);
                }
            }
            return value != null ? String.valueOf(value) : null;
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u5f02\u5e38: {}", (Object)condition.getField(), (Object)e2);
            return null;
        }
    }

    private boolean evaluateConditionByOperator(String operator, String actualValue, String expectedValue) {
        try {
            String normalizedOperator;
            if (operator == null) {
                return false;
            }
            if ("is_empty".equalsIgnoreCase(operator)) {
                return actualValue == null || actualValue.trim().isEmpty();
            }
            if ("is_not_empty".equalsIgnoreCase(operator)) {
                return actualValue != null && !actualValue.trim().isEmpty();
            }
            if ("is_department_manager".equalsIgnoreCase(operator)) {
                return this.isDepartmentManager(actualValue);
            }
            if ("is_not_department_manager".equalsIgnoreCase(operator)) {
                return !this.isDepartmentManager(actualValue);
            }
            if (actualValue == null || expectedValue == null) {
                return false;
            }
            switch (normalizedOperator = operator.toLowerCase()) {
                case "eq": 
                case "=": {
                    return expectedValue.equals(actualValue);
                }
                case "ne": 
                case "!=": {
                    return !expectedValue.equals(actualValue);
                }
                case "gt": 
                case ">": {
                    return this.compareNumericOrDate(actualValue, expectedValue) > 0;
                }
                case "gte": 
                case ">=": {
                    return this.compareNumericOrDate(actualValue, expectedValue) >= 0;
                }
                case "lt": 
                case "<": {
                    return this.compareNumericOrDate(actualValue, expectedValue) < 0;
                }
                case "lte": 
                case "<=": {
                    return this.compareNumericOrDate(actualValue, expectedValue) <= 0;
                }
                case "in": {
                    return Arrays.asList(expectedValue.split("[,\uff0c]")).contains(actualValue);
                }
                case "not_in": 
                case "notin": {
                    return !Arrays.asList(expectedValue.split("[,\uff0c]")).contains(actualValue);
                }
                case "contains": {
                    return this.evaluateContains(actualValue, expectedValue);
                }
                case "not_contains": {
                    return !this.evaluateContains(actualValue, expectedValue);
                }
            }
            log.warn("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26: {}", (Object)operator);
            return false;
        }
        catch (Exception e2) {
            log.error("\u6761\u4ef6\u8bc4\u4f30\u5f02\u5e38: operator={}, actualValue={}, expectedValue={}", new Object[]{operator, actualValue, expectedValue, e2});
            return false;
        }
    }

    private boolean evaluateContains(String actualValue, String expectedValue) {
        if (actualValue == null || expectedValue == null) {
            return false;
        }
        try {
            if (actualValue.startsWith("[") && actualValue.endsWith("]")) {
                String listContent = actualValue.substring(1, actualValue.length() - 1);
                if (!listContent.trim().isEmpty()) {
                    String[] items;
                    for (String item : items = listContent.split("[,\uff0c]")) {
                        if (!item.trim().equals(expectedValue.trim())) continue;
                        return true;
                    }
                }
                return false;
            }
            if (actualValue.contains(",")) {
                String[] items;
                for (String item : items = actualValue.split("[,\uff0c]")) {
                    if (!item.trim().equals(expectedValue.trim())) continue;
                    return true;
                }
                return false;
            }
            return actualValue.contains(expectedValue);
        }
        catch (Exception e2) {
            log.warn("\u5305\u542b\u5173\u7cfb\u8bc4\u4f30\u5f02\u5e38: actualValue={}, expectedValue={}", new Object[]{actualValue, expectedValue, e2});
            return actualValue.contains(expectedValue);
        }
    }

    private int compareNumericOrDate(String actualValue, String expectedValue) {
        try {
            BigDecimal actual = new BigDecimal(actualValue);
            BigDecimal expected = new BigDecimal(expectedValue);
            return actual.compareTo(expected);
        }
        catch (NumberFormatException e2) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date actualDate = sdf.parse(actualValue);
                Date expectedDate = sdf.parse(expectedValue);
                return actualDate.compareTo(expectedDate);
            }
            catch (Exception ex) {
                return actualValue.compareTo(expectedValue);
            }
        }
    }

    private boolean combineResults(List<Boolean> results, String logic) {
        if (CollectionUtils.isEmpty(results)) {
            return false;
        }
        if ("or".equalsIgnoreCase(logic)) {
            return results.stream().anyMatch(Boolean::booleanValue);
        }
        return results.stream().allMatch(Boolean::booleanValue);
    }

    public boolean evaluateExpression(DelegateExecution execution, List<b> conditionGroups, String groupLogic) {
        return this.evaluateExpression(execution, (Object)conditionGroups, groupLogic);
    }

    private boolean isDepartmentManager(String userId) {
        if (userId == null || userId.trim().isEmpty()) {
            return false;
        }
        try {
            boolean isManager = this.extSystemOaMapper.isDepartmentManager(userId);
            log.debug("\u5224\u65ad\u7528\u6237 {} \u662f\u5426\u4e3a\u90e8\u95e8\u8d1f\u8d23\u4eba: {}", (Object)userId, (Object)isManager);
            return isManager;
        }
        catch (Exception e2) {
            log.error("\u5224\u65ad\u90e8\u95e8\u8d1f\u8d23\u4eba\u5f02\u5e38: userId={}", (Object)userId, (Object)e2);
            return false;
        }
    }

    private Set<String> getUserPosts(String applyId) {
        try {
            if (applyId == null) {
                return null;
            }
            return this.extSystemOaMapper.getUserPositionNamesByUsername(applyId);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u7528\u6237\u4e3b\u5c97\u4f4d\u548c\u517c\u804c\u5c97\u4f4d\u7684\u804c\u52a1\uff01\u5f02\u5e38: applyId={}", (Object)applyId, (Object)e2);
            return null;
        }
    }
}

