/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.common.expression;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="flowNodeExpression")
public class FlowNodeExpression {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowNodeExpression.class);
    @Lazy
    @Autowired
    private ISysBaseAPI sysbase;

    public List<String> getDepartLeaders(String applyUserId) {
        log.info("getDepartLeaders called with applyUserId={}", (Object)applyUserId);
        List depIds = this.sysbase.getDepartIdsByUsername(applyUserId);
        if (CollectionUtils.isEmpty((Collection)depIds)) {
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)depIds, (String)","));
        return users;
    }

    public List<String> getLevel1DepartLeaders(String applyUserId) {
        Set level1DepParentIds = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        if (CollectionUtils.isEmpty((Collection)level1DepParentIds)) {
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)level1DepParentIds, (String)","));
        return users;
    }

    public List<String> getLevel2DepartLeaders(String applyUserId) {
        Set level1DepParentIds = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        log.info("level1DepParentIds = {}", (Object)level1DepParentIds);
        if (CollectionUtils.isEmpty((Collection)level1DepParentIds)) {
            return null;
        }
        Set level2DepParentIds = this.sysbase.getDepartParentIdsByDepIds(level1DepParentIds);
        log.info("level2DepParentIds = {}", (Object)level2DepParentIds);
        if (CollectionUtils.isEmpty((Collection)level2DepParentIds)) {
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)level2DepParentIds, (String)","));
        log.info("users = {}", (Object)users);
        return users;
    }

    public List<String> getLevel3DepartLeaders(String applyUserId) {
        Set level1DepParentIds = this.sysbase.getDepartParentIdsByUsername(applyUserId);
        log.info("level1DepParentIds = {}", (Object)level1DepParentIds);
        if (CollectionUtils.isEmpty((Collection)level1DepParentIds)) {
            return null;
        }
        Set level2DepParentIds = this.sysbase.getDepartParentIdsByDepIds(level1DepParentIds);
        log.info("level2DepParentIds = {}", (Object)level2DepParentIds);
        if (CollectionUtils.isEmpty((Collection)level2DepParentIds)) {
            return null;
        }
        Set level3DepParentIds = this.sysbase.getDepartParentIdsByDepIds(level2DepParentIds);
        log.info("level3DepParentIds = {}", (Object)level3DepParentIds);
        if (CollectionUtils.isEmpty((Collection)level3DepParentIds)) {
            return null;
        }
        List users = this.sysbase.getDeptHeadByDepId(StringUtils.join((Collection)level3DepParentIds, (String)","));
        log.info("users = {}", (Object)users);
        return users;
    }
}

