/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.bpm.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.StartProcessInstanceCmd;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.common.b;
import org.jeecg.modules.extbpm.process.service.IExtActFormDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="customTimeStartJobEventHandler")
public class CustomTimeStartJobEventHandler
extends TimerEventHandler
implements JobHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomTimeStartJobEventHandler.class);
    public static final String TYPE = "timer-start-event-custom";
    private IExtActFormDataService extActFormDataService;

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        log.info("============\u6267\u884c\u81ea\u5b9a\u4e49 \u5b9a\u65f6\u542f\u52a8\u6d41\u7a0b \u5904\u7406\u5668============");
        log.info("\u5b9a\u65f6\u4efb\u52a1\u8be6\u60c5 = {}", (Object)JSON.toJSONString((Object)job));
        if (this.extActFormDataService == null) {
            this.extActFormDataService = (IExtActFormDataService)SpringContextUtils.getBean(IExtActFormDataService.class);
        }
        String jobHandlerConfigStr = job.getJobHandlerConfiguration();
        JSONObject jobHandlerConfig = JSONObject.parseObject((String)jobHandlerConfigStr);
        ProcessDefinitionEntity processDefinitionEntity = ProcessDefinitionUtil.getProcessDefinitionFromDatabase((String)job.getProcessDefinitionId());
        if (processDefinitionEntity == null) {
            throw new FlowableException("Could not find process definition needed for timer start event");
        }
        try {
            if (!processDefinitionEntity.isSuspended()) {
                ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
                FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
                if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TIMER_FIRED, (Object)job), processEngineConfiguration.getEngineCfgKey());
                }
                Process process = ProcessDefinitionUtil.getProcess((String)job.getProcessDefinitionId());
                String activityId = TimerEventHandler.getActivityIdFromConfiguration((String)configuration);
                if (activityId != null) {
                    FlowElement flowElement = process.getFlowElement(activityId, true);
                    if (flowElement == null) {
                        throw new FlowableException("Could not find matching FlowElement for activityId " + activityId);
                    }
                    ProcessInstanceHelper processInstanceHelper = processEngineConfiguration.getProcessInstanceHelper();
                    String formKey = oConvertUtils.getString((Object)jobHandlerConfig.get((Object)b.h));
                    String dataId = oConvertUtils.getString((Object)jobHandlerConfig.get((Object)b.m));
                    Map<String, Object> params = this.extActFormDataService.getJsonDataById(formKey, dataId);
                    log.debug("---\u65e5\u671f\u5b9a\u65f6\u542f\u52a8\u5668\uff0c\u52a0\u8f7d\u521d\u59cb\u5316\u6570\u636e\uff1a{}", params);
                    if (params == null) {
                        params = new HashMap<String, Object>();
                        params.put(b.s, dataId);
                        params.put(b.r, formKey);
                    }
                    params.put(b.s, dataId);
                    params.put(b.r, formKey);
                    params.put(b.m, dataId);
                    params.put(b.z, "2");
                    params.put(b.h, formKey);
                    String url = "{{DOMAIN_URL}}/desform/detail/" + formKey + "/" + dataId + "?token={{TOKEN}}&taskId={{TASKID}}";
                    String mobileUrl = "{{DOMAIN_URL}}/desform/detail/" + formKey + "/" + dataId + "?token={{TOKEN}}&taskId={{TASKID}}";
                    params.put(b.u, url);
                    params.put(b.v, mobileUrl);
                    params.put(b.q, jobHandlerConfig.get((Object)b.q));
                    processInstanceHelper.createAndStartProcessInstanceWithInitialFlowElement((ProcessDefinition)processDefinitionEntity, (String)null, (String)null, (String)null, flowElement, process, params, (Map)null, null, null, true);
                } else {
                    new StartProcessInstanceCmd(processDefinitionEntity.getKey(), (String)null, (String)null, (Map)null, job.getTenantId()).execute(commandContext);
                }
            } else {
                log.debug("ignoring timer of suspended process definition {}", (Object)processDefinitionEntity.getName());
            }
        }
        catch (RuntimeException var12) {
            log.error("exception during timer execution", (Throwable)var12);
            throw var12;
        }
        catch (Exception var13) {
            log.error("exception during timer execution", (Throwable)var13);
            throw new FlowableException("exception during timer execution: " + var13.getMessage(), (Throwable)var13);
        }
    }
}

