<#assign CACHE_VERSION = "v=1715084186.10">
<!DOCTYPE html>
<html>
<head>
    <script>
        let base = "${base}";
        let baseFull = "${base}" + "${customPrePath}";

        /**
         * 获取url参数
         */
        function getRequestUrl() {
            let url = location.search;
            let theRequest = new Object();
            if (url.indexOf("?") != -1) {
                let str = url.substr(1);
                strs = str.split("&");
                for (let i = 0; i < strs.length; i++) {
                    theRequest[strs[i].split("=")[0]] = decodeURI(strs[i].split("=")[1]);
                }
            }
            return theRequest;
        }

        let token = getRequestUrl().token;
        if (token == "" || token == null) {
            token = window.localStorage.getItem('JmReport-Access-Token');
        }
        window.localStorage.setItem('JmReport-Access-Token', token);

        //update-begin---author:wangshuai ---date:20220708  for：[JMREP-2661]多租户权限集成------------
        let tenantId = getRequestUrl().tenantId;
        if ("" == tenantId || null == tenantId) {
            tenantId = window.localStorage.getItem('JmReport-Tenant-Id');
        }
        window.localStorage.setItem('JmReport-Tenant-Id', tenantId);
        //update-end---author:wangshuai ---date:20220708  for：[JMREP-2661]多租户权限集成------------
    </script>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width">
    <title>仪表盘在线设计—积木报表</title>
    <link rel="stylesheet" href="${base}${customPrePath}/drag/list/core/css/drag.css?${CACHE_VERSION}">
    <link rel="shortcut icon" href="${base}${customPrePath}/drag/list/core/img/logo.png?${CACHE_VERSION}" type="image/x-ico">
    <!-- vue -->
    <script type="text/javascript" src="${base}${customPrePath}/drag/list/core/cdn/vue/vue.min.js"></script>
    <!-- iview -->
    <link rel="stylesheet" type="text/css" href="${base}${customPrePath}/drag/list/core/cdn/iview/iview.css">
    <script type="text/javascript" src="${base}${customPrePath}/drag/list/core/cdn/iview/iview.min.js"></script>
    <!-- axios -->
    <script src="${base}${customPrePath}/drag/list/core/cdn/axios/axios.min.js"></script>
    <script src="${base}${customPrePath}/drag/list/core/cdn/axios/qs.min.js"></script>
    <!-- core -->
    <script src="${base}${customPrePath}/drag/list/core/js/request.js?${CACHE_VERSION}"></script>
    <script src="${base}${customPrePath}/drag/list/core/api/api.js?${CACHE_VERSION}"></script>
    <!-- dayjs -->
    <script src="${base}${customPrePath}/drag/list/core/js/dayjs.min.js"></script>
</head>
<body>
<!--引入自定义组件-->
<#include "./common/comps.ftl">
<div id="app" style="padding-left: 30px">
    <div class="layout" style="margin-left: -30px;margin-top: -10px;">
        <div style="background-color: #1890FF;height: 47px">
            <span class="aui-logo"></span>
            <span class="jimu-header">欢迎进入仪表盘工作台 </span>
        </div>
        <Layout>
            <Sider breakpoint="md" collapsible :collapsed-width="78" v-model="isCollapsed">
                <i-menu theme="primary" width="auto" :class="menuitemClasses" active-name="1"
                        :open-names="['sub']" @on-select="onMenuSelect">
                    <Submenu name="sub">
                        <template slot="title">
                            <Icon type="md-cube" />
                            </Icon>
                            <span>仪表盘管理</span>
                        </template>
                        <Menu-Item name="1">
                            <Icon type="md-grid"/>
                            </Icon>
                            <span>仪表盘设计</span>
                        </Menu-Item>
                        <Menu-Item name="2">
                            <Icon type="md-apps"></Icon>
                            <span>门户设计</span>
                        </Menu-Item>
                    </Submenu>
                </i-menu>
                <div slot="trigger"></div>
            </Sider>
            <Tabs value="name1" style="width: 100%" @on-click="tabsClick">
                <tab-pane icon="md-desktop" label="仪表盘设计" name="name1" class="jimu-tab">
                    <div style="display: flex;justify-content:space-between;margin-left:16px;margin-right: 38px;">
                        <div style="display: flex">
                            <i-input size="small" v-model="name" @keyup.enter.native="enterSearchClick" placeholder="搜索仪表盘名称"></i-input>
                        </div>
                        <div class="page">
                            <Page :total="page.total"
                                  show-total
                                  show-elevator
                                  :page-size="page.size"
                                  show-sizer
                                  @on-change="handleCurrentChange"
                                  @on-page-size-change="handleSizeChange"
                                  size="small">
                            </Page>
                        </div>
                        <div>
                            <i-select
                                transfer="true"
                                v-model="previewModel"
                                size="small"
                                style="width: 78px;text-align: center;">
                                <i-option value="view" style="font-size: 10px">视图</i-option>
                                <i-option value="list" style="font-size: 10px">列表</i-option>
                            </i-select>
                        </div>
                    </div>
                    <div style="display: flex;flex-wrap: wrap;" v-if="previewModel =='view'">
                        <div class="excel-view-item excel-list-add">
                            <a @click="createDrag">
                                <i class="ivu-icon ivu-icon-md-add" style="font-size:20px; padding-bottom: 5px;"></i>
                                <p style="letter-spacing: 2px;font-size: 14px;">新建仪表盘</p>
                            </a>
                        </div>

                        <!-- 循环开始 &ndash;&gt;-->
                        <div
                            v-for="(item,index) in dataSource"
                            :key="index"
                            class="excel-view-item"
                            @mouseover="item.editable=true"
                            @mouseout="item.editable=false">

                            <!-- 保护码 &ndash;&gt;-->
                            <span class="lock-to-right" v-if="item.protectionCode">
                               <i class="ivu-icon ivu-icon-md-lock" style="font-size: 16px"></i>
                            </span>

                            <!-- 缩略图 &ndash;&gt;-->
                            <div class="thumb">
                                <img :src="getThumbSrc(item)"/>
                                <div class="excel-edit-container" v-show="item.editable">
                                    <a :href="getDragEditUrl(item)" target="_blank">
                                        设计
                                    </a>
                                </div>
                            </div>

                            <!-- 底部 &ndash;&gt;-->
                            <div class="item-footer">
                                <Tooltip :content="item.name" placement="top-start" :transfer="true">
                                    <template slot="content">
                                        <span class="tooltip-footer-font-size">{{item.name}}</span>
                                    </template>
                                    <div class="item-name">
                                        {{ item.name }}
                                    </div>
                                </Tooltip>
                                <div style="display:flex">
                                    <a class="opt-show" :href="getDragViewUrl(item)" target="_blank">
                                        <Tooltip content="预览" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-ios-eye-outline" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-show" @click="handleEdit(item)">
                                        <Tooltip content="编辑" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-md-create" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-show" v-show="userMessage" @click="setTemplate(item,1)">
                                        <Tooltip content="收藏" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-ios-star-outline" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-show" @click="handleDelete(item)">
                                        <Tooltip content="删除" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-ios-trash" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-show" @click="handleCopy(item)">
                                        <Tooltip content="复制" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-ios-browsers" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-show" @click="handleShare(item)">
                                        <Tooltip content="分享" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-ios-share-alt" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!-- 循环结束 &ndash;&gt;-->
                    </div>
                    <div v-else style="padding: 10px 10px">
                        <i-button type="primary" @click="createDrag" size="small" style="margin-left: 6px;width:78px;font-size: 10px">
                            新建仪表盘
                        </i-button>
                        <i-table size="small" style="margin-top: 10px" border :columns="listColumns" :data="dataSource">
                            <template slot-scope="{ row, index }" slot="action">
                                <template>
                                    <a class="opt-list-show" :href="getDragViewUrl(row)" target="_blank">
                                        <Tooltip transfer="true" content="预览" placement="top">
                                            <i class="ivu-icon ivu-icon-ios-eye-outline" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-list-show" :href="getDragEditUrl(row)" target="_blank">
                                        <Tooltip transfer="true" content="编辑" placement="top">
                                            <i class="ivu-icon ivu-icon-md-create" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-list-show" v-show="userMessage" @click="setTemplate(row,1)">
                                        <Tooltip transfer="true" content="收藏" placement="top">
                                            <i class="ivu-icon ivu-icon-ios-star-outline" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-list-show" @click="handleDelete(row)">
                                        <Tooltip transfer="true" content="删除" placement="top">
                                            <i class="ivu-icon ivu-icon-ios-trash" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-list-show" @click="handleCopy(row)">
                                        <Tooltip transfer="true" content="复制" placement="top">
                                            <i class="ivu-icon ivu-icon-ios-browsers" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                </template>
                            </template>
                        </i-table>
                    </div>
                </tab-pane>
                <tab-pane icon="md-options" label="模板案例" name="name2" class="jimu-tab">
                    <div style="display: flex;justify-content:space-between;margin-left:16px;margin-right: 38px">
                        <div>
                            <i-input size="small" v-model="name" @keyup.enter.native="loadData" placeholder="搜索仪表盘名称"></i-input>
                        </div>
                        <div class="page">
                            <Page :total="page.total"
                                  show-total
                                  show-elevator
                                  :page-size="page.size"
                                  show-sizer
                                  @on-change="handleCurrentChange"
                                  @on-page-size-change="handleSizeChange"
                                  size="small">
                            </Page>
                        </div>
                        <div>
                            <i-select
                                    transfer="true"
                                    v-model="previewModel"
                                    size="small"
                                    style="width: 78px;text-align: center;">
                                <i-option value="view" style="font-size: 10px">视图</i-option>
                                <i-option value="list" style="font-size: 10px">列表</i-option>
                            </i-select>
                        </div>
                    </div>
                    <div style="display: flex;flex-wrap: wrap;" v-if="previewModel =='view'">

                        <!-- 循环开始 &ndash;&gt;-->
                        <div
                            v-for="(item,index) in dataSource"
                            :key="index"
                            class="excel-view-item"
                            @mouseover="item.editable=true"
                            @mouseout="item.editable=false">
                            <!-- 保护码 &ndash;&gt;-->
                            <span class="lock-to-right" v-if="item.protectionCode">
                               <i class="ivu-icon ivu-icon-md-lock" style="font-size: 16px"></i>
                            </span>

                            <!-- 缩略图 &ndash;&gt;-->
                            <div class="thumb" @click="toView(item)">
                                <img :src="getThumbSrc(item)"/>
<#--                                <div class="excel-edit-container" v-show="item.editable">-->
<#--                                    <a v-show="userMessage" :href="getDragEditUrl(item)" target="_blank">-->
<#--                                        设计-->
<#--                                    </a>-->
<#--                                </div>-->
                            </div>

                            <!-- 底部 &ndash;&gt;-->
                            <div class="item-footer">
                                <Tooltip placement="top-start" transfer>
                                    <template slot="content">
                                        <span class="tooltip-footer-font-size">{{item.name}}</span>
                                    </template>
                                    <div class="item-name">
                                        {{ item.name }}
                                    </div>
                                </Tooltip>
                                <div style="margin-left: 14%;">
                                    <a class="opt-show" :href="getDragViewUrl(item)" target="_blank">
                                        <Tooltip content="预览" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-ios-eye-outline" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-show" v-show="userMessage" @click="setTemplate(item,0)">
                                        <Tooltip content="取消收藏" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-ios-star" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                    <a class="opt-show" @click="handleCopy(item)">
                                        <Tooltip content="复制" placement="top" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-ios-browsers" style="font-size: 16px"></i>
                                        </Tooltip>
                                    </a>
                                </div>
                                <div v-show="userMessage">
                                    <Upload
                                        :headers="uploadHeader"
                                        :before-upload="handleUpload"
                                        :action="actionUrl"
                                        :format="['jpg','jpeg','png']"
                                        :on-format-error="handleFormatError"
                                        :on-exceeded-size="handleMaxSize"
                                        :on-success="handleSuccess">
                                        <Tooltip content="上传封面" placement="top-end" class="tooltip-footer-font-size">
                                            <i class="ivu-icon ivu-icon-md-image" style="font-size: 16px;cursor: pointer" @click="uploadFile(item)"></i>
                                        </Tooltip>
                                    </Upload>
                                </div>
                            </div>
                        </div>
                        <!-- 循环结束 &ndash;&gt;-->
                    </div>
                    <div v-else style="padding: 10px 10px">
                        <i-button type="primary" @click="createDrag" style="margin-left: 6px;width:78px;font-size: 10px" size="small">
                            新建仪表盘
                        </i-button>
                        <i-table size="small" style="margin-top: 10px" border :columns="listColumns" :data="dataSource">
                            <template slot-scope="{ row, index }" slot="action">
                                <a class="opt-list-show" v-show="userMessage" :href="getDragEditUrl(row)" target="_blank">
                                    <Tooltip transfer="true" content="编辑" placement="top" class="tooltip-footer-font-size">
                                        <i class="ivu-icon ivu-icon-md-create" style="font-size: 16px"></i>
                                    </Tooltip>
                                </a>
                                <a class="opt-list-show" :href="getDragViewUrl(row)" target="_blank">
                                    <Tooltip transfer="true" content="预览" placement="top" class="tooltip-footer-font-size">
                                        <i class="ivu-icon ivu-icon-ios-eye-outline" style="font-size: 16px"></i>
                                    </Tooltip>
                                </a>
                                <a class="opt-list-show" v-show="userMessage" @click="setTemplate(row,0)">
                                    <Tooltip transfer="true" content="取消收藏" placement="top" class="tooltip-footer-font-size">
                                        <i class="ivu-icon ivu-icon-ios-star" style="font-size: 16px"></i>
                                    </Tooltip>
                                </a>
                                <a class="opt-list-show" @click="handleCopy(row)">
                                    <Tooltip transfer="true" content="复制" placement="top" class="tooltip-footer-font-size">
                                        <i class="ivu-icon ivu-icon-ios-browsers" style="font-size: 16px"></i>
                                    </Tooltip>
                                </a>
                            </template>
                        </i-table>
                    </div>
                </tab-pane>
            </Tabs>
        </Layout>
    </div>
    <#--分享弹窗-->
    <j-share-modal ref="shareModal"></j-share-modal>
    <j-drag-modal ref="dragModal" @ok="reloadList"></j-drag-modal>
</div>
<script>
    let BASE_URL = "${base}" + "${customPrePath}";
    let currentPage = new Vue({
        el: '#app',
        data: {
            isCollapsed: false,
            token: '',//token
            tenantId: '',//租户id
            name: '',
            designerObj: {},
            loading: true,
            showEdit: false,
            dataSource: [],
            modalTitle: "",
            page: { //分页参数
                page: 1,
                size: 10,
                total: 0,
            },
            changecode: "",
            changename: "",
            menuitem: "1",
            tabpan: "name1",
            userMessage: false,
            file: null,
            uploadHeader: {},
            actionUrl: "",
            previewModel: "view",//浏览方式
            selectItem:{},
            listColumns: [
                {
                    title: '仪表盘名称',
                    key: 'name',
                    align: 'left',
                    className: 'table-background'
                },
                {
                    title: '创建时间',
                    key: 'createTime',
                    align: 'center',
                    className: 'table-background'
                },
                {
                    title: '操作',
                    width: 240,
                    align: 'center',
                    slot: 'action',
                    className: 'table-background',
                    fixed: 'right'
                }
            ],//列表的列
        },
        computed: {
            menuitemClasses: function () {
                return [
                    'menu-item',
                    this.isCollapsed ? 'collapsed-menu' : ''
                ]
            }
        },
        mounted: function () {
            this.token = token;
            this.tenantId = tenantId;
            console.log("进入页面token--------------", this.token);
            this.uploadHeader = {"X-Access-Token": this.token};
            this.actionUrl = BASE_URL + "/sys/common/upload";
            console.log("token--------------", token);
            console.log("tenantId--------------", tenantId);
            this.$nextTick(() => {
                this.dataSource = [];
                this.userInfo();
            });
        },
        methods: {
            handleSizeChange(val) {
                this.page.size = val;
                this.loadData();
            },
            handleCurrentChange(val) {
                this.page.page = val;
                this.loadData();
            },
            show: function () {
            },
            //查询用户信息并加载数据
            userInfo: function () {
                let that = this;
                $Http.get({
                    url: api.getLoginUser,
                    data: {
                        token: that.token
                    },
                    success: (res) => {
                        if (res.username) {
                            //admin可以收藏模版
                            that.userMessage = (res.username == "admin");
                        }
                        that.$nextTick(() => {
                            that.loadData();
                        });
                    },
                    error: (err) => {
                        console.error(err);
                    }
                }, that)
            },
            reloadList(){
                this.page = {page: 1, size: 10, total: 0};
                this.loadData()
            },
            //加载数据
            loadData: function (name) {
                let that = this;
                if (name != null && name != "") {
                    that.tabpan = name;
                    that.page = {page: 1, size: 10, total: 0,};
                }
                //查询报表名称加trim
                if (that.name) {
                    that.name = that.name.trim();
                }
                let url = "";
                that.dataSource = [];
                if (that.tabpan == "name1") {
                    url = api.queryPageList
                } else {
                    url = api.queryTemplateList
                }
                $Http.get({
                    url: url,
                    data: {
                        pageNo: that.page.page,
                        pageSize: that.page.size,
                        type: that.menuitem,
                        izTemplate: that.tabpan == "name1"?"0":"1",
                        name: that.name,
                        token: that.token
                    },
                    success: (res) => {
                        console.log("res", res)
                        let records = res.records;
                        records.forEach(item => {
                            item['editable'] = false
                        })
                        that.dataSource = res.records || [];
                        that.page.total = res.total;
                    },
                    error: (err) => {
                        console.error(err);
                    }
                }, that)
            },
            //新建仪表盘
            createDrag: function () {
                this.$refs.dragModal.show({
                    type: this.menuitem,
                    designType: 100,
                    theme: 'default',
                    style: 'default'
                })
            },
            //编辑仪表盘
            handleEdit: function (item) {
                this.$refs.dragModal.show({...item})
            },
            //分享仪表盘
            handleShare: function (item) {
                let protocol = window.location.protocol;
                let host = window.location.host;
                let url = protocol+"//"+host+BASE_URL+"/drag/share?pageId="+item.id;
                url = this.splicingToken(url);
                this.$refs.shareModal.show(url)
            },
            /**
             * 为路径拼接token
             * @param url 需要拼接的路径
             * @return 拼接后的token
             */
            splicingToken(url) {
                if (this.token && "null" != this.token) {
                    url = this.splicingUrl("token", this.token, url);
                }
                if (this.tenantId && "null" !== this.tenantId) {
                    url = this.splicingUrl("tenantId", this.tenantId, url);
                }
                return url;
            },
            /**
             * 拼接路径
             * @param name
             * @param value
             * @param url
             */
            splicingUrl(name, value, url) {
                if (url.indexOf("?") !== -1) {
                    url = url + "&" + name + "=" + value;
                } else {
                    url = url + "?" + name + "=" + value;
                }
                return url;
            },
            //删除报表
            handleDelete: function (item) {
                $Http.confirm({
                    title: '删除仪表盘',
                    content: '是否确认删除?',
                    url: api.deleteDrag,
                    data: {
                        id: item.id,
                        token: this.token
                    },
                    success: (result) => {
                        this.loadData();
                    }
                }, this);
            },
            //复制模版
            handleCopy: function (item) {
                $Http.confirm({
                    title: '复制仪表盘',
                    content: '是否确认复制?',
                    url: api.dragCopy,
                    method: 'get',
                    data: {
                        id: item.id,
                        token: this.token
                    },
                    success: (result) => {
                        this.loadData();
                    }
                }, this);
            },
            handlerViewExcel: function (item) {
                console.log(item)
            },
            getDragEditUrl: function (item) {
                //update-begin---author:wangshuai ---date:20220215  for：[issues/I4SOSH]做完的积木报表，预览生成的访问地址，默认都加了token=null------------
                return this.splicingToken(api.index + "?pageId=" +item.id);
                //update-end---author:wangshuai ---date:20220215  for：[issues/I4SOSH]做完的积木报表，预览生成的访问地址，默认都加了token=null------------
            },
            getDragViewUrl: function (item) {
                //update-begin---author:wangshuai ---date:20220215  for：[issues/I4SOSH]做完的积木报表，预览生成的访问地址，默认都加了token=null------------
                return this.splicingToken(api.view + "?pageId=" + item.id);
                //update-end---author:wangshuai ---date:20220215  for：[issues/I4SOSH]做完的积木报表，预览生成的访问地址，默认都加了token=null------------
            },
            toView: function (item) {
                let url = this.splicingToken(api.view + "?pageId=" + item.id);
                window.open(url,'_blank');
            },
            getLabelText1: function (createElement) {
                return createElement('div',
                    {
                        style: {color: '#fff'}
                    },
                    [
                        createElement('Icon', {props: {type: 'ios-checkmark'}}),
                        '模板库'
                    ]
                )
            },
            onMenuSelect: function (name) {
                this.menuitem = name;
                this.page = {page: 1, size: 10, total: 0,};
                this.dataSource = [];
                this.name = ""
                this.loadData();
            },
            //报表设计和模板案例点击事件
            tabsClick(name) {
                this.name = ""
                this.loadData(name)
            },
            //回车搜索事件
            enterSearchClick() {
                this.loadData()
            },
            //设置取消模版
            setTemplate: function (item, status) {
                let content = (status == 1) ? '是否确认设置为模板?' : '是否确认取消模板?';
                let title = (status == 1) ? '收藏' : '取消收藏'
                $Http.confirm({
                    title: title,
                    content: content,
                    url: api.setTemplate,
                    contentType: 'json',
                    method: 'post',
                    data: {
                        id: item.id,
                        izTemplate: status,
                        token: this.token
                    },
                    success: (result) => {
                        this.loadData();
                    }
                }, this);
            },
            uploadFile(item){
                this.selectItem = {...item}
            },
            handleUpload(file) {
                this.file = file;
                return true;
            },
            handleFormatError(file) {
                this.$Notice.warning({
                    title: '文件格式不正确',
                    desc: '文件 ' + file.name + ' 格式不正确，请上传 jpg 或 png 格式的图片。'
                });
            },
            handleMaxSize(file) {
                this.$Notice.warning({
                    title: '超出文件大小限制',
                    desc: '文件 ' + file.name + ' 太大，不能超过 2M。'
                });
            },
            handleSuccess(res) {
                let that = this;
                if (res != null) {
                    that.$Message.success("上传成功");
                    console.log( {
                        id: that.selectItem.id,
                        coverUrl: res.message
                    })
                    $Http.post({
                        contentType: 'json',
                        url: api.edit,
                        data: {
                            id: that.selectItem.id,
                            coverUrl: res.message
                        },
                        success: (res) => {
                            if (res) {
                                that.reloadList()
                            }
                        },
                        error: () => {
                            that.$Message.warning("封面更新失败！")
                        }
                    })
                }
            },
            // 获取缩略图的预览地址
            getThumbSrc(item) {
                if (!item.coverUrl) {
                    return `${base}${customPrePath}/drag/list/core/img/drag_cover.png`
                } else {
                    if (item.coverUrl.indexOf('http') == 0) {
                        return item.coverUrl
                    } else {
                        return "${base}" + "${customPrePath}" + JM_VIEW_IMG_URL + "/" + item.coverUrl
                    }
                }
            },
            /**
             * 真实删除
             * @param item
             */
            handleRealDelete(item) {
                let that = this;
                this.$Modal.confirm({
                    title: "彻底删除",
                    content: "确定要彻底删除吗，删除之后无法恢复",
                    closable: true,
                    onOk: (res) => {
                        $Http.del({
                            url: api.deleteReportById,
                            data: {
                                id: item.id
                            },
                            success: (res) => {
                                that.loadData();
                            }
                        })
                    },
                });
            },
            /**
             * 撤回
             * @param item
             */
            handleReduction(item) {
                let that = this;
                $Http.post({
                    contentType: 'json',
                    url: api.revertReportById,
                    data: {
                        id: item.id
                    },
                    success: (res) => {
                        that.loadData();
                    }
                })
            }
        }
    })
</script>
<#include "./common/tj.ftl">
</body>
<style>
    body{
        background: #ffffff
    }

    /** list页面样式 */
    .ivu-tabs-nav .ivu-tabs-tab{color: #000000}
    .ivu-tabs-nav .ivu-tabs-tab-active {color: #2d8cf0;}
    .ivu-tabs-bar {border-bottom-color:  rgba(131, 125, 125, 0.5);}

    .excel-list-add{
        height: 184px;
        width: 258px;
        border: 1px solid #00baff;
        font-size: 14px;
        color: #8eeeff;
        background-image: linear-gradient(-90deg, rgba(169,222,225, .39) 0, rgba(0, 174, 255, .19) 100%);
        box-shadow: 0 0 10px 0 rgba(55, 224, 255, .3);
        cursor: pointer;
    }
    .excel-list-add a{
        height: 100%;
        color: #00BFFF;
        flex-direction: column;
        display: flex;
        justify-content: center;
        align-items: center;
    }
    .excel-list-add a:hover{
        color:#2d8cf0;
    }
    .excel-view-item{
        position: relative;
        margin: 16px;
        display: flex;
        flex-direction: column;
        width: 229px;
        height: 162px;
        -webkit-box-shadow:0 0 6px #000000;
        box-shadow: 0 0 6px #000000;
        border-radius: 5px;
        overflow: hidden;
    }

    /*右上角锁标记*/
    .lock-to-right{
        z-index: 1;
        color: #fff;
        position: absolute;
        right: 0;
        top: 0;
    }

    .lock-to-right >i{
        position: relative;
        right: 5px;
        top: 2px;
        color: #db2828;
    }

    .lock-to-right::after {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        border-style: solid;
        border-width: 0;
        z-index: -1
    }

    .excel-view-item:hover{
        box-shadow: 0 0 10px #000000;
        -webkit-box-shadow:0 0 10px #000000;
        animation: mymove .2s ;
        -webkit-animation: move .2s;
    }
    .excel-view-item .thumb {
        position: relative;
        height: calc(100% - 36px);
    }
    .excel-view-item .thumb img{
        width: 100%;height: 100%
    }
    .excel-view-item .item-footer{
        font-size: 12px;
        width: 100%;
        height: 36px;
        display: flex;
        align-items: center;
        position: absolute;
        bottom: 0;
        justify-content: space-between;
        background: #1d262e;
        box-sizing: border-box;
        padding: 0 10px;
        color: #bcc9d4;
    }
    .excel-view-item .item-name{
        width: 100px;
        padding: 0 5px;
        line-height: 28px;
        text-overflow: ellipsis;
        overflow: hidden;
        white-space: nowrap;
        border: 1px solid transparent;
    }
    .opt-show{
        color: #bcc9d4;
    }
    .opt-list-show{
        color: #696969;
    }

    .excel-edit-container{
        position: absolute;
        top: 0;
        left: 0;
        /*background-color: rgba(29,38,46,0.5);*/
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .excel-edit-container a{
        display: inline-block;
        vertical-align: middle;
        height: 32px;
        line-height: 32px;
        padding: 0 30px;
        box-sizing: border-box;
        outline: 0;
        text-align: center;
        font-size: 14px;
        background-image: linear-gradient(-225deg, #00d3f1 0, #12b3ff 100%);
        color: #ffffff;
        border: none;
        transition: .3s ease;
        cursor: pointer;
    }
    <#--.aui-logo {-->
    <#--    display: block;-->
    <#--    height: 32px;-->
    <#--    width: 130px;-->
    <#--    background: url(`${base}/drag/list/core/img/jim_logo.png`) center no-repeat;-->
    <#--    background-size: contain;-->
    <#--    margin: 10px 35px;-->
    <#--    position: relative;-->
    <#--    top: 7px;-->
    <#--}-->
    .ivu-layout-sider-children{
        padding-top:0;
    }
    .jimu-header{
        color: white;
        font-size: 14px;
        position: relative;
        top: -29px;
        left: 206px;
    }
    .ivu-modal-confirm-head-icon {
        font-size: 28px;
    }
    .ivu-modal-confirm-head-title {
        display: inline-block;
        vertical-align: middle;
        margin-left: 12px;
        font-size: 16px;
        color: #17233d;
        font-weight: 500;
    }
    .ivu-modal-confirm-body {
        padding: 15px 0 0 15px;
        font-size: 13px;
        color: #515a6e;
        position: relative;
        border-top: 1px solid #e8e8e8;
    }
    .ivu-page,
    .ivu-page-prev,
    .ivu-page-next,
    .ivu-select-selection,
    .ivu-select-dropdown,
    .ivu-page.mini .ivu-page-options-elevator input
    {
        background-color: #ffffff;
        color: #515a6e;
    }
    .page{
        display: flex;
        justify-content: center;
        -webkit-box-pack: center;
    }
    .ivu-page-item{
        background-color: #ffffff;
        border: 1px solid rgba(131, 125, 125, 0.5);
    }
    .ivu-page-item-active{
        background-color: white;
        border: 1px solid #409eff;
    }
    .ivu-page-item a{
        margin: 0 6px;
        text-decoration: none;
        color: #515a6e;
    }
    .ivu-page-next a, .ivu-page-prev a {
        font-size: 14px;
        color: #515a6e;
    }
    .ivu-spin-fix{
        background-color: rgba(131, 125, 125, 0.5);
    }
    .title{
        font-size: 20px;
        color: #000000;
        text-align: center;
        line-height: 60px;
        font-weight: 500;
    }
    .ivu-layout-sider {
        transition: all .2s ease-in-out;
        position: relative;
        background: #ffffff;
    }
    .ivu-layout {
        display: flex;
        -webkit-box-orient: vertical;
        -webkit-box-direction: normal;
        flex-direction: column;
        -webkit-box-flex: 1;
        flex: auto;
        background: #ffffff;
    }
    .ivu-menu-dark.ivu-menu-vertical .ivu-menu-opened .ivu-menu-submenu-title  {
        background: #ffffff;
    }
    .ivu-menu-dark.ivu-menu-vertical .ivu-menu-opened {
        background: #ffffff;
    }
    .ivu-upload-list{
        display: none;
    }
    .ivu-table-tip table tbody tr td{
        background-color: #ffffff;
        color: #000000;
    }
    .ivu-select-dropdown-list .ivu-select-item-focus{
        background: none !important;
    }
    /*列表底部tooltip字体大小*/
    .tooltip-footer-font-size .ivu-tooltip-inner{
        font-size: 12px;
    }
    .tooltip-footer-font-size{
        font-size: 12px;
    }
</style>
</html>
