/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.enums.vip.PayVipResourceEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.IpUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.vo.WeiXinPay;
import org.jeecg.modules.pay.constant.PayConstant;
import org.jeecg.modules.pay.entity.SysVipMembership;
import org.jeecg.modules.pay.entity.SysVipPayments;
import org.jeecg.modules.pay.enums.PayVipExtendEnum;
import org.jeecg.modules.pay.service.ISysVipMembershipService;
import org.jeecg.modules.pay.service.ISysVipPaymentsService;
import org.jeecg.modules.pay.util.WeiXinPayUtil;
import org.jeecg.modules.pay.vo.PayExtendVo;
import org.jeecg.modules.pay.vo.WeChatPayStatusVo;
import org.jeecg.modules.pay.vo.WeChatQrCodeVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay"})
public class WeChatPayController {
    private static final Logger log = LoggerFactory.getLogger(WeChatPayController.class);
    @Resource
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private ISysVipPaymentsService vipPaymentsService;
    @Autowired
    private ISysVipMembershipService vipMembershipService;
    @Autowired
    private RedisUtil redisUtil;

    @GetMapping(value={"/getPayCode"})
    public Result<WeChatQrCodeVo> getPayCode(HttpServletRequest request, HttpServletResponse response) {
        WeiXinPay weiXinPay = this.jeecgBaseConfig.getWeiXinPay();
        String payNo = UUIDGenerator.generate();
        String buyYears = request.getParameter("buyYears");
        if (oConvertUtils.isEmpty((Object)buyYears)) {
            return Result.error((String)"\u8bf7\u9009\u62e9\u8d2d\u4e70\u5e74\u9650");
        }
        List<String> list = Arrays.asList(PayConstant.YEARS);
        if (!list.contains(buyYears)) {
            return Result.error((String)"\u8d2d\u4e70\u5e74\u9650\u4e0d\u5339\u914d");
        }
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request);
        if (oConvertUtils.isEmpty((Object)tenantId)) {
            return Result.error((String)"\u5f53\u524d\u767b\u5f55\u79df\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8d2d\u4e70\u4f1a\u5458\uff01");
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        Long izAdmin = this.vipPaymentsService.izHaveBuyAuth(oConvertUtils.getInt((String)tenantId), sysUser.getId());
        if (izAdmin == 0L) {
            return Result.error((String)"\u60a8\u4e0d\u662f\u8be5\u79df\u6237\u7684\u7ba1\u7406\u5458\uff0c\u65e0\u6cd5\u8d2d\u4e70\uff01");
        }
        BigDecimal total = new BigDecimal(Integer.parseInt(buyYears));
        BigDecimal price = total.multiply(PayVipResourceEnum.NORMAL_VIP.getPrice());
        BigDecimal totalPrice = price.multiply(new BigDecimal("100"));
        String payName = "\u6572\u6572\u4e91VIP";
        String createIp = IpUtils.getServerIp();
        String urlCode = "";
        try {
            urlCode = WeiXinPayUtil.getWeiXinCodeUrl(weiXinPay, payName, payNo, createIp, totalPrice, request);
        }
        catch (JeecgBootException e) {
            return Result.error((String)e.getMessage());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String token = TokenUtils.getTokenByRequest((HttpServletRequest)request);
        map.put("tenantId", tenantId);
        map.put("token", token);
        map.put("buyType", "vip");
        map.put("payCount", Integer.valueOf(buyYears));
        map.put("payPrice", price);
        map.put("payNo", payNo);
        this.redisUtil.set("pay_" + payNo, (Object)JSONObject.toJSONString(map), 360L);
        WeChatQrCodeVo weChatQrCodeVo = new WeChatQrCodeVo(urlCode, payNo, payName, total.intValue(), price);
        return Result.ok((Object)weChatQrCodeVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/notify"})
    public void notify(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03");
        StringBuilder sb = null;
        try {
            String s;
            sb = new StringBuilder();
            ServletInputStream inputStream = request.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            while ((s = in.readLine()) != null) {
                sb.append(s);
            }
            in.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, String> map = WeiXinPayUtil.xmlToMap(sb.toString());
        TreeMap<Object, Object> packageParams = new TreeMap<Object, Object>();
        if (null != map) {
            for (String parameter : map.keySet()) {
                String parameterValue = map.get(parameter);
                String v = "";
                if (null != parameterValue) {
                    v = parameterValue.trim();
                }
                packageParams.put(parameter, v);
            }
        }
        WeiXinPay weiXinPay = this.jeecgBaseConfig.getWeiXinPay();
        String resultXml = "";
        if (WeiXinPayUtil.isTenPaySign("UTF-8", packageParams, weiXinPay.getApiKey())) {
            String resultCode = (String)packageParams.get("result_code");
            String returnCode = (String)packageParams.get("return_code");
            String mchId = (String)packageParams.get("mch_id");
            String outTradeNo = (String)packageParams.get("out_trade_no");
            String transactionId = (String)packageParams.get("transaction_id");
            String totalFee = (String)packageParams.get("total_fee");
            String attach = (String)packageParams.get("attach");
            WeChatPayController weChatPayController = this;
            synchronized (weChatPayController) {
                if ("SUCCESS".equals(resultCode)) {
                    this.vipPaymentsService.updatePayStatusCompleted(outTradeNo, resultCode, returnCode, transactionId, totalFee, attach);
                    resultXml = "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml> ";
                    log.info("\u652f\u4ed8\u6210\u529f");
                } else {
                    String returnMsg = (String)packageParams.get("return_msg");
                    this.vipPaymentsService.updatePayStatusFail(outTradeNo, resultCode, resultCode, transactionId, attach);
                    resultXml = "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u652f\u4ed8\u5931\u8d25]]></return_msg></xml> ";
                    log.error("\u652f\u4ed8\u5931\u8d25\uff0c\u539f\u56e0" + returnMsg);
                }
            }
            response.getWriter().write(resultXml);
        } else {
            response.getWriter().write("\u652f\u4ed8\u5931\u8d25");
        }
    }

    @GetMapping(value={"/queryPayStatus"})
    public Result<String> queryPayStatus(@RequestParam(value="orderNo") String orderNo) {
        WeChatPayStatusVo payStatus = this.vipPaymentsService.getPayStatus(orderNo);
        String tradeState = payStatus.getTradeState();
        String tradeStateDesc = payStatus.getTradeStateDesc();
        if (oConvertUtils.isNotEmpty((Object)tradeState) && oConvertUtils.isNotEmpty((Object)tradeStateDesc)) {
            return Result.ok((String)tradeStateDesc);
        }
        return Result.error((String)payStatus.getReturnMsg());
    }

    @PostMapping(value={"/refund"})
    @RequiresRoles(value={"admin", "J3rRzjI28B"}, logical=Logical.OR)
    public Result<String> payRefund(@RequestBody SysVipPayments vipPayments, HttpServletRequest request) {
        SysVipPayments sysVipPayments = (SysVipPayments)this.vipPaymentsService.getById((Serializable)((Object)vipPayments.getId()));
        if (null == sysVipPayments) {
            return Result.error((String)"\u5f53\u524d\u652f\u4ed8\u8ba2\u5355\u672a\u627e\u5230");
        }
        String payStatus = sysVipPayments.getPayStatus();
        if ("5".equals(payStatus)) {
            return Result.error((String)("\u8ba2\u5355\u53f7\uff1a" + sysVipPayments.getTransNo() + "\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u65b0\u53d1\u8d77"));
        }
        SysVipMembership sysVipMembership = this.vipMembershipService.getEndTimeByUserId(sysVipPayments.getTenantId(), sysVipPayments.getPayTime(), sysVipPayments.getBuyType(), sysVipPayments.getBuyYears());
        String keyString = String.format("sys:cache:vip:user::%s", sysVipPayments.getTenantId());
        this.redisUtil.del(new String[]{keyString});
        WeiXinPay weiXinPay = this.jeecgBaseConfig.getWeiXinPay();
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("appid", weiXinPay.getAppId());
        parameters.put("mch_id", weiXinPay.getMchId());
        String nonceStr = RandomUtil.randomString((int)32);
        parameters.put("nonce_str", nonceStr);
        String outRefundNo = RandomUtil.randomString((int)32);
        parameters.put("out_trade_no", sysVipPayments.getPayNo());
        parameters.put("out_refund_no", outRefundNo);
        BigDecimal multiply = sysVipPayments.getTotalAmount().multiply(new BigDecimal("100"));
        if ((double)multiply.intValue() - multiply.doubleValue() == 0.0) {
            parameters.put("total_fee", String.valueOf(multiply.intValue()));
            parameters.put("refund_fee", String.valueOf(multiply.intValue()));
        } else {
            parameters.put("total_fee", multiply.toString());
            parameters.put("refund_fee", multiply.toString());
        }
        String refundDesc = "\u6572\u6572\u4e91\u4f1a\u5458\u7533\u8bf7\u9000\u6b3e";
        String buyType = sysVipPayments.getBuyType();
        if ("sms".equals(buyType)) {
            refundDesc = "\u6572\u6572\u4e91\u77ed\u4fe1\u6269\u5c55\u5305\u7533\u8bf7\u9000\u6b3e";
        } else if ("file".equals(buyType)) {
            refundDesc = "\u6572\u6572\u4e91\u9644\u4ef6\u4e0a\u4f20\u91cf\u6269\u5c55\u5305\u7533\u8bf7\u9000\u6b3e";
        } else if ("userCount".equals(buyType)) {
            refundDesc = "\u6572\u6572\u4e91\u4eba\u5458\u6269\u5c55\u5305\u7533\u8bf7\u9000\u6b3e";
        }
        parameters.put("refund_desc", refundDesc);
        String sign = WeiXinPayUtil.createSign("UTF-8", parameters, weiXinPay.getApiKey());
        parameters.put("sign", sign);
        String requestXML = WeiXinPayUtil.getRequestXml(parameters);
        String outPayResult = WeiXinPayUtil.doRefund(weiXinPay.getMchId(), "https://api.mch.weixin.qq.com/secapi/pay/refund", requestXML, weiXinPay.getCertPath());
        if (oConvertUtils.isNotEmpty((Object)outPayResult)) {
            Map<String, String> outPayMap = WeiXinPayUtil.xmlToMap(outPayResult);
            log.info("\u9000\u6b3e\u8fd4\u56de\u6d88\u606f\u901a\u77e5\uff1a\uff1a" + outPayResult);
            String returnCode = outPayMap.get("return_code");
            String returnMsg = outPayMap.get("return_msg");
            if ("FAIL".equals(returnCode)) {
                return Result.error((String)returnMsg);
            }
            if ("SUCCESS".equals(returnCode)) {
                String refundId = outPayMap.get("refund_id");
                this.vipPaymentsService.updatePayStatusRefund(vipPayments.getId(), refundId, sysVipPayments.getBuyYears(), sysVipMembership, sysVipPayments.getBuyType());
                return Result.ok((String)"\u9000\u6b3e\u6210\u529f\uff0c\u9000\u6b3e\u65f6\u95f4\u53ef\u80fd\u4f1a\u6709\u5ef6\u8fdf");
            }
        }
        return Result.error((String)"\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @GetMapping(value={"/genPayQrCode"})
    public Result<WeChatQrCodeVo> genPayQrCode(@RequestParam(name="type") String type, @RequestParam(name="value") Integer value, HttpServletRequest request) {
        String tenantId;
        List<PayExtendVo> extendList = PayVipExtendEnum.getExtendList(type);
        List collect = extendList.stream().filter(item -> item.getValue().equals(value)).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(collect) && !"userCount".equals(type)) {
            return Result.error((String)"\u672a\u627e\u5230\u5f53\u524d\u5bf9\u5e94\u7684\u6269\u5c55\u5305\uff01");
        }
        if ("userCount".equals(type)) {
            if (null == value || 0 == value) {
                return Result.error((String)"\u8d2d\u4e70\u5931\u8d25\uff0c\u8d2d\u4e70\u4eba\u6570\u4e0d\u80fd\u4e3a0");
            }
            BigDecimal price = PayVipExtendEnum.USER_COUNT.getPrice();
            BigDecimal multiply = price.multiply(new BigDecimal(value));
            PayExtendVo extendVo = new PayExtendVo();
            extendVo.setPrice(multiply);
            extendVo.setTitle(PayVipExtendEnum.USER_COUNT.getTitle());
            extendVo.setValue(value);
            if (CollectionUtil.isNotEmpty(collect)) {
                ((PayExtendVo)collect.get(0)).setPrice(multiply);
                ((PayExtendVo)collect.get(0)).setTitle(PayVipExtendEnum.USER_COUNT.getTitle());
                ((PayExtendVo)collect.get(0)).setValue(value);
            } else {
                collect.add(extendVo);
            }
        }
        if (oConvertUtils.isEmpty((Object)(tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request)))) {
            return Result.error((String)"\u5f53\u524d\u767b\u5f55\u79df\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8d2d\u4e70\u6269\u5c55\u5305\uff01");
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        Long izAdmin = this.vipPaymentsService.izHaveBuyAuth(oConvertUtils.getInt((String)tenantId), sysUser.getId());
        if (izAdmin == 0L) {
            return Result.error((String)"\u60a8\u4e0d\u662f\u8be5\u79df\u6237\u7684\u7ba1\u7406\u5458\uff0c\u65e0\u6cd5\u8d2d\u4e70\uff01");
        }
        PayExtendVo extendVo = (PayExtendVo)collect.get(0);
        WeiXinPay weiXinPay = this.jeecgBaseConfig.getWeiXinPay();
        String payNo = UUIDGenerator.generate();
        BigDecimal price = extendVo.getPrice();
        BigDecimal totalPrice = price.multiply(new BigDecimal("100"));
        String payName = "\u9644\u4ef6\u4e0a\u4f20\u91cf\u8d2d\u4e70";
        if ("sms".equals(type)) {
            payName = "\u77ed\u4fe1\u4f7f\u7528\u91cf\u8d2d\u4e70";
        } else if ("userCount".equals(type)) {
            payName = "\u4eba\u5458\u6269\u5c55\u5305\u8d2d\u4e70";
        }
        String createIp = IpUtils.getServerIp();
        String urlCode = "";
        try {
            urlCode = WeiXinPayUtil.getWeiXinCodeUrl(weiXinPay, payName, payNo, createIp, totalPrice, request);
        }
        catch (JeecgBootException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String token = TokenUtils.getTokenByRequest((HttpServletRequest)request);
        map.put("token", token);
        map.put("tenantId", tenantId);
        map.put("buyType", type);
        map.put("payCount", extendVo.getValue());
        map.put("payPrice", price);
        map.put("payNo", payNo);
        this.redisUtil.set("pay_" + payNo, (Object)JSONObject.toJSONString(map), 360L);
        WeChatQrCodeVo weChatQrCodeVo = new WeChatQrCodeVo(urlCode, payNo, payName, extendVo.getValue(), price);
        return Result.ok((Object)weChatQrCodeVo);
    }
}

