/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.desform.api.IDesformBaseApi;
import org.jeecg.common.drag.api.IDragBaseApi;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.model.LowAppCopyMenu;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.low.entity.LowAppMenu;
import org.jeecg.modules.online.low.mapper.LowAppMenuMapper;
import org.jeecg.modules.online.low.service.ILowAppMenuService;
import org.jeecg.modules.online.low.vo.LowAppMenuVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="lowAppMenuServiceImpl")
public class k
extends ServiceImpl<LowAppMenuMapper, LowAppMenu>
implements ILowAppMenuService {
    @Lazy
    @Autowired
    IDesformBaseApi desformBaseApi;
    @Lazy
    @Autowired
    IDragBaseApi dragBaseApi;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<LowAppMenuVo> listAndChildren(String appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LowAppMenu::getAppId, (Object)appId);
        queryWrapper.orderByAsc(LowAppMenu::getParentId);
        queryWrapper.orderByAsc(LowAppMenu::getOrderNum);
        List menuList = super.list((Wrapper)queryWrapper);
        ArrayList<LowAppMenuVo> filterList = new ArrayList<LowAppMenuVo>(menuList.size());
        HashMap<String, ArrayList<LowAppMenuVo>> groupMap = new HashMap<String, ArrayList<LowAppMenuVo>>(5);
        for (LowAppMenu menu : menuList) {
            JSONObject cgform;
            LowAppMenuVo vo = new LowAppMenuVo(menu);
            if ("group".equals(vo.getType())) {
                children = (ArrayList<LowAppMenuVo>)groupMap.get(vo.getId());
                if (children == null) {
                    children = new ArrayList<LowAppMenuVo>();
                }
                groupMap.put(vo.getId(), (ArrayList<LowAppMenuVo>)children);
                vo.setChildren(children);
                filterList.add(vo);
            } else if (oConvertUtils.isNotEmpty((Object)vo.getParentId())) {
                children = (List)groupMap.get(vo.getParentId());
                if (children == null) {
                    children = new ArrayList();
                }
                children.add(vo);
                groupMap.put(vo.getParentId(), (ArrayList<LowAppMenuVo>)children);
            } else {
                filterList.add(vo);
            }
            if (!"cgform".equals(vo.getType()) || (cgform = ((LowAppMenuMapper)this.baseMapper).queryCgformDetail(vo.getMenuUrl())) == null) continue;
            vo.setCgformIsTree(cgform.getString("is_tree"));
            vo.setCgformThemeTemplate(cgform.getString("theme_template"));
        }
        return filterList;
    }

    @Override
    public int calcOrderNum(String appId, String parentId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LowAppMenu::getAppId, (Object)appId);
        if (oConvertUtils.isNotEmpty((Object)parentId)) {
            queryWrapper.eq(LowAppMenu::getParentId, (Object)parentId);
        } else {
            queryWrapper.eq(LowAppMenu::getParentId, (Object)"");
        }
        Long count = super.count((Wrapper)queryWrapper);
        return count.intValue() + 1;
    }

    @Override
    public boolean saveMenu(LowAppMenu menu) {
        int newOrderNum = this.calcOrderNum(menu.getAppId(), menu.getParentId());
        menu.setOrderNum(newOrderNum);
        if (menu.getParentId() == null) {
            menu.setParentId("");
        }
        if ("form".equals(menu.getType()) && oConvertUtils.isEmpty((Object)menu.getDesformCode())) {
            String desformCode = ((LowAppMenuMapper)this.baseMapper).getDesformCodeById(menu.getMenuUrl());
            menu.setDesformCode(desformCode);
        }
        return super.save((Object)menu);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean moveToGroup(LowAppMenu menu) {
        int orderNum;
        LowAppMenu oldMenu = (LowAppMenu)super.getById((Serializable)((Object)menu.getId()));
        if (oldMenu == null) {
            throw new JeecgBootException("\u5b9e\u4f53\u4e0d\u5b58\u5728");
        }
        String appId = oldMenu.getAppId();
        if (oConvertUtils.isEmpty((Object)menu.getParentId())) {
            menu.setParentId("");
            orderNum = this.calcOrderNum(appId, "");
        } else {
            orderNum = this.calcOrderNum(appId, menu.getParentId());
        }
        menu.setOrderNum(orderNum);
        this.updateById(menu);
        ((LowAppMenuMapper)this.baseMapper).otherOrderNumMinus(appId, oldMenu.getParentId(), oldMenu.getOrderNum());
        this.redisUtil.removeAll("drag:cache:page:");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean orderToUp(LowAppMenu menu) {
        Number nextOrderNum = this.a(menu, true);
        if (nextOrderNum == null) {
            throw new JeecgBootException("\u5df2\u5728\u6700\u9876\u90e8");
        }
        return this.a(menu, nextOrderNum.intValue());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean orderToDown(LowAppMenu menu) {
        Number nextOrderNum = this.a(menu, false);
        if (nextOrderNum == null) {
            throw new JeecgBootException("\u5df2\u5728\u6700\u5e95\u90e8");
        }
        return this.a(menu, nextOrderNum.intValue());
    }

    @Override
    public LowAppMenu queryMenuByDesformIdOrCode(String lowAppId, String desformId, String desformCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (oConvertUtils.isNotEmpty((Object)lowAppId)) {
            queryWrapper.eq(LowAppMenu::getAppId, (Object)lowAppId);
        }
        queryWrapper.and(w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(LowAppMenu::getMenuUrl, (Object)desformId)).or()).eq(LowAppMenu::getMenuUrl, (Object)desformCode)).or()).eq(LowAppMenu::getDesformCode, (Object)desformCode));
        queryWrapper.and(w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(LowAppMenu::getType, (Object)"form")).or()).eq(LowAppMenu::getType, (Object)"desform"));
        return (LowAppMenu)super.getOne((Wrapper)queryWrapper);
    }

    private LowAppMenu a(Wrapper<LowAppMenu> wrapper) {
        Page page = new Page(1L, 1L);
        List menuList = super.page((IPage)page, wrapper).getRecords();
        if (menuList == null || menuList.size() == 0) {
            return null;
        }
        return (LowAppMenu)menuList.get(0);
    }

    private Number a(LowAppMenu menu, boolean isUp) {
        String appId = menu.getAppId();
        String parentId = menu.getParentId();
        Integer orderNum = menu.getOrderNum();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LowAppMenu::getAppId, (Object)appId);
        if (oConvertUtils.isNotEmpty((Object)parentId)) {
            queryWrapper.eq(LowAppMenu::getParentId, (Object)parentId);
        } else {
            queryWrapper.eq(LowAppMenu::getParentId, (Object)"");
        }
        if (isUp) {
            queryWrapper.lt(LowAppMenu::getOrderNum, (Object)orderNum);
            queryWrapper.orderByDesc(LowAppMenu::getOrderNum);
        } else {
            queryWrapper.gt(LowAppMenu::getOrderNum, (Object)orderNum);
            queryWrapper.orderByAsc(LowAppMenu::getOrderNum);
        }
        LowAppMenu nextMenu = this.a((Wrapper<LowAppMenu>)queryWrapper);
        if (nextMenu == null) {
            return null;
        }
        return nextMenu.getOrderNum();
    }

    private boolean a(LowAppMenu menu, int newOrderNum) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LowAppMenu::getOrderNum, (Object)newOrderNum);
        queryWrapper.eq(LowAppMenu::getAppId, (Object)menu.getAppId());
        if (oConvertUtils.isNotEmpty((Object)menu.getParentId())) {
            queryWrapper.eq(LowAppMenu::getParentId, (Object)menu.getParentId());
        } else {
            queryWrapper.eq(LowAppMenu::getParentId, (Object)"");
        }
        LowAppMenu updateMenu = new LowAppMenu();
        updateMenu.setOrderNum(menu.getOrderNum());
        super.update((Object)updateMenu, (Wrapper)queryWrapper);
        menu.setOrderNum(newOrderNum);
        return super.updateById((Object)menu);
    }

    @Override
    public List<LowAppMenu> queryLogicDeleted(String lowAppId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LowAppMenu::getAppId, (Object)lowAppId);
        return this.queryLogicDeleted((LambdaQueryWrapper<LowAppMenu>)wrapper);
    }

    @Override
    public List<LowAppMenu> queryLogicDeleted(LambdaQueryWrapper<LowAppMenu> wrapper) {
        if (wrapper == null) {
            wrapper = new LambdaQueryWrapper();
        }
        wrapper.eq(LowAppMenu::getDelFlag, (Object)CommonConstant.DEL_FLAG_1);
        return ((LowAppMenuMapper)this.baseMapper).selectLogicDeleted((Wrapper<LowAppMenu>)wrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean revertLogicDeleted(List<String> idList, LowAppMenu updateEntity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LowAppMenu::getAppId, (Object)updateEntity.getAppId());
        queryWrapper.orderByDesc(LowAppMenu::getOrderNum);
        LowAppMenu maxMenu = this.a((Wrapper<LowAppMenu>)queryWrapper);
        int newOrderNum = 0;
        if (maxMenu != null) {
            newOrderNum = maxMenu.getOrderNum();
        }
        for (String id : idList) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(LowAppMenu::getId, (Object)id);
            updateEntity.setOrderNum(++newOrderNum);
            ((LowAppMenuMapper)this.baseMapper).revertLogicDeleted(updateEntity, (Wrapper<LowAppMenu>)wrapper);
        }
        return true;
    }

    @Override
    public boolean removeLogicDeleted(List<String> idList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(LowAppMenu::getId, idList);
        return ((LowAppMenuMapper)this.baseMapper).deleteLogicDeleted((Wrapper<LowAppMenu>)wrapper) > 0;
    }

    @Override
    public boolean forceRemove(LambdaQueryWrapper<LowAppMenu> wrapper) {
        return ((LowAppMenuMapper)this.baseMapper).deleteLogicDeleted((Wrapper<LowAppMenu>)wrapper) > 0;
    }

    @Override
    public boolean forceRemoveByDesformId(List<String> idList) {
        return ((LowAppMenuMapper)this.baseMapper).deleteLogicDeletedByDesformId(idList) > 0;
    }

    @Override
    public void createFirstGroup(LowAppMenu lowAppMenu) {
        lowAppMenu.setType("group");
        lowAppMenu.setDelFlag(CommonConstant.DEL_FLAG_0);
        lowAppMenu.setOrderNum(1);
        ((LowAppMenuMapper)this.baseMapper).insert(lowAppMenu);
        String groupId = lowAppMenu.getId();
        String appId = lowAppMenu.getAppId();
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(LowAppMenu::getAppId, (Object)appId)).in(LowAppMenu::getType, new Object[]{"drag", "desform", "form"})).set(LowAppMenu::getParentId, (Object)groupId);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void deleteGroup(String deleteId, String groupId) {
        LowAppMenu menu = (LowAppMenu)((LowAppMenuMapper)this.baseMapper).selectById((Serializable)((Object)deleteId));
        boolean isUpdateGroup = false;
        if (menu != null) {
            LowAppMenu menu2;
            String appId = menu.getAppId();
            LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppMenu::getAppId, (Object)appId)).eq(LowAppMenu::getDelFlag, (Object)CommonConstant.DEL_FLAG_0)).eq(LowAppMenu::getType, (Object)"group");
            Long count = ((LowAppMenuMapper)this.baseMapper).selectCount((Wrapper)query1);
            if (count != null && count == 1L) {
                isUpdateGroup = true;
                groupId = "";
                LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(LowAppMenu::getAppId, (Object)appId)).in(LowAppMenu::getType, new Object[]{"drag", "desform", "form"})).set(LowAppMenu::getParentId, (Object)groupId);
                this.update((Wrapper)updateWrapper);
            }
            if (oConvertUtils.isNotEmpty((Object)groupId) && (menu2 = (LowAppMenu)((LowAppMenuMapper)this.baseMapper).selectById((Serializable)((Object)groupId))) != null) {
                LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(LowAppMenu::getAppId, (Object)appId)).eq(LowAppMenu::getParentId, (Object)deleteId)).in(LowAppMenu::getType, new Object[]{"drag", "desform", "form"})).set(LowAppMenu::getParentId, (Object)groupId);
                this.update((Wrapper)updateWrapper);
            }
            this.removeById((Serializable)((Object)deleteId));
        }
    }

    @Override
    public void changeOrder(JSONObject jsonObject) {
        JSONArray array = jsonObject.getJSONArray("info");
        ArrayList<LowAppMenu> list = new ArrayList<LowAppMenu>();
        for (int i2 = 0; i2 < array.size(); ++i2) {
            JSONObject json = array.getJSONObject(i2);
            String id = json.getString("id");
            Integer orderNum = json.getInteger("orderNum");
            LowAppMenu lowAppMenu = new LowAppMenu();
            lowAppMenu.setId(id);
            lowAppMenu.setOrderNum(orderNum);
            list.add(lowAppMenu);
        }
        this.saveOrUpdateBatch(list);
    }

    @Override
    public void deleteMenu(String id) {
        LowAppMenu menu = (LowAppMenu)this.getById((Serializable)((Object)id));
        if (menu != null) {
            String menuType = menu.getType();
            boolean isIdForm = "form".equals(menuType);
            if ("desform".equals(menuType) || isIdForm) {
                String desformCode = menu.getMenuUrl();
                if (isIdForm) {
                    desformCode = menu.getDesformCode();
                }
                this.desformBaseApi.deleteDesignForm(desformCode);
            } else if ("drag".equals(menuType)) {
                try {
                    this.dragBaseApi.deleteDragPage(menu.getMenuUrl());
                }
                catch (Exception e2) {
                    this.log.error(e2.getMessage());
                }
            }
            this.removeById((Serializable)((Object)id));
        }
    }

    @Override
    public void updateMenu(LowAppMenu lowAppMenu) {
        LowAppMenu menu = (LowAppMenu)this.getById((Serializable)((Object)lowAppMenu.getId()));
        if (menu != null) {
            String newName = lowAppMenu.getMenuName();
            if (oConvertUtils.isNotEmpty((Object)newName) && !newName.equals(menu.getMenuName())) {
                String menuType = menu.getType();
                menu.setMenuName(newName);
                boolean isIdForm = "form".equals(menuType);
                if ("desform".equals(menuType) || isIdForm) {
                    ((LowAppMenuMapper)this.baseMapper).updateDesignFormName(menu, isIdForm);
                    String desformCode = isIdForm ? menu.getDesformCode() : menu.getMenuUrl();
                    this.redisUtil.removeAll("sys:cache:desform:byCode::" + desformCode + "*");
                } else if ("drag".equals(menuType)) {
                    ((LowAppMenuMapper)this.baseMapper).updateDragName(menu);
                }
            }
            this.updateById(lowAppMenu);
        }
    }

    @Override
    public void copyMenu(String menuId) {
        LowAppMenu menu = (LowAppMenu)((LowAppMenuMapper)this.baseMapper).selectById((Serializable)((Object)menuId));
        if (menu != null) {
            String menuType = menu.getType();
            String menuUrl = menu.getMenuUrl();
            LowAppMenu appMenu = new LowAppMenu();
            BeanUtils.copyProperties((Object)menu, (Object)appMenu);
            boolean isIdForm = "form".equals(menu.getType());
            if ("desform".equals(menuType) || isIdForm) {
                LowAppCopyMenu copyMenu = new LowAppCopyMenu(menuUrl, "menu");
                copyMenu.setIdForm(isIdForm);
                LowAppCopyMenu copyResult = this.desformBaseApi.copyDesignForm(copyMenu);
                if (isIdForm) {
                    menuUrl = copyResult.getNewFormId();
                    appMenu.setDesformCode(copyResult.getNewFormCode());
                } else {
                    menuUrl = copyResult.getNewFormCode();
                }
            } else if ("drag".equals(menuType)) {
                menuUrl = this.dragBaseApi.copyDragPage(menuUrl, null);
            }
            appMenu.setId(null);
            appMenu.setMenuUrl(menuUrl);
            String menuName = menu.getMenuName();
            appMenu.setMenuName(menuName + "-\u590d\u5236");
            ((LowAppMenuMapper)this.baseMapper).insert(appMenu);
        }
    }

    @Override
    public void moveMenu2App(LowAppMenu lowAppMenu) {
        int orderNum = this.calcOrderNum(lowAppMenu.getAppId(), lowAppMenu.getParentId());
        lowAppMenu.setOrderNum(orderNum);
        ((LowAppMenuMapper)this.baseMapper).moveMenu2App(lowAppMenu);
        String menuType = lowAppMenu.getType();
        if ("desform".equals(menuType)) {
            ((LowAppMenuMapper)this.baseMapper).updateDesignFormAppId(lowAppMenu.getAppId(), lowAppMenu.getMenuUrl());
        } else if ("form".equals(menuType)) {
            ((LowAppMenuMapper)this.baseMapper).updateDesignFormAppId(lowAppMenu.getAppId(), lowAppMenu.getDesformCode());
        } else if ("drag".equals(menuType)) {
            ((LowAppMenuMapper)this.baseMapper).updateDragAppId(lowAppMenu);
        }
        this.redisUtil.removeAll("drag:cache:page:");
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getOrderNum": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return LowAppMenu::getOrderNum;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return LowAppMenu::getOrderNum;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return LowAppMenu::getOrderNum;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return LowAppMenu::getOrderNum;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return LowAppMenu::getOrderNum;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return LowAppMenu::getOrderNum;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) break;
                return LowAppMenu::getOrderNum;
            }
            case "getType": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getType;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getType;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getType;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getType;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getType;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppMenu::getType;
            }
            case "getMenuUrl": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getMenuUrl;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppMenu::getMenuUrl;
            }
            case "getDelFlag": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) {
                    return LowAppMenu::getDelFlag;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) break;
                return LowAppMenu::getDelFlag;
            }
            case "getDesformCode": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppMenu::getDesformCode;
            }
            case "getId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppMenu::getId;
            }
            case "getParentId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getParentId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppMenu::getParentId;
            }
            case "getAppId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppMenu::getAppId;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

