/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AssertDelegateTarget;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.CharSequenceAssert;
import org.assertj.core.api.GenericComparableAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.PathAssert;

public class AssertionsForInterfaceTypes
extends AssertionsForClassTypes {
    public static <T> T assertThat(AssertProvider<T> component) {
        return component.assertThat();
    }

    protected AssertionsForInterfaceTypes() {
    }

    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assertThat(CharSequence actual) {
        return new CharSequenceAssert(actual);
    }

    public static <T> AbstractIterableAssert<?, ? extends Iterable<? extends T>, T> assertThat(Iterable<? extends T> actual) {
        return new IterableAssert<T>(actual);
    }

    public static <T> AbstractIterableAssert<?, ? extends Iterable<? extends T>, T> assertThat(Iterator<? extends T> actual) {
        return new IterableAssert<T>(actual);
    }

    public static <T> AbstractListAssert<?, ? extends List<? extends T>, T> assertThat(List<? extends T> actual) {
        return new ListAssert<T>(actual);
    }

    public static <T> AbstractListAssert<?, ? extends List<? extends T>, T> assertThat(Stream<? extends T> actual) {
        return new ListAssert<T>(actual);
    }

    public static AbstractPathAssert<?> assertThat(Path actual) {
        return new PathAssert(actual);
    }

    public static <K, V> MapAssert<K, V> assertThat(Map<K, V> actual) {
        return new MapAssert<K, V>(actual);
    }

    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assertThat(T actual) {
        return new GenericComparableAssert<T>(actual);
    }

    public static <T extends AssertDelegateTarget> T assertThat(T assertion) {
        return assertion;
    }
}

