/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.listener.global;

import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class AutoCompleteCmd
implements Command<Object> {
    private String taskId;
    private String comment;
    private Map<String, Object> variables;

    public AutoCompleteCmd(String taskId, Map<String, Object> variables, String comment) {
        this.taskId = taskId;
        this.variables = variables;
        this.comment = comment;
    }

    public Object execute(CommandContext commandContext) {
        TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (this.variables != null) {
            taskEntity.setExecutionVariables(this.variables);
        }
        taskEntity.fireEvent("complete");
        if (Authentication.getAuthenticatedUserId() != null && taskEntity.getProcessInstanceId() != null) {
            taskEntity.getProcessInstance().involveUser(Authentication.getAuthenticatedUserId(), "participant");
        }
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, this.comment, false);
        if (taskEntity.getExecutionId() != null) {
            ExecutionEntity executionEntity = taskEntity.getExecution();
            executionEntity.removeTask(taskEntity);
            executionEntity.signal(null, null);
        }
        return null;
    }
}

