/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.aspect;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.pojo.RoleInfo;
import org.jeecg.modules.extbpm.process.pojo.UserInfo;
import org.jeecg.modules.extbpm.process.service.IExtActProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="sysUserAspect")
public class SysUserAspect {
    private static final Logger log = LoggerFactory.getLogger(SysUserAspect.class);
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private IExtActProcessService extActProcessService;

    @Pointcut(value="execution(public * org.jeecg.modules.system.controller.SysUserController.add(..))")
    public void excudeServiceAdd() {
    }

    @Around(value="excudeServiceAdd()")
    public Object doAroundAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        try {
            Object[] objectArray = pjp.getArgs();
            JSONObject jSONObject = (JSONObject)objectArray[0];
            String string = jSONObject.getString("username");
            log.info("------------SysUserAspect------add----" + string);
            LoginUser loginUser = this.sysBaseAPI.getUserByName(string);
            if (loginUser != null && CommonConstant.ACT_SYNC_1.equals(loginUser.getActivitiSync())) {
                UserInfo userInfo = new UserInfo();
                userInfo.setUuid(loginUser.getId());
                userInfo.setFirstName(loginUser.getRealname());
                userInfo.setEmail(loginUser.getEmail());
                userInfo.setId(loginUser.getUsername());
                List<RoleInfo> list = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                this.extActProcessService.saveActIdMembership(userInfo, list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.system.controller.SysUserController.edit(..))")
    public void excudeServiceEdit() {
    }

    @Around(value="excudeServiceEdit()")
    public Object doAroundEdit(ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        try {
            Object[] objectArray = pjp.getArgs();
            JSONObject jSONObject = (JSONObject)objectArray[0];
            String string = jSONObject.getString("username");
            log.info("------------SysUserAspect------edit----" + string);
            LoginUser loginUser = this.sysBaseAPI.getUserByName(string);
            if (loginUser != null) {
                if (CommonConstant.ACT_SYNC_1.equals(loginUser.getActivitiSync())) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setUuid(loginUser.getId());
                    userInfo.setFirstName(loginUser.getRealname());
                    userInfo.setEmail(loginUser.getEmail());
                    userInfo.setId(loginUser.getUsername());
                    List<RoleInfo> list = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                    this.extActProcessService.saveActIdMembership(userInfo, list);
                } else {
                    this.extActProcessService.deleteActIdMembership(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.system.controller.SysUserController.putRecycleBin(..))")
    public void excudeServicePutRecycleBin() {
    }

    @Around(value="excudeServicePutRecycleBin()")
    public Object doAroundPutRecycleBin(ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        try {
            Object[] objectArray = pjp.getArgs();
            JSONObject jSONObject = (JSONObject)objectArray[0];
            String string = jSONObject.getString("userIds");
            log.info("------------SysUserAspect------PutRecycleBin----" + string);
            if (oConvertUtils.isNotEmpty((Object)string)) {
                List list = this.sysBaseAPI.queryAllUserByIds(string.split(","));
                for (LoginUser loginUser : list) {
                    if (!CommonConstant.ACT_SYNC_1.equals(loginUser.getActivitiSync())) continue;
                    UserInfo userInfo = new UserInfo();
                    userInfo.setUuid(loginUser.getId());
                    userInfo.setFirstName(loginUser.getRealname());
                    userInfo.setEmail(loginUser.getEmail());
                    userInfo.setId(loginUser.getUsername());
                    List<RoleInfo> list2 = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                    this.extActProcessService.saveActIdMembership(userInfo, list2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.system.controller.SysUserController.delete(..))")
    public void excudeServiceDelete() {
    }

    @Around(value="excudeServiceDelete()")
    public Object doAroundDelete(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        try {
            object = pjp.getArgs();
            String string = (String)object[0];
            log.info("------------SysUserAspect------delete----" + string);
            LoginUser loginUser = this.sysBaseAPI.getUserById(string);
            if (loginUser != null) {
                this.extActProcessService.deleteActIdMembership(loginUser.getUsername());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = pjp.proceed();
        return object;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.system.controller.SysUserController.deleteBatch(..))")
    public void excudeServiceDeleteBatch() {
    }

    @Around(value="excudeServiceDeleteBatch()")
    public Object doAroundDeleteBatch(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        try {
            String[] stringArray;
            object = pjp.getArgs();
            String string = (String)object[0];
            log.info("------------SysUserAspect------deleteBatch----" + string);
            for (String string2 : stringArray = string.split(",")) {
                LoginUser loginUser = this.sysBaseAPI.getUserById(string2);
                if (loginUser == null) continue;
                this.extActProcessService.deleteActIdMembership(loginUser.getUsername());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = pjp.proceed();
        return object;
    }
}

