/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.image.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.AssociationDirection;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.ManualTask;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Task;
import org.activiti.bpmn.model.TextAnnotation;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.image.impl.DefaultProcessDiagramCanvas;

public class DefaultProcessDiagramGenerator
implements ProcessDiagramGenerator {
    protected Map<Class<? extends BaseElement>, ActivityDrawInstruction> a = new HashMap<Class<? extends BaseElement>, ActivityDrawInstruction>();
    protected Map<Class<? extends BaseElement>, ArtifactDrawInstruction> b = new HashMap<Class<? extends BaseElement>, ArtifactDrawInstruction>();

    public DefaultProcessDiagramGenerator() {
        this(1.0);
    }

    public DefaultProcessDiagramGenerator(final double scaleFactor) {
        this.a.put(StartEvent.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                StartEvent startEvent = (StartEvent)flowNode;
                if (startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty()) {
                    EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                    if (eventDefinition instanceof TimerEventDefinition) {
                        processDiagramCanvas.drawTimerStartEvent(graphicInfo, scaleFactor);
                    } else if (eventDefinition instanceof ErrorEventDefinition) {
                        processDiagramCanvas.drawErrorStartEvent(graphicInfo, scaleFactor);
                    } else if (eventDefinition instanceof SignalEventDefinition) {
                        processDiagramCanvas.drawSignalStartEvent(graphicInfo, scaleFactor);
                    } else if (eventDefinition instanceof MessageEventDefinition) {
                        processDiagramCanvas.drawMessageStartEvent(graphicInfo, scaleFactor);
                    } else {
                        processDiagramCanvas.drawNoneStartEvent(graphicInfo);
                    }
                } else {
                    processDiagramCanvas.drawNoneStartEvent(graphicInfo);
                }
            }
        });
        this.a.put(IntermediateCatchEvent.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                IntermediateCatchEvent intermediateCatchEvent = (IntermediateCatchEvent)flowNode;
                if (intermediateCatchEvent.getEventDefinitions() != null && !intermediateCatchEvent.getEventDefinitions().isEmpty()) {
                    if (intermediateCatchEvent.getEventDefinitions().get(0) instanceof SignalEventDefinition) {
                        processDiagramCanvas.drawCatchingSignalEvent(flowNode.getName(), graphicInfo, true, scaleFactor);
                    } else if (intermediateCatchEvent.getEventDefinitions().get(0) instanceof TimerEventDefinition) {
                        processDiagramCanvas.drawCatchingTimerEvent(flowNode.getName(), graphicInfo, true, scaleFactor);
                    } else if (intermediateCatchEvent.getEventDefinitions().get(0) instanceof MessageEventDefinition) {
                        processDiagramCanvas.drawCatchingMessageEvent(flowNode.getName(), graphicInfo, true, scaleFactor);
                    }
                }
            }
        });
        this.a.put(ThrowEvent.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                ThrowEvent throwEvent = (ThrowEvent)flowNode;
                if (throwEvent.getEventDefinitions() != null && !throwEvent.getEventDefinitions().isEmpty()) {
                    if (throwEvent.getEventDefinitions().get(0) instanceof SignalEventDefinition) {
                        processDiagramCanvas.drawThrowingSignalEvent(graphicInfo, scaleFactor);
                    } else if (throwEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) {
                        processDiagramCanvas.drawThrowingCompensateEvent(graphicInfo, scaleFactor);
                    } else {
                        processDiagramCanvas.drawThrowingNoneEvent(graphicInfo, scaleFactor);
                    }
                } else {
                    processDiagramCanvas.drawThrowingNoneEvent(graphicInfo, scaleFactor);
                }
            }
        });
        this.a.put(EndEvent.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                EndEvent endEvent = (EndEvent)flowNode;
                if (endEvent.getEventDefinitions() != null && !endEvent.getEventDefinitions().isEmpty()) {
                    if (endEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) {
                        processDiagramCanvas.drawErrorEndEvent(flowNode.getName(), graphicInfo, scaleFactor);
                    } else {
                        processDiagramCanvas.drawNoneEndEvent(graphicInfo, scaleFactor);
                    }
                } else {
                    processDiagramCanvas.drawNoneEndEvent(graphicInfo, scaleFactor);
                }
            }
        });
        this.a.put(Task.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawTask(flowNode.getName(), graphicInfo);
            }
        });
        this.a.put(UserTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawUserTask(flowNode.getName(), graphicInfo, scaleFactor);
            }
        });
        this.a.put(ScriptTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawScriptTask(flowNode.getName(), graphicInfo, scaleFactor);
            }
        });
        this.a.put(ServiceTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                ServiceTask serviceTask = (ServiceTask)flowNode;
                if ("camel".equalsIgnoreCase(serviceTask.getType())) {
                    processDiagramCanvas.drawCamelTask(serviceTask.getName(), graphicInfo, scaleFactor);
                } else if ("mule".equalsIgnoreCase(serviceTask.getType())) {
                    processDiagramCanvas.drawMuleTask(serviceTask.getName(), graphicInfo, scaleFactor);
                } else {
                    processDiagramCanvas.drawServiceTask(serviceTask.getName(), graphicInfo, scaleFactor);
                }
            }
        });
        this.a.put(ReceiveTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawReceiveTask(flowNode.getName(), graphicInfo, scaleFactor);
            }
        });
        this.a.put(SendTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawSendTask(flowNode.getName(), graphicInfo, scaleFactor);
            }
        });
        this.a.put(ManualTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawManualTask(flowNode.getName(), graphicInfo, scaleFactor);
            }
        });
        this.a.put(BusinessRuleTask.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawBusinessRuleTask(flowNode.getName(), graphicInfo, scaleFactor);
            }
        });
        this.a.put(ExclusiveGateway.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawExclusiveGateway(graphicInfo, scaleFactor);
            }
        });
        this.a.put(InclusiveGateway.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawInclusiveGateway(graphicInfo, scaleFactor);
            }
        });
        this.a.put(ParallelGateway.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawParallelGateway(graphicInfo, scaleFactor);
            }
        });
        this.a.put(EventGateway.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawEventBasedGateway(graphicInfo, scaleFactor);
            }
        });
        this.a.put(BoundaryEvent.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                BoundaryEvent boundaryEvent = (BoundaryEvent)flowNode;
                if (boundaryEvent.getEventDefinitions() != null && !boundaryEvent.getEventDefinitions().isEmpty()) {
                    if (boundaryEvent.getEventDefinitions().get(0) instanceof TimerEventDefinition) {
                        processDiagramCanvas.drawCatchingTimerEvent(flowNode.getName(), graphicInfo, boundaryEvent.isCancelActivity(), scaleFactor);
                    } else if (boundaryEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) {
                        processDiagramCanvas.drawCatchingErrorEvent(graphicInfo, boundaryEvent.isCancelActivity(), scaleFactor);
                    } else if (boundaryEvent.getEventDefinitions().get(0) instanceof SignalEventDefinition) {
                        processDiagramCanvas.drawCatchingSignalEvent(flowNode.getName(), graphicInfo, boundaryEvent.isCancelActivity(), scaleFactor);
                    } else if (boundaryEvent.getEventDefinitions().get(0) instanceof MessageEventDefinition) {
                        processDiagramCanvas.drawCatchingMessageEvent(flowNode.getName(), graphicInfo, boundaryEvent.isCancelActivity(), scaleFactor);
                    } else if (boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) {
                        processDiagramCanvas.drawCatchingCompensateEvent(graphicInfo, boundaryEvent.isCancelActivity(), scaleFactor);
                    }
                }
            }
        });
        this.a.put(SubProcess.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                if (graphicInfo.getExpanded() != null && !graphicInfo.getExpanded().booleanValue()) {
                    processDiagramCanvas.drawCollapsedSubProcess(flowNode.getName(), graphicInfo, Boolean.valueOf(false));
                } else {
                    processDiagramCanvas.drawExpandedSubProcess(flowNode.getName(), graphicInfo, Boolean.valueOf(false), scaleFactor);
                }
            }
        });
        this.a.put(EventSubProcess.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                if (graphicInfo.getExpanded() != null && !graphicInfo.getExpanded().booleanValue()) {
                    processDiagramCanvas.drawCollapsedSubProcess(flowNode.getName(), graphicInfo, Boolean.valueOf(true));
                } else {
                    processDiagramCanvas.drawExpandedSubProcess(flowNode.getName(), graphicInfo, Boolean.valueOf(true), scaleFactor);
                }
            }
        });
        this.a.put(CallActivity.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
                processDiagramCanvas.drawCollapsedCallActivity(flowNode.getName(), graphicInfo);
            }
        });
        this.b.put(TextAnnotation.class, new ArtifactDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, Artifact artifact) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(artifact.getId());
                TextAnnotation textAnnotation = (TextAnnotation)artifact;
                processDiagramCanvas.drawTextAnnotation(textAnnotation.getText(), graphicInfo);
            }
        });
        this.b.put(Association.class, new ArtifactDrawInstruction(){

            @Override
            public void draw(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, Artifact artifact) {
                Association association = (Association)artifact;
                String string = association.getSourceRef();
                String string2 = association.getTargetRef();
                FlowElement flowElement = bpmnModel.getFlowElement(string);
                FlowElement flowElement2 = bpmnModel.getFlowElement(string2);
                if (flowElement == null) {
                    flowElement = bpmnModel.getArtifact(string);
                }
                if (flowElement2 == null) {
                    flowElement2 = bpmnModel.getArtifact(string2);
                }
                List<GraphicInfo> list = bpmnModel.getFlowLocationGraphicInfo(artifact.getId());
                list = DefaultProcessDiagramGenerator.a(processDiagramCanvas, bpmnModel, (BaseElement)flowElement, (BaseElement)flowElement2, list);
                int[] nArray = new int[list.size()];
                int[] nArray2 = new int[list.size()];
                for (int i2 = 1; i2 < list.size(); ++i2) {
                    GraphicInfo graphicInfo = list.get(i2);
                    GraphicInfo graphicInfo2 = list.get(i2 - 1);
                    if (i2 == 1) {
                        nArray[0] = (int)graphicInfo2.getX();
                        nArray2[0] = (int)graphicInfo2.getY();
                    }
                    nArray[i2] = (int)graphicInfo.getX();
                    nArray2[i2] = (int)graphicInfo.getY();
                }
                AssociationDirection associationDirection = association.getAssociationDirection();
                processDiagramCanvas.drawAssociation(nArray, nArray2, associationDirection, false, scaleFactor);
            }
        });
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.b(bpmnModel, imageType, highLightedActivities, highLightedFlows, activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor).generateImage(imageType);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows) {
        return this.generateDiagram(bpmnModel, imageType, highLightedActivities, highLightedFlows, null, null, null, null, 1.0);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows, double scaleFactor) {
        return this.generateDiagram(bpmnModel, imageType, highLightedActivities, highLightedFlows, null, null, null, null, scaleFactor);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities) {
        return this.generateDiagram(bpmnModel, imageType, highLightedActivities, Collections.emptyList());
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, double scaleFactor) {
        return this.generateDiagram(bpmnModel, imageType, highLightedActivities, Collections.emptyList(), scaleFactor);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        return this.generateDiagram(bpmnModel, imageType, Collections.emptyList(), Collections.emptyList(), activityFontName, labelFontName, annotationFontName, customClassLoader, 1.0);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.generateDiagram(bpmnModel, imageType, Collections.emptyList(), Collections.emptyList(), activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor);
    }

    public InputStream generatePngDiagram(BpmnModel bpmnModel) {
        return this.generatePngDiagram(bpmnModel, 1.0);
    }

    public InputStream generatePngDiagram(BpmnModel bpmnModel, double scaleFactor) {
        return this.generateDiagram(bpmnModel, "png", Collections.emptyList(), Collections.emptyList(), scaleFactor);
    }

    public InputStream generateJpgDiagram(BpmnModel bpmnModel) {
        return this.generateJpgDiagram(bpmnModel, 1.0);
    }

    public InputStream generateJpgDiagram(BpmnModel bpmnModel, double scaleFactor) {
        return this.generateDiagram(bpmnModel, "jpg", Collections.emptyList(), Collections.emptyList());
    }

    public BufferedImage a(BpmnModel bpmnModel, String string, List<String> list, List<String> list2, String string2, String string3, String string4, ClassLoader classLoader, double d2) {
        return this.b(bpmnModel, string, list, list2, string2, string3, string4, classLoader, d2).generateBufferedImage(string);
    }

    public BufferedImage a(BpmnModel bpmnModel, String string, List<String> list, List<String> list2, double d2) {
        return this.a(bpmnModel, string, list, list2, null, null, null, null, d2);
    }

    public BufferedImage generatePngImage(BpmnModel bpmnModel, double scaleFactor) {
        return this.a(bpmnModel, "png", Collections.emptyList(), Collections.emptyList(), scaleFactor);
    }

    protected DefaultProcessDiagramCanvas b(BpmnModel bpmnModel, String string, List<String> list, List<String> list2, String string2, String string3, String string4, ClassLoader classLoader, double d2) {
        GraphicInfo graphicInfo;
        Object object;
        this.a(bpmnModel);
        DefaultProcessDiagramCanvas defaultProcessDiagramCanvas = DefaultProcessDiagramGenerator.a(bpmnModel, string, string2, string3, string4, classLoader);
        for (Pool pool : bpmnModel.getPools()) {
            object = bpmnModel.getGraphicInfo(pool.getId());
            defaultProcessDiagramCanvas.drawPoolOrLane(pool.getName(), (GraphicInfo)object);
        }
        for (Pool pool : bpmnModel.getProcesses()) {
            for (Object object22 : pool.getLanes()) {
                graphicInfo = bpmnModel.getGraphicInfo(object22.getId());
                defaultProcessDiagramCanvas.drawPoolOrLane(object22.getName(), graphicInfo);
            }
        }
        for (Pool pool : bpmnModel.getProcesses()) {
            for (Object object22 : pool.findFlowElementsOfType(FlowNode.class)) {
                this.a(defaultProcessDiagramCanvas, bpmnModel, (FlowNode)object22, list, list2, d2);
            }
        }
        for (Pool pool : bpmnModel.getProcesses()) {
            Object object22;
            for (Object object22 : pool.getArtifacts()) {
                this.a(defaultProcessDiagramCanvas, bpmnModel, (Artifact)object22);
            }
            object = pool.findFlowElementsOfType(SubProcess.class, true);
            if (object == null) continue;
            object22 = object.iterator();
            while (object22.hasNext()) {
                graphicInfo = (SubProcess)object22.next();
                for (Artifact artifact : graphicInfo.getArtifacts()) {
                    this.a(defaultProcessDiagramCanvas, bpmnModel, artifact);
                }
            }
        }
        return defaultProcessDiagramCanvas;
    }

    protected void a(BpmnModel bpmnModel) {
        ArrayList arrayList = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            arrayList.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            arrayList.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List list : bpmnModel.getFlowLocationMap().values()) {
                arrayList.addAll(list);
            }
        }
        if (arrayList.size() > 0) {
            double d2;
            boolean bl = false;
            boolean bl2 = false;
            double d3 = 0.0;
            double d4 = 0.0;
            for (GraphicInfo graphicInfo : arrayList) {
                d2 = graphicInfo.getX();
                double d5 = graphicInfo.getY();
                if (d2 < d3) {
                    bl = true;
                    d3 = d2;
                }
                if (!(d5 < d4)) continue;
                bl2 = true;
                d4 = d5;
            }
            if (bl || bl2) {
                double d6 = Math.abs(d3);
                d2 = Math.abs(d4);
                for (GraphicInfo graphicInfo : arrayList) {
                    if (bl) {
                        graphicInfo.setX(graphicInfo.getX() + d6);
                    }
                    if (!bl2) continue;
                    graphicInfo.setY(graphicInfo.getY() + d2);
                }
            }
        }
    }

    protected void a(DefaultProcessDiagramCanvas defaultProcessDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode, List<String> list, List<String> list2, double d2) {
        Object object;
        boolean bl;
        ActivityDrawInstruction activityDrawInstruction = this.a.get(flowNode.getClass());
        if (activityDrawInstruction != null) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics;
            activityDrawInstruction.draw(defaultProcessDiagramCanvas, bpmnModel, flowNode);
            boolean bl2 = false;
            boolean bl3 = false;
            bl = false;
            if (flowNode instanceof Activity && (multiInstanceLoopCharacteristics = (object = (Activity)flowNode).getLoopCharacteristics()) != null) {
                bl2 = multiInstanceLoopCharacteristics.isSequential();
                bl3 = !bl2;
            }
            object = bpmnModel.getGraphicInfo(flowNode.getId());
            if (flowNode instanceof SubProcess) {
                bl = object.getExpanded() != null && object.getExpanded() == false;
            } else if (flowNode instanceof CallActivity) {
                bl = true;
            }
            if (d2 == 1.0) {
                defaultProcessDiagramCanvas.drawActivityMarkers((int)object.getX(), (int)object.getY(), (int)object.getWidth(), (int)object.getHeight(), bl2, bl3, bl);
            }
            if (list.contains(flowNode.getId())) {
                DefaultProcessDiagramGenerator.a(defaultProcessDiagramCanvas, bpmnModel.getGraphicInfo(flowNode.getId()));
            }
        }
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
            GraphicInfo graphicInfo;
            bl = list2.contains(sequenceFlow.getId());
            object = null;
            if (flowNode instanceof Activity) {
                object = ((Activity)flowNode).getDefaultFlow();
            } else if (flowNode instanceof Gateway) {
                object = ((Gateway)flowNode).getDefaultFlow();
            }
            boolean bl4 = false;
            if (object != null && ((String)object).equalsIgnoreCase(sequenceFlow.getId())) {
                bl4 = true;
            }
            boolean bl5 = sequenceFlow.getConditionExpression() != null && !(flowNode instanceof Gateway);
            String string = sequenceFlow.getSourceRef();
            String string2 = sequenceFlow.getTargetRef();
            FlowElement flowElement = bpmnModel.getFlowElement(string);
            FlowElement flowElement2 = bpmnModel.getFlowElement(string2);
            List<GraphicInfo> list3 = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
            if (list3 == null || list3.size() <= 0) continue;
            list3 = DefaultProcessDiagramGenerator.a(defaultProcessDiagramCanvas, bpmnModel, (BaseElement)flowElement, (BaseElement)flowElement2, list3);
            int[] nArray = new int[list3.size()];
            int[] nArray2 = new int[list3.size()];
            for (int i2 = 1; i2 < list3.size(); ++i2) {
                graphicInfo = list3.get(i2);
                GraphicInfo graphicInfo2 = list3.get(i2 - 1);
                if (i2 == 1) {
                    nArray[0] = (int)graphicInfo2.getX();
                    nArray2[0] = (int)graphicInfo2.getY();
                }
                nArray[i2] = (int)graphicInfo.getX();
                nArray2[i2] = (int)graphicInfo.getY();
            }
            defaultProcessDiagramCanvas.drawSequenceflow(nArray, nArray2, bl5, bl4, bl, d2);
            GraphicInfo graphicInfo3 = bpmnModel.getLabelGraphicInfo(sequenceFlow.getId());
            if (graphicInfo3 != null) {
                defaultProcessDiagramCanvas.drawLabel(sequenceFlow.getName(), graphicInfo3, false);
                continue;
            }
            graphicInfo = DefaultProcessDiagramGenerator.a(list3);
            DefaultProcessDiagramCanvas.LABEL_COLOR = Color.BLACK;
            DefaultProcessDiagramCanvas.LABEL_FONT = new Font("\u5b8b\u4f53", 1, 10);
            defaultProcessDiagramCanvas.drawLabel(sequenceFlow.getName(), graphicInfo, false);
        }
        if (flowNode instanceof FlowElementsContainer) {
            for (FlowElement flowElement : ((FlowElementsContainer)flowNode).getFlowElements()) {
                if (!(flowElement instanceof FlowNode)) continue;
                this.a(defaultProcessDiagramCanvas, bpmnModel, (FlowNode)flowElement, list, list2, d2);
            }
        }
    }

    protected static List<GraphicInfo> a(DefaultProcessDiagramCanvas defaultProcessDiagramCanvas, BpmnModel bpmnModel, BaseElement baseElement, BaseElement baseElement2, List<GraphicInfo> list) {
        GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(baseElement.getId());
        GraphicInfo graphicInfo2 = bpmnModel.getGraphicInfo(baseElement2.getId());
        DefaultProcessDiagramCanvas.SHAPE_TYPE sHAPE_TYPE = DefaultProcessDiagramGenerator.a(baseElement);
        DefaultProcessDiagramCanvas.SHAPE_TYPE sHAPE_TYPE2 = DefaultProcessDiagramGenerator.a(baseElement2);
        return defaultProcessDiagramCanvas.connectionPerfectionizer(sHAPE_TYPE, sHAPE_TYPE2, graphicInfo, graphicInfo2, list);
    }

    protected static DefaultProcessDiagramCanvas.SHAPE_TYPE a(BaseElement baseElement) {
        if (baseElement instanceof Task || baseElement instanceof Activity || baseElement instanceof TextAnnotation) {
            return DefaultProcessDiagramCanvas.SHAPE_TYPE.Rectangle;
        }
        if (baseElement instanceof Gateway) {
            return DefaultProcessDiagramCanvas.SHAPE_TYPE.Rhombus;
        }
        if (baseElement instanceof Event) {
            return DefaultProcessDiagramCanvas.SHAPE_TYPE.Ellipse;
        }
        return null;
    }

    protected static GraphicInfo a(List<GraphicInfo> list) {
        int n2;
        GraphicInfo graphicInfo = new GraphicInfo();
        int[] nArray = new int[list.size()];
        int[] nArray2 = new int[list.size()];
        double d2 = 0.0;
        double[] dArray = new double[list.size()];
        dArray[0] = 0.0;
        for (n2 = 1; n2 < list.size(); ++n2) {
            GraphicInfo graphicInfo2 = list.get(n2);
            GraphicInfo graphicInfo3 = list.get(n2 - 1);
            if (n2 == 1) {
                nArray[0] = (int)graphicInfo3.getX();
                nArray2[0] = (int)graphicInfo3.getY();
            }
            nArray[n2] = (int)graphicInfo2.getX();
            nArray2[n2] = (int)graphicInfo2.getY();
            dArray[n2] = d2 += Math.sqrt(Math.pow((int)graphicInfo2.getX() - (int)graphicInfo3.getX(), 2.0) + Math.pow((int)graphicInfo2.getY() - (int)graphicInfo3.getY(), 2.0));
        }
        double d3 = d2 / 2.0;
        n2 = 0;
        int n3 = 1;
        int n4 = 1;
        while (n4 < dArray.length) {
            double d4 = dArray[n4];
            n2 = n4 - 1;
            n3 = n4++;
            if (d4 > d3) break;
        }
        GraphicInfo graphicInfo4 = list.get(n2);
        GraphicInfo graphicInfo5 = list.get(n3);
        double d5 = (int)graphicInfo5.getX() - (int)graphicInfo4.getX();
        double d6 = (int)graphicInfo5.getY() - (int)graphicInfo4.getY();
        double d7 = dArray[n3] - dArray[n2];
        double d8 = d3 - dArray[n2];
        double d9 = d5 * d8 / d7;
        double d10 = d6 * d8 / d7;
        double d11 = graphicInfo4.getX() + d9;
        double d12 = graphicInfo4.getY() + d10;
        graphicInfo.setX(d11);
        graphicInfo.setY(d12);
        return graphicInfo;
    }

    protected void a(DefaultProcessDiagramCanvas defaultProcessDiagramCanvas, BpmnModel bpmnModel, Artifact artifact) {
        ArtifactDrawInstruction artifactDrawInstruction = this.b.get(artifact.getClass());
        if (artifactDrawInstruction != null) {
            artifactDrawInstruction.draw(defaultProcessDiagramCanvas, bpmnModel, artifact);
        }
    }

    private static void a(DefaultProcessDiagramCanvas defaultProcessDiagramCanvas, GraphicInfo graphicInfo) {
        defaultProcessDiagramCanvas.drawHighLight((int)graphicInfo.getX(), (int)graphicInfo.getY(), (int)graphicInfo.getWidth(), (int)graphicInfo.getHeight());
    }

    protected static DefaultProcessDiagramCanvas a(BpmnModel bpmnModel, String string, String string2, String string3, String string4, ClassLoader classLoader) {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        Object object52;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = Double.MAX_VALUE;
        double d5 = 0.0;
        for (Object object52 : bpmnModel.getPools()) {
            object4 = bpmnModel.getGraphicInfo(object52.getId());
            d2 = object4.getX();
            d3 = object4.getX() + object4.getWidth();
            d4 = object4.getY();
            d5 = object4.getY() + object4.getHeight();
        }
        List<FlowNode> list = DefaultProcessDiagramGenerator.c(bpmnModel);
        object52 = list.iterator();
        while (object52.hasNext()) {
            object4 = (FlowNode)object52.next();
            object3 = bpmnModel.getGraphicInfo(object4.getId());
            if (object3.getX() + object3.getWidth() > d3) {
                d3 = object3.getX() + object3.getWidth();
            }
            if (object3.getX() < d2) {
                d2 = object3.getX();
            }
            if (object3.getY() + object3.getHeight() > d5) {
                d5 = object3.getY() + object3.getHeight();
            }
            if (object3.getY() < d4) {
                d4 = object3.getY();
            }
            for (Object object6 : object4.getOutgoingFlows()) {
                object22 = bpmnModel.getFlowLocationGraphicInfo(object6.getId());
                if (object22 == null) continue;
                object = object22.iterator();
                while (object.hasNext()) {
                    GraphicInfo graphicInfo = (GraphicInfo)object.next();
                    if (graphicInfo.getX() > d3) {
                        d3 = graphicInfo.getX();
                    }
                    if (graphicInfo.getX() < d2) {
                        d2 = graphicInfo.getX();
                    }
                    if (graphicInfo.getY() > d5) {
                        d5 = graphicInfo.getY();
                    }
                    if (!(graphicInfo.getY() < d4)) continue;
                    d4 = graphicInfo.getY();
                }
            }
        }
        object52 = DefaultProcessDiagramGenerator.b(bpmnModel);
        object4 = object52.iterator();
        while (object4.hasNext()) {
            Object object6;
            object3 = (Artifact)object4.next();
            Object object7 = bpmnModel.getGraphicInfo(object3.getId());
            if (object7 != null) {
                if (object7.getX() + object7.getWidth() > d3) {
                    d3 = object7.getX() + object7.getWidth();
                }
                if (object7.getX() < d2) {
                    d2 = object7.getX();
                }
                if (object7.getY() + object7.getHeight() > d5) {
                    d5 = object7.getY() + object7.getHeight();
                }
                if (object7.getY() < d4) {
                    d4 = object7.getY();
                }
            }
            if ((object6 = bpmnModel.getFlowLocationGraphicInfo(object3.getId())) == null) continue;
            object22 = object6.iterator();
            while (object22.hasNext()) {
                object = (GraphicInfo)object22.next();
                if (object.getX() > d3) {
                    d3 = object.getX();
                }
                if (object.getX() < d2) {
                    d2 = object.getX();
                }
                if (object.getY() > d5) {
                    d5 = object.getY();
                }
                if (!(object.getY() < d4)) continue;
                d4 = object.getY();
            }
        }
        int n2 = 0;
        for (Object object7 : bpmnModel.getProcesses()) {
            for (Object object22 : object7.getLanes()) {
                ++n2;
                object = bpmnModel.getGraphicInfo(object22.getId());
                if (object.getX() + object.getWidth() > d3) {
                    d3 = object.getX() + object.getWidth();
                }
                if (object.getX() < d2) {
                    d2 = object.getX();
                }
                if (object.getY() + object.getHeight() > d5) {
                    d5 = object.getY() + object.getHeight();
                }
                if (!(object.getY() < d4)) continue;
                d4 = object.getY();
            }
        }
        if (list.isEmpty() && bpmnModel.getPools().isEmpty() && n2 == 0) {
            d2 = 0.0;
            d4 = 0.0;
        }
        return new DefaultProcessDiagramCanvas((int)d3 + 10, (int)d5 + 10, (int)d2, (int)d4, string, string2, string3, string4, classLoader);
    }

    protected static List<Artifact> b(BpmnModel bpmnModel) {
        ArrayList<Artifact> arrayList = new ArrayList<Artifact>();
        for (Process process : bpmnModel.getProcesses()) {
            arrayList.addAll(process.getArtifacts());
        }
        return arrayList;
    }

    protected static List<FlowNode> c(BpmnModel bpmnModel) {
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
        for (Process process : bpmnModel.getProcesses()) {
            arrayList.addAll(DefaultProcessDiagramGenerator.a((FlowElementsContainer)process));
        }
        return arrayList;
    }

    protected static List<FlowNode> a(FlowElementsContainer flowElementsContainer) {
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            if (flowElement instanceof FlowNode) {
                arrayList.add((FlowNode)flowElement);
            }
            if (!(flowElement instanceof FlowElementsContainer)) continue;
            arrayList.addAll(DefaultProcessDiagramGenerator.a((FlowElementsContainer)flowElement));
        }
        return arrayList;
    }

    public Map<Class<? extends BaseElement>, ActivityDrawInstruction> getActivityDrawInstructions() {
        return this.a;
    }

    public void setActivityDrawInstructions(Map<Class<? extends BaseElement>, ActivityDrawInstruction> activityDrawInstructions) {
        this.a = activityDrawInstructions;
    }

    public Map<Class<? extends BaseElement>, ArtifactDrawInstruction> getArtifactDrawInstructions() {
        return this.b;
    }

    public void setArtifactDrawInstructions(Map<Class<? extends BaseElement>, ArtifactDrawInstruction> artifactDrawInstructions) {
        this.b = artifactDrawInstructions;
    }

    protected static interface ArtifactDrawInstruction {
        public void draw(DefaultProcessDiagramCanvas var1, BpmnModel var2, Artifact var3);
    }

    protected static interface ActivityDrawInstruction {
        public void draw(DefaultProcessDiagramCanvas var1, BpmnModel var2, FlowNode var3);
    }
}

