/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.weixinpay;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jdom.JDOMException;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.pay.PayBaseVo;
import weixin.pay.PayExecutor;
import weixin.pay.RefundBaseVo;
import weixin.pay.entity.WxPayLogEntity;
import weixin.pay.pojo.Wx_pay_pojo_weixinpay;
import weixin.pay.service.WxPayCenterConfigServiceI;
import weixin.pay.service.WxPayLogServiceI;
import weixin.pay.tenpay.HttpRequester;
import weixin.pay.tenpay.HttpRespons;
import weixin.pay.tenpay.MD5Util;
import weixin.pay.tenpay.XMLUtil;
import weixin.pay.weixinpay.MerCallBackThreadTask;
import weixin.pay.weixinpay.WeixinpayVo;
import weixin.shop.base.entity.WeixinShopDealEntity;
import weixin.util.DateUtils;

@Service(value="weixinpay")
public class WeixinPayClient
implements PayExecutor {
    @Autowired
    private WxPayLogServiceI wxPayLogService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WxPayCenterConfigServiceI wxPayCenterConfigService;
    private static final String ApplyPayURL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String ApplyRefundURL = "https://api.mch.weixin.qq.com/secapi/pay/refund";

    protected String createSign(Map<String, String> params, String key) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = params.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (v == null || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(String.valueOf(k) + "=" + v + "&");
        }
        sb.append("key=" + key);
        LogUtil.info(sb);
        String sign = MD5Util.MD5Encode(sb.toString(), "UTF-8").toUpperCase();
        LogUtil.info("sign=" + sign);
        return sign;
    }

    private boolean checkWxSign(Map<String, String> params, String key, String sign) {
        boolean flag = false;
        String localsign = this.createSign(params, key);
        if (sign.equals(localsign)) {
            flag = true;
        }
        return flag;
    }

    public Map obtainPrepay(String openid, PayBaseVo payBaseVo, Wx_pay_pojo_weixinpay wxWeixinPay, String tradeNo) throws JDOMException, IOException {
        HttpRespons hr;
        HttpRequester request = new HttpRequester();
        TreeMap<String, String> params = new TreeMap<String, String>();
        String total_fee = String.valueOf(BigDecimal.valueOf(Double.valueOf(payBaseVo.getTotal_money())).multiply(new BigDecimal(100)).intValue());
        params.put("appid", wxWeixinPay.getAppid());
        params.put("mch_id", wxWeixinPay.getMch_id());
        params.put("nonce_str", UUIDGenerator.generate());
        params.put("body", payBaseVo.getDesc());
        params.put("detail", payBaseVo.getDesc());
        params.put("out_trade_no", tradeNo);
        params.put("total_fee", total_fee);
        params.put("fee_type", "CNY");
        params.put("spbill_create_ip", "8.8.8.8");
        params.put("notify_url", this.getPayNotifyUrl(payBaseVo.getAccountid()));
        params.put("trade_type", "JSAPI");
        params.put("openid", openid);
        String sign = this.createSign(params, wxWeixinPay.getKey());
        params.put("sign", sign);
        String converterPayXML = XMLUtil.converterWeixinpayXML(params);
        LogUtil.info(converterPayXML);
        try {
            hr = request.sendPost(ApplyPayURL, converterPayXML);
        }
        catch (IOException e) {
            throw new BusinessException("\u7531\u4e8e\u7f51\u7edc\u8fde\u63a5\uff0c\u751f\u6210\u9884\u652f\u4ed8\u8ba2\u5355\u65f6\u51fa\u9519", e);
        }
        LogUtil.info("*************\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f_\u5f00\u59cb***************");
        LogUtil.info(hr.getUrlString());
        LogUtil.info(hr.getProtocol());
        LogUtil.info(hr.getHost());
        LogUtil.info(hr.getPort());
        LogUtil.info(hr.getContentEncoding());
        LogUtil.info(hr.getMethod());
        LogUtil.info(hr.getContent());
        LogUtil.info(hr.getContentEncoding());
        LogUtil.info("\u8fd4\u56de\u7684\u5185\u5bb9\uff1a" + hr.getContent());
        LogUtil.info("*************\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f_\u7ed3\u675f***************");
        return XMLUtil.doXMLParse(hr.getContent());
    }

    private WeixinpayVo parsePrepayMap2WeixinpayVo(Map<?, ?> weixinPrepayMap, Wx_pay_pojo_weixinpay wxWeixinPay) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appId", oConvertUtils.getString(weixinPrepayMap.get("appid")));
        params.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonceStr", oConvertUtils.getString(weixinPrepayMap.get("nonce_str"), UUIDGenerator.generate()));
        params.put("package", "prepay_id=" + oConvertUtils.getString(weixinPrepayMap.get("prepay_id")));
        params.put("signType", "MD5");
        String sign = this.createSign(params, wxWeixinPay.getKey());
        WeixinpayVo weixinpayVo = new WeixinpayVo();
        weixinpayVo.setAppId(oConvertUtils.getString(params.get("appId")));
        weixinpayVo.setTimeStamp(oConvertUtils.getString(params.get("timeStamp")));
        weixinpayVo.setNonceStr(oConvertUtils.getString(params.get("nonceStr")));
        weixinpayVo.setPackageValue(oConvertUtils.getString(params.get("package")));
        weixinpayVo.setSignType(oConvertUtils.getString(params.get("signType")));
        weixinpayVo.setPaySign(sign);
        return weixinpayVo;
    }

    private Map<String, String> rebuildWeixinPayMap(Map weixinPrepayMap, Wx_pay_pojo_weixinpay wxWeixinPay) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appId", oConvertUtils.getString(weixinPrepayMap.get("appid")));
        params.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("nonceStr", oConvertUtils.getString(weixinPrepayMap.get("nonce_str"), UUIDGenerator.generate()));
        params.put("package", "prepay_id=" + oConvertUtils.getString(weixinPrepayMap.get("prepay_id")));
        params.put("signType", "MD5");
        String paySign = this.createSign(params, wxWeixinPay.getKey());
        params.put("paySign", paySign);
        return params;
    }

    @Override
    public String executePayMethod(HttpServletRequest req, PayBaseVo payBaseVo, String wxWeixinJson) throws BusinessException {
        String preCallUrl;
        WxPayLogEntity wxPayLog = this.wxPayLogService.findWxPayLogEntity(payBaseVo.getRequestNo(), payBaseVo.getSysCode());
        if (oConvertUtils.isNullOrEmpty(wxPayLog)) {
            wxPayLog = new WxPayLogEntity();
            wxPayLog.setId(UUIDGenerator.generate());
            wxPayLog.setSysCode(payBaseVo.getSysCode());
            wxPayLog.setRequestNo(payBaseVo.getRequestNo());
            wxPayLog.setAccountId(payBaseVo.getAccountid());
            wxPayLog.setPayType(payBaseVo.getPayType());
            BigDecimal payTotal = new BigDecimal(payBaseVo.getTotal_money()).multiply(new BigDecimal("100")).setScale(0);
            wxPayLog.setPayTotal(payTotal.toString());
            wxPayLog.setOrderId(payBaseVo.getOrderId());
            wxPayLog.setBackCallUrl(payBaseVo.getBackCallUrl());
            wxPayLog.setPreCallUrl(payBaseVo.getPreCallUrl());
            wxPayLog.setStatus("00");
            this.wxPayLogService.save(wxPayLog);
        } else if ("01".equals(wxPayLog.getStatus())) {
            new Thread((Runnable)((Object)new MerCallBackThreadTask(wxPayLog, this.wxPayCenterConfigService))).start();
            throw new BusinessException("\u8be5\u8ba2\u5355\u5df2\u652f\u4ed8\u6210\u529f");
        }
        Wx_pay_pojo_weixinpay wxWeixinPay = JSONHelper.fromJsonToObject(wxWeixinJson, Wx_pay_pojo_weixinpay.class);
        Map weixinPrepayMap = new HashMap();
        String openid = ResourceUtil.getOpenid(req);
        if (oConvertUtils.isNullOrEmpty(openid)) {
            openid = (String)req.getAttribute("openid");
        }
        if (oConvertUtils.isNullOrEmpty(openid)) {
            throw new BusinessException("\u6ca1\u6709\u83b7\u53d6\u5230openid");
        }
        LogUtil.info("----------\u5fae\u4fe1\u652f\u4ed8openid=" + openid + "-------------------");
        try {
            weixinPrepayMap = this.obtainPrepay(openid, payBaseVo, wxWeixinPay, wxPayLog.getId());
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
        String prepay_id = (String)weixinPrepayMap.get("prepay_id");
        LogUtil.info("\u53d6\u5f97\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u7684prepay_id=" + prepay_id);
        if (oConvertUtils.isNullOrEmpty(prepay_id)) {
            throw new BusinessException("prepay_id\u672a\u751f\u6210\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6");
        }
        StringBuilder redirectURI = new StringBuilder("redirect:weixinPayController/wx/weixinpay.do?redirectWeixinpay");
        Map<String, String> rebulidMap = this.rebuildWeixinPayMap(weixinPrepayMap, wxWeixinPay);
        if (rebulidMap != null && rebulidMap.size() > 0) {
            Set<String> keys = rebulidMap.keySet();
            for (String key : keys) {
                if ("package".equalsIgnoreCase(key)) {
                    key = "packageValue";
                    redirectURI.append("&").append(key).append("=").append(rebulidMap.get("package"));
                    continue;
                }
                redirectURI.append("&").append(key).append("=").append(rebulidMap.get(key));
            }
        }
        if (StringUtil.isNotEmpty(preCallUrl = payBaseVo.getPreCallUrl())) {
            preCallUrl = URLDecoder.decode(preCallUrl);
            redirectURI.append("&preCallUrl=preCallUrl");
        }
        redirectURI.append("&showwxpaytitle=1");
        return redirectURI.toString();
    }

    @Override
    public String getPayCallbackUrl(String accountid) {
        return String.valueOf(BaseCallBackURL) + "weixinpay/" + accountid;
    }

    @Override
    public String getPayNotifyUrl(String accountid) {
        return String.valueOf(BaseNotifyUrl) + "weixinpay/" + accountid;
    }

    @Override
    public void doNotify(HttpServletRequest request, HttpServletResponse response, String payConfigJson) {
        try {
            String return_msg;
            Wx_pay_pojo_weixinpay wxWeixinPay = JSONHelper.fromJsonToObject(payConfigJson, Wx_pay_pojo_weixinpay.class);
            LogUtil.info("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u5f00\u59cb");
            ServletInputStream inStream = request.getInputStream();
            ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outSteam.write(buffer, 0, len);
            }
            outSteam.close();
            inStream.close();
            String result = new String(outSteam.toByteArray(), "utf-8");
            LogUtil.info("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u5185\u5bb9\uff1a" + result);
            Map map = XMLUtil.doXMLParse(result);
            for (String keyValue : map.keySet()) {
                LogUtil.info(String.valueOf(keyValue) + "=" + (String)map.get(keyValue));
            }
            String sign = map.get("sign") == null ? "" : ((String)map.get("sign")).toString();
            TreeMap<String, String> sort = new TreeMap<String, String>(map);
            if (!this.checkWxSign(sort, wxWeixinPay.getKey(), sign)) {
                throw new BusinessException("\u9a8c\u7b7e\u5931\u8d25");
            }
            String tradeNo = (String)map.get("out_trade_no");
            WxPayLogEntity wxPayLog = this.wxPayLogService.get(WxPayLogEntity.class, (Serializable)((Object)tradeNo));
            wxPayLog.setTransactionId((String)map.get("transaction_id"));
            String result_code = map.get("result_code") == null ? "" : ((String)map.get("result_code")).toString();
            String string = return_msg = map.get("return_msg") == null ? "" : ((String)map.get("return_msg")).toString();
            if ("SUCCESS".equalsIgnoreCase(result_code)) {
                wxPayLog.setResultCode("SUCCESS");
                wxPayLog.setResultMsg("OK");
                wxPayLog.setStatus("01");
                String finishTime = (String)map.get("time_end");
                wxPayLog.setFinishTime(DateUtils.parseDate((String)finishTime, (String)"yyyyMMddHHmmss"));
            } else {
                wxPayLog.setResultCode(result_code);
                wxPayLog.setResultMsg(return_msg);
                wxPayLog.setStatus("99");
                this.wxPayLogService.updateEntitie(wxPayLog);
            }
            this.wxPayLogService.updateEntitie(wxPayLog);
            new Thread((Runnable)((Object)new MerCallBackThreadTask(wxPayLog, this.wxPayCenterConfigService))).start();
            response.getWriter().write(this.outPutXML("SUCCESS", "OK"));
        }
        catch (Exception e) {
            try {
                LogUtil.info("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u5f02\u5e38:" + e.getMessage());
                response.getWriter().write(this.outPutXML("FAIL", "\u51fa\u73b0\u5f02\u5e38:" + e.getMessage()));
            }
            catch (IOException e1) {
                LogUtil.info("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5IO\u5f02\u5e38");
            }
        }
    }

    public String outPutXML(String return_code, String return_msg) {
        return "<xml><return_code><![CDATA[" + return_code + "]]></return_code><return_msg><![CDATA[" + return_msg + "]]></return_msg></xml>";
    }

    public static void main(String[] args) throws IOException {
        LogUtil.info(new String("\u7edb\u60e7\u6095\u95bf\u6b12\ue1e4".getBytes("GBK"), "UTF-8"));
        HttpRequester requester = new HttpRequester();
        String orderid = "1422801071779";
        String postUrl = String.valueOf(ResourceBundle.getBundle("sysConfig").getString("domain")) + "/weixinShopDealController.do?payResultNotify&orderid=" + orderid;
        HttpRespons respons = requester.sendPost(postUrl);
        LogUtil.info(respons.getContent());
        JSONObject json2 = JSONObject.fromObject((Object)respons.getContent());
        Gson gson = new Gson();
        AjaxJson ajaxJson = (AjaxJson)gson.fromJson(json2.toString(), AjaxJson.class);
        LogUtil.info(ajaxJson);
    }

    @Override
    public String executeRefundMethod(HttpServletRequest req, RefundBaseVo refundBaseVo, String payConfigJson) throws BusinessException {
        String message = "";
        WxPayLogEntity wxPayLog = this.wxPayLogService.findUniqueByProperty(WxPayLogEntity.class, "orderId", refundBaseVo.getOrderId());
        wxPayLog.setOutRefundNo(UUIDGenerator.generate());
        wxPayLog.setIsRefundFlag("\u7533\u8bf7\u9000\u6b3e");
        this.wxPayLogService.save(wxPayLog);
        TreeMap<String, String> params = new TreeMap<String, String>();
        Wx_pay_pojo_weixinpay wxWeixinPay = JSONHelper.fromJsonToObject(payConfigJson, Wx_pay_pojo_weixinpay.class);
        params.put("appid", wxWeixinPay.getAppid());
        params.put("mch_id", wxWeixinPay.getMch_id());
        params.put("device_info", "1");
        params.put("nonce_str", UUIDGenerator.generate());
        params.put("transaction_id", wxPayLog.getTransactionId());
        params.put("out_trade_no", refundBaseVo.getOrderId());
        params.put("out_refund_no", wxPayLog.getOutRefundNo());
        params.put("total_fee", wxPayLog.getPayTotal());
        params.put("refund_fee", String.valueOf(refundBaseVo.getRefundTotal().multiply(new BigDecimal("100")).intValue()));
        params.put("refund_fee_type", "CNY");
        params.put("op_user_id", wxWeixinPay.getMch_id());
        String sign = this.createSign(params, wxWeixinPay.getKey());
        params.put("sign", sign);
        String converterRefundXML = XMLUtil.converterWeixinpayXML(params);
        LogUtil.info("\u7533\u8bf7\u9000\u6b3e\u8bf7\u6c42\uff1a" + converterRefundXML);
        try {
            Map<String, String> refundApplayResult = this.sslResquest(ApplyRefundURL, converterRefundXML, wxWeixinPay.getMch_id(), wxWeixinPay.getCertFileName());
            String return_code = refundApplayResult.get("return_code");
            String result_code = refundApplayResult.get("result_code");
            if ("SUCCESS".equals(return_code)) {
                if ("SUCCESS".equals(result_code)) {
                    wxPayLog.setIsRefundFlag("\u9000\u6b3e\u6210\u529f");
                    this.wxPayLogService.save(wxPayLog);
                    WeixinShopDealEntity weixinShopDeal = this.systemService.findUniqueByProperty(WeixinShopDealEntity.class, "dealNumber", refundBaseVo.getOrderId());
                    weixinShopDeal.setDealStatement("\u9000\u6b3e\u6210\u529f");
                    this.systemService.updateEntitie(weixinShopDeal);
                    message = "\u9000\u6b3e\u5df2\u7533\u8bf7\uff0c\u9000\u6b3e\u6709\u4e00\u5b9a\u5ef6\u65f6\uff0c\u7528\u96f6\u94b1\u652f\u4ed8\u7684\u9000\u6b3e20\u5206\u949f\u5185\u5230\u8d26\uff0c\u94f6\u884c\u5361\u652f\u4ed8\u7684\u9000\u6b3e3\u4e2a\u5de5\u4f5c\u65e5\u540e\u91cd\u65b0\u67e5\u8be2\u9000\u6b3e\u72b6\u6001";
                } else {
                    wxPayLog.setIsRefundFlag("\u9000\u6b3e\u5931\u8d25");
                    this.wxPayLogService.save(wxPayLog);
                    message = "\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6";
                }
            } else {
                message = refundApplayResult.get("return_msg");
                wxPayLog.setIsRefundFlag("\u9000\u6b3e\u5931\u8d25");
                this.wxPayLogService.save(wxPayLog);
            }
        }
        catch (IOException e) {
            throw new BusinessException("\u7531\u4e8e\u7f51\u7edc\u8fde\u63a5\uff0c\u9000\u6b3e\u7533\u8bf7\u65f6\u51fa\u9519", e);
        }
        catch (JDOMException e) {
            throw new BusinessException("\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u9519\u8bef\uff0c\u9000\u6b3e\u7533\u8bf7\u65f6\u51fa\u9519", e);
        }
        catch (Exception e) {
            throw new BusinessException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u9000\u6b3e\u7533\u8bf7\u65f6\u51fa\u9519", e);
        }
        return message;
    }

    public Map<String, String> sslResquest(String url, String arrayToXml, String mch_id, String certFileName) throws Exception {
        HashMap<String, String> doXMLtoMap = new HashMap();
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        String absoluteFileName = String.valueOf(ResourceUtil.getConfigByName("PKCS12_Base")) + File.separator + mch_id + File.separator + certFileName;
        FileInputStream instream = new FileInputStream(new File(absoluteFileName));
        try {
            keyStore.load(instream, mch_id.toCharArray());
        }
        finally {
            instream.close();
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, mch_id.toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(arrayToXml, "UTF-8"));
            LogUtil.info("executing request " + httpPost.getRequestLine());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            String xmlStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            doXMLtoMap = XMLUtil.doXMLParse(xmlStr);
            LogUtil.info("\u7533\u8bf7\u9000\u6b3e\u8fd4\u56de\u7684XML\u6570\u636e\u4e3a" + xmlStr);
            response.close();
        }
        finally {
            httpclient.close();
        }
        return doXMLtoMap;
    }
}

