/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.weixinpay;

import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.StringUtil;
import weixin.pay.entity.WxPayCenterConfigEntity;
import weixin.pay.entity.WxPayLogEntity;
import weixin.pay.service.WxPayCenterConfigServiceI;
import weixin.util.EncryptionUtil;
import weixin.util.SignatureUtil;
import weixin.util.ThreadTask;

public class MerCallBackThreadTask
implements ThreadTask {
    private static final long serialVersionUID = 5253700279807396631L;
    private static final Logger log = Logger.getLogger(MerCallBackThreadTask.class);
    private WxPayLogEntity wxPayLog;
    private WxPayCenterConfigServiceI wxPayCenterConfigService;

    public MerCallBackThreadTask(WxPayLogEntity wxPayLog, WxPayCenterConfigServiceI wxPayCenterConfigService) {
        this.wxPayLog = wxPayLog;
        this.wxPayCenterConfigService = wxPayCenterConfigService;
    }

    public void run() {
        int i = 0;
        this.notifyMerchant(i);
    }

    private String callBackMerchant(WxPayLogEntity wxPayLog) {
        StringBuilder sb = new StringBuilder("");
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("requestNo", wxPayLog.getRequestNo());
            map.put("orderId", wxPayLog.getOrderId());
            map.put("payType", wxPayLog.getPayType());
            map.put("payTotal", wxPayLog.getPayTotal());
            map.put("accountId", wxPayLog.getAccountId());
            map.put("status", wxPayLog.getStatus());
            map.put("returnMsg", wxPayLog.getResultMsg());
            WxPayCenterConfigEntity wxPayCenterConfigEntity = this.wxPayCenterConfigService.getWxPayCenterConfigEntity(wxPayLog.getSysCode());
            if (wxPayCenterConfigEntity == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            String encryptKey = wxPayCenterConfigEntity.getEncrypKey();
            String signKey = wxPayCenterConfigEntity.getSignKey();
            String sign = SignatureUtil.sign(map, (String)signKey);
            map.put("sign", sign);
            String data = JSONHelper.map2json(map);
            data = EncryptionUtil.aesEncrypt((String)data, (String)encryptKey);
            sb.append(wxPayLog.getBackCallUrl());
            sb.append("&sysCode=").append(wxPayLog.getSysCode());
            sb.append("&data=").append(URLEncoder.encode(data));
        }
        catch (Exception e) {
            return "";
        }
        return sb.toString();
    }

    public void notifyMerchant(int i) {
        HttpClient client = new HttpClient();
        GetMethod method = null;
        try {
            log.info((Object)"\u540e\u53f0\u7ebf\u7a0b\u901a\u77e5\u5546\u5bb6\u63a5\u53e3\u5f00\u59cb");
            String backUrl = this.callBackMerchant(this.wxPayLog);
            method = new GetMethod(backUrl);
            log.info((Object)("\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f\uff0c\u540e\u53f0\u56de\u8c03\u5730\u5740========" + backUrl));
            if (StringUtil.isEmpty(backUrl)) {
                return;
            }
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode == 200 && method.getResponseBodyAsString().indexOf("success") != -1) {
                    log.info((Object)("\u540e\u53f0\u901a\u77e5\u63a5\u53e3\uff0c\u56de\u8c03\u5546\u5bb6\u6210\u529f\uff0c\u5546\u5bb6accountId===" + this.wxPayLog.getAccountId() + ",\u5546\u5bb6\u8ba2\u5355===" + this.wxPayLog.getOrderId()));
                    method.releaseConnection();
                } else {
                    Thread.sleep(3000L);
                    if (i < 3) {
                        log.info((Object)("\u540e\u53f0\u901a\u77e5\u63a5\u53e3\uff0c\u56de\u8c03\u5546\u5bb6\u7b2c" + (i + 1) + "\u6b21\u5931\u8d25\uff0c\u5546\u5bb6accountId===" + this.wxPayLog.getAccountId() + ",\u5546\u5bb6\u8ba2\u5355===" + this.wxPayLog.getOrderId()));
                        this.notifyMerchant(++i);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)("\u540e\u53f0\u901a\u77e5\u63a5\u53e3,\u53d1\u751f\u5f02\u5e38=======" + e.getMessage()));
                try {
                    Thread.sleep(3000L);
                    if (i < 3) {
                        log.info((Object)("\u540e\u53f0\u901a\u77e5\u63a5\u53e3\uff0c\u56de\u8c03\u5546\u5bb6\u7b2c" + (i + 1) + "\u6b21\u5931\u8d25\uff0c\u5546\u5bb6accountId===" + this.wxPayLog.getAccountId() + ",\u5546\u5bb6\u8ba2\u5355===" + this.wxPayLog.getOrderId()));
                        this.notifyMerchant(++i);
                    }
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

