/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import weixin.pay.RedPackInfoBaseVo;
import weixin.pay.RedPackInfoResponse;
import weixin.pay.SendRedPackBaseVo;
import weixin.pay.entity.WxPayTransOrderRedpackEntity;
import weixin.pay.pojo.Wx_pay_pojo_weixinpay;
import weixin.pay.tenpay.MD5Util;
import weixin.pay.tenpay.XMLUtil;
import weixin.util.DateUtils;

public class RedPackUtil {
    public static void validateSendRedPack(SendRedPackBaseVo sendRedPackBaseVo) {
        if (StringUtil.isEmpty(sendRedPackBaseVo.getSysCode())) {
            throw new BusinessException("\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getRequestNo())) {
            throw new BusinessException("\u8bf7\u6c42\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getAccountid())) {
            throw new BusinessException("\u5fae\u4fe1\u8d26\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getOrderId())) {
            throw new BusinessException("\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getSendName())) {
            throw new BusinessException("\u5546\u6237\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getOpenid())) {
            throw new BusinessException("openid\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getActName())) {
            throw new BusinessException("\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getRemark())) {
            throw new BusinessException("\u6d3b\u52a8\u5907\u6ce8\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getWishing())) {
            throw new BusinessException("\u7ea2\u5305\u795d\u798f\u8bed\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getTotalAmount())) {
            throw new BusinessException("\u53d1\u653e\u7ea2\u5305\u91d1\u989d\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getTotalNum())) {
            throw new BusinessException("\u7ea2\u5305\u53d1\u653e\u603b\u4eba\u6570\u4e3a\u7a7a");
        }
        if (Integer.valueOf(sendRedPackBaseVo.getTotalAmount()) > 20000 || Integer.valueOf(sendRedPackBaseVo.getTotalAmount()) < 100) {
            throw new BusinessException("\u6bcf\u4e2a\u7ea2\u5305\u91d1\u989d\u5fc5\u987b\u5927\u4e8e1\u5143\uff0c\u5c0f\u4e8e200\u5143");
        }
        if (Integer.valueOf(sendRedPackBaseVo.getTotalNum()) != 1) {
            throw new BusinessException("\u7ea2\u5305\u53d1\u653e\u603b\u4eba\u6570\u5e94\u4e3a1");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e3a\u7a7a");
        }
    }

    public static String populationSendRedPackXml(Wx_pay_pojo_weixinpay wxConfig, WxPayTransOrderRedpackEntity wxPayTransOrderRedpackEntity) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("nonce_str", UUIDGenerator.generate());
        params.put("mch_billno", wxPayTransOrderRedpackEntity.getMchBillno());
        params.put("mch_id", wxPayTransOrderRedpackEntity.getMchId());
        params.put("wxappid", wxPayTransOrderRedpackEntity.getWxappid());
        params.put("send_name", wxPayTransOrderRedpackEntity.getSendName());
        params.put("re_openid", wxPayTransOrderRedpackEntity.getReOpenid());
        params.put("total_amount", wxPayTransOrderRedpackEntity.getTotalAmount().toString());
        params.put("total_num", wxPayTransOrderRedpackEntity.getTotalNum().toString());
        params.put("wishing", wxPayTransOrderRedpackEntity.getWishing());
        params.put("client_ip", wxPayTransOrderRedpackEntity.getClientIp());
        params.put("act_name", wxPayTransOrderRedpackEntity.getActName());
        params.put("remark", wxPayTransOrderRedpackEntity.getRemark());
        String sign = RedPackUtil.createSign(params, wxConfig.getKey());
        params.put("sign", sign);
        String paramXml = XMLUtil.converterWeixinpayXML(params);
        return paramXml;
    }

    private static String createSign(Map<String, String> params, String key) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = params.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (v == null || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(String.valueOf(k) + "=" + v + "&");
        }
        sb.append("key=" + key);
        LogUtil.info(sb);
        String sign = MD5Util.MD5Encode(sb.toString(), "UTF-8").toUpperCase();
        LogUtil.info("sign=" + sign);
        return sign;
    }

    public static String sslResquest(String url, String arrayToXml, Wx_pay_pojo_weixinpay wxConfig) throws Exception {
        String xmlStr;
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        String absoluteFileName = String.valueOf(ResourceUtil.getConfigByName("PKCS12_Base")) + File.separator + wxConfig.getMch_id() + File.separator + wxConfig.getCertFileName();
        FileInputStream instream = new FileInputStream(new File(absoluteFileName));
        try {
            keyStore.load(instream, wxConfig.getMch_id().toCharArray());
        }
        finally {
            instream.close();
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, wxConfig.getMch_id().toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(arrayToXml, "UTF-8"));
            LogUtil.info("executing request " + httpPost.getRequestLine());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            xmlStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            LogUtil.info("\u8fd4\u56de\u7684XML\u6570\u636e\u4e3a" + xmlStr);
            response.close();
        }
        finally {
            httpclient.close();
        }
        return xmlStr;
    }

    public static void validateSendGroupRedPack(SendRedPackBaseVo sendRedPackBaseVo) {
        if (StringUtil.isEmpty(sendRedPackBaseVo.getSysCode())) {
            throw new BusinessException("\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getRequestNo())) {
            throw new BusinessException("\u8bf7\u6c42\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getAccountid())) {
            throw new BusinessException("\u5fae\u4fe1\u8d26\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getOrderId())) {
            throw new BusinessException("\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getSendName())) {
            throw new BusinessException("\u5546\u6237\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getOpenid())) {
            throw new BusinessException("openid\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getActName())) {
            throw new BusinessException("\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getRemark())) {
            throw new BusinessException("\u6d3b\u52a8\u5907\u6ce8\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getWishing())) {
            throw new BusinessException("\u7ea2\u5305\u795d\u798f\u8bed\u4e3a\u7a7a");
        }
        if (sendRedPackBaseVo.getTotalAmount() == null) {
            throw new BusinessException("\u53d1\u653e\u7ea2\u5305\u91d1\u989d\u4e3a\u7a7a");
        }
        if (sendRedPackBaseVo.getTotalNum() == null) {
            throw new BusinessException("\u7ea2\u5305\u53d1\u653e\u603b\u4eba\u6570\u4e3a\u7a7a");
        }
        if (Integer.valueOf(sendRedPackBaseVo.getTotalAmount()) > 499900 || Integer.valueOf(sendRedPackBaseVo.getTotalAmount()) < 100) {
            throw new BusinessException("\u6bcf\u4e2a\u7ea2\u5305\u91d1\u989d\u5fc5\u987b\u5927\u4e8e1\u5143\uff0c\u5c0f\u4e8e\u7b49\u4e8e4999\u5143");
        }
        if (Integer.valueOf(sendRedPackBaseVo.getTotalNum()) > 10000) {
            throw new BusinessException("\u7ea2\u5305\u53d1\u653e\u7ea2\u5305\u6570\u91cf\u4e0d\u5927\u4e8e10000\u4e2a");
        }
        if (StringUtil.isEmpty(sendRedPackBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e3a\u7a7a");
        }
    }

    private static String generateNum(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            sb.append(random.nextInt(10));
            ++i;
        }
        return sb.toString();
    }

    public static synchronized String generatorMchBillno(String mchId) {
        StringBuilder sb = new StringBuilder(mchId);
        String date = DateUtils.date2SStr();
        sb.append(date);
        String num = RedPackUtil.generateNum(10);
        sb.append(num);
        return sb.toString();
    }

    public static void validateRedPackInfo(RedPackInfoBaseVo redPackInfoBaseVo) {
        if (StringUtil.isEmpty(redPackInfoBaseVo.getSysCode())) {
            throw new BusinessException("\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(redPackInfoBaseVo.getRequestNo())) {
            throw new BusinessException("\u8bf7\u6c42\u53f7\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(redPackInfoBaseVo.getAccountid())) {
            throw new BusinessException("\u5fae\u4fe1\u8d26\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(redPackInfoBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e3a\u7a7a");
        }
    }

    public static String populationRedPackInfoXml(Wx_pay_pojo_weixinpay wxConfig, WxPayTransOrderRedpackEntity wxPayTransOrderRedpackEntity) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("nonce_str", UUIDGenerator.generate());
        params.put("mch_billno", wxPayTransOrderRedpackEntity.getMchBillno());
        params.put("mch_id", wxPayTransOrderRedpackEntity.getMchId());
        params.put("appid", wxPayTransOrderRedpackEntity.getWxappid());
        params.put("bill_type", "MCHT");
        String sign = RedPackUtil.createSign(params, wxConfig.getKey());
        params.put("sign", sign);
        String paramXml = XMLUtil.converterWeixinpayXML(params);
        return paramXml;
    }

    public static RedPackInfoResponse populationRedPackInfoResponse(WxPayTransOrderRedpackEntity wxPayTransOrderRedpackEntity) {
        RedPackInfoResponse res = new RedPackInfoResponse();
        res.setMchBillno(wxPayTransOrderRedpackEntity.getMchBillno());
        res.setHbStatus(wxPayTransOrderRedpackEntity.getHbStatus());
        res.setReason(wxPayTransOrderRedpackEntity.getReason());
        Integer refundAmount = wxPayTransOrderRedpackEntity.getRefundAmount();
        res.setRefundAmount(refundAmount != null ? refundAmount.toString() : null);
        res.setRefundTime(wxPayTransOrderRedpackEntity.getRefundTime());
        res.setSendTime(wxPayTransOrderRedpackEntity.getSendTimeStr());
        res.setTotalAmount(wxPayTransOrderRedpackEntity.getTotalAmount().toString());
        res.setTotalNum(wxPayTransOrderRedpackEntity.getTotalNum().toString());
        res.setOpenid(wxPayTransOrderRedpackEntity.getReOpenid());
        res.setRcvTime(wxPayTransOrderRedpackEntity.getRcvTime());
        Integer amount = wxPayTransOrderRedpackEntity.getAmount();
        res.setAmount(amount != null ? amount.toString() : null);
        return res;
    }
}

