/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.service.impl;

import java.util.List;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.pay.SendRedPackBaseVo;
import weixin.pay.entity.WxPayConfigEntity;
import weixin.pay.entity.WxPayTransOrderRedpackEntity;
import weixin.pay.pojo.Wx_pay_pojo_weixinpay;
import weixin.pay.service.OpenPayService;
import weixin.pay.util.RedPackUtil;

@Service(value="openPayService")
public class OpenPayServiceImpl
extends CommonServiceImpl
implements OpenPayService {
    @Autowired
    private SystemService systemService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public WxPayTransOrderRedpackEntity preTransOrderRedPack(Wx_pay_pojo_weixinpay wxConfig, SendRedPackBaseVo sendRedPackBaseVo) {
        WxPayTransOrderRedpackEntity wxPayTransOrderRedpackEntity = new WxPayTransOrderRedpackEntity();
        wxPayTransOrderRedpackEntity.setAccountId(sendRedPackBaseVo.getAccountid());
        wxPayTransOrderRedpackEntity.setActName(sendRedPackBaseVo.getActName());
        wxPayTransOrderRedpackEntity.setClientIp("8.8.8.8");
        wxPayTransOrderRedpackEntity.setMchBillno(RedPackUtil.generatorMchBillno(wxConfig.getMch_id()));
        wxPayTransOrderRedpackEntity.setOrderId(sendRedPackBaseVo.getOrderId());
        wxPayTransOrderRedpackEntity.setPayType("weixinpay");
        wxPayTransOrderRedpackEntity.setRemark(sendRedPackBaseVo.getRemark());
        wxPayTransOrderRedpackEntity.setReOpenid(sendRedPackBaseVo.getOpenid());
        wxPayTransOrderRedpackEntity.setRequestNo(sendRedPackBaseVo.getRequestNo());
        wxPayTransOrderRedpackEntity.setSysCode(sendRedPackBaseVo.getSysCode());
        wxPayTransOrderRedpackEntity.setTotalAmount(Integer.valueOf(sendRedPackBaseVo.getTotalAmount()));
        wxPayTransOrderRedpackEntity.setTotalNum(Integer.valueOf(sendRedPackBaseVo.getTotalNum()));
        wxPayTransOrderRedpackEntity.setWishing(sendRedPackBaseVo.getWishing());
        wxPayTransOrderRedpackEntity.setMchId(wxConfig.getMch_id());
        wxPayTransOrderRedpackEntity.setWxappid(wxConfig.getAppid());
        wxPayTransOrderRedpackEntity.setSendName(sendRedPackBaseVo.getSendName());
        wxPayTransOrderRedpackEntity.setSendType("API");
        wxPayTransOrderRedpackEntity.setHbType("NORMAL");
        this.systemService.save(wxPayTransOrderRedpackEntity);
        return wxPayTransOrderRedpackEntity;
    }

    @Override
    public Wx_pay_pojo_weixinpay getWxPayConfig(String accountid, String payType) throws BusinessException {
        Wx_pay_pojo_weixinpay wxWeixinPay;
        List payConfigList = this.systemService.findByQueryString(" FROM WxPayConfigEntity p WHERE p.accountid='" + accountid + "' AND payType='" + payType + "'");
        if (oConvertUtils.isNullOrEmpty(payConfigList)) {
            throw new BusinessException("\u6682\u672a\u5f00\u542f\u8be5\u652f\u4ed8\u65b9\u5f0f");
        }
        WxPayConfigEntity configEntity = (WxPayConfigEntity)payConfigList.get(0);
        if (configEntity == null || configEntity.getIsUsed() != 1) {
            throw new BusinessException("\u6682\u672a\u5f00\u542f\u8be5\u652f\u4ed8\u65b9\u5f0f");
        }
        String payConfigJson = configEntity.getPayJson();
        try {
            wxWeixinPay = JSONHelper.fromJsonToObject(payConfigJson, Wx_pay_pojo_weixinpay.class);
        }
        catch (Exception e) {
            throw new BusinessException("\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (wxWeixinPay == null) {
            throw new BusinessException("\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        return wxWeixinPay;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void postTransOrderRedPack(WxPayTransOrderRedpackEntity wxPayTransOrderRedpackEntity) {
        this.systemService.updateEntitie(wxPayTransOrderRedpackEntity);
    }

    @Override
    public WxPayTransOrderRedpackEntity queryWxPayTransOrderRedpack(String requestNo, String sysCode) {
        String hql = "from WxPayTransOrderRedpackEntity where requestNo = ? and sysCode = ? ";
        List list = this.systemService.findHql(hql, requestNo, sysCode);
        if (list != null && list.size() > 0) {
            return (WxPayTransOrderRedpackEntity)list.get(0);
        }
        return null;
    }
}

