/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.controller;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.pay.PayConfigPojoFieldAnnotation;
import weixin.pay.entity.WxPayConfigEntity;
import weixin.pay.entity.WxPayTypeEntity;
import weixin.pay.form.WxPayConfigEntityForm;
import weixin.pay.service.WxPayConfigServiceI;
import weixin.pay.service.WxPayTypeServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/wxPayConfigController"})
public class WxPayConfigController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WxPayConfigController.class);
    @Autowired
    private WxPayConfigServiceI wxPayConfigService;
    @Autowired
    private SystemService systemService;
    private String message;
    @Autowired
    private WxPayTypeServiceI wxPayTypeService;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"wxPayConfigMain"})
    public ModelAndView wxPayConfigMain(HttpServletRequest request) {
        return new ModelAndView("weixin/pay/config/wxPayConfigMain");
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WxPayConfigEntity wxPayConfig, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        wxPayConfig = (WxPayConfigEntity)this.systemService.getEntity(WxPayConfigEntity.class, (Serializable)((Object)wxPayConfig.getId()));
        this.message = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u5220\u9664\u6210\u529f";
        try {
            this.wxPayConfigService.delete(wxPayConfig);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WxPayConfigEntity wxPayConfig = (WxPayConfigEntity)this.systemService.getEntity(WxPayConfigEntity.class, (Serializable)((Object)id));
                this.wxPayConfigService.delete(wxPayConfig);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAddOrUpdate"})
    public String goAddOrUpdate(WxPayConfigEntity wxPayConfig, HttpServletRequest req) {
        String viewPage = "weixin/pay/config/wxPayConfig";
        LogUtil.info("\u5fae\u4fe1\u8d26\u6237ID=" + wxPayConfig.getAccountid() + ",\u652f\u4ed8\u7c7b\u578b=" + wxPayConfig.getPayType());
        if (oConvertUtils.isNotEmpty(wxPayConfig.getPayType())) {
            WxPayTypeEntity wxPayType = this.systemService.findUniqueByProperty(WxPayTypeEntity.class, "payType", wxPayConfig.getPayType());
            List configEntityList = this.wxPayConfigService.findByQueryString(" FROM WxPayConfigEntity w where w.accountid = '" + wxPayConfig.getAccountid() + "' AND payType = '" + wxPayConfig.getPayType() + "'");
            try {
                Class<?> clazz = Class.forName(wxPayType.getPayPojoClass());
                if (!oConvertUtils.isNullOrEmpty(configEntityList)) {
                    wxPayConfig = (WxPayConfigEntity)configEntityList.get(0);
                    req.setAttribute("payPojo", JSONHelper.json2Object(wxPayConfig.getPayJson(), clazz));
                }
                Map<String, String> sortedMapInput = this.dynamicGenerateInput(clazz);
                req.setAttribute("wxPayConfigPage", (Object)wxPayConfig);
                req.setAttribute("sortedMap", sortedMapInput);
            }
            catch (ClassNotFoundException e) {
                this.message = "\u51fa\u73b0\u9519\u8bef\uff0c\u672a\u627e\u5230\u5904\u7406\u7684\u7c7b";
                throw new BusinessException(e.getMessage());
            }
            catch (SecurityException e) {
                this.message = "\u51fa\u73b0\u9519\u8bef\uff0cSecurityException";
                throw new BusinessException(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                this.message = "\u51fa\u73b0\u9519\u8bef\uff0c\u6ca1\u6709\u8fd9\u4e2a\u5b57\u6bb5";
                throw new BusinessException(e.getMessage());
            }
        }
        return viewPage;
    }

    @RequestMapping(params={"doAddOrUpdate"})
    @ResponseBody
    public AjaxJson doAddOrUpdate(WxPayConfigEntityForm wxPayConfigForm, HttpServletRequest request) {
        WxPayConfigEntity wxPayConfig = wxPayConfigForm.getWxPayConfigPage();
        String payJson = JSONHelper.map2json(wxPayConfigForm.getPayPojoMap());
        AjaxJson j = new AjaxJson();
        WxPayConfigEntity t = this.wxPayConfigService.get(WxPayConfigEntity.class, (Serializable)((Object)wxPayConfig.getId()));
        wxPayConfig.setPayJson(payJson);
        try {
            if (oConvertUtils.isEmpty(t)) {
                this.message = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u6dfb\u52a0\u6210\u529f";
                this.wxPayConfigService.save(wxPayConfig);
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            } else {
                this.message = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u66f4\u65b0\u6210\u529f";
                MyBeanUtils.copyBeanNotNull2Bean(wxPayConfig, t);
                LogUtil.info("\u6253\u5370\u51fajson\uff1a" + payJson);
                this.wxPayConfigService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u6dfb\u52a0\u6216\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/pay/config/wxPayConfigUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WxPayConfigEntity wxPayConfig, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e";
                if (BrowserUtils.isIE(request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WxPayConfigEntity.class, dataGrid);
                HqlGenerateUtil.installHql(cq, wxPayConfig, request.getParameterMap());
                List wxPayConfigs = this.wxPayConfigService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel(new ExcelTitle("\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WxPayConfigEntity.class, wxPayConfigs);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WxPayConfigEntity wxPayConfig, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e";
                if (BrowserUtils.isIE(request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel(new ExcelTitle("\u652f\u4ed8\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WxPayConfigEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWxPayConfigEntitys = (List)ExcelImportUtil.importExcelByIs(file.getInputStream(), WxPayConfigEntity.class, params);
                    for (WxPayConfigEntity wxPayConfig : listWxPayConfigEntitys) {
                        this.wxPayConfigService.save(wxPayConfig);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage(e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    private Map<String, String> dynamicGenerateInput(Class clazz) throws NoSuchFieldException {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Class)clazz);
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        PropertyDescriptor[] propertyDescriptorArray = origDescriptors;
        int n = origDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            if (!"class".equals(propertyDescriptor.getName())) {
                String fieldText = propertyDescriptor.getName();
                PayConfigPojoFieldAnnotation payConfigPojoFieldAnnotation = clazz.getDeclaredField(propertyDescriptor.getName()).getAnnotation(PayConfigPojoFieldAnnotation.class);
                if (oConvertUtils.isNotEmpty(payConfigPojoFieldAnnotation)) {
                    fieldText = payConfigPojoFieldAnnotation.fieldText();
                }
                sortedMap.put(propertyDescriptor.getName(), fieldText);
            }
            ++n2;
        }
        return sortedMap;
    }
}

