/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.controller;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.core.wxRule.impl.RemoteWeixinMethod;
import weixin.idea.oauth2.util.OAuth2Util;
import weixin.pay.PayBaseVo;
import weixin.pay.PayExecutor;
import weixin.pay.PayVo;
import weixin.pay.RefundBaseVo;
import weixin.pay.TransOrderRequest;
import weixin.pay.entity.WxPayCenterConfigEntity;
import weixin.pay.entity.WxPayConfigEntity;
import weixin.pay.entity.WxPayLogEntity;
import weixin.pay.service.WxPayCenterConfigServiceI;
import weixin.pay.service.WxPayConfigServiceI;
import weixin.pay.service.WxPayLogServiceI;
import weixin.pay.weixinpay.WeixinpayVo;
import weixin.util.EncryptionUtil;
import weixin.util.SignatureUtil;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinPayController"})
public class WeixinPayController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinPayController.class);
    @Autowired
    private WxPayConfigServiceI wxPayConfigService;
    @Autowired
    private WxPayCenterConfigServiceI wxPayCenterConfigService;
    @Autowired
    private RemoteWeixinMethod remoteWeixinMethod;
    @Autowired
    private WxPayLogServiceI wxPayLogService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"testPay"})
    public String testPay(HttpServletRequest request, HttpServletResponse response) {
        String modelViewStr = "weixin/pay/testPay";
        return modelViewStr;
    }

    @RequestMapping(params={"toPay"})
    public String toPay(HttpServletRequest req, PayBaseVo payBaseVo) {
        String modelViewStr = "";
        LogUtil.info("\u4f20\u5165\u7684\u652f\u4ed8\u5bf9\u8c61\u4e3a==>" + payBaseVo);
        String payType = payBaseVo.getPayType();
        List payConfigList = this.systemService.findByQueryString(" FROM WxPayConfigEntity p WHERE p.accountid='" + payBaseVo.getAccountid() + "' AND payType='" + payType + "'");
        if (oConvertUtils.isNullOrEmpty(payConfigList)) {
            req.setAttribute("msg", (Object)"\u6682\u672a\u5f00\u542f\u8be5\u652f\u4ed8\u65b9\u5f0f");
            return "weixin/pay/payError";
        }
        if (!oConvertUtils.isNullOrEmpty(payConfigList)) {
            WxPayConfigEntity configEntity = (WxPayConfigEntity)payConfigList.get(0);
            String payConfigJson = configEntity.getPayJson();
            PayExecutor payOutExecutor = (PayExecutor)ApplicationContextUtil.getContext().getBean(payType);
            if ("weixinpay".equals(payType)) {
                String targetUrlMethod = "toPay";
                String weixin_author2_url = this.callWeixinAuthor2(req, targetUrlMethod, payBaseVo);
                if (oConvertUtils.isNotEmpty(weixin_author2_url)) {
                    return weixin_author2_url;
                }
                req.setAttribute("msg", (Object)"Oauth\u8ba4\u8bc1\u5931\u8d25");
                return "weixin/pay/payError";
            }
            try {
                modelViewStr = payOutExecutor.executePayMethod(req, payBaseVo, payConfigJson);
            }
            catch (BusinessException e) {
                req.setAttribute("msg", (Object)e.getMessage());
                return "weixin/pay/payError";
            }
        }
        return modelViewStr;
    }

    @RequestMapping(params={"toWxPay"})
    public String toWxPay(HttpServletRequest req, PayVo payVo) {
        String modelViewStr = "";
        try {
            LogUtil.info("\u4f20\u5165\u7684\u652f\u4ed8\u52a0\u5bc6\u5bf9\u8c61\u4e3a==>" + payVo);
            this.validatePayParam(payVo);
            WxPayCenterConfigEntity wxPayCenterConfigEntity = this.wxPayCenterConfigService.getWxPayCenterConfigEntity(payVo.getSysCode());
            if (wxPayCenterConfigEntity == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            String encryptKey = wxPayCenterConfigEntity.getEncrypKey();
            String json = EncryptionUtil.aesDecrypt((String)payVo.getData(), (String)encryptKey);
            LogUtil.info("\u89e3\u7801\u540e\u7684json==>" + json);
            PayBaseVo payBaseVo = new PayBaseVo();
            payBaseVo = (PayBaseVo)JSONHelper.json2Object(json, PayBaseVo.class);
            LogUtil.info("\u4f20\u5165\u7684\u652f\u4ed8\u5bf9\u8c61\u4e3a==>" + payBaseVo);
            this.validatePayBaseParam(payBaseVo);
            HashMap paramMap = new HashMap();
            MyBeanUtils.copyBean2Map(paramMap, payBaseVo);
            String key = wxPayCenterConfigEntity.getSignKey();
            if (!SignatureUtil.checkSign(paramMap, (String)key, (String)payBaseVo.getSign())) {
                throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
            String payType = payBaseVo.getPayType();
            List payConfigList = this.systemService.findByQueryString(" FROM WxPayConfigEntity p WHERE p.accountid='" + payBaseVo.getAccountid() + "' AND payType='" + payType + "'");
            if (oConvertUtils.isNullOrEmpty(payConfigList)) {
                throw new BusinessException("\u6682\u672a\u5f00\u542f\u8be5\u652f\u4ed8\u65b9\u5f0f");
            }
            if (!oConvertUtils.isNullOrEmpty(payConfigList)) {
                String targetUrlMethod;
                String weixin_author2_url;
                WxPayConfigEntity configEntity = (WxPayConfigEntity)payConfigList.get(0);
                String payConfigJson = configEntity.getPayJson();
                PayExecutor payOutExecutor = (PayExecutor)ApplicationContextUtil.getContext().getBean(payType);
                if ("weixinpay".equals(payType) && oConvertUtils.isNotEmpty(weixin_author2_url = this.callWeixinAuthor2Pay(req, targetUrlMethod = "toWxPay", payBaseVo.getAccountid(), payVo))) {
                    LogUtil.info("Oauth url==>" + weixin_author2_url);
                    return weixin_author2_url;
                }
                modelViewStr = payOutExecutor.executePayMethod(req, payBaseVo, payConfigJson);
            }
        }
        catch (BusinessException e) {
            logger.info((Object)e.getMessage());
            req.setAttribute("msg", (Object)e.getMessage());
            return "weixin/pay/payError";
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)e.getMessage());
            req.setAttribute("msg", (Object)"\u7cfb\u7edf\u5f02\u5e38\uff01");
            return "weixin/pay/payError";
        }
        return modelViewStr;
    }

    @RequestMapping(params={"queryTransOrder"})
    @ResponseBody
    public PayVo queryTransOrder(HttpServletRequest req, PayVo payVo) {
        try {
            LogUtil.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355request==>" + payVo);
            this.validatePayParam(payVo);
            WxPayCenterConfigEntity wxPayCenterConfigEntity = this.wxPayCenterConfigService.getWxPayCenterConfigEntity(payVo.getSysCode());
            if (wxPayCenterConfigEntity == null) {
                throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
            }
            String encryptKey = wxPayCenterConfigEntity.getEncrypKey();
            String signKey = wxPayCenterConfigEntity.getSignKey();
            String json = EncryptionUtil.aesDecrypt((String)payVo.getData(), (String)encryptKey);
            LogUtil.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355\u89e3\u7801\u540e\u7684json==>" + json);
            TransOrderRequest requert = new TransOrderRequest();
            requert = (TransOrderRequest)JSONHelper.json2Object(json, TransOrderRequest.class);
            this.validateQueryRequest(requert);
            HashMap paramMap = new HashMap();
            MyBeanUtils.copyBean2Map(paramMap, requert);
            if (!SignatureUtil.checkSign(paramMap, (String)signKey, (String)requert.getSign())) {
                throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
            WxPayLogEntity wxPayLog = this.wxPayLogService.findWxPayLogEntity(requert.getRequestNo(), requert.getSysCode());
            LogUtil.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355==>" + wxPayLog);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("requestNo", wxPayLog.getRequestNo());
            map.put("orderId", wxPayLog.getOrderId());
            map.put("payType", wxPayLog.getPayType());
            map.put("payTotal", wxPayLog.getPayTotal());
            map.put("accountId", wxPayLog.getAccountId());
            map.put("status", wxPayLog.getStatus());
            map.put("returnMsg", wxPayLog.getResultMsg());
            String sign = SignatureUtil.sign(map, (String)signKey);
            map.put("sign", sign);
            String data = JSONHelper.map2json(map);
            data = EncryptionUtil.aesEncrypt((String)data, (String)encryptKey);
            payVo.setData(data);
            return payVo;
        }
        catch (Exception e) {
            LogUtil.info("\u67e5\u8be2\u4ea4\u6613\u8ba2\u5355\u5f02\u5e38==>" + e.getMessage());
            payVo.setData("");
            return payVo;
        }
    }

    private void validateQueryRequest(TransOrderRequest requert) {
        if (StringUtil.isEmpty(requert.getSysCode())) {
            throw new BusinessException("\u7b2c\u4e09\u65b9\u5f00\u53d1\u8005\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(requert.getRequestNo())) {
            throw new BusinessException("\u652f\u4ed8\u8bf7\u6c42\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(requert.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validatePayParam(PayVo payVo) {
        if (StringUtil.isEmpty(payVo.getSysCode())) {
            throw new BusinessException("\u7b2c\u4e09\u65b9\u5f00\u53d1\u8005\u6807\u8bc6\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(payVo.getData())) {
            throw new BusinessException("\u52a0\u5bc6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validatePayBaseParam(PayBaseVo payBaseVo) {
        if (StringUtil.isEmpty(payBaseVo.getSysCode())) {
            throw new BusinessException("\u7b2c\u4e09\u65b9\u5f00\u53d1\u8005\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(payBaseVo.getRequestNo())) {
            throw new BusinessException("\u652f\u4ed8\u8bf7\u6c42\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(payBaseVo.getOrderId())) {
            throw new BusinessException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(payBaseVo.getAccountid())) {
            throw new BusinessException("\u5fae\u4fe1\u516c\u4f17\u53f7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(payBaseVo.getTotal_money())) {
            throw new BusinessException("\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(payBaseVo.getPayType())) {
            throw new BusinessException("\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(payBaseVo.getBackCallUrl())) {
            throw new BusinessException("\u652f\u4ed8\u56de\u8c03\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty(payBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @RequestMapping(params={"toRefundPay"})
    public ModelAndView toRefundPay(HttpServletRequest req, RefundBaseVo refundBaseVo) {
        List payConfigList;
        ModelAndView mv = new ModelAndView("weixin/pay/weixinpay/torefund");
        LogUtil.info("\u4f20\u5165\u7684\u7533\u8bf7\u9000\u6b3e\u5bf9\u8c61\u4e3a==>" + refundBaseVo);
        if (StringUtil.isEmpty(refundBaseVo.getOrderId())) {
            throw new BusinessException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WxPayLogEntity wxpayLog = this.systemService.findUniqueByProperty(WxPayLogEntity.class, "orderId", refundBaseVo.getOrderId());
        if (!oConvertUtils.isNullOrEmpty(wxpayLog) && !oConvertUtils.isNullOrEmpty(payConfigList = this.systemService.findByQueryString(" FROM WxPayConfigEntity p WHERE p.accountid='" + wxpayLog.getAccountId() + "' AND payType='" + wxpayLog.getPayType() + "'"))) {
            PayExecutor payOutExecutor = (PayExecutor)ApplicationContextUtil.getContext().getBean(wxpayLog.getPayType());
            String message = payOutExecutor.executeRefundMethod(req, refundBaseVo, ((WxPayConfigEntity)payConfigList.get(0)).getPayJson());
            LogUtil.info("\u7533\u8bf7\u9000\u6b3e\u5904\u7406\u7ed3\u679c==>" + message);
            mv.addObject("message", (Object)message);
        }
        return mv;
    }

    @RequestMapping(value={"/wx/weixinpay"}, params={"redirectWeixinpay"})
    public String redirectWeixinpay(HttpServletRequest request, HttpServletResponse response, WeixinpayVo weixinpayVo) {
        LogUtil.info("\u5fae\u4fe1\u652f\u4ed8\u53c2\u6570\u4e3a\uff1a" + weixinpayVo);
        String preCallUrl = weixinpayVo.getPreCallUrl();
        try {
            if (StringUtil.isNotEmpty(preCallUrl)) {
                preCallUrl = URLDecoder.decode(preCallUrl, "UTF-8");
                weixinpayVo.setPreCallUrl(preCallUrl);
            }
        }
        catch (Exception e) {
            logger.info((Object)("\u56de\u8c03\u5730\u5740\u89e3\u7801\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        request.setAttribute("weixinpayVo", (Object)weixinpayVo);
        String modelViewStr = "weixin/pay/weixinpay/toweixinpay";
        return modelViewStr;
    }

    @RequestMapping(value={"/paycallback/{payType}/{accountid}"})
    public String paycallbackRest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="payType") String payType, @PathVariable(value="accountid") String accountid) {
        LogUtil.info("\u652f\u4ed8\u56de\u8c03\uff0c\u56de\u8c03\u7c7b\u578b\uff1a" + payType);
        if (!"Alipay".equalsIgnoreCase(payType)) {
            "Tenpay".equalsIgnoreCase(payType);
        }
        return null;
    }

    @RequestMapping(value={"/notify/{payType}/{accountid}"})
    @ResponseBody
    public void notifyRest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="payType") String payType, @PathVariable(value="accountid") String accountid) {
        LogUtil.info("\u652f\u4ed8\u901a\u77e5\uff0c\u901a\u77e5\u7c7b\u578b\uff1a" + payType);
        LogUtil.info("\u652f\u4ed8\u901a\u77e5\uff0c\u5fae\u4fe1\u8d26\u6237accountid\uff1a" + accountid);
        List payConfigList = this.systemService.findByQueryString(" FROM WxPayConfigEntity p WHERE p.accountid='" + accountid + "' AND payType='" + payType + "'");
        if (!oConvertUtils.isNullOrEmpty(payConfigList)) {
            WxPayConfigEntity configEntity = (WxPayConfigEntity)payConfigList.get(0);
            String payConfigJson = configEntity.getPayJson();
            PayExecutor payOutExecutor = (PayExecutor)ApplicationContextUtil.getContext().getBean(payType);
            payOutExecutor.doNotify(request, response, payConfigJson);
        }
    }

    private String callWeixinAuthor2(HttpServletRequest req, String targetUrlMethod, PayBaseVo payBaseVo) {
        HashMap paramsMap = new HashMap();
        MyBeanUtils.copyBean2Map(paramsMap, payBaseVo);
        String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), (String)targetUrlMethod, paramsMap);
        String weixin_author2_url = this.remoteWeixinMethod.callWeixinAuthor2(req, payBaseVo.getAccountid(), tagetUrl);
        return weixin_author2_url;
    }

    private String callWeixinAuthor2Pay(HttpServletRequest req, String targetUrlMethod, String accountid, PayVo payVo) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("sysCode", payVo.getSysCode());
        paramsMap.put("data", URLEncoder.encode(payVo.getData()));
        String tagetUrl = OAuth2Util.obtainTargetUrl(this.getClass(), (String)targetUrlMethod, paramsMap);
        String weixin_author2_url = this.remoteWeixinMethod.callWeixinAuthor2Pay(req, accountid, tagetUrl);
        return weixin_author2_url;
    }
}

