/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.controller;

import com.alibaba.fastjson.JSONObject;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.util.MyBeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import weixin.pay.RedPackInfoBaseVo;
import weixin.pay.RedPackInfoResponse;
import weixin.pay.SendRedPackBaseVo;
import weixin.pay.entity.WxPayCenterConfigEntity;
import weixin.pay.entity.WxPayTransOrderRedpackEntity;
import weixin.pay.pojo.Wx_pay_pojo_weixinpay;
import weixin.pay.service.OpenPayService;
import weixin.pay.service.WxPayCenterConfigServiceI;
import weixin.pay.tenpay.XMLUtil;
import weixin.pay.util.RedPackUtil;
import weixin.pay.util.XMLParseUtil;
import weixin.util.SignatureUtil;

@Controller
@RequestMapping(value={"/openPayController"})
public class OpenPayController {
    private static final Logger logger = Logger.getLogger(OpenPayController.class);
    private static final String REDPACKURL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
    private static final String REDPACK_INFOURL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo";
    @Autowired
    private OpenPayService openPayService;
    @Autowired
    private WxPayCenterConfigServiceI wxPayCenterConfigService;

    private void validateSign(SendRedPackBaseVo sendRedPackBaseVo) {
        WxPayCenterConfigEntity wxPayCenterConfigEntity = this.wxPayCenterConfigService.getWxPayCenterConfigEntity(sendRedPackBaseVo.getSysCode());
        if (wxPayCenterConfigEntity == null) {
            throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
        }
        HashMap paramMap = new HashMap();
        MyBeanUtils.copyBean2Map(paramMap, sendRedPackBaseVo);
        String key = wxPayCenterConfigEntity.getSignKey();
        if (!SignatureUtil.checkSign(paramMap, (String)key, (String)sendRedPackBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    @RequestMapping(params={"sendRedPack"})
    public void sendRedPack(SendRedPackBaseVo sendRedPackBaseVo, HttpServletRequest request, HttpServletResponse response) {
        logger.info((Object)("[sendRedPack] \u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e param sendRedPackBaseVo = " + sendRedPackBaseVo));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            RedPackUtil.validateSendRedPack(sendRedPackBaseVo);
            this.validateSign(sendRedPackBaseVo);
            Wx_pay_pojo_weixinpay wxConfig = this.openPayService.getWxPayConfig(sendRedPackBaseVo.getAccountid(), "weixinpay");
            WxPayTransOrderRedpackEntity wxPayTransOrderRedpackEntity = this.openPayService.queryWxPayTransOrderRedpack(sendRedPackBaseVo.getRequestNo(), sendRedPackBaseVo.getSysCode());
            if (wxPayTransOrderRedpackEntity == null) {
                wxPayTransOrderRedpackEntity = this.openPayService.preTransOrderRedPack(wxConfig, sendRedPackBaseVo);
            } else if ("2".equals(wxPayTransOrderRedpackEntity.getStatus())) {
                resultMap.put("success", "true");
                resultMap.put("sysCode", wxPayTransOrderRedpackEntity.getSysCode());
                resultMap.put("requestNo", wxPayTransOrderRedpackEntity.getRequestNo());
                resultMap.put("mchBillno", wxPayTransOrderRedpackEntity.getMchBillno());
                resultMap.put("return_msg", "\u53d1\u653e\u6210\u529f");
                logger.info((Object)("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u6210\u529f\uff1a" + ((Object)resultMap).toString()));
                this.outResultMap(resultMap, response);
                return;
            }
            String paramXml = RedPackUtil.populationSendRedPackXml(wxConfig, wxPayTransOrderRedpackEntity);
            logger.info((Object)("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u8bf7\u6c42\uff1a" + paramXml));
            String xmlStr = RedPackUtil.sslResquest(REDPACKURL, paramXml, wxConfig);
            Map resMap = XMLUtil.doXMLParse(xmlStr);
            logger.info((Object)("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u54cd\u5e94\uff1a" + resMap.toString()));
            String return_code = (String)resMap.get("return_code");
            String return_msg = (String)resMap.get("return_msg");
            if ("SUCCESS".equals(return_code)) {
                String result_code = (String)resMap.get("result_code");
                if ("SUCCESS".equals(result_code)) {
                    String send_time = (String)resMap.get("send_time");
                    String send_listid = (String)resMap.get("send_listid");
                    wxPayTransOrderRedpackEntity.setStatus("2");
                    wxPayTransOrderRedpackEntity.setReturnCode(return_code);
                    wxPayTransOrderRedpackEntity.setReturnMsg(return_msg);
                    wxPayTransOrderRedpackEntity.setResultCode(result_code);
                    wxPayTransOrderRedpackEntity.setSendTime(send_time);
                    wxPayTransOrderRedpackEntity.setSendListid(send_listid);
                    wxPayTransOrderRedpackEntity.setFinishTime(new Date());
                    this.openPayService.postTransOrderRedPack(wxPayTransOrderRedpackEntity);
                    resultMap.put("success", "true");
                    resultMap.put("sysCode", wxPayTransOrderRedpackEntity.getSysCode());
                    resultMap.put("requestNo", wxPayTransOrderRedpackEntity.getRequestNo());
                    resultMap.put("mchBillno", wxPayTransOrderRedpackEntity.getMchBillno());
                    resultMap.put("return_msg", "\u53d1\u653e\u6210\u529f");
                    logger.info((Object)("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u6210\u529f\uff1a" + ((Object)resultMap).toString()));
                    this.outResultMap(resultMap, response);
                    return;
                }
                String err_code = (String)resMap.get("err_code");
                String err_code_des = (String)resMap.get("err_code_des");
                wxPayTransOrderRedpackEntity.setStatus("3");
                wxPayTransOrderRedpackEntity.setReturnCode(return_code);
                wxPayTransOrderRedpackEntity.setResultCode(result_code);
                wxPayTransOrderRedpackEntity.setErrCode(err_code);
                this.openPayService.postTransOrderRedPack(wxPayTransOrderRedpackEntity);
                resultMap.put("success", "false");
                resultMap.put("return_msg", err_code_des);
                logger.info((Object)("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u5931\u8d25\uff1a" + ((Object)resultMap).toString()));
                this.outResultMap(resultMap, response);
                return;
            }
            wxPayTransOrderRedpackEntity.setStatus("3");
            wxPayTransOrderRedpackEntity.setReturnCode(return_code);
            wxPayTransOrderRedpackEntity.setReturnMsg(return_msg);
            this.openPayService.postTransOrderRedPack(wxPayTransOrderRedpackEntity);
            resultMap.put("success", "false");
            resultMap.put("return_msg", return_msg);
            logger.info((Object)("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u5931\u8d25\uff1a" + ((Object)resultMap).toString()));
            this.outResultMap(resultMap, response);
            return;
        }
        catch (BusinessException e) {
            resultMap.put("success", "false");
            resultMap.put("return_msg", e.getMessage());
            logger.info((Object)("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u5931\u8d25\uff1a" + ((Object)resultMap).toString()));
            this.outResultMap(resultMap, response);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("success", "false");
            resultMap.put("return_msg", e.getMessage());
            logger.info((Object)("\u5fae\u4fe1\u73b0\u91d1\u7ea2\u5305\u53d1\u653e\u7cfb\u7edf\u5f02\u5e38\uff1a" + ((Object)resultMap).toString()));
            this.outResultMap(resultMap, response);
            return;
        }
    }

    private void validateSign(RedPackInfoBaseVo redPackInfoBaseVo) {
        WxPayCenterConfigEntity wxPayCenterConfigEntity = this.wxPayCenterConfigService.getWxPayCenterConfigEntity(redPackInfoBaseVo.getSysCode());
        if (wxPayCenterConfigEntity == null) {
            throw new BusinessException("\u5bc6\u94a5\u83b7\u53d6\u5931\u8d25");
        }
        HashMap paramMap = new HashMap();
        MyBeanUtils.copyBean2Map(paramMap, redPackInfoBaseVo);
        String key = wxPayCenterConfigEntity.getSignKey();
        if (!SignatureUtil.checkSign(paramMap, (String)key, (String)redPackInfoBaseVo.getSign())) {
            throw new BusinessException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    @RequestMapping(params={"getRedPackinfo"})
    public void getRedPackinfo(RedPackInfoBaseVo redPackInfoBaseVo, HttpServletRequest request, HttpServletResponse response) {
        logger.info((Object)("[sendRedPack] \u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2 param redPackInfoBaseVo = " + redPackInfoBaseVo));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            RedPackUtil.validateRedPackInfo(redPackInfoBaseVo);
            this.validateSign(redPackInfoBaseVo);
            Wx_pay_pojo_weixinpay wxConfig = this.openPayService.getWxPayConfig(redPackInfoBaseVo.getAccountid(), "weixinpay");
            WxPayTransOrderRedpackEntity wxPayTransOrderRedpackEntity = this.openPayService.queryWxPayTransOrderRedpack(redPackInfoBaseVo.getRequestNo(), redPackInfoBaseVo.getSysCode());
            if (wxPayTransOrderRedpackEntity == null) {
                throw new BusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u7ed3\u679c");
            }
            if ("RECEIVED".equals(wxPayTransOrderRedpackEntity.getHbStatus()) || "REFUND".equals(wxPayTransOrderRedpackEntity.getHbStatus())) {
                resultMap.put("success", "true");
                resultMap.put("return_msg", "\u67e5\u8be2\u6210\u529f");
                RedPackInfoResponse res = RedPackUtil.populationRedPackInfoResponse(wxPayTransOrderRedpackEntity);
                resultMap.put("hbinfo", res);
                logger.info((Object)("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u6210\u529f\uff1a" + ((Object)resultMap).toString()));
                this.outResultMap(resultMap, response);
                return;
            }
            String paramXml = RedPackUtil.populationRedPackInfoXml(wxConfig, wxPayTransOrderRedpackEntity);
            logger.info((Object)("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u8bf7\u6c42\uff1a" + paramXml));
            String xmlStr = RedPackUtil.sslResquest(REDPACK_INFOURL, paramXml, wxConfig);
            Map<String, Object> resMap = XMLParseUtil.xml2map(xmlStr);
            RedPackInfoResponse res = XMLParseUtil.getRedPackInfoResponse(resMap);
            res.setSysCode(redPackInfoBaseVo.getSysCode());
            res.setRequestNo(redPackInfoBaseVo.getRequestNo());
            logger.info((Object)("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u54cd\u5e94\uff1a" + res.toString()));
            wxPayTransOrderRedpackEntity.setHbStatus(res.getHbStatus());
            wxPayTransOrderRedpackEntity.setRefundAmount(res.getRefundAmount() != null ? Integer.valueOf(res.getRefundAmount()) : null);
            wxPayTransOrderRedpackEntity.setRefundTime(res.getRefundTime());
            wxPayTransOrderRedpackEntity.setSendTimeStr(res.getSendTime());
            wxPayTransOrderRedpackEntity.setAmount(res.getAmount() != null ? Integer.valueOf(res.getAmount()) : null);
            wxPayTransOrderRedpackEntity.setRcvTime(res.getRcvTime());
            wxPayTransOrderRedpackEntity.setReason(res.getReason());
            this.openPayService.postTransOrderRedPack(wxPayTransOrderRedpackEntity);
            resultMap.put("success", "true");
            resultMap.put("return_msg", "\u67e5\u8be2\u6210\u529f");
            resultMap.put("hbinfo", res);
            logger.info((Object)("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u6210\u529f\uff1a" + ((Object)resultMap).toString()));
            this.outResultMap(resultMap, response);
            return;
        }
        catch (BusinessException e) {
            e.printStackTrace();
            resultMap.put("success", "true");
            resultMap.put("return_msg", e.getMessage());
            logger.info((Object)("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u5931\u8d25\uff1a" + ((Object)resultMap).toString()));
            this.outResultMap(resultMap, response);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            resultMap.put("success", "true");
            resultMap.put("return_msg", e.getMessage());
            logger.info((Object)("\u5fae\u4fe1\u7ea2\u5305\u67e5\u8be2\u5f02\u5e38\uff1a" + ((Object)resultMap).toString()));
            this.outResultMap(resultMap, response);
            return;
        }
    }

    @RequestMapping(params={"sendGroupRedPack"})
    public void sendGroupRedPack(SendRedPackBaseVo sendRedPackBaseVo, HttpServletRequest request, HttpServletResponse response) {
        logger.info((Object)"[sendGroupRedPack] start");
        logger.info((Object)"[sendGroupRedPack] end");
    }

    private void outResultMap(Map<String, Object> resultMap, HttpServletResponse response) {
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        PrintWriter pw = null;
        try {
            try {
                response.setContentType("application/json");
                response.setHeader("Cache-Control", "no-store");
                pw = response.getWriter();
                pw.write(JSONObject.toJSONString(resultMap));
                pw.flush();
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

