/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.alipay.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import weixin.pay.alipay.config.AlipayConfig;
import weixin.pay.alipay.sign.MD5;
import weixin.pay.alipay.sign.RSA;
import weixin.pay.alipay.util.AlipayCore;

public class AlipayNotify {
    private static final String HTTPS_VERIFY_URL = "https://mapi.alipay.com/gateway.do?service=notify_verify&";

    public static boolean verifyReturn(Map<String, String> params, String key) {
        boolean isSign;
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return isSign = AlipayNotify.getSignVeryfy(params, sign, true, key);
    }

    public static boolean verifyNotify(Map<String, String> params, String key, String partner) throws Exception {
        boolean isSign;
        String responseTxt = "true";
        try {
            Document document = DocumentHelper.parseText((String)params.get("notify_data"));
            String notify_id = document.selectSingleNode("//notify/notify_id").getText();
            responseTxt = AlipayNotify.verifyResponse(notify_id, partner);
        }
        catch (Exception e) {
            responseTxt = e.toString();
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return (isSign = AlipayNotify.getSignVeryfy(params, sign, false, key)) && responseTxt.equals("true");
    }

    public static Map<String, String> decrypt(Map<String, String> inputPara) throws Exception {
        inputPara.put("notify_data", RSA.decrypt(inputPara.get("notify_data"), AlipayConfig.private_key, AlipayConfig.input_charset));
        return inputPara;
    }

    private static boolean getSignVeryfy(Map<String, String> Params, String sign, boolean isSort, String key) {
        Map<String, String> sParaNew = AlipayCore.paraFilter(Params);
        String preSignStr = "";
        preSignStr = isSort ? AlipayCore.createLinkString(sParaNew) : AlipayCore.createLinkStringNoSort(sParaNew);
        boolean isSign = false;
        if (AlipayConfig.sign_type.equals("MD5")) {
            isSign = MD5.verify(preSignStr, sign, key, AlipayConfig.input_charset);
        }
        if (AlipayConfig.sign_type.equals("0001")) {
            isSign = RSA.verify(preSignStr, sign, AlipayConfig.ali_public_key, AlipayConfig.input_charset);
        }
        return isSign;
    }

    private static String verifyResponse(String notify_id, String partner) {
        String veryfy_url = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + partner + "&notify_id=" + notify_id;
        return AlipayNotify.checkUrl(veryfy_url);
    }

    private static String checkUrl(String urlvalue) {
        String inputLine = "";
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            inputLine = "";
        }
        return inputLine;
    }
}

