/*
 * Decompiled with CFR 0.152.
 */
package weixin.pay.alipay;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.util.JSONHelper;
import org.jeecgframework.core.util.LogUtil;
import org.springframework.stereotype.Service;
import weixin.pay.PayBaseVo;
import weixin.pay.PayExecutor;
import weixin.pay.RefundBaseVo;
import weixin.pay.alipay.config.AlipayConfig;
import weixin.pay.alipay.sign.MD5;
import weixin.pay.alipay.sign.RSA;
import weixin.pay.alipay.util.AlipayCore;
import weixin.pay.alipay.util.AlipayNotify;
import weixin.pay.alipay.util.AlipaySubmit;
import weixin.pay.pojo.Wx_pay_pojo_alipay;
import weixin.util.DateUtils;

@Service(value="alipay")
public class AlipayPayClient
implements PayExecutor {
    public String obtain_token_id(PayBaseVo payBaseVo, Wx_pay_pojo_alipay alipay) {
        String request_token;
        String sHtmlTextToken;
        String ALIPAY_GATEWAY_NEW = "http://wappaygw.alipay.com/service/rest.htm?";
        String format = "xml";
        String v = "2.0";
        String req_id = DateUtils.date2Str((SimpleDateFormat)DateUtils.yyyymmddhhmmss);
        String notify_url = this.getPayNotifyUrl(payBaseVo.getAccountid());
        String call_back_url = this.getPayCallbackUrl(payBaseVo.getAccountid());
        String merchant_url = "http://127.0.0.1:8080/WS_WAP_PAYWAP-JAVA-UTF-8/xxxxxx.jsp";
        String seller_email = alipay.getSeller_email();
        String out_trade_no = new String(payBaseVo.getOrderId());
        String subject = new String(payBaseVo.getDesc());
        String total_fee = new String(payBaseVo.getTotal_money());
        String req_dataToken = "<direct_trade_create_req><notify_url>" + notify_url + "</notify_url><call_back_url>" + call_back_url + "</call_back_url><seller_account_name>" + seller_email + "</seller_account_name><out_trade_no>" + out_trade_no + "</out_trade_no><subject>" + subject + "</subject><total_fee>" + total_fee + "</total_fee><merchant_url>" + merchant_url + "</merchant_url></direct_trade_create_req>";
        HashMap<String, String> sParaTempToken = new HashMap<String, String>();
        sParaTempToken.put("service", "alipay.wap.trade.create.direct");
        sParaTempToken.put("partner", alipay.getPartner());
        sParaTempToken.put("_input_charset", AlipayConfig.input_charset);
        sParaTempToken.put("sec_id", AlipayConfig.sign_type);
        sParaTempToken.put("format", format);
        sParaTempToken.put("v", v);
        sParaTempToken.put("req_id", req_id);
        sParaTempToken.put("req_data", req_dataToken);
        sParaTempToken.put("key", alipay.getKey());
        try {
            sHtmlTextToken = AlipaySubmit.buildRequest(ALIPAY_GATEWAY_NEW, "", "", sParaTempToken);
        }
        catch (Exception e) {
            throw new BusinessException("\u652f\u4ed8\u5b9d\u672a\u751f\u6210\u9884\u652f\u4ed8\u8ba2\u5355\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u68c0\u67e5\u7f51\u7edc\u901a\u4fe1\u72b6\u51b5", e);
        }
        try {
            sHtmlTextToken = URLDecoder.decode(sHtmlTextToken, AlipayConfig.input_charset);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            request_token = AlipaySubmit.getRequestToken(sHtmlTextToken);
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790\u652f\u4ed8\u7684\u652f\u4ed8token\u5931\u8d25", e);
        }
        return request_token;
    }

    public static Map<String, String> buildRequestPara(String req_data, Wx_pay_pojo_alipay alipay) {
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "alipay.wap.auth.authAndExecute");
        sParaTemp.put("partner", alipay.getPartner());
        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
        sParaTemp.put("sec_id", AlipayConfig.sign_type);
        sParaTemp.put("format", "xml");
        sParaTemp.put("v", "2.0");
        sParaTemp.put("req_data", req_data);
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
        String mysign = AlipayPayClient.buildRequestMysign(sPara, alipay.getKey());
        sPara.put("sign", mysign);
        if (!sPara.get("service").equals("alipay.wap.trade.create.direct") && !sPara.get("service").equals("alipay.wap.auth.authAndExecute")) {
            sPara.put("sign_type", AlipayConfig.sign_type);
        }
        return sPara;
    }

    public static String buildRequestMysign(Map<String, String> sPara, String key) {
        String prestr = AlipayCore.createLinkString(sPara);
        String mysign = "";
        if (AlipayConfig.sign_type.equals("MD5")) {
            mysign = MD5.sign(prestr, key, AlipayConfig.input_charset);
        }
        if (AlipayConfig.sign_type.equals("0001")) {
            mysign = RSA.sign(prestr, AlipayConfig.private_key, AlipayConfig.input_charset);
        }
        return mysign;
    }

    @Override
    public String executePayMethod(HttpServletRequest req, PayBaseVo payBaseVo, String wxPayJson) {
        String modelViewStr = "";
        Wx_pay_pojo_alipay wxAlipay = JSONHelper.fromJsonToObject(wxPayJson, Wx_pay_pojo_alipay.class);
        String token_id = "";
        try {
            token_id = this.obtain_token_id(payBaseVo, wxAlipay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtil.info("\u53d6\u5f97\u652f\u4ed8\u5b9d\u8fd4\u56de\u7684token_id=" + token_id);
        String req_data = "<auth_and_execute_req><request_token>" + token_id + "</request_token></auth_and_execute_req>";
        Map<String, String> signParams = AlipayPayClient.buildRequestPara(req_data, wxAlipay);
        req.setAttribute("signParams", signParams);
        modelViewStr = "weixin/pay/alipay/toAlipay";
        return modelViewStr;
    }

    @Override
    public String getPayCallbackUrl(String accountid) {
        return String.valueOf(BaseCallBackURL) + "alipay/" + accountid;
    }

    @Override
    public String getPayNotifyUrl(String accountid) {
        return String.valueOf(BaseNotifyUrl) + "alipay/" + accountid;
    }

    @Override
    public void doNotify(HttpServletRequest request, HttpServletResponse response, String payConfigJson) {
        try {
            Wx_pay_pojo_alipay wxAlipay = JSONHelper.fromJsonToObject(payConfigJson, Wx_pay_pojo_alipay.class);
            HashMap<String, String> params = new HashMap<String, String>();
            Map requestParams = request.getParameterMap();
            for (String name : requestParams.keySet()) {
                String[] values = (String[])requestParams.get(name);
                String valueStr = "";
                int i = 0;
                while (i < values.length) {
                    valueStr = i == values.length - 1 ? String.valueOf(valueStr) + values[i] : String.valueOf(valueStr) + values[i] + ",";
                    ++i;
                }
                params.put(name, valueStr);
            }
            Document doc_notify_data = DocumentHelper.parseText((String)((String)params.get("notify_data")));
            String out_trade_no = doc_notify_data.selectSingleNode("//notify/out_trade_no").getText();
            String trade_no = doc_notify_data.selectSingleNode("//notify/trade_no").getText();
            String trade_status = doc_notify_data.selectSingleNode("//notify/trade_status").getText();
            if (AlipayNotify.verifyNotify(params, wxAlipay.getKey(), wxAlipay.getPartner())) {
                if (trade_status.equals("TRADE_FINISHED")) {
                    response.getWriter().write("success");
                } else if (trade_status.equals("TRADE_SUCCESS")) {
                    response.getWriter().write("success");
                }
            } else {
                response.getWriter().write("fail");
            }
        }
        catch (Exception e) {
            try {
                response.getWriter().write("fail");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public String executeRefundMethod(HttpServletRequest req, RefundBaseVo refundBaseVo, String payConfigJson) throws BusinessException {
        return null;
    }
}

