/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.service.impl;

import java.io.Serializable;
import java.util.Date;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.constant.WeiXinConstant;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.system.pojo.base.TSDepart;
import org.jeecgframework.web.system.pojo.base.TSRole;
import org.jeecgframework.web.system.pojo.base.TSRoleUser;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.guanjia.gzuserinfo.service.GzUserInfoYwServiceI;
import weixin.util.WeixinConfigUtil;

@Service(value="userService")
@Transactional
public class UserServiceImpl
extends CommonServiceImpl
implements UserService {
    @Autowired
    private SystemService systemService;
    @Autowired
    private GzUserInfoYwServiceI gzUserInfoYwService;

    @Override
    public TSUser checkUserExits(TSUser user) {
        return this.commonDao.getUserByUserIdAndUserNameExits(user);
    }

    @Override
    public String getUserRole(TSUser user) {
        return this.commonDao.getUserRole(user);
    }

    @Override
    public void pwdInit(TSUser user, String newPwd) {
        this.commonDao.pwdInit(user, newPwd);
    }

    @Override
    public int getUsersOfThisRole(String id) {
        Criteria criteria = this.getSession().createCriteria(TSRoleUser.class);
        criteria.add((Criterion)Restrictions.eq((String)"TSRole.id", (Object)id));
        int allCounts = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        return allCounts;
    }

    @Override
    public void delUser(TSUser user) {
        this.commonDao.updateBySqlString("update t_s_log set userid = null where userid = '" + user.getId() + "'");
        this.delete(user);
    }

    @Override
    public TSUser saveWeixinUser(String openid, String accountid) {
        String roleid = "";
        TSRole tsRole = this.systemService.findUniqueByProperty(TSRole.class, "roleCode", WeixinConfigUtil.getConfigByName((String)"default_weixin_member_role"));
        if (tsRole != null) {
            roleid = tsRole.getId();
        }
        TSUser user = new TSUser();
        String nickName = "\u5fae\u4fe1\u7528\u6237";
        user.setUserName(nickName);
        user.setPassword("");
        TSDepart pepart = new TSDepart();
        pepart.setId("4028d881436d514601436d5214d70015");
        user.setTSDepart(pepart);
        if (user.getTSDepart().equals("")) {
            user.setTSDepart(null);
        }
        user.setOpenid(openid);
        user.setStatus(Globals.User_Normal);
        user.setType(WeiXinConstant.USER_MANAGER);
        user.setCreateTime(new Date());
        this.systemService.save(user);
        String message = "\u5fae\u4fe1\u7528\u6237: " + user.getUserName() + "\u6dfb\u52a0\u6210\u529f";
        LogUtil.info("------------  openid--------------------------------------------------" + user.getUserName() + "----------save_login_ok------------");
        if (StringUtil.isNotEmpty(roleid)) {
            this.saveRoleUser(user, roleid);
        }
        return user;
    }

    private void saveRoleUser(TSUser user, String roleidstr) {
        String[] roleids = roleidstr.split(",");
        int i = 0;
        while (i < roleids.length) {
            TSRoleUser rUser = new TSRoleUser();
            TSRole role = (TSRole)this.systemService.getEntity(TSRole.class, (Serializable)((Object)roleids[i]));
            rUser.setTSRole(role);
            rUser.setTSUser(user);
            this.systemService.save(rUser);
            ++i;
        }
    }
}

