/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.service.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.MutiLangUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.dao.JeecgDictDao;
import org.jeecgframework.web.system.pojo.base.DictEntity;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.pojo.base.TSIcon;
import org.jeecgframework.web.system.pojo.base.TSLog;
import org.jeecgframework.web.system.pojo.base.TSRole;
import org.jeecgframework.web.system.pojo.base.TSRoleFunction;
import org.jeecgframework.web.system.pojo.base.TSRoleUser;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="systemService")
@Transactional
public class SystemServiceImpl
extends CommonServiceImpl
implements SystemService {
    private static final Logger logger = Logger.getLogger(SystemServiceImpl.class);
    @Autowired
    private JeecgDictDao jeecgDictDao;

    @Override
    public TSUser checkUserExits(TSUser user) throws Exception {
        return this.commonDao.getUserByUserIdAndUserNameExits(user);
    }

    @Override
    public List<DictEntity> queryDict(String dicTable, String dicCode, String dicText) {
        List<DictEntity> dictList = null;
        if (StringUtil.isEmpty(dicTable)) {
            dictList = this.jeecgDictDao.querySystemDict(dicCode);
        } else {
            dicText = StringUtil.isEmpty(dicText, dicCode);
            dictList = this.jeecgDictDao.queryCustomDict(dicTable, dicCode, dicText);
        }
        return dictList;
    }

    @Override
    public void addLog(String logcontent, Short loglevel, Short operatetype) {
        String broswer = null;
        TSUser user = null;
        TSLog log = new TSLog();
        try {
            HttpServletRequest request = ContextHolderUtils.getRequest();
            log.setNote(oConvertUtils.getIpAddrByRequest(request));
            broswer = BrowserUtils.checkBrowse(request);
            user = ResourceUtil.getSessionUserName();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        log.setLogcontent(logcontent);
        log.setLoglevel(loglevel);
        log.setOperatetype(operatetype);
        log.setBroswer(broswer);
        log.setOperatetime(DataUtils.gettimestamp());
        log.setTSUser(user);
        this.commonDao.save(log);
    }

    @Override
    public TSType getType(String typecode, String typename, TSTypegroup tsTypegroup) {
        TSType actType = this.commonDao.findUniqueByProperty(TSType.class, "typecode", typecode);
        if (actType == null) {
            actType = new TSType();
            actType.setTypecode(typecode);
            actType.setTypename(typename);
            actType.setTSTypegroup(tsTypegroup);
            this.commonDao.save(actType);
        }
        return actType;
    }

    @Override
    public TSTypegroup getTypeGroup(String typegroupcode, String typgroupename) {
        TSTypegroup tsTypegroup = this.commonDao.findUniqueByProperty(TSTypegroup.class, "typegroupcode", typegroupcode);
        if (tsTypegroup == null) {
            tsTypegroup = new TSTypegroup();
            tsTypegroup.setTypegroupcode(typegroupcode);
            tsTypegroup.setTypegroupname(typgroupename);
            this.commonDao.save(tsTypegroup);
        }
        return tsTypegroup;
    }

    @Override
    public TSTypegroup getTypeGroupByCode(String typegroupCode) {
        TSTypegroup tsTypegroup = this.commonDao.findUniqueByProperty(TSTypegroup.class, "typegroupcode", typegroupCode);
        return tsTypegroup;
    }

    @Override
    public void initAllTypeGroups() {
        List<TSTypegroup> typeGroups = this.commonDao.loadAll(TSTypegroup.class);
        for (TSTypegroup tsTypegroup : typeGroups) {
            TSTypegroup.allTypeGroups.put(tsTypegroup.getTypegroupcode().toLowerCase(), tsTypegroup);
            List<TSType> types = this.commonDao.findByProperty(TSType.class, "TSTypegroup.id", tsTypegroup.getId());
            TSTypegroup.allTypes.put(tsTypegroup.getTypegroupcode().toLowerCase(), types);
        }
    }

    @Override
    public void refleshTypesCach(TSType type) {
        TSTypegroup tsTypegroup = type.getTSTypegroup();
        TSTypegroup typeGroupEntity = this.commonDao.get(TSTypegroup.class, (Serializable)((Object)tsTypegroup.getId()));
        List<TSType> types = this.commonDao.findByProperty(TSType.class, "TSTypegroup.id", tsTypegroup.getId());
        TSTypegroup.allTypes.put(typeGroupEntity.getTypegroupcode().toLowerCase(), types);
    }

    @Override
    public void refleshTypeGroupCach() {
        TSTypegroup.allTypeGroups.clear();
        List<TSTypegroup> typeGroups = this.commonDao.loadAll(TSTypegroup.class);
        for (TSTypegroup tsTypegroup : typeGroups) {
            TSTypegroup.allTypeGroups.put(tsTypegroup.getTypegroupcode().toLowerCase(), tsTypegroup);
        }
    }

    @Override
    public Set<String> getOperationCodesByRoleIdAndFunctionId(String roleId, String functionId) {
        TSRoleFunction tsRoleFunction;
        HashSet<String> operationCodes = new HashSet<String>();
        TSRole role = this.commonDao.get(TSRole.class, (Serializable)((Object)roleId));
        CriteriaQuery cq1 = new CriteriaQuery(TSRoleFunction.class);
        cq1.eq("TSRole.id", role.getId());
        cq1.eq("TSFunction.id", functionId);
        cq1.add();
        List rFunctions = this.getListByCriteriaQuery(cq1, false);
        if (rFunctions != null && rFunctions.size() > 0 && (tsRoleFunction = (TSRoleFunction)rFunctions.get(0)).getOperation() != null) {
            String[] operationArry = tsRoleFunction.getOperation().split(",");
            int i = 0;
            while (i < operationArry.length) {
                operationCodes.add(operationArry[i]);
                ++i;
            }
        }
        return operationCodes;
    }

    @Override
    public Set<String> getOperationCodesByUserIdAndFunctionId(String userId, String functionId) {
        HashSet<String> operationCodes = new HashSet<String>();
        List<TSRoleUser> rUsers = this.findByProperty(TSRoleUser.class, "TSUser.id", userId);
        for (TSRoleUser ru : rUsers) {
            TSRoleFunction tsRoleFunction;
            TSRole role = ru.getTSRole();
            CriteriaQuery cq1 = new CriteriaQuery(TSRoleFunction.class);
            cq1.eq("TSRole.id", role.getId());
            cq1.eq("TSFunction.id", functionId);
            cq1.add();
            List rFunctions = this.getListByCriteriaQuery(cq1, false);
            if (rFunctions == null || rFunctions.size() <= 0 || (tsRoleFunction = (TSRoleFunction)rFunctions.get(0)).getOperation() == null) continue;
            String[] operationArry = tsRoleFunction.getOperation().split(",");
            int i = 0;
            while (i < operationArry.length) {
                operationCodes.add(operationArry[i]);
                ++i;
            }
        }
        return operationCodes;
    }

    @Override
    public void flushRoleFunciton(String id, TSFunction newFunction) {
        TSFunction functionEntity = (TSFunction)this.getEntity(TSFunction.class, (Serializable)((Object)id));
        if (functionEntity.getTSIcon() == null || !StringUtil.isNotEmpty(functionEntity.getTSIcon().getId())) {
            return;
        }
        TSIcon oldIcon = (TSIcon)this.getEntity(TSIcon.class, (Serializable)((Object)functionEntity.getTSIcon().getId()));
        if (!oldIcon.getIconClas().equals(newFunction.getTSIcon().getIconClas())) {
            HttpSession session = ContextHolderUtils.getSession();
            TSUser user = ResourceUtil.getSessionUserName();
            List<TSRoleUser> rUsers = this.findByProperty(TSRoleUser.class, "TSUser.id", user.getId());
            for (TSRoleUser ru : rUsers) {
                TSRole role = ru.getTSRole();
                session.removeAttribute(role.getId());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateLimitIp(HttpServletRequest request) {
        try {
            String[] limitIpArr;
            String limitIps = MutiLangUtil.getMutiKeyValueByZH("weixin.auth.limit.ip");
            logger.info((Object)("[AUTH_LIMIT_IP]----weixin.auth.limit.ip----->>>>>" + limitIps));
            if (StringUtil.isEmpty(limitIps)) {
                return true;
            }
            String ip = oConvertUtils.getIpAddrByRequest(request);
            logger.info((Object)("[AUTH_LIMIT_IP]----remote ip----->>>>>" + ip));
            if (!StringUtil.isNotEmpty(ip)) return false;
            String[] stringArray = limitIpArr = limitIps.split(",");
            int n = limitIpArr.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String limitIp = stringArray[n2];
                if (ip.equals(limitIp)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return true;
        }
    }
}

