/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.web.system.pojo.base.TSNotice;
import org.jeecgframework.web.system.pojo.base.TSNoticeAuthorityUser;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.NoticeService;
import org.springframework.stereotype.Service;

@Service(value="noticeService")
public class NoticeServiceImpl
extends CommonServiceImpl
implements NoticeService {
    @Override
    public String addNotice(String noticeTitle, String noticeContent, String noticeType, String noticeLevel, Date noticeTerm, String createUser) {
        String noticeId = null;
        TSNotice notice = new TSNotice();
        notice.setNoticeTitle(noticeTitle);
        notice.setNoticeContent(noticeContent);
        notice.setNoticeType(noticeType);
        notice.setNoticeLevel(noticeLevel);
        notice.setNoticeTerm(noticeTerm);
        notice.setCreateUser(createUser);
        notice.setCreateTime(new Date());
        this.save(notice);
        noticeId = notice.getId();
        return noticeId;
    }

    @Override
    public void addNoticeAuthorityUser(String noticeId, String userid) {
        if (noticeId != null && userid != null) {
            TSNoticeAuthorityUser entity = new TSNoticeAuthorityUser();
            entity.setNoticeId(noticeId);
            TSUser tsuser = new TSUser();
            tsuser.setId(userid);
            entity.setUser(tsuser);
            this.saveOrUpdate(entity);
        }
    }

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((TSNotice)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((TSNotice)entity);
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((TSNotice)entity);
    }

    @Override
    public boolean doAddSql(TSNotice t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(TSNotice t) {
        return true;
    }

    @Override
    public boolean doDelSql(TSNotice t) {
        return true;
    }

    public String replaceVal(String sql, TSNotice t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{notice_title}", String.valueOf(t.getNoticeTitle()));
        sql = sql.replace("#{notice_content}", String.valueOf(t.getNoticeContent()));
        sql = sql.replace("#{notice_type}", String.valueOf(t.getNoticeType()));
        sql = sql.replace("#{notice_level}", String.valueOf(t.getNoticeLevel()));
        sql = sql.replace("#{notice_term}", String.valueOf(t.getNoticeTerm()));
        sql = sql.replace("#{create_user}", String.valueOf(t.getCreateUser()));
        sql = sql.replace("#{create_time}", String.valueOf(t.getCreateTime()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }
}

