/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.service.impl;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.system.pojo.base.MutiLangEntity;
import org.jeecgframework.web.system.service.MutiLangServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mutiLangService")
@Transactional
public class MutiLangServiceImpl
extends CommonServiceImpl
implements MutiLangServiceI {
    @Autowired
    private HttpServletRequest request;

    @Override
    public void initAllMutiLang() {
        List<MutiLangEntity> mutiLang = this.commonDao.loadAll(MutiLangEntity.class);
        for (MutiLangEntity mutiLangEntity : mutiLang) {
            MutiLangEntity.mutiLangMap.put(String.valueOf(mutiLangEntity.getLangKey()) + "_" + mutiLangEntity.getLangCode(), mutiLangEntity.getLangContext());
        }
    }

    @Override
    public String getLang(String langKey) {
        String langContext;
        String language = BrowserUtils.getBrowserLanguage(this.request);
        if (this.request.getSession().getAttribute("lang") != null) {
            language = (String)this.request.getSession().getAttribute("lang");
        }
        if (StringUtil.isEmpty(langContext = MutiLangEntity.mutiLangMap.get(String.valueOf(langKey) + "_" + language))) {
            langContext = MutiLangEntity.mutiLangMap.get("common.notfind.langkey_" + this.request.getSession().getAttribute("lang"));
            if ("null".equals(langContext) || langContext == null || langKey.startsWith("?")) {
                langContext = "";
            }
            langContext = String.valueOf(langContext) + langKey;
        }
        return langContext;
    }

    @Override
    public String getLang(String lanKey, String langArg) {
        String langContext = StringUtil.getEmptyString();
        if (StringUtil.isEmpty(langArg)) {
            langContext = this.getLang(lanKey);
        } else {
            String[] argArray = langArg.split(",");
            langContext = this.getLang(lanKey);
            int i = 0;
            while (i < argArray.length) {
                String langKeyArg = argArray[i].trim();
                String langKeyContext = this.getLang(langKeyArg);
                langContext = StringUtil.replace(langContext, "{" + i + "}", langKeyContext);
                ++i;
            }
        }
        return langContext;
    }

    @Override
    public void refleshMutiLangCach() {
        MutiLangEntity.mutiLangMap.clear();
        this.initAllMutiLang();
    }
}

