/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.service.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jeecgframework.core.annotation.config.AutoMenu;
import org.jeecgframework.core.annotation.config.AutoMenuOperation;
import org.jeecgframework.core.annotation.config.MenuCodeType;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.pojo.base.TSIcon;
import org.jeecgframework.web.system.pojo.base.TSOperation;
import org.jeecgframework.web.system.service.MenuInitService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="menuInitService")
@Transactional
public class MenuInitServiceImpl
extends CommonServiceImpl
implements MenuInitService {
    private static final String KEY_SPLIT = "-";
    private static final String MENU_TYPE_ID = "#";
    private static final String MENU_TYPE_CSS = ".";

    @Override
    public void initMenu() {
        StringBuffer key;
        List<TSFunction> functionList = this.loadAll(TSFunction.class);
        List<TSOperation> operationList = this.loadAll(TSOperation.class);
        HashMap<String, TSFunction> functionMap = new HashMap<String, TSFunction>();
        HashMap<String, TSOperation> operationMap = new HashMap<String, TSOperation>();
        for (TSFunction function : functionList) {
            key = new StringBuffer();
            key.append(function.getFunctionName() == null ? "" : function.getFunctionName());
            key.append(KEY_SPLIT);
            key.append(function.getFunctionLevel() == null ? "" : function.getFunctionLevel());
            key.append(KEY_SPLIT);
            key.append(function.getFunctionUrl() == null ? "" : function.getFunctionUrl());
            functionMap.put(key.toString(), function);
        }
        for (TSOperation operation : operationList) {
            key = new StringBuffer();
            key.append(operation.getTSFunction() == null ? "" : operation.getTSFunction().getId());
            key.append(KEY_SPLIT);
            key.append(operation.getOperationcode() == null ? "" : operation.getOperationcode());
            operationMap.put(key.toString(), operation);
        }
        Set classSet = null;
        for (Class clazz : classSet) {
            Method[] methods;
            AutoMenu autoMenu;
            if (!clazz.isAnnotationPresent(AutoMenu.class) || !StringUtil.isNotEmpty((autoMenu = clazz.getAnnotation(AutoMenu.class)).name())) continue;
            StringBuffer menuKey = new StringBuffer();
            menuKey.append(autoMenu.name());
            menuKey.append(KEY_SPLIT);
            menuKey.append(autoMenu.level() == null ? "" : autoMenu.level());
            menuKey.append(KEY_SPLIT);
            menuKey.append(autoMenu.url() == null ? "" : autoMenu.url());
            TSFunction function = null;
            if (!functionMap.containsKey(menuKey.toString())) {
                function = new TSFunction();
                function.setFunctionName(autoMenu.name());
                function.setFunctionIframe(null);
                function.setFunctionLevel(Short.valueOf(autoMenu.level()));
                function.setFunctionOrder(Integer.toString(autoMenu.order()));
                function.setFunctionUrl(autoMenu.url());
                function.setTSFunction(null);
                String iconId = autoMenu.icon();
                if (StringUtil.isNotEmpty(iconId)) {
                    TSIcon obj = this.get(TSIcon.class, (Serializable)((Object)iconId));
                    if (obj != null) {
                        function.setTSIcon(obj);
                    } else {
                        function.setTSIcon(null);
                    }
                } else {
                    function.setTSIcon(null);
                }
                Serializable id = this.save(function);
                function.setId(id.toString());
            } else {
                function = (TSFunction)functionMap.get(menuKey.toString());
            }
            Method[] methodArray = methods = clazz.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                AutoMenuOperation autoMenuOperation;
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(AutoMenuOperation.class) && StringUtil.isNotEmpty((autoMenuOperation = method.getAnnotation(AutoMenuOperation.class)).code())) {
                    StringBuffer menuOperationKey = new StringBuffer();
                    menuOperationKey.append(function == null ? "" : function.getId());
                    menuOperationKey.append(KEY_SPLIT);
                    String code = "";
                    if (autoMenuOperation.codeType() == MenuCodeType.TAG) {
                        code = autoMenuOperation.code();
                    } else if (autoMenuOperation.codeType() == MenuCodeType.ID) {
                        code = MENU_TYPE_ID + autoMenuOperation.code();
                    } else if (autoMenuOperation.codeType() == MenuCodeType.CSS) {
                        code = MENU_TYPE_CSS + autoMenuOperation.code();
                    }
                    menuOperationKey.append(code);
                    if (!operationMap.containsKey(menuOperationKey.toString())) {
                        TSOperation operation = new TSOperation();
                        operation.setOperationname(autoMenuOperation.name());
                        operation.setOperationcode(code);
                        operation.setOperationicon(null);
                        operation.setStatus(Short.parseShort(Integer.toString(autoMenuOperation.status())));
                        operation.setTSFunction(function);
                        String iconId = autoMenuOperation.icon();
                        if (StringUtil.isNotEmpty(iconId)) {
                            TSIcon icon = new TSIcon();
                            icon.setId(iconId);
                            operation.setTSIcon(icon);
                        } else {
                            operation.setTSIcon(null);
                        }
                        this.save(operation);
                    }
                }
                ++n2;
            }
        }
    }
}

