/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.service.impl;

import java.util.List;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.web.system.pojo.base.DynamicDataSourceEntity;
import org.jeecgframework.web.system.service.DynamicDataSourceServiceI;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dynamicDataSourceService")
@Transactional
public class DynamicDataSourceServiceImpl
extends CommonServiceImpl
implements DynamicDataSourceServiceI {
    @Override
    public List<DynamicDataSourceEntity> initDynamicDataSource() {
        DynamicDataSourceEntity.DynamicDataSourceMap.clear();
        List<DynamicDataSourceEntity> dynamicSourceEntityList = this.commonDao.loadAll(DynamicDataSourceEntity.class);
        for (DynamicDataSourceEntity dynamicSourceEntity : dynamicSourceEntityList) {
            DynamicDataSourceEntity.DynamicDataSourceMap.put(dynamicSourceEntity.getDbKey(), dynamicSourceEntity);
        }
        return dynamicSourceEntityList;
    }

    public static DynamicDataSourceEntity getDbSourceEntityByKey(String dbKey) {
        DynamicDataSourceEntity dynamicDataSourceEntity = DynamicDataSourceEntity.DynamicDataSourceMap.get(dbKey);
        return dynamicDataSourceEntity;
    }

    @Override
    public void refleshCache() {
        this.initDynamicDataSource();
    }
}

