/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.listener;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jeecgframework.web.system.service.DynamicDataSourceServiceI;
import org.jeecgframework.web.system.service.MenuInitService;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InitListener
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent event) {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)event.getServletContext());
        SystemService systemService = (SystemService)webApplicationContext.getBean("systemService");
        MenuInitService menuInitService = (MenuInitService)webApplicationContext.getBean("menuInitService");
        DynamicDataSourceServiceI dynamicDataSourceService = (DynamicDataSourceServiceI)webApplicationContext.getBean("dynamicDataSourceService");
        systemService.initAllTypeGroups();
        String rootUrl = event.getServletContext().getRealPath("/template/cms");
        String styleUrl = String.valueOf(rootUrl) + "/meishu/html/";
        String enstaticDir = String.valueOf(styleUrl) + "static" + "/EN";
        File enfile = new File(enstaticDir);
        if (enfile.exists()) {
            InitListener.deleteDir(enfile);
        }
        String zhstaticDir = String.valueOf(styleUrl) + "static" + "/ZH";
        File zhfile = new File(zhstaticDir);
        if (enfile.exists()) {
            InitListener.deleteDir(zhfile);
        }
        dynamicDataSourceService.initDynamicDataSource();
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = InitListener.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        } else {
            dir.delete();
        }
        return true;
    }
}

