/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboBox;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.ValidForm;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.constant.WeiXinConstant;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.ListtoMenu;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.PasswordUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.RoletoJson;
import org.jeecgframework.core.util.SetListSort;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.DataTableReturn;
import org.jeecgframework.tag.vo.datatable.DataTables;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.web.system.manager.ClientManager;
import org.jeecgframework.web.system.pojo.base.TSDepart;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.pojo.base.TSRole;
import org.jeecgframework.web.system.pojo.base.TSRoleFunction;
import org.jeecgframework.web.system.pojo.base.TSRoleUser;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountUserRelation;
import weixin.vip.service.WeixinVipInfoServiceI;
import weixin.vip.service.WeixinVipMemberServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/userController"})
public class UserController {
    private static final Logger logger = Logger.getLogger(UserController.class);
    private UserService userService;
    private SystemService systemService;
    private String message = null;
    private String status = null;
    private WeixinVipInfoServiceI weixinVipInfoService;
    private WeixinVipMemberServiceI weixinVipMemberService;

    @Autowired
    public void setWeixinVipInfoService(WeixinVipInfoServiceI weixinVipInfoService) {
        this.weixinVipInfoService = weixinVipInfoService;
    }

    @Autowired
    public void setWeixinVipMemberService(WeixinVipMemberServiceI weixinVipMemberService) {
        this.weixinVipMemberService = weixinVipMemberService;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @RequestMapping(params={"menu"})
    public void menu(HttpServletRequest request, HttpServletResponse response) {
        SetListSort sort = new SetListSort();
        TSUser u = ResourceUtil.getSessionUserName();
        HashSet<TSFunction> loginActionlist = new HashSet<TSFunction>();
        List<TSRoleUser> rUsers = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", u.getId());
        for (TSRoleUser ru : rUsers) {
            TSRole role = ru.getTSRole();
            List<TSRoleFunction> roleFunctionList = this.systemService.findByProperty(TSRoleFunction.class, "TSRole.id", role.getId());
            if (roleFunctionList.size() <= 0) continue;
            for (TSRoleFunction roleFunction : roleFunctionList) {
                TSFunction function = roleFunction.getTSFunction();
                loginActionlist.add(function);
            }
        }
        ArrayList<TSFunction> bigActionlist = new ArrayList<TSFunction>();
        ArrayList<TSFunction> smailActionlist = new ArrayList<TSFunction>();
        if (loginActionlist.size() > 0) {
            for (TSFunction function : loginActionlist) {
                if (function.getFunctionLevel() == 0) {
                    bigActionlist.add(function);
                    continue;
                }
                if (function.getFunctionLevel() != 1) continue;
                smailActionlist.add(function);
            }
        }
        Collections.sort(bigActionlist, sort);
        Collections.sort(smailActionlist, sort);
        String logString = ListtoMenu.getMenu(bigActionlist, smailActionlist);
        try {
            response.getWriter().write(logString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"userDemo"})
    public String userDemo(HttpServletRequest request) {
        List departList = this.systemService.getList(TSDepart.class);
        request.setAttribute("departsReplace", (Object)RoletoJson.listToReplaceStr(departList, "departname", "id"));
        return "system/user/userList2";
    }

    @RequestMapping(params={"user"})
    public String user(HttpServletRequest request) {
        List departList = this.systemService.getList(TSDepart.class);
        request.setAttribute("departsReplace", (Object)RoletoJson.listToReplaceStr(departList, "departname", "id"));
        return "system/user/userList";
    }

    @RequestMapping(params={"userinfo"})
    public String userinfo(HttpServletRequest request) {
        TSUser user = ResourceUtil.getSessionUserName();
        request.setAttribute("user", (Object)user);
        return "system/user/userinfo";
    }

    @RequestMapping(params={"changepassword"})
    public String changepassword(HttpServletRequest request) {
        TSUser user = ResourceUtil.getSessionUserName();
        request.setAttribute("user", (Object)user);
        return "system/user/changepassword";
    }

    @RequestMapping(params={"savenewpwd"})
    @ResponseBody
    public AjaxJson savenewpwd(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        TSUser user = ResourceUtil.getSessionUserName();
        String password = oConvertUtils.getString(request.getParameter("password"));
        String newpassword = oConvertUtils.getString(request.getParameter("newpassword"));
        String pString = PasswordUtil.encrypt(user.getUserName(), password, PasswordUtil.getStaticSalt());
        if (!pString.equals(user.getPassword())) {
            j.setMsg("\u539f\u5bc6\u7801\u4e0d\u6b63\u786e");
            j.setSuccess(false);
        } else {
            try {
                user.setPassword(PasswordUtil.encrypt(user.getUserName(), newpassword, PasswordUtil.getStaticSalt()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.systemService.updateEntitie(user);
            j.setMsg("\u4fee\u6539\u6210\u529f");
        }
        return j;
    }

    @RequestMapping(params={"changepasswordforuser"})
    public ModelAndView changepasswordforuser(TSUser user, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(user.getId())) {
            user = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)user.getId()));
            req.setAttribute("user", (Object)user);
            this.idandname(req, user);
            LogUtil.info(String.valueOf(user.getPassword()) + "-----" + user.getRealName());
        }
        return new ModelAndView("system/user/adminchangepwd");
    }

    @RequestMapping(params={"savenewpwdforuser"})
    @ResponseBody
    public AjaxJson savenewpwdforuser(HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String id = oConvertUtils.getString(req.getParameter("id"));
        String password = oConvertUtils.getString(req.getParameter("password"));
        if (StringUtil.isNotEmpty(id)) {
            TSUser users = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)id));
            LogUtil.info(users.getUserName());
            users.setPassword(PasswordUtil.encrypt(users.getUserName(), password, PasswordUtil.getStaticSalt()));
            users.setStatus(Globals.User_Normal);
            users.setActivitiSync(users.getActivitiSync());
            this.systemService.updateEntitie(users);
            this.message = "\u7528\u6237: " + users.getUserName() + "\u5bc6\u7801\u91cd\u7f6e\u6210\u529f";
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"lock"})
    @ResponseBody
    public AjaxJson lock(String id, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        TSUser user = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)id));
        if ("admin".equals(user.getUserName())) {
            this.message = "\u8d85\u7ea7\u7ba1\u7406\u5458[admin]\u4e0d\u53ef\u9501\u5b9a";
            j.setMsg(this.message);
            return j;
        }
        if (user.getStatus() != Globals.User_Forbidden) {
            user.setStatus(Globals.User_Forbidden);
            this.userService.updateEntitie(user);
            this.message = "\u7528\u6237\uff1a" + user.getUserName() + "\u9501\u5b9a\u6210\u529f";
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else if (user.getStatus() == Globals.User_Forbidden) {
            user.setStatus(Globals.User_Normal);
            this.userService.updateEntitie(user);
            this.message = "\u7528\u6237\uff1a" + user.getUserName() + "\u89e3\u9501\u6210\u529f";
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u9501\u5b9a\u8d26\u6237\u5931\u8d25";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"role"})
    @ResponseBody
    public List<ComboBox> role(HttpServletResponse response, HttpServletRequest request, ComboBox comboBox) {
        List<TSRoleUser> roleUser;
        String id = request.getParameter("id");
        ArrayList<ComboBox> comboBoxs = new ArrayList();
        ArrayList<TSRole> roles = new ArrayList<TSRole>();
        if (StringUtil.isNotEmpty(id) && (roleUser = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", id)).size() > 0) {
            for (TSRoleUser ru : roleUser) {
                roles.add(ru.getTSRole());
            }
        }
        List roleList = this.systemService.getList(TSRole.class);
        comboBoxs = TagUtil.getComboBox(roleList, roles, comboBox);
        return comboBoxs;
    }

    @RequestMapping(params={"depart"})
    @ResponseBody
    public List<ComboBox> depart(HttpServletResponse response, HttpServletRequest request, ComboBox comboBox) {
        TSUser user;
        String id = request.getParameter("id");
        ArrayList<ComboBox> comboBoxs = new ArrayList();
        ArrayList<TSDepart> departs = new ArrayList<TSDepart>();
        if (StringUtil.isNotEmpty(id) && (user = this.systemService.get(TSUser.class, (Serializable)((Object)id))).getTSDepart() != null) {
            TSDepart depart = this.systemService.get(TSDepart.class, (Serializable)((Object)user.getTSDepart().getId()));
            departs.add(depart);
        }
        List departList = this.systemService.getList(TSDepart.class);
        comboBoxs = TagUtil.getComboBox(departList, departs, comboBox);
        return comboBoxs;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSUser user, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSUser.class, dataGrid);
        HqlGenerateUtil.installHql(cq, user);
        Object[] userstate = new Short[]{Globals.User_Normal, Globals.User_ADMIN, Globals.User_Forbidden};
        cq.in("status", userstate);
        cq.notEq("type", "1");
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        ArrayList<TSUser> cfeList = new ArrayList<TSUser>();
        for (Object o : dataGrid.getResults()) {
            List<TSRoleUser> roleUser;
            if (!(o instanceof TSUser)) continue;
            TSUser cfe = (TSUser)o;
            if (cfe.getId() != null && !"".equals(cfe.getId()) && (roleUser = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", cfe.getId())).size() > 0) {
                String roleName = "";
                for (TSRoleUser ru : roleUser) {
                    roleName = String.valueOf(roleName) + ru.getTSRole().getRoleName() + ",";
                }
                roleName = roleName.substring(0, roleName.length() - 1);
                cfe.setUserKey(roleName);
            }
            cfeList.add(cfe);
        }
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(TSUser user, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        if ("admin".equals(user.getUserName())) {
            this.message = "\u8d85\u7ea7\u7ba1\u7406\u5458[admin]\u4e0d\u53ef\u5220\u9664";
            j.setMsg(this.message);
            return j;
        }
        user = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)user.getId()));
        List<TSRoleUser> roleUser = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", user.getId());
        if (!user.getStatus().equals(Globals.User_ADMIN)) {
            if (roleUser.size() > 0) {
                this.delRoleUser(user);
                this.systemService.deleteAllEntitie(this.systemService.findByProperty(WeixinAccountUserRelation.class, "user.id", user.getId()));
                this.userService.delUser(user);
                this.message = "\u7528\u6237\uff1a" + user.getUserName() + "\u5220\u9664\u6210\u529f";
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
            } else {
                this.userService.delUser(user);
                this.message = "\u7528\u6237\uff1a" + user.getUserName() + "\u5220\u9664\u6210\u529f";
            }
        } else {
            this.message = "\u8d85\u7ea7\u7ba1\u7406\u5458\u4e0d\u53ef\u5220\u9664";
        }
        j.setMsg(this.message);
        return j;
    }

    public void delRoleUser(TSUser user) {
        List<TSRoleUser> roleUserList = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", user.getId());
        if (roleUserList.size() >= 1) {
            for (TSRoleUser tRoleUser : roleUserList) {
                this.systemService.delete(tRoleUser);
            }
        }
    }

    @RequestMapping(params={"checkUser"})
    @ResponseBody
    public ValidForm checkUser(HttpServletRequest request) {
        ValidForm v = new ValidForm();
        String userName = oConvertUtils.getString(request.getParameter("param"));
        String code = oConvertUtils.getString(request.getParameter("code"));
        List<TSUser> roles = this.systemService.findByProperty(TSUser.class, "userName", userName);
        if (roles.size() > 0 && !code.equals(userName)) {
            v.setInfo("\u7528\u6237\u540d\u5df2\u5b58\u5728");
            v.setStatus("n");
        }
        return v;
    }

    @RequestMapping(params={"saveUser"})
    @ResponseBody
    public AjaxJson saveUser(HttpServletRequest req, TSUser user) {
        AjaxJson j = new AjaxJson();
        String roleid = oConvertUtils.getString(req.getParameter("roleid"));
        TSUser u1 = this.systemService.findUniqueByProperty(TSUser.class, "openid", user.getOpenid());
        String password = oConvertUtils.getString(req.getParameter("password"));
        if (StringUtil.isNotEmpty(user.getId())) {
            TSUser users = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)user.getId()));
            users.setEmail(user.getEmail());
            users.setOfficePhone(user.getOfficePhone());
            users.setMobilePhone(user.getMobilePhone());
            users.setTSDepart(user.getTSDepart());
            users.setRealName(user.getRealName());
            users.setStatus(Globals.User_Normal);
            users.setActivitiSync(user.getActivitiSync());
            if (user.getValidtime() != null && !"".equals(user.getValidtime())) {
                users.setValidtime(user.getValidtime());
            } else {
                users.setValidtime(DataUtils.getNumForDay(7));
            }
            this.systemService.updateEntitie(users);
            List<TSRoleUser> ru = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", user.getId());
            this.systemService.deleteAllEntitie(ru);
            this.message = "\u7528\u6237: " + users.getUserName() + "\u66f4\u65b0\u6210\u529f";
            this.status = "2";
            if (StringUtil.isNotEmpty(roleid)) {
                this.saveRoleUser(users, roleid);
            }
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else if (u1 != null) {
            u1.setUserName(user.getUserName());
            u1.setPassword(PasswordUtil.encrypt(user.getUserName(), password, PasswordUtil.getStaticSalt()));
            this.systemService.updateEntitie(u1);
            List<TSRoleUser> ru = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", user.getId());
            this.systemService.deleteAllEntitie(ru);
            this.message = "\u7528\u6237: " + u1.getUserName() + "\u66f4\u65b0\u6210\u529f";
            this.status = "2";
            if (StringUtil.isNotEmpty(roleid)) {
                this.saveRoleUser(u1, roleid);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
        } else {
            TSUser u = this.systemService.findUniqueByProperty(TSUser.class, "userName", user.getUserName());
            if (u != null) {
                this.message = "\u7528\u6237: " + u.getUserName() + "\u5df2\u7ecf\u5b58\u5728";
                this.status = "-1";
            } else {
                String shopSymbol = req.getParameter("shopSymbol");
                if (shopSymbol != null && "shop".equals(shopSymbol)) {
                    if ("manager".equals(user.getType())) {
                        TSRole tsRole = this.systemService.findUniqueByProperty(TSRole.class, "roleCode", "manager");
                        roleid = tsRole.getId();
                    } else if ("ceshi".equals(user.getType())) {
                        TSRole tsRole = this.systemService.findUniqueByProperty(TSRole.class, "roleCode", "ceshi");
                        roleid = tsRole.getId();
                    } else if ("admin".equals(user.getType())) {
                        TSRole tsRole = this.systemService.findUniqueByProperty(TSRole.class, "roleCode", "admin");
                        roleid = tsRole.getId();
                    }
                }
                user.setCreateTime(new Date());
                if (user.getValidtime() == null || "".equals(user.getValidtime())) {
                    user.setValidtime(DataUtils.getNumForDay(7));
                }
                user.setPassword(PasswordUtil.encrypt(user.getUserName(), password, PasswordUtil.getStaticSalt()));
                if (user.getTSDepart().equals("")) {
                    user.setTSDepart(null);
                }
                user.setStatus(Globals.User_Normal);
                this.systemService.save(user);
                this.message = "\u7528\u6237: " + user.getUserName() + "\u6dfb\u52a0\u6210\u529f";
                this.status = "1";
                if (StringUtil.isNotEmpty(roleid)) {
                    this.saveRoleUser(user, roleid);
                }
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
        }
        j.setMsg(this.message);
        j.setObj(this.status);
        return j;
    }

    @RequestMapping(params={"managersaveUser"})
    @ResponseBody
    public AjaxJson managersaveUser(HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String roleid = oConvertUtils.getString(req.getParameter("roleid"));
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        password = oConvertUtils.getString(password);
        TSUser users = this.systemService.findUniqueByProperty(TSUser.class, "userName", username);
        if (users != null) {
            this.message = "\u7528\u6237: " + users.getUserName() + "\u5df2\u7ecf\u5b58\u5728";
            this.status = "-1";
        } else {
            users = new TSUser();
            users.setUserName(username);
            String shopSymbol = req.getParameter("shopSymbol");
            if (shopSymbol != null && "shop".equals(shopSymbol)) {
                TSRole tsRole = this.systemService.findUniqueByProperty(TSRole.class, "roleCode", "ceshi");
                roleid = tsRole.getId();
            }
            users.setPassword(PasswordUtil.encrypt(users.getUserName(), password, PasswordUtil.getStaticSalt()));
            TSDepart sd = new TSDepart();
            sd.setId("4028d881436d514601436d5214d70015");
            users.setTSDepart(sd);
            users.setStatus(Globals.User_Normal);
            users.setType(WeiXinConstant.USER_ACCOUNT);
            users.setCreateTime(new Date());
            users.setValidtime(DataUtils.getNumForDay(7));
            this.systemService.save(users);
            this.message = "\u7528\u6237: " + users.getUserName() + "\u6dfb\u52a0\u6210\u529f";
            this.status = "1";
            if (StringUtil.isNotEmpty(roleid)) {
                this.saveRoleUser(users, roleid);
            }
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        j.setObj(this.status);
        return j;
    }

    protected void saveRoleUser(TSUser user, String roleidstr) {
        String[] roleids = roleidstr.split(",");
        int i = 0;
        while (i < roleids.length) {
            TSRoleUser rUser = new TSRoleUser();
            TSRole role = (TSRole)this.systemService.getEntity(TSRole.class, (Serializable)((Object)roleids[i]));
            rUser.setTSRole(role);
            rUser.setTSUser(user);
            this.systemService.save(rUser);
            ++i;
        }
    }

    @RequestMapping(params={"roles"})
    public ModelAndView roles(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView("system/user/users");
        String ids = oConvertUtils.getString(request.getParameter("ids"));
        mv.addObject("ids", (Object)ids);
        return mv;
    }

    @RequestMapping(params={"datagridRole"})
    public void datagridRole(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSRole.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(TSUser user, HttpServletRequest req) {
        ArrayList<TSDepart> departList = new ArrayList<TSDepart>();
        String departid = oConvertUtils.getString(req.getParameter("departid"));
        if (!StringUtil.isEmpty(departid)) {
            departList.add((TSDepart)this.systemService.getEntity(TSDepart.class, (Serializable)((Object)departid)));
        } else {
            departList.addAll(this.systemService.getList(TSDepart.class));
        }
        req.setAttribute("departList", departList);
        if (StringUtil.isNotEmpty(user.getId())) {
            user = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)user.getId()));
            req.setAttribute("user", (Object)user);
            this.idandname(req, user);
        }
        return new ModelAndView("system/user/user");
    }

    public void idandname(HttpServletRequest req, TSUser user) {
        List<TSRoleUser> roleUsers = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", user.getId());
        String roleId = "";
        String roleName = "";
        if (roleUsers.size() > 0) {
            for (TSRoleUser tRoleUser : roleUsers) {
                roleId = String.valueOf(roleId) + tRoleUser.getTSRole().getId() + ",";
                roleName = String.valueOf(roleName) + tRoleUser.getTSRole().getRoleName() + ",";
            }
        }
        req.setAttribute("id", (Object)roleId);
        req.setAttribute("roleName", (Object)roleName);
    }

    @RequestMapping(params={"choose"})
    public String choose(HttpServletRequest request) {
        List<TSRole> roles = this.systemService.loadAll(TSRole.class);
        request.setAttribute("roleList", roles);
        return "system/membership/checkuser";
    }

    @RequestMapping(params={"chooseUser"})
    public String chooseUser(HttpServletRequest request) {
        String departid = request.getParameter("departid");
        String roleid = request.getParameter("roleid");
        request.setAttribute("roleid", (Object)roleid);
        request.setAttribute("departid", (Object)departid);
        return "system/membership/userlist";
    }

    @RequestMapping(params={"datagridUser"})
    public void datagridUser(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String departid = request.getParameter("departid");
        String roleid = request.getParameter("roleid");
        CriteriaQuery cq = new CriteriaQuery(TSUser.class, dataGrid);
        if (departid.length() > 0) {
            cq.eq("TDepart.departid", oConvertUtils.getInt(departid, 0));
            cq.add();
        }
        String userid = "";
        if (roleid.length() > 0) {
            List<TSRoleUser> roleUsers = this.systemService.findByProperty(TSRoleUser.class, "TRole.roleid", oConvertUtils.getInt(roleid, 0));
            if (roleUsers.size() > 0) {
                for (TSRoleUser tRoleUser : roleUsers) {
                    userid = String.valueOf(userid) + tRoleUser.getTSUser().getId() + ",";
                }
            }
            cq.in("userid", oConvertUtils.getInts(userid.split(",")));
            cq.add();
        }
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"roleDepart"})
    public String roleDepart(HttpServletRequest request) {
        List<TSRole> roles = this.systemService.loadAll(TSRole.class);
        request.setAttribute("roleList", roles);
        return "system/membership/roledepart";
    }

    @RequestMapping(params={"chooseDepart"})
    public ModelAndView chooseDepart(HttpServletRequest request) {
        String nodeid = request.getParameter("nodeid");
        ModelAndView modelAndView = null;
        modelAndView = nodeid.equals("role") ? new ModelAndView("system/membership/users") : new ModelAndView("system/membership/departList");
        return modelAndView;
    }

    @RequestMapping(params={"datagridDepart"})
    public void datagridDepart(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSDepart.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"test"})
    public void test(HttpServletRequest request, HttpServletResponse response) {
        String jString = request.getParameter("_dt_json");
        DataTables dataTables = new DataTables(request);
        CriteriaQuery cq = new CriteriaQuery(TSUser.class, dataTables);
        String username = request.getParameter("userName");
        if (username != null) {
            cq.like("userName", username);
            cq.add();
        }
        DataTableReturn dataTableReturn = this.systemService.getDataTableReturn(cq, true);
        TagUtil.datatable(response, dataTableReturn, "id,userName,mobilePhone,TSDepart_departname");
    }

    @RequestMapping(params={"index"})
    public String index() {
        return "bootstrap/main";
    }

    @RequestMapping(params={"main"})
    public String main() {
        return "bootstrap/test";
    }

    @RequestMapping(params={"testpage"})
    public String testpage(HttpServletRequest request) {
        return "test/test";
    }

    @RequestMapping(params={"addsign"})
    public ModelAndView addsign(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("id", (Object)id);
        return new ModelAndView("system/user/usersign");
    }

    @RequestMapping(params={"savesign"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson savesign(HttpServletRequest req) {
        UploadFile uploadFile = new UploadFile(req);
        String id = uploadFile.get("id");
        TSUser user = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)id));
        uploadFile.setRealPath("signatureFile");
        uploadFile.setCusPath("signature");
        uploadFile.setByteField("signature");
        uploadFile.setBasePath("resources");
        uploadFile.setRename(false);
        uploadFile.setObject(user);
        AjaxJson j = new AjaxJson();
        this.message = String.valueOf(user.getUserName()) + "\u8bbe\u7f6e\u7b7e\u540d\u6210\u529f";
        this.systemService.uploadFile(uploadFile);
        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"testSearch"})
    public void testSearch(TSUser user, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSUser.class, dataGrid);
        if (user.getUserName() != null) {
            cq.like("userName", user.getUserName());
        }
        if (user.getRealName() != null) {
            cq.like("realName", user.getRealName());
        }
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"changestyle"})
    public String changeStyle(HttpServletRequest request) {
        Cookie[] cookies;
        TSUser user = ResourceUtil.getSessionUserName();
        if (user == null) {
            return "login/login";
        }
        String indexStyle = "shortcut";
        Cookie[] cookieArray = cookies = request.getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (cookie != null && !StringUtils.isEmpty((String)cookie.getName()) && cookie.getName().equalsIgnoreCase("JEECGINDEXSTYLE")) {
                indexStyle = cookie.getValue();
            }
            ++n2;
        }
        request.setAttribute("indexStyle", (Object)indexStyle);
        return "system/user/changestyle";
    }

    @RequestMapping(params={"savestyle"})
    @ResponseBody
    public AjaxJson saveStyle(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        j.setSuccess(Boolean.FALSE);
        TSUser user = ResourceUtil.getSessionUserName();
        if (user != null) {
            String indexStyle = request.getParameter("indexStyle");
            if (StringUtils.isNotEmpty((String)indexStyle)) {
                Cookie cookie = new Cookie("JEECGINDEXSTYLE", indexStyle);
                cookie.setMaxAge(2592000);
                response.addCookie(cookie);
                j.setSuccess(Boolean.TRUE);
                j.setMsg("\u6837\u5f0f\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
            }
            ClientManager.getInstance().getClient().getFunctions().clear();
        } else {
            j.setMsg("\u8bf7\u767b\u5f55\u540e\u518d\u64cd\u4f5c");
        }
        return j;
    }

    @RequestMapping(params={"treeMenu"})
    @ResponseBody
    public List<ComboTree> treeMenu(HttpServletRequest request, ComboTree comboTree) {
        CriteriaQuery cq = new CriteriaQuery(TSDepart.class);
        if (StringUtil.isNotEmpty(comboTree.getId())) {
            cq.eq("TSPDepart.id", comboTree.getId());
        }
        if (StringUtil.isEmpty(comboTree.getId())) {
            cq.isNull("TSPDepart.id");
        }
        cq.add();
        List menuList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "departname", "TSDeparts");
        comboTrees = this.systemService.ComboTree(menuList, comboTreeModel, null);
        return comboTrees;
    }
}

