/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.timer.DynamicTask;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSTimeTaskEntity;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.TimeTaskServiceI;
import org.quartz.CronTrigger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/timeTaskController"})
public class TimeTaskController
extends BaseController {
    @Autowired
    private TimeTaskServiceI timeTaskService;
    @Autowired
    private DynamicTask dynamicTask;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"timeTask"})
    public ModelAndView timeTask(HttpServletRequest request) {
        return new ModelAndView("system/timetask/timeTaskList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSTimeTaskEntity timeTask, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSTimeTaskEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, timeTask, request.getParameterMap());
        this.timeTaskService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(TSTimeTaskEntity timeTask, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        timeTask = (TSTimeTaskEntity)this.systemService.getEntity(TSTimeTaskEntity.class, (Serializable)((Object)timeTask.getId()));
        this.message = "\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406\u5220\u9664\u6210\u529f";
        this.timeTaskService.delete(timeTask);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(TSTimeTaskEntity timeTask, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        CronTrigger trigger = new CronTrigger();
        try {
            trigger.setCronExpression(timeTask.getCronExpression());
        }
        catch (ParseException e) {
            j.setMsg("Cron\u8868\u8fbe\u5f0f\u9519\u8bef");
            return j;
        }
        if (StringUtil.isNotEmpty(timeTask.getId())) {
            this.message = "\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406\u66f4\u65b0\u6210\u529f";
            TSTimeTaskEntity t = this.timeTaskService.get(TSTimeTaskEntity.class, (Serializable)((Object)timeTask.getId()));
            try {
                if (!timeTask.getCronExpression().equals(t.getCronExpression())) {
                    timeTask.setIsEffect("0");
                }
                MyBeanUtils.copyBeanNotNull2Bean(timeTask, t);
                this.timeTaskService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406\u6dfb\u52a0\u6210\u529f";
            this.timeTaskService.save(timeTask);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(TSTimeTaskEntity timeTask, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(timeTask.getId())) {
            timeTask = (TSTimeTaskEntity)this.timeTaskService.getEntity(TSTimeTaskEntity.class, (Serializable)((Object)timeTask.getId()));
            req.setAttribute("timeTaskPage", (Object)timeTask);
        }
        return new ModelAndView("system/timetask/timeTask");
    }

    @RequestMapping(params={"updateTime"})
    @ResponseBody
    public AjaxJson updateTime(TSTimeTaskEntity timeTask, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        boolean isUpdate = this.dynamicTask.updateCronExpression((timeTask = this.timeTaskService.get(TSTimeTaskEntity.class, (Serializable)((Object)timeTask.getId()))).getTaskId(), timeTask.getCronExpression());
        if (isUpdate) {
            timeTask.setIsEffect("1");
            timeTask.setIsStart("1");
            this.timeTaskService.updateEntitie(timeTask);
        }
        j.setMsg(isUpdate ? "\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406\u66f4\u65b0\u6210\u529f" : "\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406\u66f4\u65b0\u5931\u8d25");
        return j;
    }

    @RequestMapping(params={"startOrStopTask"})
    @ResponseBody
    public AjaxJson startOrStopTask(TSTimeTaskEntity timeTask, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        boolean isStart = timeTask.getIsStart().equals("1");
        boolean isSuccess = this.dynamicTask.startOrStop((timeTask = this.timeTaskService.get(TSTimeTaskEntity.class, (Serializable)((Object)timeTask.getId()))).getTaskId(), isStart);
        if (isSuccess) {
            timeTask.setIsStart(isStart ? "1" : "0");
            this.timeTaskService.updateEntitie(timeTask);
            this.systemService.addLog(String.valueOf(isStart ? "\u5f00\u542f\u4efb\u52a1" : "\u505c\u6b62\u4efb\u52a1") + timeTask.getTaskId(), Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        j.setMsg(isSuccess ? "\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406\u66f4\u65b0\u6210\u529f" : "\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406\u66f4\u65b0\u5931\u8d25");
        return j;
    }
}

