/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.common.model.json.ValidForm;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.SetListSort;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.manager.ClientManager;
import org.jeecgframework.web.system.manager.ClientSort;
import org.jeecgframework.web.system.pojo.base.Client;
import org.jeecgframework.web.system.pojo.base.TSDepart;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.pojo.base.TSRole;
import org.jeecgframework.web.system.pojo.base.TSRoleFunction;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.pojo.base.TSVersion;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/systemController"})
public class SystemController
extends BaseController {
    private static final Logger logger = Logger.getLogger(SystemController.class);
    private UserService userService;
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @RequestMapping(params={"druid"})
    public ModelAndView druid() {
        return new ModelAndView((View)new RedirectView("druid/index.html"));
    }

    @RequestMapping(params={"typeGroupTabs"})
    public ModelAndView typeGroupTabs(HttpServletRequest request) {
        List<TSTypegroup> typegroupList = this.systemService.loadAll(TSTypegroup.class);
        request.setAttribute("typegroupList", typegroupList);
        return new ModelAndView("system/type/typeGroupTabs");
    }

    @RequestMapping(params={"typeGroupList"})
    public ModelAndView typeGroupList(HttpServletRequest request) {
        return new ModelAndView("system/type/typeGroupList");
    }

    @RequestMapping(params={"typeList"})
    public ModelAndView typeList(HttpServletRequest request) {
        String typegroupid = request.getParameter("typegroupid");
        TSTypegroup typegroup = (TSTypegroup)this.systemService.getEntity(TSTypegroup.class, (Serializable)((Object)typegroupid));
        request.setAttribute("typegroup", (Object)typegroup);
        return new ModelAndView("system/type/typeList");
    }

    @RequestMapping(params={"typeGroupGrid"})
    public void typeGroupGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSTypegroup.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"typeGrid"})
    public void typeGrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String typegroupid = request.getParameter("typegroupid");
        String typename = request.getParameter("typename");
        CriteriaQuery cq = new CriteriaQuery(TSType.class, dataGrid);
        cq.eq("TSTypegroup.id", typegroupid);
        cq.like("typename", typename);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"typeGridTree"})
    @ResponseBody
    public List<TreeGrid> typeGridTree(HttpServletRequest request, TreeGrid treegrid) {
        ArrayList<TreeGrid> treeGrids = new ArrayList<TreeGrid>();
        if (treegrid.getId() != null) {
            CriteriaQuery cq = new CriteriaQuery(TSType.class);
            cq.eq("TSTypegroup.id", treegrid.getId().substring(1));
            cq.add();
            List typeList = this.systemService.getListByCriteriaQuery(cq, false);
            for (TSType obj : typeList) {
                TreeGrid treeNode = new TreeGrid();
                treeNode.setId("T" + obj.getId());
                treeNode.setText(obj.getTypename());
                treeNode.setCode(obj.getTypecode());
                treeGrids.add(treeNode);
            }
        } else {
            CriteriaQuery cq = new CriteriaQuery(TSTypegroup.class);
            if (StringUtil.isNotEmpty(treegrid.getCode())) {
                cq.like("typegroupcode", "%" + treegrid.getCode() + "%");
            }
            if (StringUtil.isNotEmpty(treegrid.getText())) {
                cq.like("typegroupname", "%" + treegrid.getText() + "%");
            }
            cq.add();
            List typeGroupList = this.systemService.getListByCriteriaQuery(cq, false);
            for (TSTypegroup obj : typeGroupList) {
                TreeGrid treeNode = new TreeGrid();
                treeNode.setId("G" + obj.getId());
                treeNode.setText(obj.getTypegroupname());
                treeNode.setCode(obj.getTypegroupcode());
                treeNode.setState("closed");
                treeGrids.add(treeNode);
            }
        }
        treegrid.setId(null);
        return treeGrids;
    }

    @RequestMapping(params={"delTypeGridTree"})
    @ResponseBody
    public AjaxJson delTypeGridTree(String id, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (id.startsWith("G")) {
            TSTypegroup typegroup = (TSTypegroup)this.systemService.getEntity(TSTypegroup.class, (Serializable)((Object)id.substring(1)));
            this.message = "\u6570\u636e\u5b57\u5178\u5206\u7ec4: " + typegroup.getTypegroupname() + "\u88ab\u5220\u9664 \u6210\u529f";
            this.systemService.delete(typegroup);
        } else {
            TSType type = (TSType)this.systemService.getEntity(TSType.class, (Serializable)((Object)id.substring(1)));
            this.message = "\u6570\u636e\u5b57\u5178\u7c7b\u578b: " + type.getTypename() + "\u88ab\u5220\u9664 \u6210\u529f";
            this.systemService.delete(type);
        }
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        this.systemService.refleshTypeGroupCach();
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delTypeGroup"})
    @ResponseBody
    public AjaxJson delTypeGroup(TSTypegroup typegroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        typegroup = (TSTypegroup)this.systemService.getEntity(TSTypegroup.class, (Serializable)((Object)typegroup.getId()));
        this.message = "\u7c7b\u578b\u5206\u7ec4: " + typegroup.getTypegroupname() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete(typegroup);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        this.systemService.refleshTypeGroupCach();
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delType"})
    @ResponseBody
    public AjaxJson delType(TSType type, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        type = (TSType)this.systemService.getEntity(TSType.class, (Serializable)((Object)type.getId()));
        this.message = "\u7c7b\u578b: " + type.getTypename() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete(type);
        this.systemService.refleshTypesCach(type);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"checkTypeGroup"})
    @ResponseBody
    public ValidForm checkTypeGroup(HttpServletRequest request) {
        ValidForm v = new ValidForm();
        String typegroupcode = oConvertUtils.getString(request.getParameter("param"));
        String code = oConvertUtils.getString(request.getParameter("code"));
        List<TSTypegroup> typegroups = this.systemService.findByProperty(TSTypegroup.class, "typegroupcode", typegroupcode);
        if (typegroups.size() > 0 && !code.equals(typegroupcode)) {
            v.setInfo("\u5206\u7ec4\u5df2\u5b58\u5728");
            v.setStatus("n");
        }
        return v;
    }

    @RequestMapping(params={"saveTypeGroup"})
    @ResponseBody
    public AjaxJson saveTypeGroup(TSTypegroup typegroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(typegroup.getId())) {
            this.message = "\u7c7b\u578b\u5206\u7ec4: " + typegroup.getTypegroupname() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate(typegroup);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u7c7b\u578b\u5206\u7ec4: " + typegroup.getTypegroupname() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save(typegroup);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        this.systemService.refleshTypeGroupCach();
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"checkType"})
    @ResponseBody
    public ValidForm checkType(HttpServletRequest request) {
        ValidForm v = new ValidForm();
        String typecode = oConvertUtils.getString(request.getParameter("param"));
        String code = oConvertUtils.getString(request.getParameter("code"));
        String typeGroupCode = oConvertUtils.getString(request.getParameter("typeGroupCode"));
        StringBuilder hql = new StringBuilder("FROM ").append(TSType.class.getName()).append(" AS entity WHERE 1=1 ");
        hql.append(" AND entity.TSTypegroup.typegroupcode =  '").append(typeGroupCode).append("'");
        hql.append(" AND entity.typecode =  '").append(typecode).append("'");
        List types = this.systemService.findByQueryString(hql.toString());
        if (types.size() > 0 && !code.equals(typecode)) {
            v.setInfo("\u7c7b\u578b\u5df2\u5b58\u5728");
            v.setStatus("n");
        }
        return v;
    }

    @RequestMapping(params={"saveType"})
    @ResponseBody
    public AjaxJson saveType(TSType type, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(type.getId())) {
            this.message = "\u7c7b\u578b: " + type.getTypename() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate(type);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u7c7b\u578b: " + type.getTypename() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save(type);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        this.systemService.refleshTypesCach(type);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"aouTypeGroup"})
    public ModelAndView aouTypeGroup(TSTypegroup typegroup, HttpServletRequest req) {
        if (typegroup.getId() != null) {
            typegroup = (TSTypegroup)this.systemService.getEntity(TSTypegroup.class, (Serializable)((Object)typegroup.getId()));
            req.setAttribute("typegroup", (Object)typegroup);
        }
        return new ModelAndView("system/type/typegroup");
    }

    @RequestMapping(params={"addorupdateType"})
    public ModelAndView addorupdateType(TSType type, HttpServletRequest req) {
        String typegroupid = req.getParameter("typegroupid");
        req.setAttribute("typegroupid", (Object)typegroupid);
        if (StringUtil.isNotEmpty(type.getId())) {
            type = (TSType)this.systemService.getEntity(TSType.class, (Serializable)((Object)type.getId()));
            req.setAttribute("type", (Object)type);
        }
        return new ModelAndView("system/type/type");
    }

    @RequestMapping(params={"depart"})
    public ModelAndView depart() {
        return new ModelAndView("system/depart/departList");
    }

    @RequestMapping(params={"datagridDepart"})
    public void datagridDepart(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSDepart.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"delDepart"})
    @ResponseBody
    public AjaxJson delDepart(TSDepart depart, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        depart = (TSDepart)this.systemService.getEntity(TSDepart.class, (Serializable)((Object)depart.getId()));
        this.message = "\u90e8\u95e8: " + depart.getDepartname() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete(depart);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"saveDepart"})
    @ResponseBody
    public AjaxJson saveDepart(TSDepart depart, HttpServletRequest request) {
        String pid = request.getParameter("TSPDepart.id");
        if (pid.equals("")) {
            depart.setTSPDepart(null);
        }
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(depart.getId())) {
            this.message = "\u90e8\u95e8: " + depart.getDepartname() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate(depart);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u90e8\u95e8: " + depart.getDepartname() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save(depart);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdateDepart"})
    public ModelAndView addorupdateDepart(TSDepart depart, HttpServletRequest req) {
        List departList = this.systemService.getList(TSDepart.class);
        req.setAttribute("departList", departList);
        if (depart.getId() != null) {
            depart = (TSDepart)this.systemService.getEntity(TSDepart.class, (Serializable)((Object)depart.getId()));
            req.setAttribute("depart", (Object)depart);
        }
        return new ModelAndView("system/depart/depart");
    }

    @RequestMapping(params={"setPFunction"})
    @ResponseBody
    public List<ComboTree> setPFunction(HttpServletRequest request, ComboTree comboTree) {
        CriteriaQuery cq = new CriteriaQuery(TSDepart.class);
        if (StringUtil.isNotEmpty(comboTree.getId())) {
            cq.eq("TSPDepart.id", comboTree.getId());
        }
        if (StringUtil.isEmpty(comboTree.getId())) {
            cq.isNull("TSPDepart.id");
        }
        cq.add();
        List<TSDepart> departsList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList<ComboTree> comboTrees = new ArrayList();
        comboTrees = this.systemService.comTree(departsList, comboTree);
        return comboTrees;
    }

    @RequestMapping(params={"role"})
    public ModelAndView role() {
        return new ModelAndView("system/role/roleList");
    }

    @RequestMapping(params={"datagridRole"})
    public void datagridRole(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSRole.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"delRole"})
    @ResponseBody
    public AjaxJson delRole(TSRole role, String ids, HttpServletRequest request) {
        this.message = "\u89d2\u8272: " + role.getRoleName() + "\u88ab\u5220\u9664\u6210\u529f";
        AjaxJson j = new AjaxJson();
        role = (TSRole)this.systemService.getEntity(TSRole.class, (Serializable)((Object)role.getId()));
        this.userService.delete(role);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"saveRole"})
    @ResponseBody
    public AjaxJson saveRole(TSRole role, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (role.getId() != null) {
            this.message = "\u89d2\u8272: " + role.getRoleName() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate(role);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u89d2\u8272: " + role.getRoleName() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.saveOrUpdate(role);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"fun"})
    public ModelAndView fun(HttpServletRequest request) {
        Integer roleid = oConvertUtils.getInt(request.getParameter("roleid"), 0);
        request.setAttribute("roleid", (Object)roleid);
        return new ModelAndView("system/role/roleList");
    }

    @RequestMapping(params={"setAuthority"})
    @ResponseBody
    public List<ComboTree> setAuthority(TSRole role, HttpServletRequest request, ComboTree comboTree) {
        List<TSRoleFunction> roleFunctionList;
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        if (comboTree.getId() != null) {
            cq.eq("TFunction.functionid", oConvertUtils.getInt(comboTree.getId(), 0));
        }
        if (comboTree.getId() == null) {
            cq.isNull("TFunction");
        }
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList<ComboTree> comboTrees = new ArrayList();
        Integer roleid = oConvertUtils.getInt(request.getParameter("roleid"), 0);
        ArrayList<TSFunction> loginActionlist = new ArrayList<TSFunction>();
        role = this.systemService.get(TSRole.class, roleid);
        if (role != null && (roleFunctionList = this.systemService.findByProperty(TSRoleFunction.class, "TSRole.id", role.getId())).size() > 0) {
            for (TSRoleFunction roleFunction : roleFunctionList) {
                TSFunction function = roleFunction.getTSFunction();
                loginActionlist.add(function);
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "TSFunctions");
        comboTrees = this.systemService.ComboTree(functionList, comboTreeModel, loginActionlist);
        return comboTrees;
    }

    @RequestMapping(params={"updateAuthority"})
    public String updateAuthority(HttpServletRequest request) {
        Integer roleid = oConvertUtils.getInt(request.getParameter("roleid"), 0);
        String rolefunction = request.getParameter("rolefunctions");
        TSRole role = this.systemService.get(TSRole.class, roleid);
        List<TSRoleFunction> roleFunctionList = this.systemService.findByProperty(TSRoleFunction.class, "TSRole.id", role.getId());
        this.systemService.deleteAllEntitie(roleFunctionList);
        String[] roleFunctions = null;
        if (rolefunction != "") {
            String[] stringArray = roleFunctions = rolefunction.split(",");
            int n = roleFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                TSRoleFunction rf = new TSRoleFunction();
                TSFunction f = this.systemService.get(TSFunction.class, Integer.valueOf(s));
                rf.setTSFunction(f);
                rf.setTSRole(role);
                this.systemService.save(rf);
                ++n2;
            }
        }
        return "system/role/roleList";
    }

    @RequestMapping(params={"addorupdateRole"})
    public ModelAndView addorupdateRole(TSRole role, HttpServletRequest req) {
        if (role.getId() != null) {
            role = (TSRole)this.systemService.getEntity(TSRole.class, (Serializable)((Object)role.getId()));
            req.setAttribute("role", (Object)role);
        }
        return new ModelAndView("system/role/role");
    }

    @RequestMapping(params={"operate"})
    public ModelAndView operate(HttpServletRequest request) {
        String roleid = request.getParameter("roleid");
        request.setAttribute("roleid", (Object)roleid);
        return new ModelAndView("system/role/functionList");
    }

    @RequestMapping(params={"setOperate"})
    @ResponseBody
    public List<TreeGrid> setOperate(HttpServletRequest request, TreeGrid treegrid) {
        String roleid = request.getParameter("roleid");
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        if (treegrid.getId() != null) {
            cq.eq("TFunction.functionid", oConvertUtils.getInt(treegrid.getId(), 0));
        }
        if (treegrid.getId() == null) {
            cq.isNull("TFunction");
        }
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        Collections.sort(functionList, new SetListSort());
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setRoleid(roleid);
        treeGrids = this.systemService.treegrid(functionList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"saveOperate"})
    @ResponseBody
    public AjaxJson saveOperate(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String fop = request.getParameter("fp");
        String roleid = request.getParameter("roleid");
        this.clearp(roleid);
        String[] fun_op = fop.split(",");
        String aa = "";
        String bb = "";
        if (fun_op.length == 1) {
            bb = fun_op[0].split("_")[1];
            aa = fun_op[0].split("_")[0];
            this.savep(roleid, bb, aa);
        } else {
            int i = 0;
            while (i < fun_op.length) {
                String cc = fun_op[i].split("_")[0];
                if (i > 0 && bb.equals(fun_op[i].split("_")[1])) {
                    aa = String.valueOf(aa) + "," + cc;
                    if (i == fun_op.length - 1) {
                        this.savep(roleid, bb, aa);
                    }
                } else if (i > 0) {
                    this.savep(roleid, bb, aa);
                    aa = fun_op[i].split("_")[0];
                    if (i == fun_op.length - 1) {
                        bb = fun_op[i].split("_")[1];
                        this.savep(roleid, bb, aa);
                    }
                } else {
                    aa = fun_op[i].split("_")[0];
                }
                bb = fun_op[i].split("_")[1];
                ++i;
            }
        }
        return j;
    }

    public void savep(String roleid, String functionid, String ids) {
        String hql = "from TRoleFunction t where t.TSRole.id=" + roleid + " " + "and t.TFunction.functionid=" + functionid;
        TSRoleFunction rFunction = (TSRoleFunction)this.systemService.singleResult(hql);
        if (rFunction != null) {
            rFunction.setOperation(ids);
            this.systemService.saveOrUpdate(rFunction);
        }
    }

    public void clearp(String roleid) {
        String hql = "from TRoleFunction t where t.TSRole.id=" + roleid;
        List rFunctions = this.systemService.findByQueryString(hql);
        if (rFunctions.size() > 0) {
            for (TSRoleFunction tRoleFunction : rFunctions) {
                tRoleFunction.setOperation(null);
                this.systemService.saveOrUpdate(tRoleFunction);
            }
        }
    }

    @RequestMapping(params={"versionList"})
    public void versionList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSVersion.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"delVersion"})
    @ResponseBody
    public AjaxJson delVersion(TSVersion version, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        version = (TSVersion)this.systemService.getEntity(TSVersion.class, (Serializable)((Object)version.getId()));
        this.message = "\u7248\u672c\uff1a" + version.getVersionName() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete(version);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"addversion"})
    public ModelAndView addversion(HttpServletRequest req) {
        return new ModelAndView("system/version/version");
    }

    @RequestMapping(params={"saveVersion"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveVersion(HttpServletRequest request) throws Exception {
        AjaxJson j = new AjaxJson();
        TSVersion version = new TSVersion();
        String versionName = request.getParameter("versionName");
        String versionCode = request.getParameter("versionCode");
        version.setVersionCode(versionCode);
        version.setVersionName(versionName);
        this.systemService.save(version);
        j.setMsg("\u7248\u672c\u4fdd\u5b58\u6210\u529f");
        return j;
    }

    @RequestMapping(params={"documentList"})
    public void documentList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSDocument.class, dataGrid);
        String typecode = oConvertUtils.getString(request.getParameter("typecode"));
        cq.createAlias("TSType", "TSType");
        cq.eq("TSType.typecode", typecode);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"delDocument"})
    @ResponseBody
    public AjaxJson delDocument(TSDocument document, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)document.getId()));
        this.message = document.getDocumentTitle() + "\u88ab\u5220\u9664\u6210\u529f";
        this.userService.delete(document);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setSuccess(true);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addFiles"})
    public ModelAndView addFiles(HttpServletRequest req) {
        return new ModelAndView("system/document/files");
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, TSDocument document) {
        AjaxJson j = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString(request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString(request.getParameter("documentTitle"));
        if (StringUtil.isNotEmpty(fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath(document));
        document.setCreatedate(DataUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile(request, document);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"datagridOnline"})
    public void datagridOnline(Client tSOnline, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        Collection<Client> news = ClientManager.getInstance().getAllClient();
        ArrayList<Client> onlines = new ArrayList<Client>();
        HashMap<String, Client> mp = new HashMap<String, Client>();
        for (Client c : news) {
            if ("1".equals(c.getUser().getType()) || mp.containsKey(c.getIp())) continue;
            mp.put(c.getIp(), c);
            onlines.add(c);
        }
        mp.clear();
        dataGrid.setTotal(onlines.size());
        dataGrid.setResults(this.getClinetList(onlines, dataGrid));
        TagUtil.datagrid(response, dataGrid);
    }

    private List<Client> getClinetList(List<Client> onlines, DataGrid dataGrid) {
        Collections.sort(onlines, new ClientSort());
        ArrayList<Client> result = new ArrayList<Client>();
        int i = (dataGrid.getPage() - 1) * dataGrid.getRows();
        while (i < onlines.size() && i < dataGrid.getPage() * dataGrid.getRows()) {
            result.add(onlines.get(i));
            ++i;
        }
        return result;
    }

    @RequestMapping(params={"commonUpload"})
    public ModelAndView commonUpload(HttpServletRequest req) {
        return new ModelAndView("common/upload/uploadView");
    }
}

