/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.common.model.json.ValidForm;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.NumberComparator;
import org.jeecgframework.core.util.SetListSort;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.pojo.base.TSOperation;
import org.jeecgframework.web.system.pojo.base.TSRole;
import org.jeecgframework.web.system.pojo.base.TSRoleFunction;
import org.jeecgframework.web.system.pojo.base.TSRoleUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/roleController"})
public class RoleController
extends BaseController {
    private static final Logger logger = Logger.getLogger(RoleController.class);
    private UserService userService;
    private SystemService systemService;
    private String message = null;

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @RequestMapping(params={"role"})
    public ModelAndView role() {
        return new ModelAndView("system/role/roleList");
    }

    @RequestMapping(params={"roleGrid"})
    public void roleGrid(TSRole role, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSRole.class, dataGrid);
        HqlGenerateUtil.installHql(cq, role);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"delRole"})
    @ResponseBody
    public AjaxJson delRole(TSRole role, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        int count = this.userService.getUsersOfThisRole(role.getId());
        if (count == 0) {
            this.delRoleFunction(role);
            role = (TSRole)this.systemService.getEntity(TSRole.class, (Serializable)((Object)role.getId()));
            this.userService.delete(role);
            this.message = "\u89d2\u8272: " + role.getRoleName() + "\u88ab\u5220\u9664\u6210\u529f";
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u89d2\u8272: \u4ecd\u88ab\u7528\u6237\u4f7f\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5173\u8054\u5173\u7cfb";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"checkRole"})
    @ResponseBody
    public ValidForm checkRole(TSRole role, HttpServletRequest request, HttpServletResponse response) {
        ValidForm v = new ValidForm();
        String roleCode = oConvertUtils.getString(request.getParameter("param"));
        String code = oConvertUtils.getString(request.getParameter("code"));
        List<TSRole> roles = this.systemService.findByProperty(TSRole.class, "roleCode", roleCode);
        if (roles.size() > 0 && !code.equals(roleCode)) {
            v.setInfo("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
            v.setStatus("n");
        }
        return v;
    }

    protected void delRoleFunction(TSRole role) {
        List<TSRoleFunction> roleFunctions = this.systemService.findByProperty(TSRoleFunction.class, "TSRole.id", role.getId());
        if (roleFunctions.size() > 0) {
            for (TSRoleFunction tsRoleFunction : roleFunctions) {
                this.systemService.delete(tsRoleFunction);
            }
        }
        List<TSRoleUser> roleUsers = this.systemService.findByProperty(TSRoleUser.class, "TSRole.id", role.getId());
        for (TSRoleUser tsRoleUser : roleUsers) {
            this.systemService.delete(tsRoleUser);
        }
    }

    @RequestMapping(params={"saveRole"})
    @ResponseBody
    public AjaxJson saveRole(TSRole role, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(role.getId())) {
            this.message = "\u89d2\u8272: " + role.getRoleName() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate(role);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u89d2\u8272: " + role.getRoleName() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save(role);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"fun"})
    public ModelAndView fun(HttpServletRequest request) {
        String roleId = request.getParameter("roleId");
        request.setAttribute("roleId", (Object)roleId);
        return new ModelAndView("system/role/roleSet");
    }

    @RequestMapping(params={"setAuthority"})
    @ResponseBody
    public List<ComboTree> setAuthority(TSRole role, HttpServletRequest request, ComboTree comboTree) {
        List<TSRoleFunction> roleFunctionList;
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        if (comboTree.getId() != null) {
            cq.eq("TSFunction.id", comboTree.getId());
        }
        if (comboTree.getId() == null) {
            cq.isNull("TSFunction");
        }
        cq.notEq("functionLevel", Short.parseShort("-1"));
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, false);
        Collections.sort(functionList, new NumberComparator());
        ArrayList<ComboTree> comboTrees = new ArrayList();
        String roleId = request.getParameter("roleId");
        ArrayList<TSFunction> loginActionlist = new ArrayList<TSFunction>();
        role = this.systemService.get(TSRole.class, (Serializable)((Object)roleId));
        if (role != null && (roleFunctionList = this.systemService.findByProperty(TSRoleFunction.class, "TSRole.id", role.getId())).size() > 0) {
            for (TSRoleFunction roleFunction : roleFunctionList) {
                TSFunction function = roleFunction.getTSFunction();
                loginActionlist.add(function);
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "TSFunctions");
        comboTrees = this.systemService.ComboTree(functionList, comboTreeModel, loginActionlist);
        return comboTrees;
    }

    @RequestMapping(params={"updateAuthority"})
    @ResponseBody
    public AjaxJson updateAuthority(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String roleId = request.getParameter("roleId");
            String rolefunction = request.getParameter("rolefunctions");
            TSRole role = this.systemService.get(TSRole.class, (Serializable)((Object)roleId));
            List<TSRoleFunction> roleFunctionList = this.systemService.findByProperty(TSRoleFunction.class, "TSRole.id", role.getId());
            HashMap<String, TSRoleFunction> map = new HashMap<String, TSRoleFunction>();
            for (TSRoleFunction functionOfRole : roleFunctionList) {
                map.put(functionOfRole.getTSFunction().getId(), functionOfRole);
            }
            String[] roleFunctions = rolefunction.split(",");
            HashSet<String> set = new HashSet<String>();
            String[] stringArray = roleFunctions;
            int n = roleFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                set.add(s);
                ++n2;
            }
            this.updateCompare(set, role, map);
            j.setMsg("\u6743\u9650\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getExceptionMessage(e));
            j.setMsg("\u6743\u9650\u66f4\u65b0\u5931\u8d25");
        }
        return j;
    }

    private void updateCompare(Set<String> set, TSRole role, Map<String, TSRoleFunction> map) {
        ArrayList<TSRoleFunction> entitys = new ArrayList<TSRoleFunction>();
        ArrayList<TSRoleFunction> deleteEntitys = new ArrayList<TSRoleFunction>();
        for (String s : set) {
            if (map.containsKey(s)) {
                map.remove(s);
                continue;
            }
            TSRoleFunction rf = new TSRoleFunction();
            TSFunction f = this.systemService.get(TSFunction.class, (Serializable)((Object)s));
            rf.setTSFunction(f);
            rf.setTSRole(role);
            entitys.add(rf);
        }
        Collection<TSRoleFunction> collection = map.values();
        Iterator<TSRoleFunction> it = collection.iterator();
        while (it.hasNext()) {
            deleteEntitys.add(it.next());
        }
        this.systemService.batchSave(entitys);
        this.systemService.deleteAllEntitie(deleteEntitys);
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(TSRole role, HttpServletRequest req) {
        if (role.getId() != null) {
            role = (TSRole)this.systemService.getEntity(TSRole.class, (Serializable)((Object)role.getId()));
            req.setAttribute("role", (Object)role);
        }
        return new ModelAndView("system/role/role");
    }

    @RequestMapping(params={"setOperate"})
    @ResponseBody
    public List<TreeGrid> setOperate(HttpServletRequest request, TreeGrid treegrid) {
        String roleId = request.getParameter("roleId");
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        if (treegrid.getId() != null) {
            cq.eq("TSFunction.id", treegrid.getId());
        }
        if (treegrid.getId() == null) {
            cq.isNull("TSFunction");
        }
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        Collections.sort(functionList, new SetListSort());
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setRoleid(roleId);
        treeGrids = this.systemService.treegrid(functionList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"saveOperate"})
    @ResponseBody
    public AjaxJson saveOperate(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String fop = request.getParameter("fp");
        String roleId = request.getParameter("roleId");
        this.clearp(roleId);
        String[] fun_op = fop.split(",");
        String aa = "";
        String bb = "";
        if (fun_op.length == 1) {
            bb = fun_op[0].split("_")[1];
            aa = fun_op[0].split("_")[0];
            this.savep(roleId, bb, aa);
        } else {
            int i = 0;
            while (i < fun_op.length) {
                String cc = fun_op[i].split("_")[0];
                if (i > 0 && bb.equals(fun_op[i].split("_")[1])) {
                    aa = String.valueOf(aa) + "," + cc;
                    if (i == fun_op.length - 1) {
                        this.savep(roleId, bb, aa);
                    }
                } else if (i > 0) {
                    this.savep(roleId, bb, aa);
                    aa = fun_op[i].split("_")[0];
                    if (i == fun_op.length - 1) {
                        bb = fun_op[i].split("_")[1];
                        this.savep(roleId, bb, aa);
                    }
                } else {
                    aa = fun_op[i].split("_")[0];
                }
                bb = fun_op[i].split("_")[1];
                ++i;
            }
        }
        return j;
    }

    public void savep(String roleId, String functionid, String ids) {
        CriteriaQuery cq = new CriteriaQuery(TSRoleFunction.class);
        cq.eq("TSRole.id", roleId);
        cq.eq("TSFunction.id", functionid);
        cq.add();
        List rFunctions = this.systemService.getListByCriteriaQuery(cq, false);
        if (rFunctions.size() > 0) {
            TSRoleFunction roleFunction = (TSRoleFunction)rFunctions.get(0);
            roleFunction.setOperation(ids);
            this.systemService.saveOrUpdate(roleFunction);
        }
    }

    public void clearp(String roleId) {
        List<TSRoleFunction> rFunctions = this.systemService.findByProperty(TSRoleFunction.class, "TSRole.id", roleId);
        if (rFunctions.size() > 0) {
            for (TSRoleFunction tRoleFunction : rFunctions) {
                tRoleFunction.setOperation(null);
                this.systemService.saveOrUpdate(tRoleFunction);
            }
        }
    }

    @RequestMapping(params={"operationListForFunction"})
    public ModelAndView operationListForFunction(HttpServletRequest request, String functionId, String roleId) {
        CriteriaQuery cq = new CriteriaQuery(TSOperation.class);
        cq.eq("TSFunction.id", functionId);
        cq.add();
        List operationList = this.systemService.getListByCriteriaQuery(cq, false);
        Set<String> operationCodes = this.systemService.getOperationCodesByRoleIdAndFunctionId(roleId, functionId);
        request.setAttribute("operationList", operationList);
        request.setAttribute("operationcodes", operationCodes);
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("system/role/operationListForFunction");
    }

    @RequestMapping(params={"updateOperation"})
    @ResponseBody
    public AjaxJson updateOperation(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String roleId = request.getParameter("roleId");
        String functionId = request.getParameter("functionId");
        String operationcodes = null;
        try {
            operationcodes = URLDecoder.decode(request.getParameter("operationcodes"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        CriteriaQuery cq1 = new CriteriaQuery(TSRoleFunction.class);
        cq1.eq("TSRole.id", roleId);
        cq1.eq("TSFunction.id", functionId);
        cq1.add();
        List rFunctions = this.systemService.getListByCriteriaQuery(cq1, false);
        if (rFunctions != null && rFunctions.size() > 0) {
            TSRoleFunction tsRoleFunction = (TSRoleFunction)rFunctions.get(0);
            tsRoleFunction.setOperation(operationcodes);
            this.systemService.saveOrUpdate(tsRoleFunction);
        }
        j.setMsg("\u6309\u94ae\u6743\u9650\u66f4\u65b0\u6210\u529f");
        return j;
    }
}

