/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSNotice;
import org.jeecgframework.web.system.pojo.base.TSNoticeReadUser;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.NoticeService;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/noticeController"})
public class NoticeController
extends BaseController {
    private SystemService systemService;
    @Autowired
    private NoticeService noticeService;
    private String message;

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"getNoticeList"})
    @ResponseBody
    public AjaxJson getNoticeList(HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        TSUser user = ResourceUtil.getSessionUserName();
        String sql = "";
        sql = String.valueOf(sql) + " SELECT * FROM  t_s_notice t WHERE";
        sql = String.valueOf(sql) + " (t.notice_level = '1' ";
        sql = String.valueOf(sql) + " OR (t.notice_level = '2' AND EXISTS (SELECT 1 FROM t_s_notice_authority_role r,t_s_role_user ru WHERE r.role_id = ru.roleid AND t.id = r.notice_id AND ru.userid = '" + user.getId() + "'))";
        sql = String.valueOf(sql) + " OR (t.notice_level = '3' AND EXISTS (SELECT 1 FROM t_s_notice_authority_user u WHERE t.id = u.notice_id AND u.user_id = '" + user.getId() + "'))";
        sql = String.valueOf(sql) + " ) AND NOT EXISTS (SELECT 1 FROM t_s_notice_read_user rd WHERE t.id = rd.notice_id AND rd.user_id = '" + user.getId() + "')";
        sql = String.valueOf(sql) + " ORDER BY t.create_time DESC LIMIT 10";
        List<Map<String, Object>> noticeList = this.systemService.findForJdbc(sql, new Object[0]);
        JSONArray result = new JSONArray();
        if (noticeList != null && noticeList.size() > 0) {
            int i = 0;
            while (i < noticeList.size()) {
                JSONObject jsonParts = new JSONObject();
                jsonParts.put((Object)"id", noticeList.get(i).get("id"));
                jsonParts.put((Object)"noticeTitle", noticeList.get(i).get("notice_title"));
                result.add((Object)jsonParts);
                ++i;
            }
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("noticeList", result);
        j.setAttributes(attrs);
        if (result.size() == 0) {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(params={"noticeList"})
    public ModelAndView noticeList(HttpServletRequest request) {
        return new ModelAndView("system/user/noticeList");
    }

    @RequestMapping(params={"goNotice"})
    public ModelAndView noticeInfo(TSNotice notice, HttpServletRequest request) {
        if (StringUtil.isNotEmpty(notice.getId())) {
            notice = (TSNotice)this.systemService.getEntity(TSNotice.class, (Serializable)((Object)notice.getId()));
            request.setAttribute("notice", (Object)notice);
        }
        return new ModelAndView("system/user/noticeinfo");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSNotice notice, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        try {
            TSUser user = ResourceUtil.getSessionUserName();
            String sql = "";
            sql = String.valueOf(sql) + " SELECT * FROM  t_s_notice t WHERE";
            sql = String.valueOf(sql) + " t.notice_level = '1' ";
            sql = String.valueOf(sql) + " OR (t.notice_level = '2' AND EXISTS (SELECT 1 FROM t_s_notice_authority_role r,t_s_role_user ru WHERE r.role_id = ru.roleid AND t.id = r.notice_id AND ru.userid = '" + user.getId() + "'))";
            sql = String.valueOf(sql) + " OR (t.notice_level = '3' AND EXISTS (SELECT 1 FROM t_s_notice_authority_user u WHERE t.id = u.notice_id AND u.user_id = '" + user.getId() + "'))";
            sql = String.valueOf(sql) + " ORDER BY t.create_time DESC";
            List<Map<String, Object>> resultList = this.systemService.findForJdbc(sql, dataGrid.getPage(), dataGrid.getRows());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            ArrayList<TSNotice> noticeList = new ArrayList<TSNotice>();
            if (resultList != null && resultList.size() > 0) {
                int i = 0;
                while (i < resultList.size()) {
                    List<Map<String, Object>> readinfo;
                    Map<String, Object> obj = resultList.get(i);
                    TSNotice n = new TSNotice();
                    n.setId(String.valueOf(obj.get("id")));
                    n.setNoticeTitle(String.valueOf(obj.get("notice_title")));
                    n.setNoticeContent(String.valueOf(obj.get("notice_content")));
                    if (obj.get("create_time") != null) {
                        n.setCreateTime(format.parse(obj.get("create_time").toString()));
                    }
                    if ((readinfo = this.systemService.findForJdbc("select * from t_s_notice_read_user where notice_id = ? and user_id = ? ", n.getId(), user.getId())) != null && readinfo.size() > 0) {
                        n.setIsRead("1");
                    } else {
                        n.setIsRead("0");
                    }
                    noticeList.add(n);
                    ++i;
                }
            }
            dataGrid.setResults(noticeList);
            String sql2 = "";
            sql2 = String.valueOf(sql2) + " SELECT count(*) AS count FROM  t_s_notice t WHERE";
            sql2 = String.valueOf(sql2) + " t.notice_level = '1' ";
            sql2 = String.valueOf(sql2) + " OR (t.notice_level = '2' AND EXISTS (SELECT 1 FROM t_s_notice_authority_role r,t_s_role_user ru WHERE r.role_id = ru.roleid AND t.id = r.notice_id AND ru.userid = '" + user.getId() + "'))";
            sql2 = String.valueOf(sql2) + " OR (t.notice_level = '3' AND EXISTS (SELECT 1 FROM t_s_notice_authority_user u WHERE t.id = u.notice_id AND u.user_id = '" + user.getId() + "'))";
            List<Map<String, Object>> resultList2 = this.systemService.findForJdbc(sql2, new Object[0]);
            Object count = resultList2.get(0).get("count");
            long cn = (Long)count;
            dataGrid.setTotal((int)cn);
            TagUtil.datagrid(response, dataGrid);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"updateNoticeRead"})
    @ResponseBody
    public AjaxJson updateNoticeRead(String noticeId, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        try {
            TSUser user = ResourceUtil.getSessionUserName();
            TSNoticeReadUser readUser = new TSNoticeReadUser();
            readUser.setNoticeId(noticeId);
            readUser.setUserId(user.getId());
            readUser.setCreateTime(new Date());
            this.systemService.saveOrUpdate(readUser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"tSNotice"})
    public ModelAndView tSNotice(HttpServletRequest request) {
        return new ModelAndView("system/user/tSNoticeList");
    }

    @RequestMapping(params={"datagrid2"})
    public void datagrid2(TSNotice tSNotice, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSNotice.class, dataGrid);
        HqlGenerateUtil.installHql(cq, tSNotice, request.getParameterMap());
        cq.add();
        this.noticeService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(TSNotice tSNotice, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        tSNotice = (TSNotice)this.systemService.getEntity(TSNotice.class, (Serializable)((Object)tSNotice.getId()));
        this.message = "\u901a\u77e5\u516c\u544a\u5220\u9664\u6210\u529f";
        try {
            this.noticeService.delete(tSNotice);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u901a\u77e5\u516c\u544a\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TSNotice tSNotice = (TSNotice)this.systemService.getEntity(TSNotice.class, (Serializable)((Object)id));
                this.noticeService.delete(tSNotice);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(TSNotice tSNotice, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u901a\u77e5\u516c\u544a\u6dfb\u52a0\u6210\u529f";
        try {
            this.noticeService.save(tSNotice);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(TSNotice tSNotice, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u901a\u77e5\u516c\u544a\u66f4\u65b0\u6210\u529f";
        TSNotice t = this.noticeService.get(TSNotice.class, (Serializable)((Object)tSNotice.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean(tSNotice, t);
            this.noticeService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(TSNotice tSNotice, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(tSNotice.getId())) {
            tSNotice = (TSNotice)this.noticeService.getEntity(TSNotice.class, (Serializable)((Object)tSNotice.getId()));
            req.setAttribute("tSNoticePage", (Object)tSNotice);
        }
        return new ModelAndView("system/user/tSNotice-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(TSNotice tSNotice, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(tSNotice.getId())) {
            if ((tSNotice = (TSNotice)this.noticeService.getEntity(TSNotice.class, (Serializable)((Object)tSNotice.getId()))).getNoticeTerm() == null) {
                tSNotice.setNoticeTerm(new Date());
            }
            req.setAttribute("tSNoticePage", (Object)tSNotice);
        }
        return new ModelAndView("system/user/tSNotice-update");
    }
}

