/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSNoticeAuthorityUser;
import org.jeecgframework.web.system.service.NoticeAuthorityUserServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/noticeAuthorityUserController"})
public class NoticeAuthorityUserController
extends BaseController {
    private static final Logger logger = Logger.getLogger(NoticeAuthorityUserController.class);
    @Autowired
    private NoticeAuthorityUserServiceI noticeAuthorityUserService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"noticeAuthorityUser"})
    public ModelAndView noticeAuthorityUser(String noticeId, HttpServletRequest request) {
        request.setAttribute("noticeId", (Object)noticeId);
        return new ModelAndView("system/user/noticeAuthorityUserList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSNoticeAuthorityUser.class, dataGrid);
        HqlGenerateUtil.installHql(cq, noticeAuthorityUser, request.getParameterMap());
        cq.add();
        this.noticeAuthorityUserService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        noticeAuthorityUser = (TSNoticeAuthorityUser)this.systemService.getEntity(TSNoticeAuthorityUser.class, (Serializable)((Object)noticeAuthorityUser.getId()));
        this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u5220\u9664\u6210\u529f";
        try {
            this.noticeAuthorityUserService.delete(noticeAuthorityUser);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TSNoticeAuthorityUser noticeAuthorityUser = (TSNoticeAuthorityUser)this.systemService.getEntity(TSNoticeAuthorityUser.class, (Serializable)((Object)id));
                this.noticeAuthorityUserService.delete(noticeAuthorityUser);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u6dfb\u52a0\u6210\u529f";
        try {
            this.noticeAuthorityUserService.save(noticeAuthorityUser);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doSave"})
    @ResponseBody
    public AjaxJson doSave(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u4fdd\u5b58\u6210\u529f";
        try {
            if (this.noticeAuthorityUserService.checkAuthorityUser(noticeAuthorityUser.getNoticeId(), noticeAuthorityUser.getUser().getId())) {
                this.message = "\u8be5\u7528\u6237\u5df2\u6388\u6743\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002";
            } else {
                this.noticeAuthorityUserService.save(noticeAuthorityUser);
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u4fdd\u5b58\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u66f4\u65b0\u6210\u529f";
        TSNoticeAuthorityUser t = this.noticeAuthorityUserService.get(TSNoticeAuthorityUser.class, (Serializable)((Object)noticeAuthorityUser.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean(noticeAuthorityUser, t);
            this.noticeAuthorityUserService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(noticeAuthorityUser.getId())) {
            noticeAuthorityUser = (TSNoticeAuthorityUser)this.noticeAuthorityUserService.getEntity(TSNoticeAuthorityUser.class, (Serializable)((Object)noticeAuthorityUser.getId()));
            req.setAttribute("noticeAuthorityUserPage", (Object)noticeAuthorityUser);
        }
        return new ModelAndView("system/user/noticeAuthorityUser-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(noticeAuthorityUser.getId())) {
            noticeAuthorityUser = (TSNoticeAuthorityUser)this.noticeAuthorityUserService.getEntity(TSNoticeAuthorityUser.class, (Serializable)((Object)noticeAuthorityUser.getId()));
            req.setAttribute("noticeAuthorityUserPage", (Object)noticeAuthorityUser);
        }
        return new ModelAndView("system/user/noticeAuthorityUser-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("system/user/noticeAuthorityUserUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743";
                if (BrowserUtils.isIE(request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(TSNoticeAuthorityUser.class, dataGrid);
                HqlGenerateUtil.installHql(cq, noticeAuthorityUser, request.getParameterMap());
                List noticeAuthorityUsers = this.noticeAuthorityUserService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel(new ExcelTitle("\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), TSNoticeAuthorityUser.class, noticeAuthorityUsers);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(TSNoticeAuthorityUser noticeAuthorityUser, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743";
                if (BrowserUtils.isIE(request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel(new ExcelTitle("\u901a\u77e5\u516c\u544a\u7528\u6237\u6388\u6743\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), TSNoticeAuthorityUser.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listTSNoticeAuthorityUsers = (List)ExcelImportUtil.importExcelByIs(file.getInputStream(), TSNoticeAuthorityUser.class, params);
                    for (TSNoticeAuthorityUser noticeAuthorityUser : listTSNoticeAuthorityUsers) {
                        this.noticeAuthorityUserService.save(noticeAuthorityUser);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage(e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"selectUser"})
    public ModelAndView selectUser(HttpServletRequest request) {
        return new ModelAndView("system/user/userList-select");
    }
}

