/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MutiLangUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.MutiLangEntity;
import org.jeecgframework.web.system.service.MutiLangServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/mutiLangController"})
public class MutiLangController
extends BaseController {
    private static final Logger logger = Logger.getLogger(MutiLangController.class);
    @Autowired
    private MutiLangServiceI mutiLangService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"mutiLang"})
    public ModelAndView mutiLang(HttpServletRequest request) {
        return new ModelAndView("system/mutilang/mutiLangList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(MutiLangEntity mutiLang, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(MutiLangEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, mutiLang, request.getParameterMap());
        this.mutiLangService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(MutiLangEntity mutiLang, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        mutiLang = (MutiLangEntity)this.systemService.getEntity(MutiLangEntity.class, (Serializable)((Object)mutiLang.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.mutiLangService.delete(mutiLang);
        this.mutiLangService.initAllMutiLang();
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(MutiLangEntity mutiLang, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(mutiLang.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            MutiLangEntity t = this.mutiLangService.get(MutiLangEntity.class, (Serializable)((Object)mutiLang.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean(mutiLang, t);
                this.mutiLangService.saveOrUpdate(t);
                this.mutiLangService.initAllMutiLang();
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u4fdd\u5b58\u5931\u8d25";
            }
        } else {
            if (MutiLangUtil.existLangContext(mutiLang.getLangContext())) {
                this.message = "\u5185\u5bb9\u5df2\u5b58\u5728";
            }
            if (StringUtil.isEmpty(this.message)) {
                this.mutiLangService.save(mutiLang);
                this.message = "\u4fdd\u5b58\u6210\u529f";
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(MutiLangEntity mutiLang, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(mutiLang.getId())) {
            mutiLang = (MutiLangEntity)this.mutiLangService.getEntity(MutiLangEntity.class, (Serializable)((Object)mutiLang.getId()));
            req.setAttribute("mutiLangPage", (Object)mutiLang);
        }
        return new ModelAndView("system/mutilang/mutiLang");
    }

    @RequestMapping(params={"refreshCach"})
    @ResponseBody
    public AjaxJson refreshCach(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            this.mutiLangService.refleshMutiLangCach();
            this.message = "\u5237\u65b0\u6210\u529f";
        }
        catch (Exception e) {
            this.message = "\u5237\u65b0\u5931\u8d25";
        }
        j.setMsg(this.message);
        return j;
    }
}

