/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.Highchart;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSLog;
import org.jeecgframework.web.system.service.LogService;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/logController"})
public class LogController
extends BaseController {
    private static final Logger logger = Logger.getLogger(LogController.class);
    private SystemService systemService;
    @Autowired
    private LogService logService;

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"log"})
    public ModelAndView log() {
        return new ModelAndView("system/log/logList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String operatetime_end;
        String operatetime_begin;
        CriteriaQuery cq = new CriteriaQuery(TSLog.class, dataGrid);
        String loglevel = request.getParameter("loglevel");
        if (loglevel != null && !loglevel.equals("0")) {
            cq.eq("loglevel", oConvertUtils.getShort(loglevel));
            cq.add();
        }
        if ((operatetime_begin = request.getParameter("operatetime_begin")) != null) {
            Timestamp beginValue = null;
            try {
                beginValue = DataUtils.parseTimestamp(operatetime_begin, "yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            cq.ge("operatetime", beginValue);
        }
        if ((operatetime_end = request.getParameter("operatetime_end")) != null) {
            if (operatetime_end.length() == 10) {
                operatetime_end = String.valueOf(operatetime_end) + " 23:59:59";
            }
            Timestamp endValue = null;
            try {
                endValue = DataUtils.parseTimestamp(operatetime_end, "yyyy-MM-dd hh:mm:ss");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            cq.le("operatetime", endValue);
        }
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"logDetail"})
    public ModelAndView logDetail(TSLog tsLog, HttpServletRequest request) {
        if (StringUtil.isNotEmpty(tsLog.getId())) {
            tsLog = (TSLog)this.logService.getEntity(TSLog.class, (Serializable)((Object)tsLog.getId()));
            request.setAttribute("tsLog", (Object)tsLog);
        }
        return new ModelAndView("system/log/logDetail");
    }

    @RequestMapping(params={"statisticTabs"})
    public ModelAndView statisticTabs(HttpServletRequest request) {
        return new ModelAndView("system/log/statisticTabs");
    }

    @RequestMapping(params={"userBroswer"})
    public ModelAndView userBroswer(String reportType, HttpServletRequest request) {
        request.setAttribute("reportType", (Object)reportType);
        if ("pie".equals(reportType)) {
            return new ModelAndView("system/log/userBroswerPie");
        }
        if ("line".equals(reportType)) {
            return new ModelAndView("system/log/userBroswerLine");
        }
        return new ModelAndView("system/log/userBroswer");
    }

    @RequestMapping(params={"getBroswerBar"})
    @ResponseBody
    public List<Highchart> getBroswerBar(HttpServletRequest request, String reportType, HttpServletResponse response) {
        ArrayList<Highchart> list = new ArrayList<Highchart>();
        Highchart hc = new Highchart();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT broswer ,count(broswer) FROM TSLog group by broswer");
        List userBroswerList = this.systemService.findByQueryString(sb.toString());
        Long count = this.systemService.getCountForJdbc("SELECT COUNT(1) FROM T_S_Log WHERE 1=1");
        ArrayList lt = new ArrayList();
        hc = new Highchart();
        hc.setName("\u7528\u6237\u6d4f\u89c8\u5668\u7edf\u8ba1\u5206\u6790");
        hc.setType(reportType);
        if (userBroswerList.size() > 0) {
            for (Object object : userBroswerList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Object[] obj = (Object[])object;
                map.put("name", obj[0]);
                map.put("y", obj[1]);
                Long groupCount = (Long)obj[1];
                Double percentage = 0.0;
                if (count != null && count.intValue() != 0) {
                    percentage = new Double(groupCount.longValue()) / (double)count.longValue();
                }
                map.put("percentage", percentage * 100.0);
                lt.add(map);
            }
        }
        hc.setData(lt);
        list.add(hc);
        return list;
    }

    @RequestMapping(params={"export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("utf-8");
        response.setCharacterEncoding("utf-8");
        String type = request.getParameter("type");
        String svg = request.getParameter("svg");
        String filename = request.getParameter("filename");
        filename = filename == null ? "chart" : filename;
        ServletOutputStream out = response.getOutputStream();
        try {
            if (type != null && svg != null) {
                svg = svg.replaceAll(":rect", "rect");
                String ext = "";
                PNGTranscoder t = null;
                if (type.equals("image/png")) {
                    ext = "png";
                    t = new PNGTranscoder();
                } else if (type.equals("image/jpeg")) {
                    ext = "jpg";
                    t = new JPEGTranscoder();
                } else if (type.equals("application/pdf")) {
                    ext = "pdf";
                    t = new PDFTranscoder();
                } else if (type.equals("image/svg+xml")) {
                    ext = "svg";
                }
                response.addHeader("Content-Disposition", "attachment; filename=" + new String(filename.getBytes("GBK"), "ISO-8859-1") + "." + ext);
                response.addHeader("Content-Type", type);
                if (t != null) {
                    TranscoderInput input = new TranscoderInput((Reader)new StringReader(svg));
                    TranscoderOutput output = new TranscoderOutput((OutputStream)out);
                    try {
                        t.transcode(input, output);
                    }
                    catch (TranscoderException e) {
                        out.print("Problem transcoding stream. See the web logs for more details.");
                        e.printStackTrace();
                    }
                } else if (ext.equals("svg")) {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                    writer.append(svg);
                    writer.close();
                } else {
                    out.print("Invalid type: " + type);
                }
            } else {
                response.addHeader("Content-Type", "text/html");
                out.println("Usage:\n\tParameter [svg]: The DOM Element to be converted.\n\tParameter [type]: The destination MIME type for the elment to be transcoded.");
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

