/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.imageio.stream.FileImageOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.web.system.pojo.base.TSIcon;

public class IconImageUtil {
    public static void convertDataGrid(DataGrid dataGrid, HttpServletRequest request) {
        String fileDirName = String.valueOf(request.getSession().getServletContext().getRealPath("")) + File.separator + "temp";
        IconImageUtil.delFolder(fileDirName);
        File fileDir = new File(fileDirName);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        try {
            List list = dataGrid.getResults();
            for (Object obj : list) {
                TSIcon icon = (TSIcon)obj;
                String fileName = "icon" + UUID.randomUUID() + "." + icon.getExtend();
                File tempFile = new File(String.valueOf(fileDirName) + File.separator + fileName);
                if (icon.getIconContent() == null) continue;
                IconImageUtil.byte2image(icon.getIconContent(), tempFile);
                icon.setIconPath("temp/" + fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void byte2image(byte[] data, File file) {
        if (data.length < 3) {
            return;
        }
        FileImageOutputStream imageOutput = null;
        Object fileName = null;
        try {
            try {
                imageOutput = new FileImageOutputStream(file);
                imageOutput.write(data, 0, data.length);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    imageOutput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                imageOutput.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void delFolder(String folderPath) {
        try {
            IconImageUtil.delAllFile(folderPath);
            File folder = new File(folderPath);
            folder.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        int i = 0;
        while (i < tempList.length) {
            temp = path.endsWith(File.separator) ? new File(String.valueOf(path) + tempList[i]) : new File(String.valueOf(path) + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (temp.isDirectory()) {
                IconImageUtil.delAllFile(String.valueOf(path) + "/" + tempList[i]);
                IconImageUtil.delFolder(String.valueOf(path) + "/" + tempList[i]);
                flag = true;
            }
            ++i;
        }
        return flag;
    }
}

