/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.controller.core.IconImageUtil;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.pojo.base.TSIcon;
import org.jeecgframework.web.system.pojo.base.TSOperation;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/iconController"})
public class IconController
extends BaseController {
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"icon"})
    public ModelAndView icon() {
        return new ModelAndView("system/icon/iconList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSIcon icon, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSIcon.class, dataGrid);
        HqlGenerateUtil.installHql(cq, icon);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        IconImageUtil.convertDataGrid(dataGrid, request);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"saveOrUpdateIcon"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveOrUpdateIcon(HttpServletRequest request) throws Exception {
        AjaxJson j = new AjaxJson();
        TSIcon icon = new TSIcon();
        Short iconType = oConvertUtils.getShort(request.getParameter("iconType"));
        String iconName = oConvertUtils.getString(request.getParameter("iconName"));
        String id = request.getParameter("id");
        icon.setId(id);
        icon.setIconName(iconName);
        icon.setIconType(iconType);
        UploadFile uploadFile = new UploadFile(request, icon);
        uploadFile.setCusPath("plug-in/accordion/images");
        uploadFile.setExtend("extend");
        uploadFile.setTitleField("iconclas");
        uploadFile.setRealPath("iconPath");
        uploadFile.setObject(icon);
        uploadFile.setByteField("iconContent");
        uploadFile.setRename(false);
        this.systemService.uploadFile(uploadFile);
        String css = "." + icon.getIconClas() + "{background:url('../images/" + icon.getIconClas() + "." + icon.getExtend() + "') no-repeat}";
        this.write(request, css);
        this.message = "\u4e0a\u4f20\u6210\u529f";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"update"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson update(HttpServletRequest request) throws Exception {
        AjaxJson j = new AjaxJson();
        Short iconType = oConvertUtils.getShort(request.getParameter("iconType"));
        String iconName = URLDecoder.decode(oConvertUtils.getString(request.getParameter("iconName")));
        String id = request.getParameter("id");
        TSIcon icon = new TSIcon();
        if (StringUtil.isNotEmpty(id)) {
            icon = this.systemService.get(TSIcon.class, (Serializable)((Object)id));
            icon.setId(id);
        }
        icon.setIconName(iconName);
        icon.setIconType(iconType);
        this.systemService.saveOrUpdate(icon);
        String css = "." + icon.getIconClas() + "{background:url('../images/" + icon.getIconClas() + "." + icon.getExtend() + "') no-repeat}";
        this.write(request, css);
        this.message = "\u66f4\u65b0\u6210\u529f";
        j.setMsg(this.message);
        return j;
    }

    protected void write(HttpServletRequest request, String css) {
        try {
            String path = request.getSession().getServletContext().getRealPath("/plug-in/accordion/css/icons.css");
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter out = new FileWriter(file, true);
            out.write("\r\n");
            out.write(css);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @RequestMapping(params={"repair"})
    @ResponseBody
    public AjaxJson repair(HttpServletRequest request) throws Exception {
        AjaxJson json = new AjaxJson();
        List<TSIcon> icons = this.systemService.loadAll(TSIcon.class);
        String rootpath = request.getSession().getServletContext().getRealPath("/");
        String csspath = request.getSession().getServletContext().getRealPath("/plug-in/accordion/css/icons.css");
        this.clearFile(csspath);
        for (TSIcon c : icons) {
            byte[] content;
            File file = new File(String.valueOf(rootpath) + c.getIconPath());
            if (!file.exists() && (content = c.getIconContent()) != null) {
                BufferedImage imag = ImageIO.read(new ByteArrayInputStream(content));
                ImageIO.write((RenderedImage)imag, "PNG", file);
            }
            String css = "." + c.getIconClas() + "{background:url('../images/" + c.getIconClas() + "." + c.getExtend() + "') no-repeat}";
            this.write(request, css);
            json.setMsg("\u6837\u5f0f\u8868\u521b\u5efa\u6210\u529f");
        }
        json.setSuccess(true);
        return json;
    }

    protected void clearFile(String path) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(path));
            fos.write("".getBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(TSIcon icon, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        boolean isPermit = this.isPermitDel(icon = (TSIcon)this.systemService.getEntity(TSIcon.class, (Serializable)((Object)icon.getId())));
        if (isPermit) {
            this.systemService.delete(icon);
            this.message = "\u56fe\u6807: " + icon.getIconName() + "\u88ab\u5220\u9664\u6210\u529f\u3002";
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
            return j;
        }
        this.message = "\u56fe\u6807: " + icon.getIconName() + "\u6b63\u5728\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002";
        j.setMsg(this.message);
        return j;
    }

    private boolean isPermitDel(TSIcon icon) {
        List<TSFunction> functions = this.systemService.findByProperty(TSFunction.class, "TSIcon.id", icon.getId());
        return functions == null || functions.isEmpty();
    }

    public void upEntity(TSIcon icon) {
        List<TSOperation> operations;
        List<TSFunction> functions = this.systemService.findByProperty(TSFunction.class, "TSIcon.id", icon.getId());
        if (functions.size() > 0) {
            for (TSFunction tsFunction : functions) {
                tsFunction.setTSIcon(null);
                this.systemService.saveOrUpdate(tsFunction);
            }
        }
        if ((operations = this.systemService.findByProperty(TSOperation.class, "TSIcon.id", icon.getId())).size() > 0) {
            for (TSOperation tsOperation : operations) {
                tsOperation.setTSIcon(null);
                this.systemService.saveOrUpdate(tsOperation);
            }
        }
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(TSIcon icon, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(icon.getId())) {
            icon = (TSIcon)this.systemService.getEntity(TSIcon.class, (Serializable)((Object)icon.getId()));
            req.setAttribute("icon", (Object)icon);
        }
        return new ModelAndView("system/icon/icons");
    }
}

