/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.pojo.base.TSIcon;
import org.jeecgframework.web.system.pojo.base.TSOperation;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/functionController"})
public class FunctionController
extends BaseController {
    private static final Logger logger = Logger.getLogger(FunctionController.class);
    private UserService userService;
    private SystemService systemService;
    private String message = null;

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @RequestMapping(params={"function"})
    public ModelAndView function() {
        return new ModelAndView("system/function/functionList");
    }

    @RequestMapping(params={"operation"})
    public ModelAndView operation(HttpServletRequest request, String functionId) {
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("system/operation/operationList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"opdategrid"})
    public void opdategrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSOperation.class, dataGrid);
        String functionId = oConvertUtils.getString(request.getParameter("functionId"));
        cq.eq("TSFunction.id", functionId);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(TSFunction function, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        function = (TSFunction)this.systemService.getEntity(TSFunction.class, (Serializable)((Object)function.getId()));
        this.message = "\u6743\u9650: " + function.getFunctionName() + "\u88ab\u5220\u9664\u6210\u529f";
        this.systemService.updateBySqlString("delete from t_s_role_function where functionid='" + function.getId() + "'");
        this.systemService.delete(function);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"delop"})
    @ResponseBody
    public AjaxJson delop(TSOperation operation, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        operation = (TSOperation)this.systemService.getEntity(TSOperation.class, (Serializable)((Object)operation.getId()));
        this.message = "\u64cd\u4f5c: " + operation.getOperationname() + "\u88ab\u5220\u9664\u6210\u529f";
        this.userService.delete(operation);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        return j;
    }

    private void updateSubFunction(List<TSFunction> subFunction, TSFunction parent) {
        if (subFunction.size() == 0) {
            return;
        }
        for (TSFunction tsFunction : subFunction) {
            tsFunction.setFunctionLevel(Short.valueOf(String.valueOf(parent.getFunctionLevel() + 1)));
            this.systemService.saveOrUpdate(tsFunction);
            List<TSFunction> subFunction1 = this.systemService.findByProperty(TSFunction.class, "TSFunction.id", tsFunction.getId());
            this.updateSubFunction(subFunction1, tsFunction);
        }
    }

    @RequestMapping(params={"saveFunction"})
    @ResponseBody
    public AjaxJson saveFunction(TSFunction function, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String functionOrder = function.getFunctionOrder();
        if (StringUtils.isEmpty((String)functionOrder)) {
            function.setFunctionOrder("0");
        }
        if (function.getTSFunction().getId().equals("")) {
            function.setTSFunction(null);
        } else {
            TSFunction parent = (TSFunction)this.systemService.getEntity(TSFunction.class, (Serializable)((Object)function.getTSFunction().getId()));
            function.setFunctionLevel(Short.valueOf(String.valueOf(parent.getFunctionLevel() + 1)));
        }
        if (StringUtil.isNotEmpty(function.getId())) {
            this.message = "\u6743\u9650: " + function.getFunctionName() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate(function);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            List<TSFunction> subFunction = this.systemService.findByProperty(TSFunction.class, "TSFunction.id", function.getId());
            this.updateSubFunction(subFunction, function);
            this.systemService.flushRoleFunciton(function.getId(), function);
        } else {
            List<TSFunction> functionList;
            if (function.getFunctionLevel().equals(Globals.Function_Leave_ONE)) {
                functionList = this.systemService.findByProperty(TSFunction.class, "functionLevel", Globals.Function_Leave_ONE);
                function.setFunctionOrder(function.getFunctionOrder());
            } else {
                functionList = this.systemService.findByProperty(TSFunction.class, "functionLevel", Globals.Function_Leave_TWO);
                function.setFunctionOrder(function.getFunctionOrder());
            }
            this.message = "\u6743\u9650: " + function.getFunctionName() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save(function);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"saveop"})
    @ResponseBody
    public AjaxJson saveop(TSOperation operation, HttpServletRequest request) {
        String pid = request.getParameter("TSFunction.id");
        if (pid.equals("")) {
            operation.setTSFunction(null);
        }
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(operation.getId())) {
            this.message = "\u64cd\u4f5c: " + operation.getOperationname() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate(operation);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u64cd\u4f5c: " + operation.getOperationname() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save(operation);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(TSFunction function, HttpServletRequest req) {
        String functionid = req.getParameter("id");
        List fuinctionlist = this.systemService.getList(TSFunction.class);
        req.setAttribute("flist", fuinctionlist);
        List iconlist = this.systemService.findByQueryString("from TSIcon where iconType != 3");
        req.setAttribute("iconlist", iconlist);
        List iconDeskList = this.systemService.findByQueryString("from TSIcon where iconType = 3");
        req.setAttribute("iconDeskList", iconDeskList);
        if (functionid != null) {
            function = (TSFunction)this.systemService.getEntity(TSFunction.class, (Serializable)((Object)functionid));
            req.setAttribute("function", (Object)function);
        }
        if (function.getTSFunction() != null && function.getTSFunction().getId() != null) {
            function.setFunctionLevel((short)1);
            function.setTSFunction((TSFunction)this.systemService.getEntity(TSFunction.class, (Serializable)((Object)function.getTSFunction().getId())));
            req.setAttribute("function", (Object)function);
        }
        return new ModelAndView("system/function/function");
    }

    @RequestMapping(params={"addorupdateop"})
    public ModelAndView addorupdateop(TSOperation operation, HttpServletRequest req) {
        List iconlist = this.systemService.getList(TSIcon.class);
        req.setAttribute("iconlist", iconlist);
        if (operation.getId() != null) {
            operation = (TSOperation)this.systemService.getEntity(TSOperation.class, (Serializable)((Object)operation.getId()));
            req.setAttribute("operation", (Object)operation);
        }
        String functionId = oConvertUtils.getString(req.getParameter("functionId"));
        req.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("system/operation/operation");
    }

    @RequestMapping(params={"functionGrid"})
    @ResponseBody
    public List<TreeGrid> functionGrid(HttpServletRequest request, TreeGrid treegrid) {
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        String selfId = request.getParameter("selfId");
        if (selfId != null) {
            cq.notEq("id", selfId);
        }
        if (treegrid.getId() != null) {
            cq.eq("TSFunction.id", treegrid.getId());
        }
        if (treegrid.getId() == null) {
            cq.isNull("TSFunction");
        }
        cq.addOrder("functionOrder", SortDirection.asc);
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, false);
        Collections.sort(functionList, new Comparator<TSFunction>(){

            @Override
            public int compare(TSFunction arg0, TSFunction arg1) {
                return Integer.parseInt(arg0.getFunctionOrder()) - Integer.parseInt(arg1.getFunctionOrder());
            }
        });
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setIcon("TSIcon_iconPath");
        treeGridModel.setTextField("functionName");
        treeGridModel.setParentText("TSFunction_functionName");
        treeGridModel.setParentId("TSFunction_id");
        treeGridModel.setSrc("functionUrl");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("TSFunctions");
        treeGridModel.setOrder("functionOrder");
        treeGrids = this.systemService.treegrid(functionList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"functionList"})
    @ResponseBody
    public void functionList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class, dataGrid);
        String id = oConvertUtils.getString(request.getParameter("id"));
        cq.isNull("TSFunction");
        if (id != null) {
            cq.eq("TSFunction.id", id);
        }
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList treeGrids = new ArrayList();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"setPFunction"})
    @ResponseBody
    public List<ComboTree> setPFunction(HttpServletRequest request, ComboTree comboTree) {
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        if (request.getParameter("selfId") != null) {
            cq.notEq("id", request.getParameter("selfId"));
        }
        if (comboTree.getId() != null) {
            cq.eq("TSFunction.id", comboTree.getId());
        }
        if (comboTree.getId() == null) {
            cq.isNull("TSFunction");
        }
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "functionName", "TSFunctions");
        comboTrees = this.systemService.ComboTree(functionList, comboTreeModel, null);
        return comboTrees;
    }

    @RequestMapping(params={"searchApp"})
    public ModelAndView searchApp(TSFunction function, HttpServletRequest req) {
        String name = req.getParameter("name");
        String menuListMap = "";
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        cq.notEq("functionLevel", Short.valueOf("0"));
        if (name == null || "".equals(name)) {
            cq.isNull("TSFunction");
        } else {
            String name1 = "%" + name + "%";
            cq.like("functionName", name1);
        }
        cq.add();
        List functionList = this.systemService.getListByCriteriaQuery(cq, false);
        if (functionList.size() > 0 && functionList != null) {
            int i = 0;
            while (i < functionList.size()) {
                String icon = "";
                icon = !"".equals(((TSFunction)functionList.get(i)).getTSIconDesk()) && ((TSFunction)functionList.get(i)).getTSIconDesk() != null ? ((TSFunction)functionList.get(i)).getTSIconDesk().getIconPath() : "plug-in/sliding/icon/default.png";
                menuListMap = String.valueOf(menuListMap) + "<div type='" + i + 1 + "' class='menuSearch_Info' id='" + ((TSFunction)functionList.get(i)).getId() + "' title='" + ((TSFunction)functionList.get(i)).getFunctionName() + "' url='" + ((TSFunction)functionList.get(i)).getFunctionUrl() + "' icon='" + icon + "' style='float:left;left: 0px; top: 0px;margin-left: 30px;margin-top: 20px;'>" + "<div ><img alt='" + ((TSFunction)functionList.get(i)).getFunctionName() + "' src='" + icon + "'></div>" + "<div class='appButton_appName_inner1' style='color:#333333;'>" + ((TSFunction)functionList.get(i)).getFunctionName() + "</div>" + "<div class='appButton_appName_inner_right1'></div>" + "</div>";
                ++i;
            }
        } else {
            menuListMap = String.valueOf(menuListMap) + "\u5f88\u9057\u61be\uff0c\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u68c0\u7d22\u5230\u4e0e\u201c" + name + "\u201d\u76f8\u5173\u7684\u4fe1\u606f\uff01";
        }
        LogUtil.info("-------------------------------" + menuListMap);
        req.setAttribute("menuListMap", (Object)menuListMap);
        return new ModelAndView("system/function/menuAppList");
    }
}

