/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.DynamicDataSourceEntity;
import org.jeecgframework.web.system.service.DynamicDataSourceServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/dynamicDataSourceController"})
public class DynamicDataSourceController
extends BaseController {
    private static final Logger logger = Logger.getLogger(DynamicDataSourceController.class);
    @Autowired
    private DynamicDataSourceServiceI dynamicDataSourceService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"dbSource"})
    public ModelAndView dbSource(HttpServletRequest request) {
        return new ModelAndView("system/dbsource/dbSourceList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(DynamicDataSourceEntity dbSource, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(DynamicDataSourceEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, dbSource, request.getParameterMap());
        this.dynamicDataSourceService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(DynamicDataSourceEntity dbSource, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        dbSource = (DynamicDataSourceEntity)this.systemService.getEntity(DynamicDataSourceEntity.class, (Serializable)((Object)dbSource.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.dynamicDataSourceService.delete(dbSource);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(DynamicDataSourceEntity dbSource, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(dbSource.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            DynamicDataSourceEntity t = this.dynamicDataSourceService.get(DynamicDataSourceEntity.class, (Serializable)((Object)dbSource.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean(dbSource, t);
                this.dynamicDataSourceService.saveOrUpdate(t);
                this.dynamicDataSourceService.refleshCache();
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u6dfb\u52a0\u6210\u529f";
            this.dynamicDataSourceService.save(dbSource);
            this.dynamicDataSourceService.refleshCache();
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(DynamicDataSourceEntity dbSource, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(dbSource.getId())) {
            dbSource = (DynamicDataSourceEntity)this.dynamicDataSourceService.getEntity(DynamicDataSourceEntity.class, (Serializable)((Object)dbSource.getId()));
            req.setAttribute("dbSourcePage", (Object)dbSource);
        }
        return new ModelAndView("system/dbsource/dbSource");
    }
}

