/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.pojo.base.TSDepart;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/departController"})
public class DepartController {
    private static final Logger logger = Logger.getLogger(DepartController.class);
    private UserService userService;
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @RequestMapping(params={"depart"})
    public ModelAndView depart() {
        return new ModelAndView("system/depart/departList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSDepart.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(TSDepart depart, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        depart = (TSDepart)this.systemService.getEntity(TSDepart.class, (Serializable)((Object)depart.getId()));
        this.message = "\u90e8\u95e8: " + depart.getDepartname() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.upEntity(depart);
        this.systemService.delete(depart);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    public void upEntity(TSDepart depart) {
        List<TSUser> users = this.systemService.findByProperty(TSUser.class, "TSDepart.id", depart.getId());
        if (users.size() > 0) {
            for (TSUser tsUser : users) {
                this.systemService.delete(tsUser);
            }
        }
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(TSDepart depart, HttpServletRequest request) {
        String pid = request.getParameter("TSPDepart.id");
        if (pid.equals("")) {
            depart.setTSPDepart(null);
        }
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(depart.getId())) {
            this.message = "\u90e8\u95e8: " + depart.getDepartname() + "\u88ab\u66f4\u65b0\u6210\u529f";
            this.userService.saveOrUpdate(depart);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u90e8\u95e8: " + depart.getDepartname() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            this.userService.save(depart);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"add"})
    public ModelAndView add(TSDepart depart, HttpServletRequest req) {
        List departList = this.systemService.getList(TSDepart.class);
        req.setAttribute("departList", departList);
        if (StringUtil.isNotEmpty(depart.getId())) {
            TSDepart tspDepart = new TSDepart();
            TSDepart tsDepart = new TSDepart();
            depart = (TSDepart)this.systemService.getEntity(TSDepart.class, (Serializable)((Object)depart.getId()));
            tspDepart.setId(depart.getId());
            tspDepart.setDepartname(depart.getDepartname());
            tsDepart.setTSPDepart(tspDepart);
            req.setAttribute("depart", (Object)tsDepart);
        }
        return new ModelAndView("system/depart/depart");
    }

    @RequestMapping(params={"update"})
    public ModelAndView update(TSDepart depart, HttpServletRequest req) {
        List departList = this.systemService.getList(TSDepart.class);
        req.setAttribute("departList", departList);
        if (StringUtil.isNotEmpty(depart.getId())) {
            depart = (TSDepart)this.systemService.getEntity(TSDepart.class, (Serializable)((Object)depart.getId()));
            req.setAttribute("depart", (Object)depart);
        }
        return new ModelAndView("system/depart/depart");
    }

    @RequestMapping(params={"setPFunction"})
    @ResponseBody
    public List<ComboTree> setPFunction(HttpServletRequest request, ComboTree comboTree) {
        CriteriaQuery cq = new CriteriaQuery(TSDepart.class);
        if (request.getParameter("selfId") != null) {
            cq.notEq("id", request.getParameter("selfId"));
        }
        if (comboTree.getId() != null) {
            cq.eq("TSPDepart.id", comboTree.getId());
        }
        if (comboTree.getId() == null) {
            cq.isNull("TSPDepart");
        }
        cq.add();
        List departsList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "departname", "TSDeparts");
        comboTrees = this.systemService.ComboTree(departsList, comboTreeModel, null);
        return comboTrees;
    }

    @RequestMapping(params={"departgrid"})
    @ResponseBody
    public List<TreeGrid> departgrid(TSDepart tSDepart, HttpServletRequest request, HttpServletResponse response, TreeGrid treegrid) {
        CriteriaQuery cq = new CriteriaQuery(TSDepart.class);
        if ("yes".equals(request.getParameter("isSearch"))) {
            treegrid.setId(null);
            tSDepart.setId(null);
        }
        if (tSDepart.getDepartname() != null) {
            HqlGenerateUtil.installHql(cq, tSDepart);
        }
        if (treegrid.getId() != null) {
            cq.eq("TSPDepart.id", treegrid.getId());
        }
        if (treegrid.getId() == null) {
            cq.isNull("TSPDepart");
        }
        cq.add();
        List departList = null;
        departList = this.systemService.getListByCriteriaQuery(cq, false);
        if (departList.size() == 0 && tSDepart.getDepartname() != null) {
            cq = new CriteriaQuery(TSDepart.class);
            TSDepart parDepart = new TSDepart();
            tSDepart.setTSPDepart(parDepart);
            HqlGenerateUtil.installHql(cq, tSDepart);
            departList = this.systemService.getListByCriteriaQuery(cq, false);
        }
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("departname");
        treeGridModel.setParentText("TSPDepart_departname");
        treeGridModel.setParentId("TSPDepart_id");
        treeGridModel.setSrc("description");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("TSDeparts");
        treeGrids = this.systemService.treegrid(departList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"userList"})
    public ModelAndView userList(HttpServletRequest request, String departid) {
        request.setAttribute("departid", (Object)departid);
        return new ModelAndView("system/depart/departUserList");
    }

    @RequestMapping(params={"userDatagrid"})
    public void userDatagrid(TSUser user, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSUser.class, dataGrid);
        HqlGenerateUtil.installHql(cq, user);
        String departid = oConvertUtils.getString(request.getParameter("departid"));
        if (!StringUtil.isEmpty(departid)) {
            DetachedCriteria dc = cq.getDetachedCriteria();
            DetachedCriteria dcDepart = dc.createCriteria("TSDepart");
            dcDepart.add((Criterion)Restrictions.eq((String)"id", (Object)departid));
        }
        Object[] userstate = new Short[]{Globals.User_Normal, Globals.User_ADMIN};
        cq.in("status", userstate);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"departs"})
    public ModelAndView departs(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView("system/user/departs");
        String ids = oConvertUtils.getString(request.getParameter("ids"));
        mv.addObject("ids", (Object)ids);
        return mv;
    }
}

