/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.system.controller.core;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSConfig;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/configController"})
public class ConfigController
extends BaseController {
    private static final Logger logger = Logger.getLogger(ConfigController.class);
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"config"})
    public ModelAndView config() {
        return new ModelAndView("system/config/configList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSConfig.class, dataGrid);
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(TSConfig config, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        config = (TSConfig)this.systemService.getEntity(TSConfig.class, (Serializable)((Object)config.getId()));
        this.message = "\u914d\u7f6e\u4fe1\u606f: " + config.getName() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete(config);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(TSConfig tsConfig, HttpServletRequest request) {
        if (StringUtil.isEmpty(tsConfig.getId())) {
            TSConfig tsConfig2 = this.systemService.findUniqueByProperty(TSConfig.class, "code", tsConfig.getCode());
            if (tsConfig2 != null) {
                this.message = "\u7f16\u7801\u4e3a: " + tsConfig.getCode() + "\u7684\u914d\u7f6e\u4fe1\u606f\u5df2\u5b58\u5728";
            } else {
                tsConfig.setTSUser(ResourceUtil.getSessionUserName());
                this.systemService.save(tsConfig);
                this.message = "\u914d\u7f6e\u4fe1\u606f: " + tsConfig.getName() + "\u88ab\u6dfb\u52a0\u6210\u529f";
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
        } else {
            this.message = "\u914d\u7f6e\u4fe1\u606f: " + tsConfig.getName() + "\u88ab\u4fee\u6539\u6210\u529f";
            this.systemService.updateEntitie(tsConfig);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        AjaxJson j = new AjaxJson();
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(TSConfig config, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(config.getId())) {
            config = (TSConfig)this.systemService.getEntity(TSConfig.class, (Serializable)((Object)config.getId()));
            req.setAttribute("config", (Object)config);
        }
        return new ModelAndView("system/config/config");
    }
}

