/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.rest.controller;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.validation.Validator;
import org.jeecgframework.core.beanvalidator.BeanValidators;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/user"})
public class UserRestController {
    @Autowired
    private UserService userService;
    @Autowired
    private Validator validator;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<TSUser> list() {
        List<TSUser> listUsers = this.userService.getList(TSUser.class);
        return listUsers;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> get(@PathVariable(value="id") Long id) {
        TSUser task = this.userService.get(TSUser.class, id);
        if (task == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)task, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<?> create(@RequestBody TSUser user, UriComponentsBuilder uriBuilder) {
        Set failures = this.validator.validate((Object)user, new Class[0]);
        if (!failures.isEmpty()) {
            return new ResponseEntity(BeanValidators.extractPropertyAndMessage(failures), HttpStatus.BAD_REQUEST);
        }
        this.userService.save(user);
        String id = user.getId();
        URI uri = uriBuilder.path("/rest/user/" + id).build().toUri();
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uri);
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    public ResponseEntity<?> update(@RequestBody TSUser user) {
        Set failures = this.validator.validate((Object)user, new Class[0]);
        if (!failures.isEmpty()) {
            return new ResponseEntity(BeanValidators.extractPropertyAndMessage(failures), HttpStatus.BAD_REQUEST);
        }
        this.userService.saveOrUpdate(user);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable(value="id") Long id) {
        this.userService.deleteEntityById(TSUser.class, id);
    }
}

