/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.rank.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.jeecgframework.web.rank.entity.TSTeamPersonEntity;
import org.jeecgframework.web.rank.service.TSTeamPersonServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tSTeamPersonController"})
public class TSTeamPersonController
extends BaseController {
    private static final Logger logger = Logger.getLogger(TSTeamPersonController.class);
    private final String FTL_Teachers = "template/rank/html/teachers.ftl";
    private final String FTL_Teacher = "template/rank/html/teacher.ftl";
    private final String FTL_Introduce = "template/rank/html/introduce.ftl";
    private static String getTeacherList_ftl;
    private static String introduce_ftl;
    @Autowired
    private TSTeamPersonServiceI tSTeamPersonService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"tSTeamPerson"})
    public ModelAndView tSTeamPerson(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/rank/tSTeamPersonList");
    }

    @RequestMapping(params={"getTeacherList"})
    public void getTeacherList(HttpServletRequest request, HttpServletResponse response) {
        if (oConvertUtils.isNotEmpty(getTeacherList_ftl)) {
            try {
                response.setContentType("text/html");
                response.setHeader("Cache-Control", "no-store");
                PrintWriter writer = response.getWriter();
                writer.println(getTeacherList_ftl);
                writer.flush();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FreemarkerHelper viewEngine = new FreemarkerHelper();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List teamPersonEntities = this.tSTeamPersonService.findByQueryString("from TSTeamPersonEntity order by isJoin desc,jionDate asc");
        String path = request.getContextPath();
        String url = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        map.put("teachers", teamPersonEntities);
        map.put("url", url);
        getTeacherList_ftl = viewEngine.parseTemplate("template/rank/html/teachers.ftl", map);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(getTeacherList_ftl);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"clear"})
    public void clear(HttpServletRequest request, HttpServletResponse response) {
        getTeacherList_ftl = null;
        introduce_ftl = null;
    }

    @RequestMapping(params={"getTeacher"})
    public void getTeacher(@RequestParam String id, HttpServletRequest request, HttpServletResponse response) {
        FreemarkerHelper viewEngine = new FreemarkerHelper();
        TSTeamPersonEntity teamPersonEntity = this.tSTeamPersonService.get(TSTeamPersonEntity.class, (Serializable)((Object)id));
        String path = request.getContextPath();
        String url = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("teacher", teamPersonEntity);
        map.put("url", url);
        String html = viewEngine.parseTemplate("template/rank/html/teacher.ftl", map);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TSTeamPersonEntity tSTeamPerson, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TSTeamPersonEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, tSTeamPerson, request.getParameterMap());
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(TSTeamPersonEntity tSTeamPerson, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        tSTeamPerson = (TSTeamPersonEntity)this.systemService.getEntity(TSTeamPersonEntity.class, (Serializable)((Object)tSTeamPerson.getId()));
        this.message = "\u56e2\u961f\u4eba\u5458\u699c\u5220\u9664\u6210\u529f";
        try {
            this.tSTeamPersonService.delete(tSTeamPerson);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u56e2\u961f\u4eba\u5458\u699c\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u56e2\u961f\u4eba\u5458\u699c\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TSTeamPersonEntity tSTeamPerson = (TSTeamPersonEntity)this.systemService.getEntity(TSTeamPersonEntity.class, (Serializable)((Object)id));
                this.tSTeamPersonService.delete(tSTeamPerson);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u56e2\u961f\u4eba\u5458\u699c\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(TSTeamPersonEntity tSTeamPerson, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u56e2\u961f\u4eba\u5458\u699c\u6dfb\u52a0\u6210\u529f";
        try {
            this.tSTeamPersonService.save(tSTeamPerson);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u56e2\u961f\u4eba\u5458\u699c\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(TSTeamPersonEntity tSTeamPerson, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u56e2\u961f\u4eba\u5458\u699c\u66f4\u65b0\u6210\u529f";
        TSTeamPersonEntity t = this.tSTeamPersonService.get(TSTeamPersonEntity.class, (Serializable)((Object)tSTeamPerson.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean(tSTeamPerson, t);
            this.tSTeamPersonService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u56e2\u961f\u4eba\u5458\u699c\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(TSTeamPersonEntity tSTeamPerson, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(tSTeamPerson.getId())) {
            tSTeamPerson = (TSTeamPersonEntity)this.tSTeamPersonService.getEntity(TSTeamPersonEntity.class, (Serializable)((Object)tSTeamPerson.getId()));
            req.setAttribute("tSTeamPersonPage", (Object)tSTeamPerson);
        }
        return new ModelAndView("jeecg/demo/rank/tSTeamPerson-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(TSTeamPersonEntity tSTeamPerson, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(tSTeamPerson.getId())) {
            tSTeamPerson = (TSTeamPersonEntity)this.tSTeamPersonService.getEntity(TSTeamPersonEntity.class, (Serializable)((Object)tSTeamPerson.getId()));
            req.setAttribute("tSTeamPersonPage", (Object)tSTeamPerson);
        }
        return new ModelAndView("jeecg/demo/rank/tSTeamPerson-update");
    }

    @RequestMapping(params={"introduce"})
    public void introduce(HttpServletRequest request, HttpServletResponse response) {
        if (oConvertUtils.isNotEmpty(introduce_ftl)) {
            try {
                response.setContentType("text/html");
                response.setHeader("Cache-Control", "no-store");
                PrintWriter writer = response.getWriter();
                writer.println(introduce_ftl);
                writer.flush();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FreemarkerHelper viewEngine = new FreemarkerHelper();
        String path = request.getContextPath();
        String url = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url", url);
        introduce_ftl = viewEngine.parseTemplate("template/rank/html/introduce.ftl", map);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(introduce_ftl);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

