/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.service.impl.test;

import java.io.IOException;
import java.sql.Blob;
import java.util.Date;
import org.hibernate.LobHelper;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.demo.entity.test.WebOfficeEntity;
import org.jeecgframework.web.demo.service.test.WebOfficeServiceI;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="webOfficeService")
@Transactional
public class WebOfficeServiceImpl
extends CommonServiceImpl
implements WebOfficeServiceI {
    @Override
    public void saveObj(WebOfficeEntity docObj, MultipartFile file) {
        WebOfficeEntity obj = null;
        if (StringUtil.isNotEmpty(docObj.getId())) {
            obj = (WebOfficeEntity)this.commonDao.getEntity(WebOfficeEntity.class, docObj.getId());
            if (obj == null) {
                return;
            }
        } else {
            obj = new WebOfficeEntity();
            BeanUtils.copyProperties((Object)docObj, (Object)obj);
            String sFileName = file.getOriginalFilename();
            int iPos = sFileName.lastIndexOf(46);
            if (iPos >= 0) {
                obj.setDoctype(sFileName.substring(iPos + 1));
            }
        }
        obj.setDocdate(new Date());
        LobHelper lobHelper = this.commonDao.getSession().getLobHelper();
        try {
            Blob data = lobHelper.createBlob(file.getInputStream(), 0L);
            obj.setDoccontent(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.save(obj);
    }
}

