/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.service.impl.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jeecgframework.core.common.dao.jdbc.JdbcDao;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.JeecgSqlUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.demo.entity.test.JeecgJdbcEntity;
import org.jeecgframework.web.demo.service.test.JeecgJdbcServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="jeecgJdbcService")
@Transactional
public class JeecgJdbcServiceImpl
extends CommonServiceImpl
implements JeecgJdbcServiceI {
    @Autowired
    private JdbcDao jdbcDao;

    @Override
    public void getDatagrid1(JeecgJdbcEntity pageObj, DataGrid dataGrid) {
        String sqlWhere = this.getSqlWhere(pageObj);
        String sqlCnt = "select count(*) from jeecg_demo t";
        if (!sqlWhere.isEmpty()) {
            sqlCnt = String.valueOf(sqlCnt) + " where" + sqlWhere;
        }
        Long iCount = this.getCountForJdbcParam(sqlCnt, null);
        String sql = "select t.id,t.user_name as userName,d.departname as depId,t.sex,t.age,t.birthday,t.email,t.mobile_phone as mobilePhone from jeecg_demo t left join t_s_depart d on d.id=t.dep_id";
        if (!sqlWhere.isEmpty()) {
            sql = String.valueOf(sql) + " where" + sqlWhere;
        }
        List<JeecgJdbcEntity> list = this.findObjForJdbc(sql, dataGrid.getPage(), dataGrid.getRows(), JeecgJdbcEntity.class);
        dataGrid.setResults(list);
        dataGrid.setTotal(iCount.intValue());
    }

    @Override
    public void getDatagrid2(JeecgJdbcEntity pageObj, DataGrid dataGrid) {
        String sqlWhere = this.getSqlWhere(pageObj);
        String sqlCnt = "select count(*) from jeecg_demo t";
        if (!sqlWhere.isEmpty()) {
            sqlCnt = String.valueOf(sqlCnt) + " where" + sqlWhere;
        }
        Long iCount = this.getCountForJdbcParam(sqlCnt, null);
        String sql = "select t.*,d.departname from jeecg_demo t left join t_s_depart d on d.id=t.dep_id";
        if (!sqlWhere.isEmpty()) {
            sql = String.valueOf(sql) + " where" + sqlWhere;
        }
        List<Map<String, Object>> mapList = this.findForJdbc(sql, dataGrid.getPage(), dataGrid.getRows());
        ArrayList<JeecgJdbcEntity> list = new ArrayList<JeecgJdbcEntity>();
        JeecgJdbcEntity obj = null;
        for (Map<String, Object> m : mapList) {
            try {
                obj = new JeecgJdbcEntity();
                obj.setId((String)m.get("id"));
                obj.setUserName((String)m.get("user_name"));
                obj.setDepId((String)m.get("departname"));
                String sex = (String)m.get("sex");
                if (sex == null) {
                    obj.setSex("");
                } else if (sex.equals("0")) {
                    obj.setSex("\u7537");
                } else {
                    obj.setSex("\u5973");
                }
                obj.setAge((Integer)m.get("age"));
                Date birthday = (Date)m.get("birthday");
                if (birthday != null) {
                    obj.setBirthday(birthday);
                }
                obj.setEmail((String)m.get("email"));
                obj.setMobilePhone((String)m.get("mobile_phone"));
                list.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dataGrid.setResults(list);
        dataGrid.setTotal(iCount.intValue());
    }

    @Override
    public JSONObject getDatagrid3(JeecgJdbcEntity pageObj, DataGrid dataGrid) {
        String sqlWhere = this.getSqlWhere(pageObj);
        String sqlCnt = "select count(*) from jeecg_demo t";
        if (!sqlWhere.isEmpty()) {
            sqlCnt = String.valueOf(sqlCnt) + " where" + sqlWhere;
        }
        Long iCount = this.getCountForJdbcParam(sqlCnt, null);
        String sql = "select t.*,d.departname from jeecg_demo t left join t_s_depart d on d.id=t.dep_id";
        if (!sqlWhere.isEmpty()) {
            sql = String.valueOf(sql) + " where" + sqlWhere;
        }
        List<Map<String, Object>> mapList = this.findForJdbc(sql, dataGrid.getPage(), dataGrid.getRows());
        Db2Page[] db2Pages = new Db2Page[]{new Db2Page("id"), new Db2Page("userName", "user_name", null), new Db2Page("depId", "departName", null), new Db2Page("sex", null, new MyDataExchangerSex()), new Db2Page("age"), new Db2Page("birthday"), new Db2Page("email"), new Db2Page("mobilePhone", "mobile_phone", null)};
        JSONObject jObject = this.getJsonDatagridEasyUI(mapList, iCount.intValue(), db2Pages);
        return jObject;
    }

    String getSqlWhere(JeecgJdbcEntity pageObj) {
        String sqlWhere = "";
        if (StringUtil.isNotEmpty(pageObj.getUserName())) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = String.valueOf(sqlWhere) + " and";
            }
            sqlWhere = String.valueOf(sqlWhere) + " t.user_name like '%" + pageObj.getUserName() + "%'";
        }
        if (StringUtil.isNotEmpty(pageObj.getMobilePhone())) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere = String.valueOf(sqlWhere) + " and";
            }
            sqlWhere = String.valueOf(sqlWhere) + " t.mobile_phone like '%" + pageObj.getMobilePhone() + "%'";
        }
        return sqlWhere;
    }

    public JSONObject getJsonDatagridEasyUI(List<Map<String, Object>> mapList, int iTotalCnt, Db2Page[] dataExchanger) {
        String jsonTemp = "{'total':" + iTotalCnt + ",'rows':[";
        int j = 0;
        while (j < mapList.size()) {
            Map<String, Object> m = mapList.get(j);
            if (j > 0) {
                jsonTemp = String.valueOf(jsonTemp) + ",";
            }
            jsonTemp = String.valueOf(jsonTemp) + "{";
            int i = 0;
            while (i < dataExchanger.length) {
                if (i > 0) {
                    jsonTemp = String.valueOf(jsonTemp) + ",";
                }
                jsonTemp = String.valueOf(jsonTemp) + "'" + dataExchanger[i].getKey() + "'" + ":";
                Object objValue = dataExchanger[i].getData(m);
                jsonTemp = objValue == null ? String.valueOf(jsonTemp) + "null" : String.valueOf(jsonTemp) + "'" + objValue + "'";
                ++i;
            }
            jsonTemp = String.valueOf(jsonTemp) + "}";
            ++j;
        }
        jsonTemp = String.valueOf(jsonTemp) + "]}";
        JSONObject jObject = JSONObject.fromObject((Object)jsonTemp);
        return jObject;
    }

    @Override
    public void listAllByJdbc(DataGrid dataGrid) {
        String sql = JeecgSqlUtil.getMethodSql(JeecgSqlUtil.getMethodUrl());
        String countsql = JeecgSqlUtil.getCountSqlBySql(sql);
        List<Map<String, Object>> maplist = this.jdbcDao.findForJdbcParam(sql, dataGrid.getPage(), dataGrid.getRows(), new Object[0]);
        Long count = this.jdbcDao.getCountForJdbcParam(countsql, new Object[0]);
        dataGrid.setTotal(count.intValue());
        dataGrid.setResults(maplist);
    }

    public static void main(String[] args) {
        JeecgJdbcServiceImpl service = new JeecgJdbcServiceImpl();
        service.listAllByJdbc(null);
    }

    class Db2Page {
        String fieldPage;
        String columnDB;
        IMyDataExchanger dataExchanger;

        public Db2Page(String fieldPage) {
            this.fieldPage = fieldPage;
            this.columnDB = fieldPage;
            this.dataExchanger = null;
        }

        public Db2Page(String fieldPage, String columnDB) {
            this.fieldPage = fieldPage;
            this.columnDB = columnDB == null ? fieldPage : columnDB;
            this.dataExchanger = null;
        }

        public Db2Page(String fieldPage, String columnDB, IMyDataExchanger dataExchanger) {
            this.fieldPage = fieldPage;
            this.columnDB = columnDB == null ? fieldPage : columnDB;
            this.dataExchanger = dataExchanger;
        }

        public String getKey() {
            return this.fieldPage;
        }

        public Object getData(Map mapDB) {
            Object objValue = mapDB.get(this.columnDB);
            if (objValue == null) {
                return null;
            }
            if (this.dataExchanger != null) {
                return this.dataExchanger.exchange(objValue);
            }
            return objValue;
        }
    }

    static interface IMyDataExchanger {
        public Object exchange(Object var1);
    }

    class MyDataExchangerSex
    implements IMyDataExchanger {
        MyDataExchangerSex() {
        }

        @Override
        public Object exchange(Object value) {
            if (value == null) {
                return "";
            }
            if ("0".equals(value.toString())) {
                return "\u7537";
            }
            return "\u5973";
        }
    }
}

